/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.xygraph;

import androidx.compose.runtime.MutableState;
import androidx.compose.ui.unit.Dp;
import io.github.koalaplot.core.xygraph.LinearAxisModelKt;
import io.github.koalaplot.core.xygraph.TickValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u001c\u001a\u00020\u0007R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/koalaplot/core/xygraph/DoubleTickCalculator;", "", "minimumMajorTickSpacing", "Landroidx/compose/ui/unit/Dp;", "currentRange", "Landroidx/compose/runtime/MutableState;", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "minimumMajorTickIncrement", "minorTickCount", "", "inverted", "", "<init>", "(FLandroidx/compose/runtime/MutableState;DIZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "F", "computeTickValues", "Lio/github/koalaplot/core/xygraph/TickValues;", "axisLength", "computeTickValues-0680j_4", "(F)Lio/github/koalaplot/core/xygraph/TickValues;", "computeMajorTickSpacing", "minTickSpacing", "", "computeMajorTickValues", "", "computeMinorTickValues", "majorTickValues", "majorTickSpacing", "koalaplot-core"})
@SourceDebugExtension(value={"SMAP\nDoubleLinearAxisModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleLinearAxisModel.kt\nio/github/koalaplot/core/xygraph/DoubleTickCalculator\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/Dp\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n113#2:384\n63#3:385\n1563#4:386\n1634#4,3:387\n*S KotlinDebug\n*F\n+ 1 DoubleLinearAxisModel.kt\nio/github/koalaplot/core/xygraph/DoubleTickCalculator\n*L\n204#1:384\n207#1:385\n226#1:386\n226#1:387,3\n*E\n"})
final class DoubleTickCalculator {
    private final float minimumMajorTickSpacing;
    @NotNull
    private final MutableState<ClosedFloatingPointRange<Double>> currentRange;
    private final double minimumMajorTickIncrement;
    private final int minorTickCount;
    private final boolean inverted;

    private DoubleTickCalculator(float minimumMajorTickSpacing, MutableState<ClosedFloatingPointRange<Double>> currentRange, double minimumMajorTickIncrement, int minorTickCount, boolean inverted) {
        Intrinsics.checkNotNullParameter(currentRange, (String)"currentRange");
        this.minimumMajorTickSpacing = minimumMajorTickSpacing;
        this.currentRange = currentRange;
        this.minimumMajorTickIncrement = minimumMajorTickIncrement;
        this.minorTickCount = minorTickCount;
        this.inverted = inverted;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TickValues<Double> computeTickValues-0680j_4(float f) {
        float f2;
        boolean $this$dp$iv2 = false;
        boolean $i$f$getDp = false;
        if (Dp.equals-impl0((float)f, (float)Dp.constructor-impl((float)((float)$this$dp$iv2)))) {
            f2 = 1.0f;
        } else {
            void arg0$iv;
            float $this$dp$iv2 = this.minimumMajorTickSpacing;
            float other$iv = f;
            boolean bl = false;
            f2 = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf((float)(arg0$iv / other$iv)), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        }
        float minTickSpacing = f2;
        List<Double> majorTickValues = this.computeMajorTickValues(minTickSpacing);
        List<Double> minorTickValues = this.computeMinorTickValues(majorTickValues, this.computeMajorTickSpacing(minTickSpacing));
        return new TickValues<Double>(this, majorTickValues, minorTickValues){
            private final List<Double> majorTickValues;
            private final List<Double> minorTickValues;
            {
                this.majorTickValues = DoubleTickCalculator.access$getInverted$p($receiver) ? CollectionsKt.reversed((Iterable)$majorTickValues) : $majorTickValues;
                this.minorTickValues = DoubleTickCalculator.access$getInverted$p($receiver) ? CollectionsKt.reversed((Iterable)$minorTickValues) : $minorTickValues;
            }

            public List<Double> getMajorTickValues() {
                return this.majorTickValues;
            }

            public List<Double> getMinorTickValues() {
                return this.minorTickValues;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final double computeMajorTickSpacing(float minTickSpacing) {
        Object v0;
        block3: {
            void $this$mapTo$iv$iv;
            if (!(minTickSpacing > 0.0f && minTickSpacing <= 1.0f)) {
                boolean bl = false;
                String string = "Minimum tick spacing must be greater than 0 and less than or equal to 1";
                throw new IllegalArgumentException(string.toString());
            }
            double length = ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue();
            double magnitude = Math.pow(10.0, Math.floor(Math.log10(length)));
            Iterable $this$map$iv = LinearAxisModelKt.getTickRatios();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                float f = ((Number)item$iv$iv).floatValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((double)it * magnitude);
            }
            List scaledTickRatios = (List)destination$iv$iv;
            Iterable iterable2 = scaledTickRatios;
            for (Object t : iterable2) {
                double it = ((Number)t).doubleValue();
                boolean bl = false;
                if (!(it / length >= (double)minTickSpacing && it >= this.minimumMajorTickIncrement)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Double d2 = v0;
        double tickSpacing = d2 != null ? d2 : this.minimumMajorTickIncrement;
        return tickSpacing;
    }

    @NotNull
    public final List<Double> computeMajorTickValues(float minTickSpacing) {
        List list;
        double tickSpacing = this.computeMajorTickSpacing(minTickSpacing);
        List $this$computeMajorTickValues_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (tickSpacing > 0.0) {
            double lastTick;
            double tickCount = Math.floor(((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() / tickSpacing);
            do {
                lastTick = tickCount * tickSpacing;
                if (((ClosedFloatingPointRange)this.currentRange.getValue()).contains((Comparable)Double.valueOf(lastTick))) {
                    $this$computeMajorTickValues_u24lambda_u240.add(lastTick);
                }
                tickCount += 1.0;
            } while (lastTick < ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue());
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public final List<Double> computeMinorTickValues(@NotNull List<Double> majorTickValues, double majorTickSpacing) {
        List list;
        Intrinsics.checkNotNullParameter(majorTickValues, (String)"majorTickValues");
        List $this$computeMinorTickValues_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (this.minorTickCount > 0 && !((Collection)majorTickValues).isEmpty()) {
            double nextTick;
            double minorIncrement = majorTickSpacing / (double)(this.minorTickCount + 1);
            int n = CollectionsKt.getLastIndex(majorTickValues);
            block0: for (int major = 0; major < n; ++major) {
                double majorTick1 = ((Number)majorTickValues.get(major)).doubleValue();
                int i = 1;
                int n2 = this.minorTickCount;
                if (i > n2) continue;
                while (true) {
                    $this$computeMinorTickValues_u24lambda_u240.add(majorTick1 + minorIncrement * (double)i);
                    if (i == n2) continue block0;
                    ++i;
                }
            }
            int i = 1;
            do {
                nextTick = ((Number)CollectionsKt.last(majorTickValues)).doubleValue() + minorIncrement * (double)i;
                if (((ClosedFloatingPointRange)this.currentRange.getValue()).contains((Comparable)Double.valueOf(nextTick))) {
                    $this$computeMinorTickValues_u24lambda_u240.add(nextTick);
                }
                ++i;
            } while (((ClosedFloatingPointRange)this.currentRange.getValue()).contains((Comparable)Double.valueOf(nextTick)));
            i = 1;
            do {
                nextTick = ((Number)CollectionsKt.first(majorTickValues)).doubleValue() - minorIncrement * (double)i;
                if (((ClosedFloatingPointRange)this.currentRange.getValue()).contains((Comparable)Double.valueOf(nextTick))) {
                    $this$computeMinorTickValues_u24lambda_u240.add(nextTick);
                }
                ++i;
            } while (((ClosedFloatingPointRange)this.currentRange.getValue()).contains((Comparable)Double.valueOf(nextTick)));
        }
        return CollectionsKt.build((List)list);
    }

    public /* synthetic */ DoubleTickCalculator(float minimumMajorTickSpacing, MutableState currentRange, double minimumMajorTickIncrement, int minorTickCount, boolean inverted, DefaultConstructorMarker $constructor_marker) {
        this(minimumMajorTickSpacing, (MutableState<ClosedFloatingPointRange<Double>>)currentRange, minimumMajorTickIncrement, minorTickCount, inverted);
    }

    public static final /* synthetic */ boolean access$getInverted$p(DoubleTickCalculator $this) {
        return $this.inverted;
    }
}

