/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.util;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.draw.RotateKt;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.LayoutModifier;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import io.github.koalaplot.core.util.UtilKt;
import io.github.koalaplot.core.util.Vector;
import io.github.koalaplot.core.util.VectorKt;
import io.github.koalaplot.core.util.VerticalRotation;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a6\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u001a6\u0010\r\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0007\u001a\u00020\u00022\n\u0010\u0012\u001a\u00020\u0013\"\u00020\u0002H\u0000\u001a\u0014\u0010\b\u001a\u00020\u00022\n\u0010\u0012\u001a\u00020\u0013\"\u00020\u0002H\u0000\u001a,\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0000\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0000\u001a\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0000\u00a8\u0006\u001d"}, d2={"toString", "", "", "precision", "", "", "maximize", "min", "max", "tolerance", "eval", "Lkotlin/Function1;", "", "maximizeUnguarded", "rotateVertically", "Landroidx/compose/ui/Modifier;", "rotation", "Lio/github/koalaplot/core/util/VerticalRotation;", "values", "", "lineDistance", "Lkotlin/Pair;", "Lio/github/koalaplot/core/util/Vector;", "p1", "p2", "p0", "sign", "", "x", "koalaplot-core"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\nio/github/koalaplot/core/util/UtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,236:1\n13840#2,2:237\n13840#2,2:239\n*S KotlinDebug\n*F\n+ 1 Util.kt\nio/github/koalaplot/core/util/UtilKt\n*L\n165#1:237,2\n173#1:239,2\n*E\n"})
public final class UtilKt {
    @NotNull
    public static final String toString(float $this$toString, int precision) {
        return UtilKt.toString((double)$this$toString, precision);
    }

    @NotNull
    public static final String toString(double $this$toString, int precision) {
        int x2 = 1;
        int leftShifted = (int)Math.rint(Math.abs($this$toString) * Math.pow(10.0, precision));
        StringBuilder s = new StringBuilder(String.valueOf(leftShifted));
        int n = precision + 1 - s.length();
        if (x2 <= n) {
            while (true) {
                s.insert(0, "0");
                if (x2 == n) break;
                ++x2;
            }
        }
        if (precision != 0) {
            s.insert(StringsKt.getLastIndex((CharSequence)s) - (precision - 1), ".");
        }
        if ($this$toString < 0.0) {
            s.insert(0, "-");
        }
        String string = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final double maximize(double min, double max, double tolerance, @NotNull Function1<? super Double, Boolean> eval) {
        Intrinsics.checkNotNullParameter(eval, (String)"eval");
        if (!(min <= max)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(tolerance > 0.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(Math.abs(min) <= Double.MAX_VALUE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!Double.isNaN(max))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return UtilKt.maximizeUnguarded(min, max, tolerance, eval);
    }

    public static /* synthetic */ double maximize$default(double d2, double d3, double d4, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            d4 = 0.01;
        }
        return UtilKt.maximize(d2, d3, d4, (Function1<? super Double, Boolean>)function1);
    }

    private static final double maximizeUnguarded(double min, double max, double tolerance, Function1<? super Double, Boolean> eval) {
        if (Math.abs((max - min) / ((max + min) / (double)2)) < tolerance || max == 0.0 && min == 0.0) {
            return min;
        }
        double test = Double.isInfinite(max) ? (min == 0.0 ? 1.0 : min * 2.0) : min + (max - min) / 2.0;
        return (Boolean)eval.invoke((Object)test) != false ? UtilKt.maximizeUnguarded(test, max, tolerance, eval) : UtilKt.maximizeUnguarded(min, test, tolerance, eval);
    }

    static /* synthetic */ double maximizeUnguarded$default(double d2, double d3, double d4, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            d4 = 0.01;
        }
        return UtilKt.maximizeUnguarded(d2, d3, d4, (Function1<? super Double, Boolean>)function1);
    }

    @NotNull
    public static final Modifier rotateVertically(@NotNull Modifier $this$rotateVertically, @NotNull VerticalRotation rotation) {
        Intrinsics.checkNotNullParameter((Object)$this$rotateVertically, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)rotation), (String)"rotation");
        return $this$rotateVertically.then((Modifier)new LayoutModifier(){

            public MeasureResult measure-3p2s80s(MeasureScope $this$measure_u2d3p2s80s, Measurable measurable2, long l) {
                Intrinsics.checkNotNullParameter((Object)$this$measure_u2d3p2s80s, (String)"$this$measure");
                Intrinsics.checkNotNullParameter((Object)measurable2, (String)"measurable");
                Placeable placeable = measurable2.measure-BRTryo0(l);
                return MeasureScope.layout$default((MeasureScope)$this$measure_u2d3p2s80s, (int)placeable.getHeight(), (int)placeable.getWidth(), null, arg_0 -> rotateVertically.1.measure_3p2s80s$lambda$0(placeable, arg_0), (int)4, null);
            }

            public int minIntrinsicHeight(IntrinsicMeasureScope $this$minIntrinsicHeight, IntrinsicMeasurable measurable2, int width) {
                Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicHeight, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)measurable2, (String)"measurable");
                return measurable2.maxIntrinsicWidth(width);
            }

            public int maxIntrinsicHeight(IntrinsicMeasureScope $this$maxIntrinsicHeight, IntrinsicMeasurable measurable2, int width) {
                Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicHeight, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)measurable2, (String)"measurable");
                return measurable2.maxIntrinsicWidth(width);
            }

            public int minIntrinsicWidth(IntrinsicMeasureScope $this$minIntrinsicWidth, IntrinsicMeasurable measurable2, int height) {
                Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicWidth, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)measurable2, (String)"measurable");
                return measurable2.minIntrinsicHeight(height);
            }

            public int maxIntrinsicWidth(IntrinsicMeasureScope $this$maxIntrinsicWidth, IntrinsicMeasurable measurable2, int height) {
                Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicWidth, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)measurable2, (String)"measurable");
                return measurable2.maxIntrinsicHeight(height);
            }

            private static final Unit measure_3p2s80s$lambda$0(Placeable $placeable, Placeable.PlacementScope $this$layout) {
                Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                Placeable.PlacementScope.place$default((Placeable.PlacementScope)$this$layout, (Placeable)$placeable, (int)(-($placeable.getWidth() / 2 - $placeable.getHeight() / 2)), (int)(-($placeable.getHeight() / 2 - $placeable.getWidth() / 2)), (float)0.0f, (int)4, null);
                return Unit.INSTANCE;
            }
        }).then(RotateKt.rotate((Modifier)$this$rotateVertically, (float)rotation.getValue$koalaplot_core()));
    }

    public static final float min(float ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        float m = 0.0f;
        m = Float.POSITIVE_INFINITY;
        float[] $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            float element$iv;
            float it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            m = Math.min(m, it);
        }
        return m;
    }

    public static final float max(float ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        float m = 0.0f;
        m = Float.NEGATIVE_INFINITY;
        float[] $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            float element$iv;
            float it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            m = Math.max(m, it);
        }
        return m;
    }

    @NotNull
    public static final Pair<Float, Vector> lineDistance(@NotNull Vector p1, @NotNull Vector p2, @NotNull Vector p0) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Vector line = VectorKt.line(p1, p2);
        Vector n = new Vector(-((Number)line.getValues().get(1)).floatValue(), ((Number)line.getValues().get(0)).floatValue());
        float distance = Math.abs(p0.minus$koalaplot_core(p1).times$koalaplot_core(n)) / n.norm$koalaplot_core();
        float scalar = p0.minus$koalaplot_core(p1).times$koalaplot_core(line);
        Vector point = p1.plus$koalaplot_core(VectorKt.times(scalar, line));
        return new Pair((Object)Float.valueOf(distance), (Object)point);
    }

    public static final long sign(long x2) {
        return x2 < 0L ? -1L : (x2 > 0L ? 1L : 0L);
    }

    public static final int sign(int x2) {
        return x2 < 0 ? -1 : (x2 > 0 ? 1 : 0);
    }
}

