/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.util;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.AwaitPointerEventScope;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerEventType;
import androidx.compose.ui.input.pointer.PointerEvent_skikoKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.SuspendingPointerInputFilter_skikoKt;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.IntSize;
import io.github.koalaplot.core.gestures.GestureConfig;
import io.github.koalaplot.core.gestures.GesturesKt;
import io.github.koalaplot.core.util.ExperimentalKoalaPlotApi;
import io.github.koalaplot.core.util.ZoomFactor;
import io.github.koalaplot.core.util.ZoomFactorKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u00ad\u0001\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2K\u0010\n\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000b26\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0001\u001a\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"ScrollDeltaMin", "", "ScrollDeltaMax", "onGestureInput", "Landroidx/compose/ui/Modifier;", "key1", "", "key2", "gestureConfig", "Lio/github/koalaplot/core/gestures/GestureConfig;", "onZoomChange", "Lkotlin/Function3;", "Landroidx/compose/ui/unit/IntSize;", "Lkotlin/ParameterName;", "name", "size", "Landroidx/compose/ui/geometry/Offset;", "centroid", "Lio/github/koalaplot/core/util/ZoomFactor;", "zoom", "", "onPanChange", "Lkotlin/Function2;", "pan", "", "normalizeScrollDeltaToZoom", "value", "koalaplot-core"})
@SourceDebugExtension(value={"SMAP\nModifierExtensions.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifierExtensions.desktop.kt\nio/github/koalaplot/core/util/ModifierExtensions_desktopKt\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 5 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,83:1\n71#2:84\n65#2:85\n73#2:88\n69#2:89\n60#3:86\n70#3:90\n22#4:87\n113#5:91\n*S KotlinDebug\n*F\n+ 1 ModifierExtensions.desktop.kt\nio/github/koalaplot/core/util/ModifierExtensions_desktopKt\n*L\n47#1:84\n47#1:85\n47#1:88\n47#1:89\n47#1:86\n47#1:90\n47#1:87\n64#1:91\n*E\n"})
public final class ModifierExtensions_desktopKt {
    private static final float ScrollDeltaMin = 0.75f;
    private static final float ScrollDeltaMax = 1.25f;

    @ExperimentalKoalaPlotApi
    @NotNull
    public static final Modifier onGestureInput(@NotNull Modifier $this$onGestureInput, @Nullable Object key1, @Nullable Object key2, @NotNull GestureConfig gestureConfig, @NotNull Function3<? super IntSize, ? super Offset, ? super ZoomFactor, Unit> onZoomChange, @NotNull Function2<? super IntSize, ? super Offset, Boolean> onPanChange) {
        Intrinsics.checkNotNullParameter((Object)$this$onGestureInput, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gestureConfig, (String)"gestureConfig");
        Intrinsics.checkNotNullParameter(onZoomChange, (String)"onZoomChange");
        Intrinsics.checkNotNullParameter(onPanChange, (String)"onPanChange");
        return $this$onGestureInput.then(SuspendingPointerInputFilter_skikoKt.onPointerEvent-88W8MhQ$default((Modifier)SuspendingPointerInputFilter_skikoKt.onPointerEvent-88W8MhQ$default((Modifier)((Modifier)Modifier.Companion), (int)PointerEventType.Companion.getMove-7fucELk(), null, (arg_0, arg_1) -> ModifierExtensions_desktopKt.onGestureInput$lambda$0(gestureConfig, onPanChange, arg_0, arg_1), (int)2, null), (int)PointerEventType.Companion.getScroll-7fucELk(), null, (arg_0, arg_1) -> ModifierExtensions_desktopKt.onGestureInput$lambda$1(gestureConfig, onZoomChange, onPanChange, arg_0, arg_1), (int)2, null));
    }

    public static final float normalizeScrollDeltaToZoom(float value) {
        return ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(1.0f - value), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.75f, (float)1.25f)))).floatValue();
    }

    private static final Unit onGestureInput$lambda$0(GestureConfig $gestureConfig, Function2 $onPanChange, AwaitPointerEventScope $this$onPointerEvent, PointerEvent event) {
        Intrinsics.checkNotNullParameter((Object)$this$onPointerEvent, (String)"$this$onPointerEvent");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!$gestureConfig.getPanEnabled()) {
            return Unit.INSTANCE;
        }
        PointerInputChange pointerInputChange = (PointerInputChange)CollectionsKt.lastOrNull((List)event.getChanges());
        if (pointerInputChange == null) {
            return Unit.INSTANCE;
        }
        PointerInputChange change = pointerInputChange;
        long pan = GesturesKt.applyPanLocks-9KIMszo(Offset.minus-MK-Hz9U((long)change.getPosition-F1C5BW0(), (long)change.getPreviousPosition-F1C5BW0()), $gestureConfig.getPanXEnabled(), $gestureConfig.getPanYEnabled());
        if (Offset.equals-impl0((long)pan, (long)Offset.Companion.getZero-F1C5BW0())) {
            return Unit.INSTANCE;
        }
        if (((Boolean)$onPanChange.invoke((Object)IntSize.box-impl((long)$this$onPointerEvent.getSize-YbymL2g()), (Object)Offset.box-impl((long)pan))).booleanValue()) {
            change.consume();
        }
        return Unit.INSTANCE;
    }

    private static final Unit onGestureInput$lambda$1(GestureConfig $gestureConfig, Function3 $onZoomChange, Function2 $onPanChange, AwaitPointerEventScope $this$onPointerEvent, PointerEvent event) {
        Intrinsics.checkNotNullParameter((Object)$this$onPointerEvent, (String)"$this$onPointerEvent");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PointerInputChange pointerInputChange = (PointerInputChange)CollectionsKt.lastOrNull((List)event.getChanges());
        if (pointerInputChange == null) {
            return Unit.INSTANCE;
        }
        PointerInputChange change = pointerInputChange;
        boolean isZoomEvent = PointerEvent_skikoKt.isCtrlPressed-5xRPYO0((int)event.getKeyboardModifiers-k7X9c1A());
        if (isZoomEvent && $gestureConfig.getZoomEnabled()) {
            long l;
            long l2;
            long arg0$iv = l2 = change.getScrollDelta-F1C5BW0();
            boolean bl = false;
            boolean bl2 = false;
            long value$iv$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv$iv = (int)(value$iv$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            float scrollX = Float.intBitsToFloat(bits$iv$iv$iv$iv);
            long arg0$iv2 = l2;
            boolean bl3 = false;
            boolean bl4 = false;
            long value$iv$iv$iv2 = arg0$iv2;
            boolean $i$f$unpackFloat2 = false;
            int bits$iv$iv$iv$iv2 = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
            boolean $i$f$floatFromBits2 = false;
            float scrollY = Float.intBitsToFloat(bits$iv$iv$iv$iv2);
            if (!$gestureConfig.getIndependentZoomEnabled()) {
                float maxZoomDeviation = GesturesKt.getMaxZoomDeviation(ModifierExtensions_desktopKt.normalizeScrollDeltaToZoom(scrollX), ModifierExtensions_desktopKt.normalizeScrollDeltaToZoom(scrollY));
                l = ZoomFactorKt.ZoomFactor(maxZoomDeviation, maxZoomDeviation);
            } else {
                l = ZoomFactorKt.ZoomFactor(ModifierExtensions_desktopKt.normalizeScrollDeltaToZoom(scrollX), ModifierExtensions_desktopKt.normalizeScrollDeltaToZoom(scrollY));
            }
            long rawZoom = l;
            long zoom = GesturesKt.applyZoomLocks-1NxU_30(rawZoom, $gestureConfig.getZoomXEnabled(), $gestureConfig.getZoomYEnabled());
            if (ZoomFactor.equals-impl0(zoom, ZoomFactor.Companion.getNeutral-DD4ouHY())) {
                return Unit.INSTANCE;
            }
            $onZoomChange.invoke((Object)IntSize.box-impl((long)$this$onPointerEvent.getSize-YbymL2g()), (Object)Offset.box-impl((long)change.getPosition-F1C5BW0()), (Object)ZoomFactor.box-impl(zoom));
            change.consume();
        } else if ($gestureConfig.getPanEnabled()) {
            int $this$dp$iv = 64;
            boolean $i$f$getDp = false;
            long rawPan = Offset.times-tuRUvjQ((long)change.getScrollDelta-F1C5BW0(), (float)(-$this$onPointerEvent.toPx-0680j_4(Dp.constructor-impl((float)$this$dp$iv))));
            long pan = GesturesKt.applyPanLocks-9KIMszo(rawPan, $gestureConfig.getPanXEnabled(), $gestureConfig.getPanYEnabled());
            if (Offset.equals-impl0((long)pan, (long)Offset.Companion.getZero-F1C5BW0())) {
                return Unit.INSTANCE;
            }
            if (((Boolean)$onPanChange.invoke((Object)IntSize.box-impl((long)$this$onPointerEvent.getSize-YbymL2g()), (Object)Offset.box-impl((long)pan))).booleanValue()) {
                change.consume();
            }
        }
        return Unit.INSTANCE;
    }
}

