/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.polar;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.koalaplot.core.polar.RadialAxisModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\b\t\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/github/koalaplot/core/polar/FloatRadialAxisModel;", "Lio/github/koalaplot/core/polar/RadialAxisModel;", "", "tickValues", "", "<init>", "(Ljava/util/List;)V", "getTickValues", "()Ljava/util/List;", "sortedTickValues", "range", "computeOffset", "point", "koalaplot-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFloatRadialAxisModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatRadialAxisModel.kt\nio/github/koalaplot/core/polar/FloatRadialAxisModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class FloatRadialAxisModel
implements RadialAxisModel<Float> {
    @NotNull
    private final List<Float> tickValues;
    @NotNull
    private final List<Float> sortedTickValues;
    private final float range;
    public static final int $stable = 8;

    public FloatRadialAxisModel(@NotNull List<Float> tickValues) {
        Intrinsics.checkNotNullParameter(tickValues, (String)"tickValues");
        this.tickValues = tickValues;
        if (!(this.getTickValues().size() >= 2)) {
            boolean bl = false;
            String string = "tickValues must have at least 2 values ";
            throw new IllegalArgumentException(string.toString());
        }
        this.sortedTickValues = CollectionsKt.sorted((Iterable)this.getTickValues());
        this.range = ((Number)CollectionsKt.last(this.sortedTickValues)).floatValue() - ((Number)CollectionsKt.first(this.sortedTickValues)).floatValue();
    }

    @Override
    @NotNull
    public List<Float> getTickValues() {
        return this.tickValues;
    }

    @Override
    public float computeOffset(float point) {
        return (point - ((Number)CollectionsKt.first(this.sortedTickValues)).floatValue()) / this.range;
    }
}

