/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.polar;

import io.github.koalaplot.core.util.AngularValue;
import io.github.koalaplot.core.util.GeometryKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001d"}, d2={"Lio/github/koalaplot/core/polar/AngularSector;", "", "minAngle", "Lio/github/koalaplot/core/util/AngularValue;", "maxAngle", "<init>", "(Lio/github/koalaplot/core/util/AngularValue;Lio/github/koalaplot/core/util/AngularValue;)V", "getMinAngle", "()Lio/github/koalaplot/core/util/AngularValue;", "getMaxAngle", "normalizedMin", "", "getNormalizedMin", "()D", "normalizedMax", "getNormalizedMax", "contains", "", "angle", "normalize", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "koalaplot-core"})
final class AngularSector {
    @NotNull
    private final AngularValue minAngle;
    @NotNull
    private final AngularValue maxAngle;
    private final double normalizedMin;
    private final double normalizedMax;

    public AngularSector(@NotNull AngularValue minAngle, @NotNull AngularValue maxAngle) {
        Intrinsics.checkNotNullParameter((Object)minAngle, (String)"minAngle");
        Intrinsics.checkNotNullParameter((Object)maxAngle, (String)"maxAngle");
        this.minAngle = minAngle;
        this.maxAngle = maxAngle;
        this.normalizedMin = this.normalize(GeometryKt.toDegrees(this.minAngle));
        this.normalizedMax = this.normalize(GeometryKt.toDegrees(this.maxAngle));
    }

    @NotNull
    public final AngularValue getMinAngle() {
        return this.minAngle;
    }

    @NotNull
    public final AngularValue getMaxAngle() {
        return this.maxAngle;
    }

    public final double getNormalizedMin() {
        return this.normalizedMin;
    }

    public final double getNormalizedMax() {
        return this.normalizedMax;
    }

    public final boolean contains(@NotNull AngularValue angle) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)angle, (String)"angle");
        double normalizedAngle = (GeometryKt.toDegrees(angle) % 360.0 + 360.0) % 360.0;
        if (this.normalizedMin > this.normalizedMax) {
            bl = normalizedAngle > this.normalizedMin || normalizedAngle < this.normalizedMax;
        } else {
            double d2 = this.normalizedMin;
            bl = normalizedAngle <= this.normalizedMax ? d2 <= normalizedAngle : false;
        }
        return bl;
    }

    private final double normalize(double angle) {
        return (GeometryKt.toDegrees(angle) % 360.0 + 360.0) % 360.0;
    }

    @NotNull
    public final AngularValue component1() {
        return this.minAngle;
    }

    @NotNull
    public final AngularValue component2() {
        return this.maxAngle;
    }

    @NotNull
    public final AngularSector copy(@NotNull AngularValue minAngle, @NotNull AngularValue maxAngle) {
        Intrinsics.checkNotNullParameter((Object)minAngle, (String)"minAngle");
        Intrinsics.checkNotNullParameter((Object)maxAngle, (String)"maxAngle");
        return new AngularSector(minAngle, maxAngle);
    }

    public static /* synthetic */ AngularSector copy$default(AngularSector angularSector, AngularValue angularValue, AngularValue angularValue2, int n, Object object) {
        if ((n & 1) != 0) {
            angularValue = angularSector.minAngle;
        }
        if ((n & 2) != 0) {
            angularValue2 = angularSector.maxAngle;
        }
        return angularSector.copy(angularValue, angularValue2);
    }

    @NotNull
    public String toString() {
        return "AngularSector(minAngle=" + this.minAngle + ", maxAngle=" + this.maxAngle + ")";
    }

    public int hashCode() {
        int result = this.minAngle.hashCode();
        result = result * 31 + this.maxAngle.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AngularSector)) {
            return false;
        }
        AngularSector angularSector = (AngularSector)other;
        if (!Intrinsics.areEqual((Object)this.minAngle, (Object)angularSector.minAngle)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.maxAngle, (Object)angularSector.maxAngle);
    }
}

