/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.gestures.zoom;

import androidx.compose.foundation.gestures.TransformGestureDetectorKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.unit.IntSize;
import io.github.koalaplot.core.gestures.GestureConfig;
import io.github.koalaplot.core.gestures.GesturesKt;
import io.github.koalaplot.core.gestures.zoom.ZoomHandler;
import io.github.koalaplot.core.util.ZoomFactor;
import io.github.koalaplot.core.util.ZoomFactorKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J|\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2K\u0010\u000f\u001aG\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0010H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u0015*\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\u0013*\u00020\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001b\u0010!\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u001c\u0010$\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/github/koalaplot/core/gestures/zoom/StickyAxisZoomHandler;", "Lio/github/koalaplot/core/gestures/zoom/ZoomHandler;", "minTouchesDistance", "", "<init>", "(F)V", "handle", "", "size", "Landroidx/compose/ui/unit/IntSize;", "event", "Landroidx/compose/ui/input/pointer/PointerEvent;", "isHorizontalZoom", "gestureConfig", "Lio/github/koalaplot/core/gestures/GestureConfig;", "onZoomChange", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Landroidx/compose/ui/geometry/Offset;", "centroid", "Lio/github/koalaplot/core/util/ZoomFactor;", "zoom", "", "handle-03bzQGs", "(JLandroidx/compose/ui/input/pointer/PointerEvent;ZLio/github/koalaplot/core/gestures/GestureConfig;Lkotlin/jvm/functions/Function3;)Z", "calculateZoomXY", "calculateZoomXY-Ocu8dYI", "(Landroidx/compose/ui/input/pointer/PointerEvent;)J", "calculateCentroidSizeXY", "useCurrent", "calculateCentroidSizeXY-dBAh8RU", "(Landroidx/compose/ui/input/pointer/PointerEvent;Z)J", "resetOrthogonalAxis", "resetOrthogonalAxis-QhFeFi0", "(JZ)J", "zoomGestureIsCorrect", "koalaplot-core"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nStickyAxisZoomHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StickyAxisZoomHandler.kt\nio/github/koalaplot/core/gestures/zoom/StickyAxisZoomHandler\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 5 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 6 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n*L\n1#1,119:1\n65#2:120\n69#2:123\n60#3:121\n70#3:124\n53#3,3:132\n22#4:122\n22#4:125\n35#5,5:126\n30#6:131\n*S KotlinDebug\n*F\n+ 1 StickyAxisZoomHandler.kt\nio/github/koalaplot/core/gestures/zoom/StickyAxisZoomHandler\n*L\n60#1:120\n61#1:123\n60#1:121\n61#1:124\n83#1:132,3\n60#1:122\n61#1:125\n74#1:126,5\n83#1:131\n*E\n"})
public final class StickyAxisZoomHandler
implements ZoomHandler {
    private final float minTouchesDistance;
    public static final int $stable;

    public StickyAxisZoomHandler(float minTouchesDistance) {
        this.minTouchesDistance = minTouchesDistance;
    }

    @Override
    public boolean handle-03bzQGs(long l, @NotNull PointerEvent event, boolean isHorizontalZoom, @NotNull GestureConfig gestureConfig, @NotNull Function3<? super IntSize, ? super Offset, ? super ZoomFactor, Unit> onZoomChange) {
        boolean zoomAllowed;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)gestureConfig, (String)"gestureConfig");
        Intrinsics.checkNotNullParameter(onZoomChange, (String)"onZoomChange");
        long zoomChange = GesturesKt.applyZoomLocks-1NxU_30(this.calculateZoomXY-Ocu8dYI(event), gestureConfig.getZoomXEnabled(), gestureConfig.getZoomYEnabled());
        zoomChange = this.resetOrthogonalAxis-QhFeFi0(zoomChange, isHorizontalZoom);
        boolean bl = zoomAllowed = gestureConfig.getZoomEnabled() && !ZoomFactor.equals-impl0(zoomChange, ZoomFactor.Companion.getNeutral-DD4ouHY()) && this.zoomGestureIsCorrect(event, this.minTouchesDistance, isHorizontalZoom);
        if (!zoomAllowed) {
            return false;
        }
        long centroid = TransformGestureDetectorKt.calculateCentroid((PointerEvent)event, (boolean)false);
        onZoomChange.invoke((Object)IntSize.box-impl((long)l), (Object)Offset.box-impl((long)centroid), (Object)ZoomFactor.box-impl(zoomChange));
        return true;
    }

    private final long calculateZoomXY-Ocu8dYI(PointerEvent $this$calculateZoomXY_u2dOcu8dYI) {
        long currentCentroidSize = this.calculateCentroidSizeXY-dBAh8RU($this$calculateZoomXY_u2dOcu8dYI, true);
        long previousCentroidSize = this.calculateCentroidSizeXY-dBAh8RU($this$calculateZoomXY_u2dOcu8dYI, false);
        if (Offset.equals-impl0((long)currentCentroidSize, (long)Offset.Companion.getZero-F1C5BW0()) || Offset.equals-impl0((long)previousCentroidSize, (long)Offset.Companion.getZero-F1C5BW0())) {
            return ZoomFactor.Companion.getNeutral-DD4ouHY();
        }
        long arg0$iv = currentCentroidSize;
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float f = Float.intBitsToFloat(bits$iv$iv$iv);
        arg0$iv = previousCentroidSize;
        bl = false;
        value$iv$iv = arg0$iv;
        $i$f$unpackFloat1 = false;
        bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        $i$f$floatFromBits = false;
        float f2 = f / Float.intBitsToFloat(bits$iv$iv$iv);
        arg0$iv = currentCentroidSize;
        boolean bl2 = false;
        value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        float f3 = Float.intBitsToFloat(bits$iv$iv$iv);
        arg0$iv = previousCentroidSize;
        bl2 = false;
        value$iv$iv = arg0$iv;
        $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        return ZoomFactorKt.ZoomFactor(f2, f3 / Float.intBitsToFloat(bits$iv$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final long calculateCentroidSizeXY-dBAh8RU(PointerEvent $this$calculateCentroidSizeXY_u2ddBAh8RU, boolean useCurrent) {
        void x$iv;
        long centroid = TransformGestureDetectorKt.calculateCentroid((PointerEvent)$this$calculateCentroidSizeXY_u2ddBAh8RU, (boolean)useCurrent);
        if (Offset.equals-impl0((long)centroid, (long)Offset.Companion.getUnspecified-F1C5BW0())) {
            return Offset.Companion.getZero-F1C5BW0();
        }
        float distanceToCentroidX = 0.0f;
        float distanceToCentroidY = 0.0f;
        int distanceWeight = 0;
        List $this$fastForEach$iv22 = $this$calculateCentroidSizeXY_u2ddBAh8RU.getChanges();
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv22).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Object item$iv = $this$fastForEach$iv22.get(index$iv);
            PointerInputChange change = (PointerInputChange)item$iv;
            boolean bl = false;
            if (!change.getPressed() || !change.getPreviousPressed()) continue;
            long position = useCurrent ? change.getPosition-F1C5BW0() : change.getPreviousPosition-F1C5BW0();
            long offsetToCentroid = Offset.minus-MK-Hz9U((long)position, (long)centroid);
            distanceToCentroidX += GesturesKt.getDistanceX-k-4lQ0M(offsetToCentroid);
            distanceToCentroidY += GesturesKt.getDistanceY-k-4lQ0M(offsetToCentroid);
            ++distanceWeight;
        }
        float $this$fastForEach$iv22 = distanceToCentroidX;
        float y$iv = distanceToCentroidY;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        return Offset.div-tuRUvjQ((long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)), (float)distanceWeight);
    }

    static /* synthetic */ long calculateCentroidSizeXY-dBAh8RU$default(StickyAxisZoomHandler stickyAxisZoomHandler, PointerEvent pointerEvent, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return stickyAxisZoomHandler.calculateCentroidSizeXY-dBAh8RU(pointerEvent, bl);
    }

    private final long resetOrthogonalAxis-QhFeFi0(long l, boolean isHorizontalZoom) {
        return ZoomFactor.copy-XAflt2c(l, isHorizontalZoom ? ZoomFactor.getX-impl(l) : 1.0f, !isHorizontalZoom ? ZoomFactor.getY-impl(l) : 1.0f);
    }

    private final boolean zoomGestureIsCorrect(PointerEvent $this$zoomGestureIsCorrect, float minTouchesDistance, boolean isHorizontalZoom) {
        Offset firstTouch = null;
        Offset secondTouch = null;
        for (PointerInputChange change : $this$zoomGestureIsCorrect.getChanges()) {
            if (!change.getPressed() || !change.getPreviousPressed()) continue;
            if (firstTouch == null) {
                firstTouch = Offset.box-impl((long)change.getPosition-F1C5BW0());
                continue;
            }
            secondTouch = Offset.box-impl((long)change.getPosition-F1C5BW0());
            break;
        }
        if (firstTouch == null || secondTouch == null) {
            return false;
        }
        long touchDiff = Offset.minus-MK-Hz9U((long)firstTouch.unbox-impl(), (long)secondTouch.unbox-impl());
        return isHorizontalZoom ? GesturesKt.getDistanceX-k-4lQ0M(touchDiff) > minTouchesDistance : GesturesKt.getDistanceY-k-4lQ0M(touchDiff) > minTouchesDistance;
    }
}

