/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.bar;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.koalaplot.core.bar.BarPosition;
import io.github.koalaplot.core.bar.HorizontalBarPlotEntry;
import io.github.koalaplot.core.bar.HorizontalBarPlotStackedPointEntry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003:\u0001\u0014B)\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0013\u001a\u00020\tH\u0096\u0002R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lio/github/koalaplot/core/bar/HorizontalStackToBarEntryAdapter;", "X", "Y", "Lkotlin/collections/AbstractList;", "Lio/github/koalaplot/core/bar/HorizontalBarPlotEntry;", "data", "", "Lio/github/koalaplot/core/bar/HorizontalBarPlotStackedPointEntry;", "barIndex", "", "<init>", "(Ljava/util/List;I)V", "getData", "()Ljava/util/List;", "getBarIndex", "()I", "size", "getSize", "get", "index", "HorizontalBarPositionAdapter", "koalaplot-core"})
final class HorizontalStackToBarEntryAdapter<X, Y>
extends AbstractList<HorizontalBarPlotEntry<X, Y>> {
    @NotNull
    private final List<HorizontalBarPlotStackedPointEntry<X, Y>> data;
    private final int barIndex;
    private final int size;

    public HorizontalStackToBarEntryAdapter(@NotNull List<? extends HorizontalBarPlotStackedPointEntry<X, Y>> data, int barIndex) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.data = data;
        this.barIndex = barIndex;
        this.size = this.data.size();
    }

    @NotNull
    public final List<HorizontalBarPlotStackedPointEntry<X, Y>> getData() {
        return this.data;
    }

    public final int getBarIndex() {
        return this.barIndex;
    }

    public int getSize() {
        return this.size;
    }

    @NotNull
    public HorizontalBarPlotEntry<X, Y> get(int index) {
        return new HorizontalBarPlotEntry<X, Y>(this, index){
            private final Y y;
            final /* synthetic */ HorizontalStackToBarEntryAdapter<X, Y> this$0;
            final /* synthetic */ int $index;
            {
                this.this$0 = $receiver;
                this.$index = $index;
                this.y = $receiver.getData().get($index).getY();
            }

            public Y getY() {
                return this.y;
            }

            public BarPosition<X> getX() {
                return new HorizontalBarPositionAdapter<X, Y>(this.this$0.getData().get(this.$index), this.this$0.getBarIndex());
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0007\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00028\u0002X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u000e\u001a\u00028\u0002X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0010"}, d2={"Lio/github/koalaplot/core/bar/HorizontalStackToBarEntryAdapter$HorizontalBarPositionAdapter;", "X", "Y", "Lio/github/koalaplot/core/bar/BarPosition;", "entry", "Lio/github/koalaplot/core/bar/HorizontalBarPlotStackedPointEntry;", "barIndex", "", "<init>", "(Lio/github/koalaplot/core/bar/HorizontalBarPlotStackedPointEntry;I)V", "start", "getStart", "()Ljava/lang/Object;", "Ljava/lang/Object;", "end", "getEnd", "koalaplot-core"})
    @StabilityInferred(parameters=1)
    public static final class HorizontalBarPositionAdapter<X, Y>
    implements BarPosition<X> {
        private final X start;
        private final X end;
        public static final int $stable;

        public HorizontalBarPositionAdapter(@NotNull HorizontalBarPlotStackedPointEntry<X, Y> entry, int barIndex) {
            Intrinsics.checkNotNullParameter(entry, (String)"entry");
            this.start = barIndex == 0 ? entry.getXOrigin() : entry.getX().get(RangesKt.coerceAtMost((int)(barIndex - 1), (int)CollectionsKt.getLastIndex(entry.getX())));
            this.end = entry.getX().get(RangesKt.coerceAtMost((int)barIndex, (int)CollectionsKt.getLastIndex(entry.getX())));
        }

        @Override
        public X getStart() {
            return this.start;
        }

        @Override
        public X getEnd() {
            return this.end;
        }
    }
}

