/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.shared.validators;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0007\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0002\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"verifyCPF", "", "strCpf", "", "CPF_PATTERN", "CPF_LENGTH", "", "isSameDigit", "cpf", "shared"})
public final class CpfValidatorKt {
    @NotNull
    private static final String CPF_PATTERN = "^(\\d{11})|(\\d{3}.\\d{3}.\\d{3}-\\d{2})$";
    private static final int CPF_LENGTH = 11;

    public static final boolean verifyCPF(@NotNull String strCpf) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)strCpf, (String)"strCpf");
        CharSequence charSequence = strCpf;
        if (!new Regex(CPF_PATTERN).matches(charSequence)) {
            bl = false;
        } else if (CpfValidatorKt.isSameDigit(strCpf)) {
            bl = false;
        } else {
            int d2;
            CharSequence charSequence2 = strCpf;
            Regex regex = new Regex("\\D");
            String string = "";
            String trimmedCpf = regex.replace(charSequence2, string);
            int d1 = d2 = 0;
            int digitCPF = 0;
            int n = CPF_LENGTH - 1;
            for (int nCount = 1; nCount < n; ++nCount) {
                String string2 = trimmedCpf.substring(nCount - 1, nCount);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                Integer n2 = StringsKt.toIntOrNull((String)string2);
                if (n2 == null) {
                    return false;
                }
                digitCPF = n2;
                d1 += (11 - nCount) * digitCPF;
                d2 += (12 - nCount) * digitCPF;
            }
            int rest = d1 % 11;
            int digit1 = rest < 2 ? 0 : 11 - rest;
            rest = (d2 += 2 * digit1) % 11;
            int digit2 = rest < 2 ? 0 : 11 - rest;
            String string3 = trimmedCpf.substring(CPF_LENGTH - 2, CPF_LENGTH);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String nDigVerific = string3;
            String nDigResult = "" + digit1 + digit2;
            bl = Intrinsics.areEqual((Object)nDigVerific, (Object)nDigResult);
        }
        return bl;
    }

    private static final boolean isSameDigit(String cpf) {
        if (cpf == null) {
            return false;
        }
        char[] cArray = cpf.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] cpfChar = cArray;
        if (((CharSequence)cpf).length() > 0) {
            int n = cpfChar.length;
            for (int i = 1; i < n; ++i) {
                if (cpfChar[i] == cpfChar[i - 1]) continue;
                return false;
            }
        }
        return true;
    }
}

