/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.shared.utils;

import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.shared.models.Locale;
import vet.inpulse.shared.utils.DateTimeFormatStyle;
import vet.inpulse.shared.utils.HoursMinutesSeconds;
import vet.inpulse.shared.utils.YearMonthDay;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\r\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0006H\u0002\u001a\n\u0010\"\u001a\u00020#*\u00020\u0010\u001a\n\u0010$\u001a\u00020%*\u00020\u0010\u001a\n\u0010&\u001a\u00020\u0010*\u00020\f\u001aF\u0010'\u001a\u00020(*\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\n2\b\b\u0002\u0010\u0016\u001a\u00020\n2\b\b\u0002\u0010)\u001a\u00020\n2\b\b\u0002\u0010*\u001a\u00020\n2\b\b\u0002\u0010+\u001a\u00020\n2\b\b\u0002\u0010,\u001a\u00020\n\u001a\n\u0010-\u001a\u00020\f*\u00020\u0010\u001a\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\f\u001a\n\u0010.\u001a\u00020/*\u00020\u0010\u001a\n\u00100\u001a\u00020\f*\u00020\u0010\u001a\n\u00101\u001a\u00020\n*\u00020\u0010\u001a\u0016\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020\f\u001a\u0012\u00105\u001a\u00020\u0010*\u00020\u00102\u0006\u00106\u001a\u00020\f\u001a\u0018\u00107\u001a\u00020\f2\u0006\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\fH\u0002\u001a\u0018\u0010:\u001a\u00020\n2\u0006\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\nH\u0002\u001a \u0010;\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002\"\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u000f\u001a\u00020\f*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\n*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0015\u0010\u0016\u001a\u00020\n*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\"\u0015\u0010\u0018\u001a\u00020\n*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015\"\u0015\u0010\u001a\u001a\u00020\n*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015\"\u0015\u0010\u001c\u001a\u00020\n*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015\"\u0015\u0010\u001e\u001a\u00020\n*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015\"\u0015\u0010 \u001a\u00020\n*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015\u00a8\u0006<"}, d2={"format", "", "Lkotlinx/datetime/LocalDate;", "locale", "Lvet/inpulse/shared/models/Locale;", "style", "Lvet/inpulse/shared/utils/DateTimeFormatStyle;", "toJava", "Ljava/time/format/FormatStyle;", "DAYS_PER_CYCLE", "", "DAYS_0000_TO_1970", "", "msInMonth", "ms12Hours", "msSinceEpoch", "Ljava/util/Calendar;", "getMsSinceEpoch", "(Ljava/util/Calendar;)J", "year", "getYear", "(Ljava/util/Calendar;)I", "month", "getMonth", "day", "getDay", "hour", "getHour", "minute", "getMinute", "second", "getSecond", "millisecond", "getMillisecond", "getYearMonthDay", "Lvet/inpulse/shared/utils/YearMonthDay;", "getHoursMinutesSeconds", "Lvet/inpulse/shared/utils/HoursMinutesSeconds;", "toCalendar", "setFields", "", "dayOfMonth", "hours", "minutes", "seconds", "getProlepticMonth", "isLeapYear", "", "toEpochDay", "lengthOfMonth", "getTimeBasedOnReference", "reference", "time", "plusMonths", "monthsToAdd", "floorDiv", "a", "b", "floorMod", "resolvePreviousValid", "shared"})
@SourceDebugExtension(value={"SMAP\nDateTimeUtils.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeUtils.jvm.kt\nvet/inpulse/shared/utils/DateTimeUtils_jvmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public final class DateTimeUtils_jvmKt {
    public static final int DAYS_PER_CYCLE = 146097;
    public static final long DAYS_0000_TO_1970 = 719528L;
    public static final long msInMonth = 2592000000L;
    public static final long ms12Hours = 43200000L;

    @NotNull
    public static final String format(@NotNull LocalDate $this$format, @NotNull Locale locale, @NotNull DateTimeFormatStyle style) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(DateTimeUtils_jvmKt.toJava(style)).withLocale(locale.getJvmLocale());
        String string = ConvertersKt.toJavaLocalDate((LocalDate)$this$format).format(formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private static final FormatStyle toJava(DateTimeFormatStyle $this$toJava) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toJava.ordinal()]) {
            case 1 -> FormatStyle.SHORT;
            case 2 -> FormatStyle.SHORT;
            case 3 -> FormatStyle.MEDIUM;
            case 4 -> FormatStyle.LONG;
            case 5 -> FormatStyle.FULL;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final long getMsSinceEpoch(@NotNull Calendar $this$msSinceEpoch) {
        Intrinsics.checkNotNullParameter((Object)$this$msSinceEpoch, (String)"<this>");
        return $this$msSinceEpoch.getTimeInMillis();
    }

    public static final int getYear(@NotNull Calendar $this$year) {
        Intrinsics.checkNotNullParameter((Object)$this$year, (String)"<this>");
        return $this$year.get(1);
    }

    public static final int getMonth(@NotNull Calendar $this$month) {
        Intrinsics.checkNotNullParameter((Object)$this$month, (String)"<this>");
        return $this$month.get(2);
    }

    public static final int getDay(@NotNull Calendar $this$day) {
        Intrinsics.checkNotNullParameter((Object)$this$day, (String)"<this>");
        return $this$day.get(5);
    }

    public static final int getHour(@NotNull Calendar $this$hour) {
        Intrinsics.checkNotNullParameter((Object)$this$hour, (String)"<this>");
        return $this$hour.get(11);
    }

    public static final int getMinute(@NotNull Calendar $this$minute) {
        Intrinsics.checkNotNullParameter((Object)$this$minute, (String)"<this>");
        return $this$minute.get(12);
    }

    public static final int getSecond(@NotNull Calendar $this$second) {
        Intrinsics.checkNotNullParameter((Object)$this$second, (String)"<this>");
        return $this$second.get(13);
    }

    public static final int getMillisecond(@NotNull Calendar $this$millisecond) {
        Intrinsics.checkNotNullParameter((Object)$this$millisecond, (String)"<this>");
        return $this$millisecond.get(14);
    }

    @NotNull
    public static final YearMonthDay getYearMonthDay(@NotNull Calendar $this$getYearMonthDay) {
        Intrinsics.checkNotNullParameter((Object)$this$getYearMonthDay, (String)"<this>");
        int currentYear = $this$getYearMonthDay.get(1);
        int currentMonth = $this$getYearMonthDay.get(2);
        int currentDayOfMonth = $this$getYearMonthDay.get(5);
        return new YearMonthDay(currentYear, currentMonth, currentDayOfMonth);
    }

    @NotNull
    public static final HoursMinutesSeconds getHoursMinutesSeconds(@NotNull Calendar $this$getHoursMinutesSeconds) {
        Intrinsics.checkNotNullParameter((Object)$this$getHoursMinutesSeconds, (String)"<this>");
        int hours = $this$getHoursMinutesSeconds.get(11);
        int minutes = $this$getHoursMinutesSeconds.get(12);
        int seconds = $this$getHoursMinutesSeconds.get(13);
        return new HoursMinutesSeconds(hours, minutes, seconds);
    }

    @NotNull
    public static final Calendar toCalendar(long $this$toCalendar) {
        Calendar calendar;
        Calendar it = calendar = Calendar.getInstance();
        boolean bl = false;
        it.setTimeInMillis($this$toCalendar);
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"also(...)");
        return calendar2;
    }

    public static final void setFields(@NotNull Calendar $this$setFields, int year, int month, int dayOfMonth, int hours, int minutes, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$setFields, (String)"<this>");
        $this$setFields.setTimeInMillis(0L);
        $this$setFields.set(1, year);
        $this$setFields.set(2, month);
        $this$setFields.set(5, dayOfMonth);
        $this$setFields.set(11, hours);
        $this$setFields.set(12, minutes);
        $this$setFields.set(13, seconds);
    }

    public static /* synthetic */ void setFields$default(Calendar calendar, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        if ((n7 & 1) != 0) {
            n = 1970;
        }
        if ((n7 & 2) != 0) {
            n2 = 0;
        }
        if ((n7 & 4) != 0) {
            n3 = 0;
        }
        if ((n7 & 8) != 0) {
            n4 = 0;
        }
        if ((n7 & 0x10) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x20) != 0) {
            n6 = 0;
        }
        DateTimeUtils_jvmKt.setFields(calendar, n, n2, n3, n4, n5, n6);
    }

    public static final long getProlepticMonth(@NotNull Calendar $this$getProlepticMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$getProlepticMonth, (String)"<this>");
        return (long)DateTimeUtils_jvmKt.getYear($this$getProlepticMonth) * 12L + (long)DateTimeUtils_jvmKt.getMonth($this$getProlepticMonth);
    }

    public static final boolean isLeapYear(long year) {
        return (year & 3L) == 0L && (year % (long)100 != 0L || year % (long)400 == 0L);
    }

    public static final boolean isLeapYear(@NotNull Calendar $this$isLeapYear) {
        Intrinsics.checkNotNullParameter((Object)$this$isLeapYear, (String)"<this>");
        return DateTimeUtils_jvmKt.isLeapYear($this$isLeapYear.get(1));
    }

    public static final long toEpochDay(@NotNull Calendar $this$toEpochDay) {
        Intrinsics.checkNotNullParameter((Object)$this$toEpochDay, (String)"<this>");
        int y = DateTimeUtils_jvmKt.getYear($this$toEpochDay);
        int m = DateTimeUtils_jvmKt.getMonth($this$toEpochDay);
        long total = 0L;
        total += (long)(365 * y);
        total = y >= 0 ? (total += (long)((y + 3) / 4 - (y + 99) / 100 + (y + 399) / 400)) : (total -= (long)(y / -4 - y / -100 + y / -400));
        total += (long)((367 * m - 362) / 12);
        total += (long)DateTimeUtils_jvmKt.getMonth($this$toEpochDay);
        if (m > 2) {
            long l = total;
            total = l + -1L;
            if (DateTimeUtils_jvmKt.isLeapYear($this$toEpochDay)) {
                l = total;
                total = l + -1L;
            }
        }
        return total - 719528L;
    }

    public static final int lengthOfMonth(@NotNull Calendar $this$lengthOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$lengthOfMonth, (String)"<this>");
        return switch (DateTimeUtils_jvmKt.getMonth($this$lengthOfMonth) + 1) {
            case 2 -> {
                if (DateTimeUtils_jvmKt.isLeapYear($this$lengthOfMonth)) {
                    yield 29;
                }
                yield 28;
            }
            case 4, 6, 9, 11 -> 30;
            default -> 31;
        };
    }

    public static final long getTimeBasedOnReference(long reference, long time) {
        Calendar calendar;
        Calendar ref = DateTimeUtils_jvmKt.toCalendar(reference);
        YearMonthDay yearMonthDay = DateTimeUtils_jvmKt.getYearMonthDay(ref);
        int yRef = yearMonthDay.component1();
        int mRef = yearMonthDay.component2();
        int dRef = yearMonthDay.component3();
        HoursMinutesSeconds hoursMinutesSeconds = DateTimeUtils_jvmKt.getHoursMinutesSeconds(DateTimeUtils_jvmKt.toCalendar(time));
        int hTime = hoursMinutesSeconds.component1();
        int mTime = hoursMinutesSeconds.component2();
        int sTime = hoursMinutesSeconds.component3();
        Calendar $this$getTimeBasedOnReference_u24lambda_u241 = calendar = DateTimeUtils_jvmKt.toCalendar(time);
        boolean bl = false;
        DateTimeUtils_jvmKt.setFields($this$getTimeBasedOnReference_u24lambda_u241, yRef, mRef, dRef, hTime, mTime, sTime);
        Calendar tOnDayOfRef = calendar;
        long diff = DateTimeUtils_jvmKt.getMsSinceEpoch(tOnDayOfRef) - DateTimeUtils_jvmKt.getMsSinceEpoch(ref);
        return diff < 43200000L ? DateTimeUtils_jvmKt.getMsSinceEpoch(tOnDayOfRef) + 86400000L : (diff > 43200000L ? DateTimeUtils_jvmKt.getMsSinceEpoch(tOnDayOfRef) - 86400000L : DateTimeUtils_jvmKt.getMsSinceEpoch(tOnDayOfRef));
    }

    @NotNull
    public static final Calendar plusMonths(@NotNull Calendar $this$plusMonths, long monthsToAdd) {
        Intrinsics.checkNotNullParameter((Object)$this$plusMonths, (String)"<this>");
        if (monthsToAdd == 0L) {
            return $this$plusMonths;
        }
        long monthCount = DateTimeUtils_jvmKt.getProlepticMonth($this$plusMonths);
        long calcMonths = monthCount + monthsToAdd;
        long newYear = DateTimeUtils_jvmKt.floorDiv(calcMonths, 12L);
        int newMonth = DateTimeUtils_jvmKt.floorMod(calcMonths, 12);
        return DateTimeUtils_jvmKt.resolvePreviousValid((int)newYear, newMonth, DateTimeUtils_jvmKt.getDay($this$plusMonths));
    }

    private static final long floorDiv(long a, long b) {
        return a >= 0L ? a / b : (a + 1L) / b - 1L;
    }

    private static final int floorMod(long a, int b) {
        return (int)((a % (long)b + (long)b) % (long)b);
    }

    private static final Calendar resolvePreviousValid(int year, int month, int day) {
        Calendar calendar;
        int d = switch (month + 1) {
            case 2 -> RangesKt.coerceAtMost((int)day, (int)(DateTimeUtils_jvmKt.isLeapYear(year) ? 29 : 28));
            case 4, 6, 9, 11 -> RangesKt.coerceAtMost((int)day, (int)30);
            default -> day;
        };
        Calendar $this$resolvePreviousValid_u24lambda_u242 = calendar = Calendar.getInstance();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$resolvePreviousValid_u24lambda_u242);
        DateTimeUtils_jvmKt.setFields$default($this$resolvePreviousValid_u24lambda_u242, year, month, d, 0, 0, 0, 56, null);
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"apply(...)");
        return calendar2;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DateTimeFormatStyle.values().length];
            try {
                nArray[DateTimeFormatStyle.ULTRA_SHORT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateTimeFormatStyle.SHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateTimeFormatStyle.MEDIUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateTimeFormatStyle.LONG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateTimeFormatStyle.FULL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

