/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.shared.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import kotlinx.datetime.DatePeriod;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateJvmKt;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.DateTimeFormatBuilderKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.shared.models.Locale;
import vet.inpulse.shared.utils.DateTimeFormatStyle;
import vet.inpulse.shared.utils.DateTimeUtils_jvmKt;
import vet.inpulse.shared.utils.YearMonthDay;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001e\u0010\u0007\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u001a(\u0010\u000e\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t\u001a\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0019"}, d2={"SHORT_AM_PM", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalTime;", "getSHORT_AM_PM", "()Lkotlinx/datetime/format/DateTimeFormat;", "MEDIUM_AM_PM", "getMEDIUM_AM_PM", "formatAsTime", "", "", "timeZone", "Lkotlinx/datetime/TimeZone;", "withSeconds", "", "formatAsDate", "locale", "Lvet/inpulse/shared/models/Locale;", "formatStyle", "Lvet/inpulse/shared/utils/DateTimeFormatStyle;", "getPeriodBetween", "Lvet/inpulse/shared/utils/YearMonthDay;", "start", "end", "shortenYearIfNeeded", "formatted", "shared"})
public final class DateTimeUtilsKt {
    private static final DateTimeFormat<LocalTime> getSHORT_AM_PM() {
        return LocalTime.Companion.Format(DateTimeUtilsKt::_get_SHORT_AM_PM_$lambda$0);
    }

    private static final DateTimeFormat<LocalTime> getMEDIUM_AM_PM() {
        return LocalTime.Companion.Format(DateTimeUtilsKt::_get_MEDIUM_AM_PM_$lambda$1);
    }

    @NotNull
    public static final String formatAsTime(long $this$formatAsTime, @NotNull TimeZone timeZone, boolean withSeconds) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        LocalTime localTime = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds($this$formatAsTime), (TimeZone)timeZone).getTime();
        return (withSeconds ? DateTimeUtilsKt.getMEDIUM_AM_PM() : DateTimeUtilsKt.getSHORT_AM_PM()).format((Object)localTime);
    }

    public static /* synthetic */ String formatAsTime$default(long l, TimeZone timeZone, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            timeZone = TimeZone.Companion.currentSystemDefault();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return DateTimeUtilsKt.formatAsTime(l, timeZone, bl);
    }

    @NotNull
    public static final String formatAsDate(long $this$formatAsDate, @NotNull Locale locale, @NotNull TimeZone timeZone, @NotNull DateTimeFormatStyle formatStyle) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        Intrinsics.checkNotNullParameter((Object)((Object)formatStyle), (String)"formatStyle");
        LocalDate localDate = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds($this$formatAsDate), (TimeZone)timeZone).getDate();
        String formatted = DateTimeUtils_jvmKt.format(localDate, locale, formatStyle);
        boolean bl = false;
        return formatStyle == DateTimeFormatStyle.ULTRA_SHORT ? DateTimeUtilsKt.shortenYearIfNeeded(formatted) : formatted;
    }

    public static /* synthetic */ String formatAsDate$default(long l, Locale locale, TimeZone timeZone, DateTimeFormatStyle dateTimeFormatStyle, int n, Object object) {
        if ((n & 1) != 0) {
            locale = Locale.Companion.getDefault();
        }
        if ((n & 2) != 0) {
            timeZone = TimeZone.Companion.currentSystemDefault();
        }
        if ((n & 4) != 0) {
            dateTimeFormatStyle = DateTimeFormatStyle.SHORT;
        }
        return DateTimeUtilsKt.formatAsDate(l, locale, timeZone, dateTimeFormatStyle);
    }

    @NotNull
    public static final YearMonthDay getPeriodBetween(long start, long end) {
        LocalDate dateStart = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(start), (TimeZone)TimeZone.Companion.currentSystemDefault()).getDate();
        LocalDate dateEnd = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(end), (TimeZone)TimeZone.Companion.currentSystemDefault()).getDate();
        DatePeriod a = LocalDateJvmKt.periodUntil((LocalDate)dateStart, (LocalDate)dateEnd);
        return new YearMonthDay(a.getYears(), a.getMonths(), a.getDays());
    }

    private static final String shortenYearIfNeeded(String formatted) {
        String year;
        String[] stringArray = new String[]{"/"};
        List parts = StringsKt.split$default((CharSequence)formatted, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() >= 3 && (year = (String)parts.get(2)).length() == 4) {
            return StringsKt.replace$default((String)formatted, (String)year, (String)StringsKt.takeLast((String)year, (int)2), (boolean)false, (int)4, null);
        }
        return formatted;
    }

    private static final Unit _get_SHORT_AM_PM_$lambda$0(DateTimeFormatBuilder.WithTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        DateTimeFormatBuilder.WithTime.hour$default((DateTimeFormatBuilder.WithTime)$this$Format, null, (int)1, null);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
        DateTimeFormatBuilder.WithTime.minute$default((DateTimeFormatBuilder.WithTime)$this$Format, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _get_MEDIUM_AM_PM_$lambda$1(DateTimeFormatBuilder.WithTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        DateTimeFormatBuilder.WithTime.hour$default((DateTimeFormatBuilder.WithTime)$this$Format, null, (int)1, null);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
        DateTimeFormatBuilder.WithTime.minute$default((DateTimeFormatBuilder.WithTime)$this$Format, null, (int)1, null);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
        DateTimeFormatBuilder.WithTime.second$default((DateTimeFormatBuilder.WithTime)$this$Format, null, (int)1, null);
        return Unit.INSTANCE;
    }
}

