/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.shared.repository.impl;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.shared.repository.FileCache;
import vet.inpulse.shared.repository.impl.InMemoryFileCacheKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001dB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lvet/inpulse/shared/repository/impl/InMemoryFileCache;", "Lvet/inpulse/shared/repository/FileCache;", "maxCacheSize", "", "<init>", "(J)V", "cache", "Lkotlin/collections/ArrayDeque;", "Lvet/inpulse/shared/repository/impl/InMemoryFileCache$Entry;", "lock", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "writeToCache", "", "key", "", "content", "Lokio/Source;", "(Ljava/lang/String;Lokio/Source;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeFromCache", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readFromCache", "totalEntries", "", "totalCacheSize", "evictCache", "minimumSpace", "moveToFirst", "entry", "Entry", "shared"})
@SourceDebugExtension(value={"SMAP\nInMemoryFileCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryFileCache.kt\nvet/inpulse/shared/repository/impl/InMemoryFileCache\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n72#2:91\n58#2,22:92\n1#3:114\n*S KotlinDebug\n*F\n+ 1 InMemoryFileCache.kt\nvet/inpulse/shared/repository/impl/InMemoryFileCache\n*L\n32#1:91\n32#1:92,22\n*E\n"})
public final class InMemoryFileCache
implements FileCache {
    private final long maxCacheSize;
    @NotNull
    private final ArrayDeque<Entry> cache;
    @NotNull
    private final Object lock;

    public InMemoryFileCache(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.cache = new ArrayDeque();
        this.lock = new Object();
    }

    public /* synthetic */ InMemoryFileCache(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = InMemoryFileCacheKt.access$getMB(20);
        }
        this(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Object writeToCache(@NotNull String key, @NotNull Source content, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.lock;
        synchronized (object) {
            Long l;
            Throwable thrown$iv;
            Buffer buffer;
            block18: {
                boolean bl = false;
                buffer = new Buffer();
                Closeable $this$use$iv = (Closeable)Okio.buffer((Source)content);
                boolean $i$f$use = false;
                thrown$iv = null;
                try {
                    BufferedSource input = (BufferedSource)$this$use$iv;
                    boolean bl2 = false;
                    l = Boxing.boxLong((long)buffer.writeAll((Source)input));
                }
                catch (Throwable t$iv) {
                    try {
                        thrown$iv = t$iv;
                        l = null;
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block19: {
                            try {
                                Closeable closeable = $this$use$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv2) {
                                if (thrown$iv == null) {
                                    thrown$iv = t$iv2;
                                    break block19;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv) {
                    thrown$iv = t$iv;
                }
            }
            Long result$iv = l;
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
            long size = buffer.size();
            if (size < this.maxCacheSize) {
                this.evictCache(size);
                byte[] data = buffer.readByteArray();
                Entry entry = new Entry(key, size, data);
                this.moveToFirst(entry);
            }
            Unit unit = Unit.INSTANCE;
            return Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object removeFromCache(@NotNull String key, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = CollectionsKt.removeAll((List)((List)this.cache), arg_0 -> InMemoryFileCache.removeFromCache$lambda$3$lambda$2(key, arg_0));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object readFromCache(@Nullable String key, @NotNull Continuation<? super Source> $completion) {
        Buffer buffer;
        Object object = this.lock;
        synchronized (object) {
            Buffer buffer2;
            boolean bl = false;
            if (key == null) {
                buffer2 = null;
            } else {
                Object v1;
                block8: {
                    Iterable iterable = (Iterable)this.cache;
                    for (Object t : iterable) {
                        Entry it = (Entry)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getKey(), (Object)key)) continue;
                        v1 = t;
                        break block8;
                    }
                    v1 = null;
                }
                Entry entry = v1;
                if (entry == null) {
                    buffer2 = null;
                } else {
                    Buffer buffer3;
                    Buffer buffer4;
                    Entry entry2 = entry;
                    this.moveToFirst(entry2);
                    Buffer $this$readFromCache_u24lambda_u246_u24lambda_u245 = buffer4 = new Buffer();
                    boolean bl3 = false;
                    $this$readFromCache_u24lambda_u246_u24lambda_u245.write(entry2.getData());
                    buffer2 = buffer3 = buffer4;
                }
            }
            buffer = buffer2;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int totalEntries() {
        int n;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            n = this.cache.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final long totalCacheSize() {
        long l;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Iterable iterable = (Iterable)this.cache;
            int n = 0;
            for (Object t : iterable) {
                void it;
                Entry entry = (Entry)t;
                int n2 = n;
                boolean bl2 = false;
                int n3 = (int)it.getSize();
                n = n2 + n3;
            }
            l = n;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void evictCache(long minimumSpace) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!(minimumSpace > 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long size = this.maxCacheSize - minimumSpace;
            while (this.totalCacheSize() > size) {
                this.cache.removeLast();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void moveToFirst(Entry entry) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.cache.remove((Object)entry);
            this.cache.addFirst((Object)entry);
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final boolean removeFromCache$lambda$3$lambda$2(String $key, Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getKey(), (Object)$key);
    }

    public InMemoryFileCache() {
        this(0L, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lvet/inpulse/shared/repository/impl/InMemoryFileCache$Entry;", "", "key", "", "size", "", "data", "", "<init>", "(Ljava/lang/String;J[B)V", "getKey", "()Ljava/lang/String;", "getSize", "()J", "getData", "()[B", "equals", "", "other", "hashCode", "", "component1", "component2", "component3", "copy", "toString", "shared"})
    private static final class Entry {
        @NotNull
        private final String key;
        private final long size;
        @NotNull
        private final byte[] data;

        public Entry(@NotNull String key, long size, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.key = key;
            this.size = size;
            this.data = data;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final long getSize() {
            return this.size;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.key, (Object)((Entry)other).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        public final long component2() {
            return this.size;
        }

        @NotNull
        public final byte[] component3() {
            return this.data;
        }

        @NotNull
        public final Entry copy(@NotNull String key, long size, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new Entry(key, size, data);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, String string, long l, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                string = entry.key;
            }
            if ((n & 2) != 0) {
                l = entry.size;
            }
            if ((n & 4) != 0) {
                byArray = entry.data;
            }
            return entry.copy(string, l, byArray);
        }

        @NotNull
        public String toString() {
            return "Entry(key=" + this.key + ", size=" + this.size + ", data=" + Arrays.toString(this.data) + ")";
        }
    }
}

