/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.shared.models;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.SystemInfo;
import vet.inpulse.shared.models.KotlinPlatform;
import vet.inpulse.shared.models.NativePlatformKt;
import vet.inpulse.shared.utils.StringExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010#\u001a\u00020\u0010H\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\t\u001a\u0004\b\u0015\u0010\u0012R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\t\u001a\u0004\b\u0018\u0010\u0012R\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\t\u001a\u0004\b\u001b\u0010\u0012R\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\t\u001a\u0004\b\u001e\u0010\u0012R\u001d\u0010 \u001a\u0004\u0018\u00010\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\t\u001a\u0004\b!\u0010\u0012\u00a8\u0006$"}, d2={"Lvet/inpulse/shared/models/NativePlatform;", "", "<init>", "()V", "systemInfo", "Loshi/SystemInfo;", "getSystemInfo", "()Loshi/SystemInfo;", "systemInfo$delegate", "Lkotlin/Lazy;", "current", "Lvet/inpulse/shared/models/KotlinPlatform;", "getCurrent", "()Lvet/inpulse/shared/models/KotlinPlatform;", "current$delegate", "osName", "", "getOsName", "()Ljava/lang/String;", "osName$delegate", "osVersion", "getOsVersion", "osVersion$delegate", "osArchitecture", "getOsArchitecture", "osArchitecture$delegate", "manufacturer", "getManufacturer", "manufacturer$delegate", "modelName", "getModelName", "modelName$delegate", "jvmInfo", "getJvmInfo", "jvmInfo$delegate", "toString", "shared"})
public final class NativePlatform {
    @NotNull
    public static final NativePlatform INSTANCE = new NativePlatform();
    @NotNull
    private static final Lazy systemInfo$delegate = LazyKt.lazy(NativePlatform::systemInfo_delegate$lambda$0);
    @NotNull
    private static final Lazy current$delegate = LazyKt.lazy(NativePlatform::current_delegate$lambda$1);
    @NotNull
    private static final Lazy osName$delegate = LazyKt.lazy(NativePlatform::osName_delegate$lambda$2);
    @NotNull
    private static final Lazy osVersion$delegate = LazyKt.lazy(NativePlatform::osVersion_delegate$lambda$3);
    @NotNull
    private static final Lazy osArchitecture$delegate = LazyKt.lazy(NativePlatform::osArchitecture_delegate$lambda$4);
    @NotNull
    private static final Lazy manufacturer$delegate = LazyKt.lazy(NativePlatform::manufacturer_delegate$lambda$5);
    @NotNull
    private static final Lazy modelName$delegate = LazyKt.lazy(NativePlatform::modelName_delegate$lambda$6);
    @NotNull
    private static final Lazy jvmInfo$delegate = LazyKt.lazy(NativePlatform::jvmInfo_delegate$lambda$7);

    private NativePlatform() {
    }

    private final SystemInfo getSystemInfo() {
        Lazy lazy = systemInfo$delegate;
        return (SystemInfo)lazy.getValue();
    }

    @NotNull
    public final KotlinPlatform getCurrent() {
        Lazy lazy = current$delegate;
        return (KotlinPlatform)lazy.getValue();
    }

    @Nullable
    public final String getOsName() {
        Lazy lazy = osName$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getOsVersion() {
        Lazy lazy = osVersion$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getOsArchitecture() {
        Lazy lazy = osArchitecture$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getManufacturer() {
        Lazy lazy = manufacturer$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getModelName() {
        Lazy lazy = modelName$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getJvmInfo() {
        Lazy lazy = jvmInfo$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return NativePlatformKt.describe(this);
    }

    private static final SystemInfo systemInfo_delegate$lambda$0() {
        return new SystemInfo();
    }

    private static final KotlinPlatform.Desktop current_delegate$lambda$1() {
        String string = INSTANCE.getOsName();
        if (string == null || (string = StringExtensionsKt.normalize(string)) == null) {
            return new KotlinPlatform.Desktop.Other("Operating System not detected");
        }
        String name = string;
        return StringsKt.contains$default((CharSequence)name, (CharSequence)"mac", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)"darwin", (boolean)false, (int)2, null) ? (KotlinPlatform.Desktop)KotlinPlatform.Desktop.Mac.INSTANCE : (StringsKt.contains$default((CharSequence)name, (CharSequence)"win", (boolean)false, (int)2, null) ? (KotlinPlatform.Desktop)KotlinPlatform.Desktop.Win.INSTANCE : (StringsKt.contains$default((CharSequence)name, (CharSequence)"nux", (boolean)false, (int)2, null) ? (KotlinPlatform.Desktop)KotlinPlatform.Desktop.Linux.INSTANCE : (KotlinPlatform.Desktop)new KotlinPlatform.Desktop.Other(name)));
    }

    private static final String osName_delegate$lambda$2() {
        return System.getProperty("os.name");
    }

    private static final String osVersion_delegate$lambda$3() {
        return System.getProperty("os.version");
    }

    private static final String osArchitecture_delegate$lambda$4() {
        return System.getProperty("os.arch");
    }

    private static final String manufacturer_delegate$lambda$5() {
        return INSTANCE.getSystemInfo().getHardware().getComputerSystem().getManufacturer();
    }

    private static final String modelName_delegate$lambda$6() {
        return INSTANCE.getSystemInfo().getHardware().getComputerSystem().getModel();
    }

    private static final String jvmInfo_delegate$lambda$7() {
        return System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")";
    }
}

