/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.shared.log;

import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.shared.log.DefaultInstantFormatter;
import vet.inpulse.shared.log.InstantFormatter;
import vet.inpulse.shared.log.LogColor;
import vet.inpulse.shared.log.LogEvent;
import vet.inpulse.shared.log.LogFormatter;
import vet.inpulse.shared.log.LogLevel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lvet/inpulse/shared/log/DefaultLoggerFormatter;", "Lvet/inpulse/shared/log/LogFormatter;", "colorMap", "", "Lvet/inpulse/shared/log/LogLevel;", "Lvet/inpulse/shared/log/LogColor;", "timeFormatter", "Lvet/inpulse/shared/log/InstantFormatter;", "printLevel", "", "<init>", "(Ljava/util/Map;Lvet/inpulse/shared/log/InstantFormatter;Z)V", "format", "", "event", "Lvet/inpulse/shared/log/LogEvent;", "shared"})
public final class DefaultLoggerFormatter
implements LogFormatter {
    @Nullable
    private final Map<LogLevel, LogColor> colorMap;
    @Nullable
    private final InstantFormatter timeFormatter;
    private final boolean printLevel;

    public DefaultLoggerFormatter(@Nullable Map<LogLevel, LogColor> colorMap, @Nullable InstantFormatter timeFormatter, boolean printLevel) {
        this.colorMap = colorMap;
        this.timeFormatter = timeFormatter;
        this.printLevel = printLevel;
    }

    public /* synthetic */ DefaultLoggerFormatter(Map map, InstantFormatter instantFormatter, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = LogColor.Companion.createColorMap-lVuF2OM$default(LogColor.Companion, null, null, null, null, null, null, 63, null);
        }
        if ((n & 2) != 0) {
            instantFormatter = new DefaultInstantFormatter(null, 0, 3, null);
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(map, instantFormatter, bl);
    }

    @Override
    @NotNull
    public String format(@NotNull LogEvent event) {
        Object object;
        String logColor;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        StringBuilder $this$format_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Map<LogLevel, LogColor> map = this.colorMap;
        if (map != null) {
            LogColor logColor2 = map.get(event.getLevel());
            v2 = logColor2 != null ? logColor2.unbox-impl() : null;
        } else {
            v2 = logColor = null;
        }
        if (logColor != null) {
            $this$format_u24lambda_u243.append(LogColor.box-impl(logColor));
        }
        if ((object = this.timeFormatter) != null && (object = object.format(event.getTime())) != null) {
            Object it = object;
            boolean bl2 = false;
            $this$format_u24lambda_u243.append("[");
            $this$format_u24lambda_u243.append((String)it);
            $this$format_u24lambda_u243.append("]");
        }
        if (this.printLevel) {
            $this$format_u24lambda_u243.append("[");
            $this$format_u24lambda_u243.append(switch (WhenMappings.$EnumSwitchMapping$0[event.getLevel().ordinal()]) {
                case 1 -> "TRC";
                case 2 -> "VRB";
                case 3 -> "DBG";
                case 4 -> "INF";
                case 5 -> "WAR";
                case 6 -> "ERR";
                default -> throw new NoWhenBranchMatchedException();
            });
            $this$format_u24lambda_u243.append("]");
        }
        $this$format_u24lambda_u243.append(" ");
        $this$format_u24lambda_u243.append(event.getModuleName());
        $this$format_u24lambda_u243.append(" - ");
        $this$format_u24lambda_u243.append(event.getTag());
        $this$format_u24lambda_u243.append(": ");
        $this$format_u24lambda_u243.append(event.getMessage());
        Throwable throwable = event.getError();
        if (throwable != null) {
            Throwable ex = throwable;
            boolean bl3 = false;
            $this$format_u24lambda_u243.append(" --> ");
            $this$format_u24lambda_u243.append(ex.getMessage());
            String stack = ExceptionsKt.stackTraceToString((Throwable)ex);
            boolean bl4 = false;
            $this$format_u24lambda_u243.append("\n");
            $this$format_u24lambda_u243.append(stack);
        }
        $this$format_u24lambda_u243.append("\n");
        if (logColor != null) {
            $this$format_u24lambda_u243.append(LogColor.box-impl(LogColor.Companion.getReset-vvybZsk()));
        }
        return stringBuilder.toString();
    }

    public DefaultLoggerFormatter() {
        this(null, null, false, 7, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.VERBOSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.DEBUG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.INFO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.WARNING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ERROR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

