/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.core;

import androidx.datastore.core.CorruptionException;
import androidx.datastore.core.Serializer;
import androidx.datastore.preferences.PreferencesMapCompat;
import androidx.datastore.preferences.PreferencesProto;
import androidx.datastore.preferences.core.MutablePreferences;
import androidx.datastore.preferences.core.Preferences;
import androidx.datastore.preferences.core.PreferencesFactory;
import androidx.datastore.preferences.core.PreferencesKeys;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Landroidx/datastore/preferences/core/PreferencesFileSerializer;", "Landroidx/datastore/core/Serializer;", "Landroidx/datastore/preferences/core/Preferences;", "<init>", "()V", "fileExtension", "", "defaultValue", "getDefaultValue", "()Landroidx/datastore/preferences/core/Preferences;", "readFrom", "input", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeTo", "", "t", "output", "Ljava/io/OutputStream;", "(Landroidx/datastore/preferences/core/Preferences;Ljava/io/OutputStream;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getValueProto", "Landroidx/datastore/preferences/PreferencesProto$Value;", "value", "", "addProtoEntryToPreferences", "name", "mutablePreferences", "Landroidx/datastore/preferences/core/MutablePreferences;", "datastore-preferences-core"})
@SourceDebugExtension(value={"SMAP\nPreferencesFileSerializer.jvmAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreferencesFileSerializer.jvmAndroid.kt\nandroidx/datastore/preferences/core/PreferencesFileSerializer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,114:1\n216#2,2:115\n*S KotlinDebug\n*F\n+ 1 PreferencesFileSerializer.jvmAndroid.kt\nandroidx/datastore/preferences/core/PreferencesFileSerializer\n*L\n50#1:115,2\n*E\n"})
public final class PreferencesFileSerializer
implements Serializer<Preferences> {
    @NotNull
    public static final PreferencesFileSerializer INSTANCE = new PreferencesFileSerializer();
    @NotNull
    public static final String fileExtension = "preferences_pb";

    private PreferencesFileSerializer() {
    }

    @NotNull
    public Preferences getDefaultValue() {
        return PreferencesFactory.createEmpty();
    }

    @Nullable
    public Object readFrom(@NotNull InputStream input, @NotNull Continuation<? super Preferences> $completion) throws IOException, CorruptionException {
        PreferencesProto.PreferenceMap preferencesProto = PreferencesMapCompat.Companion.readFrom(input);
        MutablePreferences mutablePreferences = PreferencesFactory.createMutable(new Preferences.Pair[0]);
        Map map = preferencesProto.getPreferencesMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getPreferencesMap(...)");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            PreferencesProto.Value value = (PreferencesProto.Value)entry.getValue();
            Intrinsics.checkNotNull((Object)name);
            Intrinsics.checkNotNull((Object)value);
            INSTANCE.addProtoEntryToPreferences(name, value, mutablePreferences);
        }
        return mutablePreferences.toPreferences();
    }

    @Nullable
    public Object writeTo(@NotNull Preferences t, @NotNull OutputStream output, @NotNull Continuation<? super Unit> $completion) throws IOException, CorruptionException {
        Map<Preferences.Key<?>, Object> preferences = t.asMap();
        PreferencesProto.PreferenceMap.Builder protoBuilder = PreferencesProto.PreferenceMap.newBuilder();
        for (Map.Entry<Preferences.Key<?>, Object> entry : preferences.entrySet()) {
            Preferences.Key<?> key = entry.getKey();
            Object value = entry.getValue();
            protoBuilder.putPreferences(key.getName(), this.getValueProto(value));
        }
        ((PreferencesProto.PreferenceMap)protoBuilder.build()).writeTo(output);
        return Unit.INSTANCE;
    }

    private final PreferencesProto.Value getValueProto(Object value) {
        PreferencesProto.Value value2;
        Object object = value;
        if (object instanceof Boolean) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setBoolean(((Boolean)value).booleanValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"build(...)");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof Float) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setFloat(((Number)value).floatValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"build(...)");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof Double) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setDouble(((Number)value).doubleValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"build(...)");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof Integer) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setInteger(((Number)value).intValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"build(...)");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof Long) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setLong(((Number)value).longValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"build(...)");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof String) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setString((String)value).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"build(...)");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof Set) {
            PreferencesProto.Value.Builder builder = PreferencesProto.Value.newBuilder();
            PreferencesProto.StringSet.Builder builder2 = PreferencesProto.StringSet.newBuilder();
            Object object2 = value;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Set<kotlin.String>");
            GeneratedMessageLite generatedMessageLite = builder.setStringSet(builder2.addAllStrings((Iterable)((Set)object2))).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"build(...)");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof byte[]) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setBytes(ByteString.copyFrom((byte[])((byte[])value))).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"build(...)");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else {
            throw new IllegalStateException("PreferencesSerializer does not support type: " + value.getClass().getName());
        }
        return value2;
    }

    private final void addProtoEntryToPreferences(String name, PreferencesProto.Value value, MutablePreferences mutablePreferences) {
        PreferencesProto.Value.ValueCase valueCase = value.getValueCase();
        switch (valueCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[valueCase.ordinal()]) {
            case 1: {
                mutablePreferences.set(PreferencesKeys.booleanKey(name), value.getBoolean());
                break;
            }
            case 2: {
                mutablePreferences.set(PreferencesKeys.floatKey(name), Float.valueOf(value.getFloat()));
                break;
            }
            case 3: {
                mutablePreferences.set(PreferencesKeys.doubleKey(name), value.getDouble());
                break;
            }
            case 4: {
                mutablePreferences.set(PreferencesKeys.intKey(name), value.getInteger());
                break;
            }
            case 5: {
                mutablePreferences.set(PreferencesKeys.longKey(name), value.getLong());
                break;
            }
            case 6: {
                mutablePreferences.set(PreferencesKeys.stringKey(name), value.getString());
                break;
            }
            case 7: {
                Preferences.Key<Set<String>> key = PreferencesKeys.stringSetKey(name);
                List list = value.getStringSet().getStringsList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringsList(...)");
                mutablePreferences.set(key, CollectionsKt.toSet((Iterable)list));
                break;
            }
            case 8: {
                mutablePreferences.set(PreferencesKeys.byteArrayKey(name), value.getBytes().toByteArray());
                break;
            }
            case 9: {
                throw new CorruptionException("Value not set.", null, 2, null);
            }
            case -1: {
                throw new CorruptionException("Value case is null.", null, 2, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PreferencesProto.Value.ValueCase.values().length];
            try {
                nArray[PreferencesProto.Value.ValueCase.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PreferencesProto.Value.ValueCase.FLOAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PreferencesProto.Value.ValueCase.DOUBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PreferencesProto.Value.ValueCase.INTEGER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PreferencesProto.Value.ValueCase.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PreferencesProto.Value.ValueCase.STRING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PreferencesProto.Value.ValueCase.STRING_SET.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PreferencesProto.Value.ValueCase.BYTES.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PreferencesProto.Value.ValueCase.VALUE_NOT_SET.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

