/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.desktop.util;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.SetupApi;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.locator.DeviceInterfaceInfo;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.desktop.util.SetupApiExt;
import vet.inpulse.shared.log.LoggerInterface;
import vet.inpulse.shared.log.LoggerModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\u0006\u0010\u0018\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0019"}, d2={"Lvet/inpulse/libcomm/desktop/util/WindowsSerialRegistryHelper;", "", "<init>", "()V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "KEY_READ", "", "SPDRP_HARDWAREID", "usbVidPidRegex", "Lkotlin/text/Regex;", "getUsbVidPidRegex", "()Lkotlin/text/Regex;", "ftdiVidPidRegex", "getFtdiVidPidRegex", "createPointerWideString", "Lcom/sun/jna/Memory;", "string", "", "getWindowsSerialPorts", "", "Lvet/inpulse/libcomm/core/locator/DeviceInterfaceInfo$Serial;", "getSetupGuidsForName", "Lcom/sun/jna/platform/win32/Guid$GUID;", "name", "libcomm"})
@SourceDebugExtension(value={"SMAP\nWindowsSerialRegistryHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsSerialRegistryHelper.kt\nvet/inpulse/libcomm/desktop/util/WindowsSerialRegistryHelper\n+ 2 LoggerModels.kt\nvet/inpulse/shared/log/LoggerModelsKt\n*L\n1#1,203:1\n65#2:204\n*S KotlinDebug\n*F\n+ 1 WindowsSerialRegistryHelper.kt\nvet/inpulse/libcomm/desktop/util/WindowsSerialRegistryHelper\n*L\n52#1:204\n*E\n"})
public final class WindowsSerialRegistryHelper {
    @NotNull
    public static final WindowsSerialRegistryHelper INSTANCE = new WindowsSerialRegistryHelper();
    @NotNull
    private static final LoggerInterface logger;
    public static final int KEY_READ = 131097;
    public static final int SPDRP_HARDWAREID = 1;
    @NotNull
    private static final Regex usbVidPidRegex;
    @NotNull
    private static final Regex ftdiVidPidRegex;

    private WindowsSerialRegistryHelper() {
    }

    @NotNull
    public final Regex getUsbVidPidRegex() {
        return usbVidPidRegex;
    }

    @NotNull
    public final Regex getFtdiVidPidRegex() {
        return ftdiVidPidRegex;
    }

    private final Memory createPointerWideString(String string) {
        int length = (string.length() + 1) * 2;
        Memory memory = new Memory((long)length);
        memory.setWideString(0L, string);
        return memory;
    }

    @NotNull
    public final List<DeviceInterfaceInfo.Serial> getWindowsSerialPorts() {
        SetupApi setupApi = SetupApi.INSTANCE;
        Advapi32 advapi = Advapi32.INSTANCE;
        SetupApiExt ext = SetupApiExt.Companion.getINSTANCE();
        List serialPorts = new ArrayList();
        List<Guid.GUID> portsGuids = this.getSetupGuidsForName("Ports");
        List<Guid.GUID> modemGuids = this.getSetupGuidsForName("Modem");
        List guidsToQuery = CollectionsKt.plus((Collection)portsGuids, (Iterable)modemGuids);
        for (Guid.GUID guid : guidsToQuery) {
            WinNT.HANDLE deviceInfoSet = setupApi.SetupDiGetClassDevs(guid, null, null, 2);
            if (Intrinsics.areEqual((Object)deviceInfoSet, (Object)WinBase.INVALID_HANDLE_VALUE)) continue;
            SetupApi.SP_DEVINFO_DATA deviceInfoData = new SetupApi.SP_DEVINFO_DATA();
            int memberIndex = 0;
            while (setupApi.SetupDiEnumDeviceInfo(deviceInfoSet, memberIndex++, deviceInfoData)) {
                Sequence sequence;
                WinReg.HKEY hKey = setupApi.SetupDiOpenDevRegKey(deviceInfoSet, deviceInfoData, 1, 0, 1, 131097);
                if (Intrinsics.areEqual((Object)hKey, (Object)WinBase.INVALID_HANDLE_VALUE)) continue;
                Memory portNameBuffer = new Memory(256L);
                IntByReference portNameLength = new IntByReference((int)portNameBuffer.size());
                int queryRes = advapi.RegQueryValueEx(hKey, "PortName", 0, null, (Pointer)portNameBuffer, portNameLength);
                advapi.RegCloseKey(hKey);
                if (queryRes != 0) continue;
                String portName = portNameBuffer.getWideString(0L);
                Intrinsics.checkNotNull((Object)portName);
                if (StringsKt.startsWith$default((String)portName, (String)"LPT", (boolean)false, (int)2, null)) continue;
                Memory hardwareIdPointer = new Memory(256L);
                IntByReference requiredSize = new IntByReference();
                Intrinsics.checkNotNull((Object)deviceInfoSet);
                if (!ext.SetupDiGetDeviceInstanceIdW(deviceInfoSet, deviceInfoData, (Pointer)hardwareIdPointer, (int)hardwareIdPointer.size(), requiredSize) && !ext.SetupDiGetDeviceRegistryPropertyW(deviceInfoSet, deviceInfoData, 1, null, (Pointer)hardwareIdPointer, (int)hardwareIdPointer.size(), requiredSize)) continue;
                String hardwareId = hardwareIdPointer.getWideString(0L);
                LoggerInterface.t$default((LoggerInterface)logger, null, () -> WindowsSerialRegistryHelper.getWindowsSerialPorts$lambda$0(portName, hardwareId), (int)1, null);
                Intrinsics.checkNotNull((Object)hardwareId);
                if (StringsKt.startsWith$default((String)hardwareId, (String)"USB", (boolean)false, (int)2, null)) {
                    sequence = Regex.findAll$default((Regex)usbVidPidRegex, (CharSequence)hardwareId, (int)0, (int)2, null);
                } else {
                    if (!StringsKt.startsWith$default((String)hardwareId, (String)"FTDI", (boolean)false, (int)2, null)) continue;
                    sequence = Regex.findAll$default((Regex)ftdiVidPidRegex, (CharSequence)hardwareId, (int)0, (int)2, null);
                }
                Sequence matchResult = sequence;
                if (SequencesKt.toList((Sequence)matchResult).isEmpty()) continue;
                MatchResult match = (MatchResult)SequencesKt.first((Sequence)matchResult);
                int vid = Integer.parseInt((String)match.getGroupValues().get(1), CharsKt.checkRadix((int)16));
                int pid = Integer.parseInt((String)match.getGroupValues().get(2), CharsKt.checkRadix((int)16));
                DeviceInterfaceInfo.Serial port = new DeviceInterfaceInfo.Serial(portName, vid, pid, null);
                serialPorts.add(port);
            }
            setupApi.SetupDiDestroyDeviceInfoList(deviceInfoSet);
        }
        return serialPorts;
    }

    private final List<Guid.GUID> getSetupGuidsForName(String name) {
        Memory portsString = this.createPointerWideString(name);
        Structure[] structureArray = new Guid.GUID().toArray(8);
        Intrinsics.checkNotNull((Object)structureArray, (String)"null cannot be cast to non-null type kotlin.Array<com.sun.jna.platform.win32.Guid.GUID>");
        Guid.GUID[] guidsForName = (Guid.GUID[])structureArray;
        IntByReference requiredSize = new IntByReference();
        boolean r = SetupApiExt.Companion.getINSTANCE().SetupDiClassGuidsFromNameW((Pointer)portsString, guidsForName, guidsForName.length, requiredSize);
        if (!r) {
            return CollectionsKt.emptyList();
        }
        int resultLength = requiredSize.getValue();
        List guids = new ArrayList();
        for (int i = 0; i < resultLength; ++i) {
            guids.add(guidsForName[i]);
        }
        return guids;
    }

    private static final String getWindowsSerialPorts$lambda$0(String $portName, String $hardwareId) {
        return "Found COM port: " + $portName + ", hardwareId: " + $hardwareId;
    }

    static {
        LoggerModule $this$getLogger$iv = InPulseLoggerKt.getLibcommLogModule();
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(WindowsSerialRegistryHelper.class).getSimpleName();
        if (string == null) {
            string = "";
        }
        logger = $this$getLogger$iv.getLogger(string);
        usbVidPidRegex = new Regex("VID_([\\dA-Fa-f]{4})&PID_([\\dA-Fa-f]{4})");
        ftdiVidPidRegex = new Regex("VID_([\\dA-Fa-f]{4})\\+PID_([\\dA-Fa-f]{4})");
    }
}

