/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.desktop.io.usbhid;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import okio.Buffer;
import okio.Timeout;
import org.hid4java.HidDevice;
import org.hid4java.jna.WideStringBuffer;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.CommException;
import vet.inpulse.libcomm.core.io.IOOperator;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.util.HexPrinterKt;
import vet.inpulse.shared.log.LoggerInterface;
import vet.inpulse.shared.log.LoggerModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010&\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lvet/inpulse/libcomm/desktop/io/usbhid/DesktopUsbHidOperator;", "Lvet/inpulse/libcomm/core/io/IOOperator;", "hidDevice", "Lorg/hid4java/HidDevice;", "<init>", "(Lorg/hid4java/HidDevice;)V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "TIMEOUT", "", "isControlledByTexasUC", "", "readOffset", "reportId", "", "writeBuffer", "Lorg/hid4java/jna/WideStringBuffer;", "readBuffer", "isOperatorOpened", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInterface", "Lvet/inpulse/libcomm/core/io/IOOperator$Interface;", "open", "tryToWriteOnIO", "", "source", "Lokio/Buffer;", "byteCount", "", "flush", "lowerReadBuffer", "getLowerReadBuffer", "()Lokio/Buffer;", "tryToReadFromIO", "sink", "timeout", "Lokio/Timeout;", "close", "isOpened", "()Z", "libcomm"})
@SourceDebugExtension(value={"SMAP\nDesktopUsbHidOperator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopUsbHidOperator.kt\nvet/inpulse/libcomm/desktop/io/usbhid/DesktopUsbHidOperator\n+ 2 LoggerModels.kt\nvet/inpulse/shared/log/LoggerModelsKt\n+ 3 SourceByteUtils.kt\nvet/inpulse/libcomm/core/util/SourceByteUtilsKt\n*L\n1#1,144:1\n65#2:145\n13#3:146\n*S KotlinDebug\n*F\n+ 1 DesktopUsbHidOperator.kt\nvet/inpulse/libcomm/desktop/io/usbhid/DesktopUsbHidOperator\n*L\n23#1:145\n108#1:146\n*E\n"})
public final class DesktopUsbHidOperator
extends IOOperator {
    @NotNull
    private final HidDevice hidDevice;
    @NotNull
    private final LoggerInterface logger;
    private final int TIMEOUT;
    private final boolean isControlledByTexasUC;
    private final int readOffset;
    private final byte reportId;
    @NotNull
    private final WideStringBuffer writeBuffer;
    @NotNull
    private final WideStringBuffer readBuffer;
    @NotNull
    private final AtomicBoolean isOperatorOpened;
    @NotNull
    private final Buffer lowerReadBuffer;

    public DesktopUsbHidOperator(@NotNull HidDevice hidDevice) {
        WideStringBuffer wideStringBuffer;
        Intrinsics.checkNotNullParameter((Object)hidDevice, (String)"hidDevice");
        this.hidDevice = hidDevice;
        LoggerModule $this$getLogger$iv = InPulseLoggerKt.getLibcommIoLogModule();
        boolean $i$f$getLogger22 = false;
        String string = Reflection.getOrCreateKotlinClass(DesktopUsbHidOperator.class).getSimpleName();
        if (string == null) {
            string = "";
        }
        this.logger = $this$getLogger$iv.getLogger(string);
        this.TIMEOUT = 1000;
        this.isControlledByTexasUC = this.hidDevice.getVendorId() == 8263;
        this.readOffset = this.isControlledByTexasUC ? 2 : 0;
        this.reportId = (byte)(this.isControlledByTexasUC ? 63 : 0);
        WideStringBuffer $i$f$getLogger22 = wideStringBuffer = new WideStringBuffer(new byte[64]);
        DesktopUsbHidOperator desktopUsbHidOperator = this;
        boolean bl = false;
        $this$writeBuffer_u24lambda_u240.buffer[0] = this.reportId;
        desktopUsbHidOperator.writeBuffer = wideStringBuffer;
        this.readBuffer = new WideStringBuffer(new byte[64]);
        this.isOperatorOpened = new AtomicBoolean(false);
        this.lowerReadBuffer = new Buffer();
    }

    @Override
    @NotNull
    public IOOperator.Interface getInterface() {
        return IOOperator.Interface.USB_HID;
    }

    @Override
    public boolean open() {
        boolean success = this.hidDevice.open();
        this.hidDevice.setNonBlocking(true);
        this.isOperatorOpened.set(success);
        this.logger.d(() -> DesktopUsbHidOperator.open$lambda$1(success));
        return success;
    }

    @Override
    public void tryToWriteOnIO(@NotNull Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Ref.IntRef written = new Ref.IntRef();
        while (this.isOpened() && written.element != (int)byteCount) {
            int bytesToWrite = RangesKt.coerceAtMost((int)((int)byteCount - written.element), (int)62);
            this.writeBuffer.buffer[1] = (byte)bytesToWrite;
            Intrinsics.checkNotNullExpressionValue((Object)this.writeBuffer.buffer, (String)"buffer");
            int numBytesTakenFromSource = source.read(this.writeBuffer.buffer, 2, bytesToWrite);
            LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> DesktopUsbHidOperator.tryToWriteOnIO$lambda$3(byteCount, numBytesTakenFromSource, written), (int)1, null);
            int numBytesWrittenOnIO = this.hidDevice.write(this.writeBuffer, numBytesTakenFromSource + 2);
            LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> DesktopUsbHidOperator.tryToWriteOnIO$lambda$4(this, numBytesTakenFromSource), (int)1, null);
            if (numBytesWrittenOnIO < 0) {
                String error = this.hidDevice.getLastErrorMessage();
                LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> DesktopUsbHidOperator.tryToWriteOnIO$lambda$5(error), (int)1, null);
                return;
            }
            written.element += numBytesTakenFromSource;
            this.setTotalBytesWritten(this.getTotalBytesWritten() + (long)numBytesWrittenOnIO);
        }
    }

    public void flush() {
    }

    @NotNull
    public final Buffer getLowerReadBuffer() {
        return this.lowerReadBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long tryToReadFromIO(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long transferred = this.lowerReadBuffer.read(sink, byteCount);
        if (transferred > 0L) {
            return transferred;
        }
        int hidRead = -1;
        do {
            int n;
            DesktopUsbHidOperator desktopUsbHidOperator = this;
            synchronized (desktopUsbHidOperator) {
                n = 0;
                n = this.hidDevice.read(this.readBuffer);
            }
            hidRead = n;
            if (hidRead > 0) {
                int n2;
                if (this.isControlledByTexasUC) {
                    byte $this$asInt$iv = this.readBuffer.buffer[1];
                    boolean $i$f$asInt = false;
                    n2 = $this$asInt$iv & 0xFF;
                } else {
                    n2 = hidRead;
                }
                int validData = n2;
                Intrinsics.checkNotNullExpressionValue((Object)this.readBuffer.buffer, (String)"buffer");
                this.lowerReadBuffer.write(this.readBuffer.buffer, this.readOffset, validData);
                this.setTotalBytesRead(this.getTotalBytesRead() + (long)hidRead);
                LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> DesktopUsbHidOperator.tryToReadFromIO$lambda$7(this, validData), (int)1, null);
                continue;
            }
            if (hidRead < 0) {
                throw new CommException("fail to read from hid device: " + this.hidDevice.getLastErrorMessage());
            }
            Thread.sleep(1L);
        } while (hidRead != 0);
        long removed = this.lowerReadBuffer.read(sink, byteCount);
        return removed == -1L ? 0L : removed;
    }

    @NotNull
    public Timeout timeout() {
        return new Timeout().timeout((long)this.TIMEOUT, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isOperatorOpened.compareAndSet(true, false)) {
            DesktopUsbHidOperator desktopUsbHidOperator = this;
            synchronized (desktopUsbHidOperator) {
                boolean bl = false;
                if (!this.hidDevice.isClosed()) {
                    this.hidDevice.close();
                }
                Unit unit = Unit.INSTANCE;
            }
            this.logger.d(DesktopUsbHidOperator::close$lambda$9);
        }
    }

    @Override
    public boolean isOpened() {
        return this.isOperatorOpened.get();
    }

    private static final String open$lambda$1(boolean $success) {
        return "HID Operator was opened: " + $success;
    }

    private static final String tryToWriteOnIO$lambda$3(long $byteCount, int $numBytesTakenFromSource, Ref.IntRef $written) {
        StringBuilder stringBuilder;
        StringBuilder $this$tryToWriteOnIO_u24lambda_u243_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$tryToWriteOnIO_u24lambda_u243_u24lambda_u242.append("WriteBuffer prepared to be written on IO. ");
        $this$tryToWriteOnIO_u24lambda_u243_u24lambda_u242.append("ByteCount (total to be written): " + $byteCount + " ");
        $this$tryToWriteOnIO_u24lambda_u243_u24lambda_u242.append("NumBytesTakenFromSource: " + $numBytesTakenFromSource + ". ");
        $this$tryToWriteOnIO_u24lambda_u243_u24lambda_u242.append("BytesWritten: " + $written.element + " (before update)");
        return stringBuilder.toString();
    }

    private static final String tryToWriteOnIO$lambda$4(DesktopUsbHidOperator this$0, int $numBytesTakenFromSource) {
        Intrinsics.checkNotNullExpressionValue((Object)this$0.writeBuffer.buffer, (String)"buffer");
        return "--> " + HexPrinterKt.printAsHex(this$0.writeBuffer.buffer, 2, $numBytesTakenFromSource);
    }

    private static final String tryToWriteOnIO$lambda$5(String $error) {
        return "Failed to write to hid device. Device error: " + $error;
    }

    private static final String tryToReadFromIO$lambda$7(DesktopUsbHidOperator this$0, int $validData) {
        Intrinsics.checkNotNullExpressionValue((Object)this$0.readBuffer.buffer, (String)"buffer");
        return "<-- " + HexPrinterKt.printAsHex(this$0.readBuffer.buffer, this$0.readOffset, $validData) + " ";
    }

    private static final String close$lambda$9() {
        return "HID Operator was closed";
    }
}

