/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.desktop.io.ble;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.atomicfu.AtomicBoolean;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicLong;
import okio.Buffer;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.io.IOOperator;
import vet.inpulse.libcomm.core.locator.bluetooth.RemoteAddress;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.util.HexPrinterKt;
import vet.inpulse.libcomm.desktop.io.ble.BleSocketException;
import vet.inpulse.libcomm.desktop.io.ble.BluezBluetooth;
import vet.inpulse.libcomm.desktop.io.ble.LinuxBleSocket;
import vet.inpulse.libcomm.desktop.io.ble.sockaddr_l2;
import vet.inpulse.shared.log.LoggerInterface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010A\u001a\u00020.H\u0016J\u0018\u0010B\u001a\u0002052\u0006\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u000205H\u0016J\u0018\u0010E\u001a\u00020F2\u0006\u0010)\u001a\u00020*2\u0006\u0010D\u001a\u000205H\u0016J\"\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020!2\b\b\u0002\u0010I\u001a\u00020\u00052\b\b\u0002\u0010J\u001a\u00020\u0005J\u001e\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020!2\u0006\u0010I\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u0005J\b\u0010M\u001a\u00020FH\u0016J\b\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020FH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R+\u0010/\u001a\u00020.2\u0006\u0010-\u001a\u00020.8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b/\u00100\"\u0004\b1\u00102R+\u00106\u001a\u0002052\u0006\u0010-\u001a\u0002058V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R+\u0010=\u001a\u0002052\u0006\u0010-\u001a\u0002058V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b@\u0010<\u001a\u0004\b>\u00108\"\u0004\b?\u0010:\u00a8\u0006S"}, d2={"Lvet/inpulse/libcomm/desktop/io/ble/LinuxBleL2CapCocOperator;", "Lvet/inpulse/libcomm/core/io/IOOperator;", "address", "Lvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress;", "l2capPsm", "", "recvMtu", "", "<init>", "(Lvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress;IS)V", "getAddress", "()Lvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress;", "getL2capPsm", "()I", "getRecvMtu", "()S", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "getLogger", "()Lvet/inpulse/shared/log/LoggerInterface;", "libc", "Lvet/inpulse/libcomm/desktop/io/ble/LinuxBleSocket;", "getLibc", "()Lvet/inpulse/libcomm/desktop/io/ble/LinuxBleSocket;", "bluez", "Lvet/inpulse/libcomm/desktop/io/ble/BluezBluetooth;", "getBluez", "()Lvet/inpulse/libcomm/desktop/io/ble/BluezBluetooth;", "socket", "getSocket", "setSocket", "(I)V", "sendBuffer", "", "getSendBuffer", "()[B", "setSendBuffer", "([B)V", "recvBuffer", "getRecvBuffer", "setRecvBuffer", "source", "Lokio/Buffer;", "getSource", "()Lokio/Buffer;", "<set-?>", "", "isOpened", "()Z", "setOpened", "(Z)V", "isOpened$delegate", "Lkotlinx/atomicfu/AtomicBoolean;", "", "totalBytesRead", "getTotalBytesRead", "()J", "setTotalBytesRead", "(J)V", "totalBytesRead$delegate", "Lkotlinx/atomicfu/AtomicLong;", "totalBytesWritten", "getTotalBytesWritten", "setTotalBytesWritten", "totalBytesWritten$delegate", "open", "tryToReadFromIO", "sink", "byteCount", "tryToWriteOnIO", "", "writeInternal", "data", "offset", "length", "readInternal", "buffer", "close", "getInterface", "Lvet/inpulse/libcomm/core/io/IOOperator$Interface;", "timeout", "Lokio/Timeout;", "flush", "libcomm"})
@SourceDebugExtension(value={"SMAP\nLinuxBleL2CapCocOperator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxBleL2CapCocOperator.kt\nvet/inpulse/libcomm/desktop/io/ble/LinuxBleL2CapCocOperator\n+ 2 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,315:1\n72#2:316\n58#2,22:317\n*S KotlinDebug\n*F\n+ 1 LinuxBleL2CapCocOperator.kt\nvet/inpulse/libcomm/desktop/io/ble/LinuxBleL2CapCocOperator\n*L\n231#1:316\n231#1:317,22\n*E\n"})
public final class LinuxBleL2CapCocOperator
extends IOOperator {
    @NotNull
    private final RemoteAddress address;
    private final int l2capPsm;
    private final short recvMtu;
    @NotNull
    private final LoggerInterface logger;
    @NotNull
    private final LinuxBleSocket libc;
    @NotNull
    private final BluezBluetooth bluez;
    private int socket;
    @Nullable
    private byte[] sendBuffer;
    @Nullable
    private byte[] recvBuffer;
    @NotNull
    private final Buffer source;
    @NotNull
    private final AtomicBoolean isOpened$delegate;
    @NotNull
    private final AtomicLong totalBytesRead$delegate;
    @NotNull
    private final AtomicLong totalBytesWritten$delegate;

    public LinuxBleL2CapCocOperator(@NotNull RemoteAddress address, int l2capPsm, short recvMtu) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.address = address;
        this.l2capPsm = l2capPsm;
        this.recvMtu = recvMtu;
        this.logger = InPulseLoggerKt.getLibcommIoLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.libc = LinuxBleSocket.Companion.loadLibrary();
        this.bluez = BluezBluetooth.Companion.loadLibrary();
        this.socket = -1;
        this.source = new Buffer();
        this.isOpened$delegate = AtomicFU.atomic((boolean)false);
        this.totalBytesRead$delegate = AtomicFU.atomic((long)0L);
        this.totalBytesWritten$delegate = AtomicFU.atomic((long)0L);
    }

    public /* synthetic */ LinuxBleL2CapCocOperator(RemoteAddress remoteAddress, int n, short s, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            s = (short)250;
        }
        this(remoteAddress, n, s);
    }

    @NotNull
    public final RemoteAddress getAddress() {
        return this.address;
    }

    public final int getL2capPsm() {
        return this.l2capPsm;
    }

    public final short getRecvMtu() {
        return this.recvMtu;
    }

    @NotNull
    public final LoggerInterface getLogger() {
        return this.logger;
    }

    @NotNull
    public final LinuxBleSocket getLibc() {
        return this.libc;
    }

    @NotNull
    public final BluezBluetooth getBluez() {
        return this.bluez;
    }

    public final int getSocket() {
        return this.socket;
    }

    public final void setSocket(int n) {
        this.socket = n;
    }

    @Nullable
    public final byte[] getSendBuffer() {
        return this.sendBuffer;
    }

    public final void setSendBuffer(@Nullable byte[] byArray) {
        this.sendBuffer = byArray;
    }

    @Nullable
    public final byte[] getRecvBuffer() {
        return this.recvBuffer;
    }

    public final void setRecvBuffer(@Nullable byte[] byArray) {
        this.recvBuffer = byArray;
    }

    @NotNull
    public final Buffer getSource() {
        return this.source;
    }

    @Override
    public boolean isOpened() {
        AtomicBoolean atomicBoolean = this.isOpened$delegate;
        return atomicBoolean.getValue();
    }

    public void setOpened(boolean bl) {
        AtomicBoolean atomicBoolean = this.isOpened$delegate;
        atomicBoolean.setValue(bl);
    }

    @Override
    public long getTotalBytesRead() {
        AtomicLong atomicLong = this.totalBytesRead$delegate;
        return atomicLong.getValue();
    }

    @Override
    public void setTotalBytesRead(long l) {
        AtomicLong atomicLong = this.totalBytesRead$delegate;
        atomicLong.setValue(l);
    }

    @Override
    public long getTotalBytesWritten() {
        AtomicLong atomicLong = this.totalBytesWritten$delegate;
        return atomicLong.getValue();
    }

    @Override
    public void setTotalBytesWritten(long l) {
        AtomicLong atomicLong = this.totalBytesWritten$delegate;
        atomicLong.setValue(l);
    }

    @Override
    public boolean open() {
        this.socket = this.libc.socket(31, 5, 0);
        if (this.socket < 0) {
            int err = Native.getLastError();
            LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.open$lambda$0(this, err), (int)1, null);
            return false;
        }
        sockaddr_l2 localAddr = new sockaddr_l2();
        localAddr.l2_family = (short)31;
        localAddr.l2_bdaddr_type = 1;
        int result2 = this.libc.bind(this.socket, localAddr, localAddr.size());
        if (result2 < 0) {
            int err = Native.getLastError();
            this.libc.close(this.socket);
            LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.open$lambda$1(this, err), (int)1, null);
            this.socket = -1;
            return false;
        }
        ByteByReference btMode = new ByteByReference(3);
        Pointer pointer = btMode.getPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getPointer(...)");
        result2 = this.libc.setsockopt(this.socket, 274, 15, pointer, 1);
        if (result2 < 0) {
            int err = Native.getLastError();
            this.libc.close(this.socket);
            this.socket = -1;
            LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.open$lambda$2(this, err), (int)1, null);
            return false;
        }
        ShortByReference setMtu = new ShortByReference(this.recvMtu);
        Pointer pointer2 = setMtu.getPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer2, (String)"getPointer(...)");
        result2 = this.libc.setsockopt(this.socket, 274, 13, pointer2, 2);
        if (result2 < 0) {
            int err = Native.getLastError();
            this.libc.close(this.socket);
            this.socket = -1;
            LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.open$lambda$3(this, err), (int)1, null);
            return false;
        }
        sockaddr_l2 addr = new sockaddr_l2();
        this.bluez.str2ba(this.address.getMacAddress(), addr.l2_bdaddr);
        addr.l2_family = (short)31;
        addr.l2_psm = (short)this.l2capPsm;
        addr.l2_cid = 0;
        addr.l2_bdaddr_type = 1;
        result2 = this.libc.connect(this.socket, addr, addr.size());
        if (result2 < 0) {
            int err = Native.getLastError();
            this.libc.close(this.socket);
            this.socket = -1;
            this.logger.v(() -> LinuxBleL2CapCocOperator.open$lambda$4(this, err));
            return false;
        }
        ShortByReference mtu = new ShortByReference(0);
        IntByReference mtuLen = new IntByReference(2);
        Pointer pointer3 = mtu.getPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer3, (String)"getPointer(...)");
        result2 = this.libc.getsockopt(this.socket, 274, 13, pointer3, mtuLen);
        if (result2 < 0) {
            int err = Native.getLastError();
            this.libc.close(this.socket);
            this.socket = -1;
            LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.open$lambda$5(this, err), (int)1, null);
            return false;
        }
        short receiveMtu = mtu.getValue();
        if (!(receiveMtu > 0)) {
            boolean bl = false;
            String string = "ReceiveMTU must be greater than 0, but got " + receiveMtu;
            throw new IllegalArgumentException(string.toString());
        }
        this.recvBuffer = new byte[receiveMtu];
        Pointer pointer4 = mtu.getPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer4, (String)"getPointer(...)");
        result2 = this.libc.getsockopt(this.socket, 274, 12, pointer4, mtuLen);
        if (result2 < 0) {
            int err = Native.getLastError();
            this.libc.close(this.socket);
            this.socket = -1;
            LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.open$lambda$7(this, err), (int)1, null);
            return false;
        }
        short sendMtu = mtu.getValue();
        if (!(sendMtu > 0)) {
            boolean bl = false;
            String string = "SendMTU must be greater than 0, but got " + sendMtu;
            throw new IllegalArgumentException(string.toString());
        }
        this.sendBuffer = new byte[sendMtu];
        this.setOpened(true);
        return true;
    }

    @Override
    public long tryToReadFromIO(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int n = (int)byteCount;
        Intrinsics.checkNotNull((Object)this.recvBuffer);
        int toRead = Math.min(n, this.recvBuffer.length - 2);
        Intrinsics.checkNotNull((Object)this.recvBuffer);
        int bytesRead = this.readInternal(this.recvBuffer, 0, toRead);
        if (bytesRead < 0) {
            return -1L;
        }
        Intrinsics.checkNotNull((Object)this.recvBuffer);
        this.source.write(this.recvBuffer, 0, bytesRead);
        return this.source.read(sink, byteCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void tryToWriteOnIO(@NotNull Buffer source, long byteCount) {
        Integer n;
        Throwable thrown$iv;
        block17: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Closeable $this$use$iv = (Closeable)Buffer.readAndWriteUnsafe$default((Buffer)source, null, (int)1, null);
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                Buffer.UnsafeCursor it = (Buffer.UnsafeCursor)$this$use$iv;
                boolean bl = false;
                long size = it.next();
                if (size < 0L) {
                    throw new BleSocketException("Failed to write data to socket");
                }
                Intrinsics.checkNotNull((Object)this.sendBuffer);
                int toWrite = (int)Math.min(size, Math.min(byteCount, (long)this.sendBuffer.length - (long)2));
                Intrinsics.checkNotNull((Object)it.data);
                int bytesWritten = this.writeInternal(it.data, it.start, toWrite);
                if (bytesWritten < 0) {
                    throw new BleSocketException("Failed to write data to socket");
                }
                n = bytesWritten;
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    n = null;
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block18: {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block18;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        Integer result$iv = n;
        Throwable throwable = thrown$iv;
        if (throwable != null) {
            throw throwable;
        }
        int written = ((Number)result$iv).intValue();
        source.skip((long)written);
    }

    public final int writeInternal(@NotNull byte[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.sendBuffer == null) {
            throw new BleSocketException("sendBuffer is not initialized");
        }
        byte[] sb = this.sendBuffer;
        int toSend = Math.min(sb.length - 2, length);
        ArraysKt.copyInto((byte[])data, (byte[])sb, (int)2, (int)offset, (int)(offset + toSend));
        sb[0] = (byte)(toSend & 0xFF);
        sb[1] = (byte)(toSend >> 8 & 0xFF);
        int totalLength = toSend + 2;
        int result2 = this.libc.send(this.socket, sb, totalLength, 0);
        LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.writeInternal$lambda$10(totalLength, sb, result2), (int)1, null);
        if (result2 < 0) {
            return -1;
        }
        this.setTotalBytesWritten(this.getTotalBytesWritten() + (long)result2);
        return result2 - 2;
    }

    public static /* synthetic */ int writeInternal$default(LinuxBleL2CapCocOperator linuxBleL2CapCocOperator, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return linuxBleL2CapCocOperator.writeInternal(byArray, n, n2);
    }

    public final int readInternal(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.recvBuffer == null) {
            throw new BleSocketException("recvBuffer is not initialized");
        }
        byte[] rb = this.recvBuffer;
        int received = this.libc.recv(this.socket, rb, rb.length, 0);
        if (received < 0) {
            return -1;
        }
        this.setTotalBytesRead(this.getTotalBytesRead() + (long)received);
        LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.readInternal$lambda$11(received, rb), (int)1, null);
        ArraysKt.copyInto((byte[])rb, (byte[])buffer, (int)offset, (int)0, (int)received);
        return received;
    }

    @Override
    public void close() {
        if (!this.isOpened()) {
            return;
        }
        this.setOpened(false);
        if (this.socket >= 0) {
            int err;
            int res = this.libc.shutdown(this.socket, 2);
            if (res < 0) {
                err = Native.getLastError();
                LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.close$lambda$12(this, err), (int)1, null);
            } else {
                LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.close$lambda$13(this), (int)1, null);
            }
            res = this.libc.close(this.socket);
            if (res < 0) {
                err = Native.getLastError();
                LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.close$lambda$14(this, err), (int)1, null);
            } else {
                LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> LinuxBleL2CapCocOperator.close$lambda$15(this), (int)1, null);
            }
            this.socket = -1;
        }
    }

    @Override
    @NotNull
    public IOOperator.Interface getInterface() {
        return IOOperator.Interface.BLUETOOTH_NATIVE;
    }

    @NotNull
    public Timeout timeout() {
        return Timeout.NONE;
    }

    public void flush() {
    }

    private static final String open$lambda$0(LinuxBleL2CapCocOperator this$0, int $err) {
        return "Failed to create socket: " + this$0.libc.strerror($err);
    }

    private static final String open$lambda$1(LinuxBleL2CapCocOperator this$0, int $err) {
        return "Failed to bind socket: " + this$0.libc.strerror($err);
    }

    private static final String open$lambda$2(LinuxBleL2CapCocOperator this$0, int $err) {
        return "Failed to set bt mode: " + this$0.libc.strerror($err);
    }

    private static final String open$lambda$3(LinuxBleL2CapCocOperator this$0, int $err) {
        return "Failed to set BT_RCVMTU: " + this$0.libc.strerror($err);
    }

    private static final String open$lambda$4(LinuxBleL2CapCocOperator this$0, int $err) {
        return "Failed to connect to " + this$0.address + " on PSM " + this$0.l2capPsm + ": " + this$0.libc.strerror($err);
    }

    private static final String open$lambda$5(LinuxBleL2CapCocOperator this$0, int $err) {
        return "Failed to get receive MTU: " + this$0.libc.strerror($err);
    }

    private static final String open$lambda$7(LinuxBleL2CapCocOperator this$0, int $err) {
        return "Failed to get send MTU: " + this$0.libc.strerror($err);
    }

    private static final String writeInternal$lambda$10(int $totalLength, byte[] $sb, int $result) {
        return ">>> " + $totalLength + " " + HexPrinterKt.printAsHex$default($sb, 0, $totalLength, 1, null) + " - result: " + $result;
    }

    private static final String readInternal$lambda$11(int $received, byte[] $rb) {
        return "<<< " + $received + " " + HexPrinterKt.printAsHex$default($rb, 0, $received, 1, null);
    }

    private static final String close$lambda$12(LinuxBleL2CapCocOperator this$0, int $err) {
        return "Failed to shutdown socket " + this$0.socket + ": " + this$0.libc.strerror($err);
    }

    private static final String close$lambda$13(LinuxBleL2CapCocOperator this$0) {
        return "Socket: " + this$0.socket + " shutdown successfully";
    }

    private static final String close$lambda$14(LinuxBleL2CapCocOperator this$0, int $err) {
        return "Failed to close socket " + this$0.socket + ": " + this$0.libc.strerror($err);
    }

    private static final String close$lambda$15(LinuxBleL2CapCocOperator this$0) {
        return "Socket: " + this$0.socket + " closed successfully";
    }
}

