/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.util.data_generator.nibp;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.device.data.NibpStatus;
import vet.inpulse.libcomm.core.protocol.message.NibpModuleSample;
import vet.inpulse.libcomm.core.util.data_generator.NibpSampleGenerator;
import vet.inpulse.libcomm.core.util.data_generator.SinusoidalGenerator;
import vet.inpulse.shared.models.NibpProcedureRequest;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lvet/inpulse/libcomm/core/util/data_generator/nibp/SimulatedNibpGenerator;", "Lvet/inpulse/libcomm/core/util/data_generator/NibpSampleGenerator;", "<init>", "()V", "status", "Lvet/inpulse/libcomm/core/device/data/NibpStatus;", "nibpDataBuffer", "", "generator", "Lvet/inpulse/libcomm/core/util/data_generator/SinusoidalGenerator;", "currentPressure", "", "maxPressure", "minPressure", "slopeStep", "inflateSlopeStep", "peakSamples", "", "calibrationTargetPressure", "peakSamplesRun", "requestNibpProcedure", "", "request", "Lvet/inpulse/shared/models/NibpProcedureRequest;", "nextSample", "Lvet/inpulse/libcomm/core/protocol/message/NibpModuleSample;", "reset", "resetNibpAcquisitionState", "initialStatus", "libcomm"})
public final class SimulatedNibpGenerator
implements NibpSampleGenerator {
    @NotNull
    private NibpStatus status = NibpStatus.NONE;
    @NotNull
    private final float[] nibpDataBuffer = new float[1];
    @NotNull
    private final SinusoidalGenerator generator = new SinusoidalGenerator(600.0, 1.0, 1.0);
    private float currentPressure;
    private float maxPressure;
    private float minPressure;
    private float slopeStep;
    private final float inflateSlopeStep;
    private final int peakSamples;
    private float calibrationTargetPressure;
    private int peakSamplesRun;

    public SimulatedNibpGenerator() {
        this.inflateSlopeStep = 0.05f;
        this.peakSamples = 100;
    }

    @Override
    public void requestNibpProcedure(@NotNull NibpProcedureRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.maxPressure = request.getMaxPressure();
        this.slopeStep = (float)request.getSlope() / 600.0f;
        this.minPressure = request.getFinalCuffPressure();
        this.generator.reset();
    }

    @Override
    @NotNull
    public NibpModuleSample nextSample() {
        this.nibpDataBuffer[0] = 0.0f;
        switch (WhenMappings.$EnumSwitchMapping$0[this.status.ordinal()]) {
            case 1: {
                this.status = NibpStatus.INFLATING;
                break;
            }
            case 2: {
                this.generator.generateData(this.nibpDataBuffer, 1, 1);
                this.currentPressure += this.inflateSlopeStep;
                if (!(this.currentPressure > this.maxPressure)) break;
                this.status = NibpStatus.PEAK;
                break;
            }
            case 3: {
                this.generator.generateData(this.nibpDataBuffer, 1, 1);
                ++this.peakSamplesRun;
                if (this.peakSamplesRun <= this.peakSamples) break;
                this.status = NibpStatus.CONTROLLING;
                break;
            }
            case 4: {
                this.generator.generateData(this.nibpDataBuffer, 1, 1);
                this.currentPressure -= this.slopeStep;
                if (!(this.currentPressure < this.minPressure)) break;
                this.status = NibpStatus.FINISHING;
                break;
            }
            case 5: {
                this.status = NibpStatus.IDLE;
                break;
            }
            case 6: {
                this.resetNibpAcquisitionState(NibpStatus.IDLE);
                break;
            }
            case 7: {
                if (this.currentPressure < this.calibrationTargetPressure) {
                    this.currentPressure += this.inflateSlopeStep;
                    break;
                }
                this.currentPressure -= this.inflateSlopeStep;
                break;
            }
            case 8: {
                throw new NotImplementedError(null, 1, null);
            }
            case 9: {
                throw new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new NibpModuleSample(this.currentPressure + this.nibpDataBuffer[0], this.status, null, null, null, 28, null);
    }

    @Override
    public void reset() {
        this.resetNibpAcquisitionState(NibpStatus.IDLE);
    }

    public final void resetNibpAcquisitionState(@NotNull NibpStatus initialStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)initialStatus), (String)"initialStatus");
        this.status = initialStatus;
        this.peakSamplesRun = 0;
        this.currentPressure = 0.0f;
        this.generator.reset();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NibpStatus.values().length];
            try {
                nArray[NibpStatus.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.INFLATING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.PEAK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.CONTROLLING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.FINISHING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.IDLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.CALIBRATING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.ADJUSTING_CALIBRATION_OFFSET.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.SETTING_PRESSURE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

