/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.util.data_generator;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.util.data_generator.DataGenerator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\t\"\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lvet/inpulse/libcomm/core/util/data_generator/SinusoidalGenerator;", "Lvet/inpulse/libcomm/core/util/data_generator/DataGenerator;", "samplingRate", "", "initialFrequency", "initialAmplitude", "<init>", "(DDD)V", "getSamplingRate", "()D", "samplingRateStep", "f", "frequency", "getFrequency", "setFrequency", "(D)V", "amplitude", "getAmplitude", "setAmplitude", "currentPhase", "reset", "", "generateData", "destination", "", "channels", "", "samples", "Companion", "libcomm"})
public final class SinusoidalGenerator
implements DataGenerator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final double samplingRate;
    private final double samplingRateStep;
    private double frequency;
    private double amplitude;
    private double currentPhase;
    @Deprecated
    public static final double PI_2 = Math.PI * 2;

    public SinusoidalGenerator(double samplingRate, double initialFrequency, double initialAmplitude) {
        this.samplingRate = samplingRate;
        if (!(initialFrequency < this.samplingRate / (double)2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.samplingRateStep = Math.PI / this.samplingRate;
        this.frequency = initialFrequency;
        this.amplitude = initialAmplitude;
    }

    public final double getSamplingRate() {
        return this.samplingRate;
    }

    public final double getFrequency() {
        return this.frequency;
    }

    public final void setFrequency(double f) {
        if (!(f < this.samplingRate / (double)2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.frequency = f;
    }

    public final double getAmplitude() {
        return this.amplitude;
    }

    public final void setAmplitude(double d) {
        this.amplitude = d;
    }

    @Override
    public void reset() {
        this.currentPhase = 0.0;
    }

    @Override
    public void generateData(@NotNull float[] destination, int channels, int samples) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        double freqStep = this.frequency * this.samplingRateStep;
        for (int s = 0; s < samples; ++s) {
            float newValue = (float)(Math.sin(this.currentPhase) * this.amplitude);
            int index = channels * s;
            for (int c = 0; c < channels; ++c) {
                destination[index + c] = newValue;
            }
            this.currentPhase += freqStep;
            if (!(this.currentPhase <= Math.PI * 2)) continue;
            this.currentPhase -= Math.PI * 2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lvet/inpulse/libcomm/core/util/data_generator/SinusoidalGenerator$Companion;", "", "<init>", "()V", "PI_2", "", "libcomm"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

