/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.util.data_generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.device.data.PpgState;
import vet.inpulse.libcomm.core.protocol.InPulseProtocolV2;
import vet.inpulse.libcomm.core.protocol.capno.CO2Waveform;
import vet.inpulse.libcomm.core.protocol.capno.RespironicsPacket;
import vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol;
import vet.inpulse.libcomm.core.protocol.message.EcgModuleSample;
import vet.inpulse.libcomm.core.protocol.message.PpgModuleSample;
import vet.inpulse.libcomm.core.protocol.message.TempModuleSample;
import vet.inpulse.libcomm.core.util.data_generator.CyclingSampleGenerator;
import vet.inpulse.libcomm.core.util.data_generator.IncardioWaveformSampleGenerator;
import vet.inpulse.libcomm.core.util.data_generator.NibpSampleGenerator;
import vet.inpulse.libcomm.core.util.data_generator.SampleGenerator;
import vet.inpulse.libcomm.core.util.data_generator.SampleGeneratorsKt;
import vet.inpulse.libcomm.core.util.data_generator.nibp.NibpSampleGeneratorImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010#\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\b\b\u0002\u0010%\u001a\u00020&J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fJ\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u000fJ\"\u0010+\u001a\b\u0012\u0004\u0012\u0002H,0\u000f\"\u0004\b\u0000\u0010,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H,0.H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u00060"}, d2={"Lvet/inpulse/libcomm/core/util/data_generator/SampleGenerators;", "", "<init>", "()V", "sampleReferences", "", "", "getSampleReferences", "()Ljava/util/List;", "samples", "", "Lvet/inpulse/libcomm/core/util/data_generator/SampleGenerators$SampleExamResources;", "getSamples", "()Ljava/util/Map;", "presentationPpg", "Lvet/inpulse/libcomm/core/util/data_generator/SampleGenerator;", "Lvet/inpulse/libcomm/core/protocol/message/PpgModuleSample;", "sample", "presentationEcg", "Lvet/inpulse/libcomm/core/protocol/message/EcgModuleSample;", "presentationTemp", "Lvet/inpulse/libcomm/core/protocol/message/TempModuleSample;", "presentationCapno", "Lvet/inpulse/libcomm/core/protocol/capno/RespironicsPacket;", "presentationNibp", "Lvet/inpulse/libcomm/core/util/data_generator/NibpSampleGenerator;", "ecgFromIncardio", "Lvet/inpulse/libcomm/core/util/data_generator/IncardioWaveformSampleGenerator;", "ecg", "Lvet/inpulse/libcomm/core/util/data_generator/CyclingSampleGenerator;", "rawSource", "Lokio/BufferedSource;", "ppg", "temperature", "capno", "nibp", "emptyEcg", "numChannels", "", "emptyPpg", "emptyTemperature", "emptyCapno", "Lvet/inpulse/libcomm/core/protocol/capno/CO2Waveform;", "createGenerator", "T", "op", "Lkotlin/Function0;", "SampleExamResources", "libcomm"})
@SourceDebugExtension(value={"SMAP\nSampleGenerators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SampleGenerators.kt\nvet/inpulse/libcomm/core/util/data_generator/SampleGenerators\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1563#2:164\n1634#2,3:165\n1#3:168\n*S KotlinDebug\n*F\n+ 1 SampleGenerators.kt\nvet/inpulse/libcomm/core/util/data_generator/SampleGenerators\n*L\n95#1:164\n95#1:165,3\n*E\n"})
public final class SampleGenerators {
    @NotNull
    public static final SampleGenerators INSTANCE = new SampleGenerators();
    @NotNull
    private static final List<String> sampleReferences = CollectionsKt.listOf((Object)"gpaim-01");
    @NotNull
    private static final Map<String, SampleExamResources> samples;

    private SampleGenerators() {
    }

    @NotNull
    public final List<String> getSampleReferences() {
        return sampleReferences;
    }

    @NotNull
    public final Map<String, SampleExamResources> getSamples() {
        return samples;
    }

    @NotNull
    public final SampleGenerator<PpgModuleSample> presentationPpg(@NotNull String sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        SampleExamResources sampleExamResources = samples.get(sample);
        Intrinsics.checkNotNull((Object)sampleExamResources);
        String resource = sampleExamResources.getPpg();
        return this.ppg((BufferedSource)SampleGeneratorsKt.getResourceAsBuffer(resource));
    }

    public static /* synthetic */ SampleGenerator presentationPpg$default(SampleGenerators sampleGenerators, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "gpaim-01";
        }
        return sampleGenerators.presentationPpg(string);
    }

    @NotNull
    public final SampleGenerator<EcgModuleSample> presentationEcg(@NotNull String sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        SampleExamResources sampleExamResources = samples.get(sample);
        Intrinsics.checkNotNull((Object)sampleExamResources);
        String resource = sampleExamResources.getEcg();
        return this.ecg((BufferedSource)SampleGeneratorsKt.getResourceAsBuffer(resource));
    }

    public static /* synthetic */ SampleGenerator presentationEcg$default(SampleGenerators sampleGenerators, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "gpaim-01";
        }
        return sampleGenerators.presentationEcg(string);
    }

    @NotNull
    public final SampleGenerator<TempModuleSample> presentationTemp(@NotNull String sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        SampleExamResources sampleExamResources = samples.get(sample);
        Intrinsics.checkNotNull((Object)sampleExamResources);
        String resource = sampleExamResources.getTemp();
        return this.temperature((BufferedSource)SampleGeneratorsKt.getResourceAsBuffer(resource));
    }

    public static /* synthetic */ SampleGenerator presentationTemp$default(SampleGenerators sampleGenerators, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "gpaim-01";
        }
        return sampleGenerators.presentationTemp(string);
    }

    @NotNull
    public final SampleGenerator<RespironicsPacket> presentationCapno(@NotNull String sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        SampleExamResources sampleExamResources = samples.get(sample);
        Intrinsics.checkNotNull((Object)sampleExamResources);
        String resource = sampleExamResources.getCapno();
        return this.capno((BufferedSource)SampleGeneratorsKt.getResourceAsBuffer(resource));
    }

    public static /* synthetic */ SampleGenerator presentationCapno$default(SampleGenerators sampleGenerators, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "gpaim-01";
        }
        return sampleGenerators.presentationCapno(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<NibpSampleGenerator> presentationNibp(@NotNull String sample) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        SampleExamResources sampleExamResources = samples.get(sample);
        Intrinsics.checkNotNull((Object)sampleExamResources);
        List<String> resource = sampleExamResources.getNibps();
        Iterable $this$map$iv = resource;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.nibp((BufferedSource)SampleGeneratorsKt.getResourceAsBuffer((String)it)));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List presentationNibp$default(SampleGenerators sampleGenerators, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "gpaim-01";
        }
        return sampleGenerators.presentationNibp(string);
    }

    @NotNull
    public final IncardioWaveformSampleGenerator ecgFromIncardio() {
        String basePath = "files/exams/partial/ecg/incardio/86e9fbac-d6a7-4a5f-b753-bf43b6f6498b/5aab3830-402d-40f4-bf2f-d9474d9b164b";
        Object[] objectArray = new Buffer[]{SampleGeneratorsKt.getResourceAsBuffer(basePath + "_D1"), SampleGeneratorsKt.getResourceAsBuffer(basePath + "_D2"), SampleGeneratorsKt.getResourceAsBuffer(basePath + "_V1")};
        List sources = CollectionsKt.listOf((Object[])objectArray);
        return new IncardioWaveformSampleGenerator(sources, 0, 2, null);
    }

    @NotNull
    public final CyclingSampleGenerator<EcgModuleSample> ecg(@NotNull BufferedSource rawSource) {
        Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
        return new CyclingSampleGenerator<EcgModuleSample>(rawSource, SampleGenerators::ecg$lambda$1);
    }

    @NotNull
    public final CyclingSampleGenerator<PpgModuleSample> ppg(@NotNull BufferedSource rawSource) {
        Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
        return new CyclingSampleGenerator<PpgModuleSample>(rawSource, SampleGenerators::ppg$lambda$2);
    }

    @NotNull
    public final CyclingSampleGenerator<TempModuleSample> temperature(@NotNull BufferedSource rawSource) {
        Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
        return new CyclingSampleGenerator<TempModuleSample>(rawSource, SampleGenerators::temperature$lambda$3);
    }

    @NotNull
    public final SampleGenerator<RespironicsPacket> capno(@NotNull BufferedSource rawSource) {
        Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
        return new CyclingSampleGenerator(rawSource, SampleGenerators::capno$lambda$5);
    }

    @NotNull
    public final NibpSampleGenerator nibp(@NotNull BufferedSource rawSource) {
        Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
        return new NibpSampleGeneratorImpl(rawSource);
    }

    @NotNull
    public final SampleGenerator<EcgModuleSample> emptyEcg(int numChannels) {
        return this.createGenerator(() -> SampleGenerators.emptyEcg$lambda$6(numChannels));
    }

    public static /* synthetic */ SampleGenerator emptyEcg$default(SampleGenerators sampleGenerators, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return sampleGenerators.emptyEcg(n);
    }

    @NotNull
    public final SampleGenerator<PpgModuleSample> emptyPpg() {
        return this.createGenerator(SampleGenerators::emptyPpg$lambda$7);
    }

    @NotNull
    public final SampleGenerator<TempModuleSample> emptyTemperature() {
        return this.createGenerator(SampleGenerators::emptyTemperature$lambda$8);
    }

    @NotNull
    public final SampleGenerator<CO2Waveform> emptyCapno() {
        return this.createGenerator(SampleGenerators::emptyCapno$lambda$9);
    }

    private final <T> SampleGenerator<T> createGenerator(Function0<? extends T> op) {
        return new SampleGenerator<T>(op){
            final /* synthetic */ Function0<T> $op;
            {
                this.$op = $op;
            }

            public T nextSample() {
                return (T)this.$op.invoke();
            }

            public void reset() {
            }
        };
    }

    private static final List ecg$lambda$1(BufferedSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return InPulseProtocolV2.Companion.deserializeEcgData(it).getSamples();
    }

    private static final List ppg$lambda$2(BufferedSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return InPulseProtocolV2.Companion.deserializePpgData(it).getSamples();
    }

    private static final List temperature$lambda$3(BufferedSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return InPulseProtocolV2.Companion.deserializeTempData(it).getSamples();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final List capno$lambda$5(BufferedSource source) {
        List list;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        RespironicsPacket respironicsPacket = RespironicsProtocol.Companion.deserializeMessage(source);
        if (respironicsPacket != null) {
            RespironicsPacket it = respironicsPacket;
            boolean bl = false;
            List list2 = CollectionsKt.listOf((Object)it);
            if (list2 != null) {
                list = list2;
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    private static final EcgModuleSample emptyEcg$lambda$6(int $numChannels) {
        return new EcgModuleSample(new byte[3], new int[$numChannels]);
    }

    private static final PpgModuleSample emptyPpg$lambda$7() {
        return new PpgModuleSample(0, 0, 0, 0, PpgState.Companion.create());
    }

    private static final TempModuleSample emptyTemperature$lambda$8() {
        return new TempModuleSample(0, 0);
    }

    private static final CO2Waveform emptyCapno$lambda$9() {
        return new CO2Waveform(0, 0.0f, null);
    }

    static {
        Pair[] pairArray = new Pair[3];
        Object[] objectArray = new String[]{"files/exams/full/gpaim-01/nibp/NibpData-1670078717776", "files/exams/full/gpaim-01/nibp/NibpData-1670078834312", "files/exams/full/gpaim-01/nibp/NibpData-1670078908066", "files/exams/full/gpaim-01/nibp/NibpData-1670078980943", "files/exams/full/gpaim-01/nibp/NibpData-1670079068783", "files/exams/full/gpaim-01/nibp/NibpData-1670079339188", "files/exams/full/gpaim-01/nibp/NibpData-1670079407277", "files/exams/full/gpaim-01/nibp/NibpData-1670079479629"};
        pairArray[0] = TuplesKt.to((Object)"gpaim-01", (Object)new SampleExamResources("files/exams/full/gpaim-01/EcgData", "files/exams/full/gpaim-01/PpgData", "files/exams/full/gpaim-01/TempData", "files/exams/full/gpaim-01/CapnoData", CollectionsKt.listOf((Object[])objectArray)));
        objectArray = new String[]{"files/exams/full/suzane-01/nibp/NibpData-1699990688896", "files/exams/full/suzane-01/nibp/NibpData-1699990992612", "files/exams/full/suzane-01/nibp/NibpData-1699991096821"};
        pairArray[1] = TuplesKt.to((Object)"suzane-01", (Object)new SampleExamResources("files/exams/full/suzane-01/EcgData", "files/exams/full/suzane-01/PpgData", "files/exams/full/suzane-01/TempData", "files/exams/full/suzane-01/CapnoData", CollectionsKt.listOf((Object[])objectArray)));
        objectArray = new String[]{"files/exams/full/christian-01/nibp/NibpData-1699992647919", "files/exams/full/christian-01/nibp/NibpData-1699992790390"};
        pairArray[2] = TuplesKt.to((Object)"christian-01", (Object)new SampleExamResources("files/exams/full/christian-01/EcgData", "files/exams/full/christian-01/PpgData", "files/exams/full/christian-01/TempData", "files/exams/full/christian-01/CapnoData", CollectionsKt.listOf((Object[])objectArray)));
        samples = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003JA\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lvet/inpulse/libcomm/core/util/data_generator/SampleGenerators$SampleExamResources;", "", "ecg", "", "ppg", "temp", "capno", "nibps", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getEcg", "()Ljava/lang/String;", "getPpg", "getTemp", "getCapno", "getNibps", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "libcomm"})
    public static final class SampleExamResources {
        @NotNull
        private final String ecg;
        @NotNull
        private final String ppg;
        @NotNull
        private final String temp;
        @NotNull
        private final String capno;
        @NotNull
        private final List<String> nibps;

        public SampleExamResources(@NotNull String ecg, @NotNull String ppg, @NotNull String temp, @NotNull String capno, @NotNull List<String> nibps) {
            Intrinsics.checkNotNullParameter((Object)ecg, (String)"ecg");
            Intrinsics.checkNotNullParameter((Object)ppg, (String)"ppg");
            Intrinsics.checkNotNullParameter((Object)temp, (String)"temp");
            Intrinsics.checkNotNullParameter((Object)capno, (String)"capno");
            Intrinsics.checkNotNullParameter(nibps, (String)"nibps");
            this.ecg = ecg;
            this.ppg = ppg;
            this.temp = temp;
            this.capno = capno;
            this.nibps = nibps;
        }

        @NotNull
        public final String getEcg() {
            return this.ecg;
        }

        @NotNull
        public final String getPpg() {
            return this.ppg;
        }

        @NotNull
        public final String getTemp() {
            return this.temp;
        }

        @NotNull
        public final String getCapno() {
            return this.capno;
        }

        @NotNull
        public final List<String> getNibps() {
            return this.nibps;
        }

        @NotNull
        public final String component1() {
            return this.ecg;
        }

        @NotNull
        public final String component2() {
            return this.ppg;
        }

        @NotNull
        public final String component3() {
            return this.temp;
        }

        @NotNull
        public final String component4() {
            return this.capno;
        }

        @NotNull
        public final List<String> component5() {
            return this.nibps;
        }

        @NotNull
        public final SampleExamResources copy(@NotNull String ecg, @NotNull String ppg, @NotNull String temp, @NotNull String capno, @NotNull List<String> nibps) {
            Intrinsics.checkNotNullParameter((Object)ecg, (String)"ecg");
            Intrinsics.checkNotNullParameter((Object)ppg, (String)"ppg");
            Intrinsics.checkNotNullParameter((Object)temp, (String)"temp");
            Intrinsics.checkNotNullParameter((Object)capno, (String)"capno");
            Intrinsics.checkNotNullParameter(nibps, (String)"nibps");
            return new SampleExamResources(ecg, ppg, temp, capno, nibps);
        }

        public static /* synthetic */ SampleExamResources copy$default(SampleExamResources sampleExamResources, String string, String string2, String string3, String string4, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = sampleExamResources.ecg;
            }
            if ((n & 2) != 0) {
                string2 = sampleExamResources.ppg;
            }
            if ((n & 4) != 0) {
                string3 = sampleExamResources.temp;
            }
            if ((n & 8) != 0) {
                string4 = sampleExamResources.capno;
            }
            if ((n & 0x10) != 0) {
                list = sampleExamResources.nibps;
            }
            return sampleExamResources.copy(string, string2, string3, string4, list);
        }

        @NotNull
        public String toString() {
            return "SampleExamResources(ecg=" + this.ecg + ", ppg=" + this.ppg + ", temp=" + this.temp + ", capno=" + this.capno + ", nibps=" + this.nibps + ")";
        }

        public int hashCode() {
            int result2 = this.ecg.hashCode();
            result2 = result2 * 31 + this.ppg.hashCode();
            result2 = result2 * 31 + this.temp.hashCode();
            result2 = result2 * 31 + this.capno.hashCode();
            result2 = result2 * 31 + ((Object)this.nibps).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SampleExamResources)) {
                return false;
            }
            SampleExamResources sampleExamResources = (SampleExamResources)other;
            if (!Intrinsics.areEqual((Object)this.ecg, (Object)sampleExamResources.ecg)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ppg, (Object)sampleExamResources.ppg)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.temp, (Object)sampleExamResources.temp)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.capno, (Object)sampleExamResources.capno)) {
                return false;
            }
            return Intrinsics.areEqual(this.nibps, sampleExamResources.nibps);
        }
    }
}

