/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.util.data_generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.device.module.hardware.Ads129xCalculator;
import vet.inpulse.libcomm.core.protocol.message.EcgModuleSample;
import vet.inpulse.libcomm.core.util.data_generator.SampleGenerator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0002H\u0016J\u001c\u0010\u001b\u001a\u00020\u0017*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lvet/inpulse/libcomm/core/util/data_generator/IncardioWaveformSampleGenerator;", "Lvet/inpulse/libcomm/core/util/data_generator/SampleGenerator;", "Lvet/inpulse/libcomm/core/protocol/message/EcgModuleSample;", "sampleStreams", "", "Lokio/Source;", "gain", "", "<init>", "(Ljava/util/List;I)V", "numChannels", "buffers", "Lokio/Buffer;", "getBuffers", "()Ljava/util/List;", "buffers$delegate", "Lkotlin/Lazy;", "peekedBuffers", "", "Lokio/BufferedSource;", "useBuffer", "channel", "reset", "", "adsCalculator", "Lvet/inpulse/libcomm/core/device/module/hardware/Ads129xCalculator;", "nextSample", "swap", "", "source", "dest", "libcomm"})
@SourceDebugExtension(value={"SMAP\nSampleGeneratorFromEcgExamWaveform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SampleGeneratorFromEcgExamWaveform.kt\nvet/inpulse/libcomm/core/util/data_generator/IncardioWaveformSampleGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1#2:88\n1563#3:89\n1634#3,3:90\n1563#3:93\n1634#3,3:94\n1761#3,3:97\n2393#3,14:100\n1563#3:114\n1634#3,3:115\n*S KotlinDebug\n*F\n+ 1 SampleGeneratorFromEcgExamWaveform.kt\nvet/inpulse/libcomm/core/util/data_generator/IncardioWaveformSampleGenerator\n*L\n17#1:89\n17#1:90,3\n24#1:93\n24#1:94,3\n26#1:97,3\n27#1:100,14\n28#1:114\n28#1:115,3\n*E\n"})
public final class IncardioWaveformSampleGenerator
implements SampleGenerator<EcgModuleSample> {
    @NotNull
    private final List<Source> sampleStreams;
    private final int numChannels;
    @NotNull
    private final Lazy buffers$delegate;
    @NotNull
    private List<BufferedSource> peekedBuffers;
    @NotNull
    private final Ads129xCalculator adsCalculator;

    public IncardioWaveformSampleGenerator(@NotNull List<? extends Source> sampleStreams, int gain) {
        Intrinsics.checkNotNullParameter(sampleStreams, (String)"sampleStreams");
        this.sampleStreams = sampleStreams;
        this.numChannels = this.sampleStreams.size();
        this.buffers$delegate = LazyKt.lazy(() -> IncardioWaveformSampleGenerator.buffers_delegate$lambda$6(this));
        int n = this.numChannels;
        IncardioWaveformSampleGenerator incardioWaveformSampleGenerator = this;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Object> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(null);
        }
        incardioWaveformSampleGenerator.peekedBuffers = arrayList;
        this.adsCalculator = new Ads129xCalculator(2.4f, gain);
    }

    public /* synthetic */ IncardioWaveformSampleGenerator(List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        this(list, n);
    }

    private final List<Buffer> getBuffers() {
        Lazy lazy = this.buffers$delegate;
        return (List)lazy.getValue();
    }

    private final BufferedSource useBuffer(int channel) {
        BufferedSource bufferedSource;
        BufferedSource buf = this.peekedBuffers.get(channel);
        if (buf != null && !buf.exhausted()) {
            bufferedSource = buf;
        } else {
            BufferedSource bufferedSource2;
            BufferedSource it = bufferedSource2 = this.getBuffers().get(channel).peek();
            boolean bl = false;
            this.peekedBuffers.set(channel, it);
            it.skip(4L);
            bufferedSource = bufferedSource2;
        }
        return bufferedSource;
    }

    @Override
    public void reset() {
        int n = ((Collection)this.peekedBuffers).size();
        for (int i = 0; i < n; ++i) {
            this.peekedBuffers.set(i, null);
        }
    }

    @Override
    @NotNull
    public EcgModuleSample nextSample() {
        int n = 0;
        int n2 = this.numChannels;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            float f = Float.intBitsToFloat(this.useBuffer(n3).readInt());
            nArray[n3] = this.adsCalculator.voltageToAdc(f);
        }
        int[] intArray = nArray;
        if (this.numChannels > 3) {
            this.swap(intArray, 2, 7);
        }
        this.swap(intArray, 0, 2);
        this.swap(intArray, 1, 2);
        return new EcgModuleSample(new byte[3], intArray);
    }

    private final void swap(int[] $this$swap, int source, int dest) {
        int temp = $this$swap[dest];
        $this$swap[dest] = $this$swap[source];
        $this$swap[source] = temp;
    }

    /*
     * WARNING - void declaration
     */
    private static final List buffers_delegate$lambda$6(IncardioWaveformSampleGenerator this$0) {
        List list;
        boolean bl;
        List buffers;
        Collection collection;
        block12: {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = this$0.sampleStreams;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Buffer buffer;
                Source source = (Source)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Buffer $this$buffers_delegate_u24lambda_u246_u24lambda_u241_u24lambda_u240 = buffer = new Buffer();
                boolean bl3 = false;
                $this$buffers_delegate_u24lambda_u246_u24lambda_u241_u24lambda_u240.writeAll((Source)it);
                collection.add(buffer);
            }
            buffers = (List)destination$iv$iv;
            Iterable $this$map$iv2 = buffers;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Buffer bl2 = (Buffer)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it.size());
            }
            List bufferSizes = (List)destination$iv$iv2;
            long firstSize = ((Number)CollectionsKt.first((List)bufferSizes)).longValue();
            Iterable $this$any$iv = bufferSizes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    long it = ((Number)element$iv).longValue();
                    boolean bl5 = false;
                    if (!(it != firstSize)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$mapTo$iv$iv;
            Object t;
            Iterable $this$minBy$iv = buffers;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                Buffer it = (Buffer)minElem$iv;
                boolean bl6 = false;
                long minValue$iv = it.size();
                do {
                    Object e$iv = iterator$iv.next();
                    Buffer it2 = (Buffer)e$iv;
                    buffer2 = false;
                    long v$iv = it2.size();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            long smallest = ((Buffer)t).size();
            Iterable $this$map$iv = buffers;
            boolean $i$f$map = false;
            iterator$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void buffer;
                Buffer buffer2 = (Buffer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                Buffer limited = new Buffer();
                buffer.write(limited, smallest);
                collection.add(limited);
            }
            list = (List)destination$iv$iv;
        } else {
            list = buffers;
        }
        return list;
    }
}

