/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.time.Clock;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.util.SamplingRateEstimate;
import vet.inpulse.libcomm.core.util.SamplingRateEstimator;
import vet.inpulse.shared.log.LoggerInterface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0002J\u0017\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b#\u0010$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lvet/inpulse/libcomm/core/util/SamplingRateEstimatorImpl;", "Lvet/inpulse/libcomm/core/util/SamplingRateEstimator;", "minimumSampleSize", "", "minimumDifferenceToUpdate", "", "updateTimeLimit", "Lkotlin/time/Duration;", "clock", "Lkotlin/time/TimeSource;", "<init>", "(IDJLkotlin/time/TimeSource;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "totalSamples", "", "firstSampleTimestamp", "Lkotlin/time/TimeMark;", "lastEstimationTimestamp", "lastSampleId", "estimatedSamplingRate", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lvet/inpulse/libcomm/core/util/SamplingRateEstimate;", "getEstimatedSamplingRate", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "update", "", "idOfFirstSample", "numSamples", "reset", "shouldEstimate", "", "estimateFs", "totalElapsedTime", "estimateFs-LRDsOJo", "(J)D", "libcomm"})
public final class SamplingRateEstimatorImpl
implements SamplingRateEstimator {
    private final int minimumSampleSize;
    private final double minimumDifferenceToUpdate;
    private final long updateTimeLimit;
    @NotNull
    private final TimeSource clock;
    @NotNull
    private final LoggerInterface logger;
    private long totalSamples;
    @Nullable
    private TimeMark firstSampleTimestamp;
    @Nullable
    private TimeMark lastEstimationTimestamp;
    private int lastSampleId;
    @NotNull
    private final MutableStateFlow<SamplingRateEstimate> estimatedSamplingRate;

    private SamplingRateEstimatorImpl(int minimumSampleSize, double minimumDifferenceToUpdate, long updateTimeLimit, TimeSource clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.minimumSampleSize = minimumSampleSize;
        this.minimumDifferenceToUpdate = minimumDifferenceToUpdate;
        this.updateTimeLimit = updateTimeLimit;
        this.clock = clock;
        this.logger = InPulseLoggerKt.getLibcommLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.lastSampleId = -1;
        this.estimatedSamplingRate = StateFlowKt.MutableStateFlow(null);
    }

    public /* synthetic */ SamplingRateEstimatorImpl(int n, double d, long l, TimeSource timeSource, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 5000;
        }
        if ((n2 & 2) != 0) {
            d = 1.0;
        }
        if ((n2 & 4) != 0) {
            l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
        }
        if ((n2 & 8) != 0) {
            timeSource = (TimeSource)TimeSource.Monotonic.INSTANCE;
        }
        this(n, d, l, timeSource, null);
    }

    @NotNull
    public MutableStateFlow<SamplingRateEstimate> getEstimatedSamplingRate() {
        return this.estimatedSamplingRate;
    }

    @Override
    public void update(int idOfFirstSample, int numSamples) {
        if (numSamples == 0) {
            return;
        }
        TimeMark now = this.clock.markNow();
        if (this.firstSampleTimestamp == null || this.lastSampleId < 0) {
            this.firstSampleTimestamp = now;
            this.lastSampleId = SamplingRateEstimatorImpl.update$calculateLastSampleId(idOfFirstSample, numSamples);
            return;
        }
        if (idOfFirstSample <= this.lastSampleId) {
            this.logger.d(() -> SamplingRateEstimatorImpl.update$lambda$0(idOfFirstSample, numSamples));
            this.reset();
            return;
        }
        int gap = idOfFirstSample - this.lastSampleId - 1;
        this.totalSamples += (long)(numSamples + gap);
        this.lastSampleId = SamplingRateEstimatorImpl.update$calculateLastSampleId(idOfFirstSample, numSamples);
        if (this.shouldEstimate()) {
            TimeMark timeMark = this.firstSampleTimestamp;
            if (timeMark == null) {
                return;
            }
            long totalElapsedTime = timeMark.elapsedNow-UwyO8pc();
            SamplingRateEstimate samplingRateEstimate = (SamplingRateEstimate)this.getEstimatedSamplingRate().getValue();
            float previousEstimate = samplingRateEstimate != null ? samplingRateEstimate.getEstimateValue() : 0.0f;
            double newEstimate = this.estimateFs-LRDsOJo(totalElapsedTime);
            if (Math.abs(newEstimate - (double)previousEstimate) < this.minimumDifferenceToUpdate) {
                return;
            }
            this.getEstimatedSamplingRate().setValue((Object)new SamplingRateEstimate((float)newEstimate, Clock.System.INSTANCE.now().toEpochMilliseconds()));
            this.lastEstimationTimestamp = this.clock.markNow();
        }
    }

    @Override
    public void reset() {
        this.totalSamples = 0L;
        this.firstSampleTimestamp = null;
        this.lastEstimationTimestamp = null;
        this.getEstimatedSamplingRate().setValue(null);
        this.lastSampleId = -1;
    }

    private final boolean shouldEstimate() {
        boolean bl;
        TimeMark timeMark = this.lastEstimationTimestamp;
        if (timeMark != null) {
            boolean expired;
            TimeMark it = timeMark;
            boolean bl2 = false;
            long elapsedSinceLastEstimation = it.elapsedNow-UwyO8pc();
            bl = expired = Duration.compareTo-LRDsOJo((long)elapsedSinceLastEstimation, (long)this.updateTimeLimit) > 0;
        } else {
            bl = true;
        }
        boolean lastEstimationExpired = bl;
        boolean hasEnoughSamplesToEstimate = this.totalSamples > (long)this.minimumSampleSize;
        return lastEstimationExpired && hasEnoughSamplesToEstimate;
    }

    private final double estimateFs-LRDsOJo(long totalElapsedTime) {
        return (double)this.totalSamples / Duration.toDouble-impl((long)totalElapsedTime, (DurationUnit)DurationUnit.SECONDS);
    }

    private static final int update$calculateLastSampleId(int $idOfFirstSample, int $numSamples) {
        return $idOfFirstSample + $numSamples - 1;
    }

    private static final String update$lambda$0(int $idOfFirstSample, int $numSamples) {
        return "sample id " + $idOfFirstSample + " is smaller than " + $numSamples + ": estimator cannot calculate gaps";
    }

    public /* synthetic */ SamplingRateEstimatorImpl(int minimumSampleSize, double minimumDifferenceToUpdate, long updateTimeLimit, TimeSource clock, DefaultConstructorMarker $constructor_marker) {
        this(minimumSampleSize, minimumDifferenceToUpdate, updateTimeLimit, clock);
    }
}

