/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol.packet;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.util.SourceMarker;
import vet.inpulse.shared.log.LoggerInterface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0002)*B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0017\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020%2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b&\u0010'J\b\u0010(\u001a\u00020\tH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource;", "Lokio/ForwardingSource;", "Lokio/Source;", "realSource", "startByte", "Lkotlin/UByte;", "sizeBytes", "", "maxPacketSize", "", "<init>", "(Lokio/Source;Lkotlin/UByte;IJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "marker", "Lvet/inpulse/libcomm/core/util/SourceMarker;", "inputBuffer", "Lokio/BufferedSource;", "getMessageSize", "Lkotlin/Function1;", "getGetMessageSize", "()Lkotlin/jvm/functions/Function1;", "bytesOverhead", "getBytesOverhead", "()I", "read", "sink", "Lokio/Buffer;", "byteCount", "checkValidChecksum", "Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$ChecksumResult;", "packetSize", "calculateSizeChecksum", "size", "calculateSizeChecksum-Wa3L5BU", "(J)B", "discardUntilStartByte", "Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$DiscardResult;", "discardUntilStartByte-7apg3OU", "(B)Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$DiscardResult;", "requestAndReadMessageSize", "DiscardResult", "ChecksumResult", "libcomm"})
public final class DecoderSource
extends ForwardingSource
implements Source {
    @Nullable
    private final UByte startByte;
    private final int sizeBytes;
    private final long maxPacketSize;
    @NotNull
    private final LoggerInterface logger;
    @NotNull
    private final SourceMarker marker;
    @NotNull
    private final BufferedSource inputBuffer;
    @NotNull
    private final Function1<BufferedSource, Long> getMessageSize;
    private final int bytesOverhead;

    private DecoderSource(Source realSource, UByte startByte, int sizeBytes, long maxPacketSize) {
        Intrinsics.checkNotNullParameter((Object)realSource, (String)"realSource");
        super(realSource);
        this.startByte = startByte;
        this.sizeBytes = sizeBytes;
        this.maxPacketSize = maxPacketSize;
        this.logger = InPulseLoggerKt.getLibcommLogModule().getLogger(Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()));
        this.marker = new SourceMarker(realSource);
        this.inputBuffer = this.marker.source();
        this.getMessageSize = switch (this.sizeBytes) {
            case 1 -> DecoderSource::getMessageSize$lambda$0;
            case 2 -> DecoderSource::getMessageSize$lambda$1;
            case 4 -> DecoderSource::getMessageSize$lambda$2;
            default -> throw new IllegalArgumentException("sizeBytes " + this.sizeBytes + " is not supported.");
        };
        this.bytesOverhead = 1 + this.sizeBytes + (this.startByte == null ? 0 : 1);
    }

    public /* synthetic */ DecoderSource(Source source, UByte uByte, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            l = (1L << n * 8) - 1L;
        }
        this(source, uByte, n, l, null);
    }

    @NotNull
    public final Function1<BufferedSource, Long> getGetMessageSize() {
        return this.getMessageSize;
    }

    public final int getBytesOverhead() {
        return this.bytesOverhead;
    }

    public long read(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        while (true) {
            long size;
            long packetSize = 0L;
            long afterStartByteMark = 0L;
            while (true) {
                if (this.startByte == null) {
                    afterStartByteMark = this.marker.mark(this.sizeBytes);
                    v0 = this.requestAndReadMessageSize();
                } else {
                    DiscardResult result2 = this.discardUntilStartByte-7apg3OU(this.startByte.unbox-impl());
                    if (result2 == DiscardResult.Exhausted) {
                        return -1L;
                    }
                    afterStartByteMark = this.marker.mark(this.sizeBytes);
                    v0 = size = this.requestAndReadMessageSize();
                }
                if (size == -1L) {
                    return -1L;
                }
                if (1L <= size ? size < this.maxPacketSize : false) break;
                Buffer buffer = new Buffer();
                this.inputBuffer.peek().read(buffer, 64L);
                ByteString context = buffer.readByteString();
                LoggerInterface.w$default((LoggerInterface)this.logger, null, () -> DecoderSource.read$lambda$3(size, this, context), (int)1, null);
                this.marker.reset(afterStartByteMark);
            }
            packetSize = size;
            long payloadSize = packetSize - (long)this.bytesOverhead;
            long afterSizeMark = this.marker.mark(payloadSize + 1L);
            ChecksumResult checksumResult = this.checkValidChecksum(packetSize);
            if (Intrinsics.areEqual((Object)checksumResult, (Object)ChecksumResult.Match.INSTANCE)) {
                this.marker.reset(afterSizeMark);
                this.inputBuffer.read(sink, payloadSize);
                this.inputBuffer.readByte();
                return payloadSize;
            }
            if (!(checksumResult instanceof ChecksumResult.NoMatch)) break;
            LoggerInterface.w$default((LoggerInterface)this.logger, null, () -> DecoderSource.read$lambda$4(checksumResult), (int)1, null);
            this.marker.reset(afterSizeMark);
        }
        throw new NoWhenBranchMatchedException();
    }

    private final ChecksumResult checkValidChecksum(long packetSize) {
        byte sum = UByte.constructor-impl((byte)0);
        long l = packetSize - (long)this.bytesOverhead;
        for (long i = 0L; i < l; ++i) {
            byte by = UByte.constructor-impl((byte)this.inputBuffer.readByte());
            sum = UByte.constructor-impl((byte)((byte)UInt.constructor-impl((int)(UInt.constructor-impl((int)(sum & 0xFF)) + UInt.constructor-impl((int)(by & 0xFF))))));
        }
        UByte uByte = this.startByte;
        byte sb = uByte != null ? uByte.unbox-impl() : (byte)0;
        byte sizeChecksum = this.calculateSizeChecksum-Wa3L5BU(packetSize);
        byte calculatedChecksum = (byte)UInt.constructor-impl((int)(UInt.constructor-impl((int)(UInt.constructor-impl((int)(sum & 0xFF)) + UInt.constructor-impl((int)(sb & 0xFF)))) + UInt.constructor-impl((int)(sizeChecksum & 0xFF))));
        byte expectedChecksum = this.inputBuffer.readByte();
        return calculatedChecksum == expectedChecksum ? (ChecksumResult)ChecksumResult.Match.INSTANCE : (ChecksumResult)new ChecksumResult.NoMatch(UByte.constructor-impl((byte)expectedChecksum), UByte.constructor-impl((byte)calculatedChecksum), null);
    }

    private final byte calculateSizeChecksum-Wa3L5BU(long size) {
        switch (this.sizeBytes) {
            case 1: {
                break;
            }
            case 2: {
                byte a = UByte.constructor-impl((byte)((byte)((size & 0xFF00L) >> 8)));
                byte b = UByte.constructor-impl((byte)((byte)(size & 0xFFL)));
                return UByte.constructor-impl((byte)((byte)UInt.constructor-impl((int)(UInt.constructor-impl((int)(a & 0xFF)) + UInt.constructor-impl((int)(b & 0xFF))))));
            }
            case 4: {
                byte a = UByte.constructor-impl((byte)((byte)((size & 0xFF000000L) >> 24)));
                byte b = UByte.constructor-impl((byte)((byte)((size & 0xFF0000L) >> 16)));
                byte c = UByte.constructor-impl((byte)((byte)((size & 0xFF00L) >> 8)));
                byte d = UByte.constructor-impl((byte)((byte)(size & 0xFFL)));
                return UByte.constructor-impl((byte)((byte)UInt.constructor-impl((int)(UInt.constructor-impl((int)(UInt.constructor-impl((int)(UInt.constructor-impl((int)(a & 0xFF)) + UInt.constructor-impl((int)(b & 0xFF)))) + UInt.constructor-impl((int)(c & 0xFF)))) + UInt.constructor-impl((int)(d & 0xFF))))));
            }
            default: {
                throw new IllegalStateException("sizeBytes not supported. size: " + this.sizeBytes);
            }
        }
        return UByte.constructor-impl((byte)((byte)size));
    }

    /*
     * WARNING - void declaration
     */
    private final DiscardResult discardUntilStartByte-7apg3OU(byte startByte) {
        void var3_3;
        void byteVal;
        do {
            if (!this.inputBuffer.request(1L)) {
                return DiscardResult.Exhausted;
            }
            byte b = UByte.constructor-impl((byte)this.inputBuffer.readByte());
        } while ((byteVal = var3_3) != startByte);
        return DiscardResult.FoundStartByte;
    }

    private final long requestAndReadMessageSize() {
        return this.inputBuffer.request((long)this.sizeBytes) ? ((Number)this.getMessageSize.invoke((Object)this.inputBuffer)).longValue() : -1L;
    }

    private static final long getMessageSize$lambda$0(BufferedSource src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return src.readByte();
    }

    private static final long getMessageSize$lambda$1(BufferedSource src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return src.readShort();
    }

    private static final long getMessageSize$lambda$2(BufferedSource src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return src.readInt();
    }

    private static final String read$lambda$3(long $size, DecoderSource this$0, ByteString $context) {
        return "Discarding packet because size was bigger than maxPacketSize. size: " + $size + ", maxPacketSize: " + this$0.maxPacketSize + ". context: " + $context + ".";
    }

    private static final String read$lambda$4(ChecksumResult $checksumResult) {
        return "Discarding packet because checksum was different from expected. expected: " + UByte.toString-impl((byte)((ChecksumResult.NoMatch)$checksumResult).getExpected-w2LRezQ()) + ", calculated: " + UByte.toString-impl((byte)((ChecksumResult.NoMatch)$checksumResult).getCalculated-w2LRezQ()) + ".";
    }

    public /* synthetic */ DecoderSource(Source realSource, UByte startByte, int sizeBytes, long maxPacketSize, DefaultConstructorMarker $constructor_marker) {
        this(realSource, startByte, sizeBytes, maxPacketSize);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$ChecksumResult;", "", "<init>", "()V", "Match", "NoMatch", "Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$ChecksumResult$Match;", "Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$ChecksumResult$NoMatch;", "libcomm"})
    private static abstract class ChecksumResult {
        private ChecksumResult() {
        }

        public /* synthetic */ ChecksumResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$ChecksumResult$Match;", "Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$ChecksumResult;", "<init>", "()V", "libcomm"})
        public static final class Match
        extends ChecksumResult {
            @NotNull
            public static final Match INSTANCE = new Match();

            private Match() {
                super(null);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\bJ\u0010\u0010\r\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\bJ$\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001a"}, d2={"Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$ChecksumResult$NoMatch;", "Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$ChecksumResult;", "expected", "Lkotlin/UByte;", "calculated", "<init>", "(BBLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getExpected-w2LRezQ", "()B", "B", "getCalculated-w2LRezQ", "component1", "component1-w2LRezQ", "component2", "component2-w2LRezQ", "copy", "copy-YVftJsw", "(BB)Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$ChecksumResult$NoMatch;", "equals", "", "other", "", "hashCode", "", "toString", "", "libcomm"})
        public static final class NoMatch
        extends ChecksumResult {
            private final byte expected;
            private final byte calculated;

            private NoMatch(byte expected, byte calculated) {
                super(null);
                this.expected = expected;
                this.calculated = calculated;
            }

            public final byte getExpected-w2LRezQ() {
                return this.expected;
            }

            public final byte getCalculated-w2LRezQ() {
                return this.calculated;
            }

            public final byte component1-w2LRezQ() {
                return this.expected;
            }

            public final byte component2-w2LRezQ() {
                return this.calculated;
            }

            @NotNull
            public final NoMatch copy-YVftJsw(byte expected, byte calculated) {
                return new NoMatch(expected, calculated, null);
            }

            public static /* synthetic */ NoMatch copy-YVftJsw$default(NoMatch noMatch, byte by, byte by2, int n, Object object) {
                if ((n & 1) != 0) {
                    by = noMatch.expected;
                }
                if ((n & 2) != 0) {
                    by2 = noMatch.calculated;
                }
                return noMatch.copy-YVftJsw(by, by2);
            }

            @NotNull
            public String toString() {
                return "NoMatch(expected=" + UByte.toString-impl((byte)this.expected) + ", calculated=" + UByte.toString-impl((byte)this.calculated) + ")";
            }

            public int hashCode() {
                int result2 = UByte.hashCode-impl((byte)this.expected);
                result2 = result2 * 31 + UByte.hashCode-impl((byte)this.calculated);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NoMatch)) {
                    return false;
                }
                NoMatch noMatch = (NoMatch)other;
                if (this.expected != noMatch.expected) {
                    return false;
                }
                return this.calculated == noMatch.calculated;
            }

            public /* synthetic */ NoMatch(byte expected, byte calculated, DefaultConstructorMarker $constructor_marker) {
                this(expected, calculated);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lvet/inpulse/libcomm/core/protocol/packet/DecoderSource$DiscardResult;", "", "<init>", "(Ljava/lang/String;I)V", "Exhausted", "FoundStartByte", "libcomm"})
    private static final class DiscardResult
    extends Enum<DiscardResult> {
        public static final /* enum */ DiscardResult Exhausted = new DiscardResult();
        public static final /* enum */ DiscardResult FoundStartByte = new DiscardResult();
        private static final /* synthetic */ DiscardResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DiscardResult[] values() {
            return (DiscardResult[])$VALUES.clone();
        }

        public static DiscardResult valueOf(String value) {
            return Enum.valueOf(DiscardResult.class, value);
        }

        @NotNull
        public static EnumEntries<DiscardResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = discardResultArray = new DiscardResult[]{DiscardResult.Exhausted, DiscardResult.FoundStartByte};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

