/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol;

import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UByte;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.locator.bluetooth.RemoteAddress;
import vet.inpulse.libcomm.core.protocol.ProtocolParseException;
import vet.inpulse.libcomm.core.protocol.ProtocolSerializationException;
import vet.inpulse.libcomm.core.protocol.message.Message;
import vet.inpulse.libcomm.core.protocol.message.MessageType;
import vet.inpulse.libcomm.core.util.HexPrinterKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 .2\u00020\u0001:\u0001.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0011J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0004J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%H\u0004J \u0010)\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020%H\u0004J\u000e\u0010,\u001a\u00020-2\u0006\u0010\f\u001a\u00020\rR-\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0017\u0012\u0004\u0012\u00020\u00180\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006/"}, d2={"Lvet/inpulse/libcomm/core/protocol/Protocol;", "", "<init>", "()V", "serialize", "", "message", "Lvet/inpulse/libcomm/core/protocol/message/Message;", "sink", "Lokio/BufferedSink;", "deserialize", "Lkotlin/Result;", "source", "Lokio/BufferedSource;", "deserialize-IoAF18A", "(Lokio/BufferedSource;)Ljava/lang/Object;", "mapMessageTypeToByte", "", "type", "Lvet/inpulse/libcomm/core/protocol/message/MessageType;", "(Lvet/inpulse/libcomm/core/protocol/message/MessageType;)Ljava/lang/Byte;", "commandsToBytesMapping", "Lkotlin/Pair;", "", "", "getCommandsToBytesMapping", "()Lkotlin/Pair;", "commandsToBytesMapping$delegate", "Lkotlin/Lazy;", "byteForType", "", "messageType", "typeForByte", "byte", "throwUnsupportedMessageSerialization", "", "tag", "", "getUnsupportedMessageParsing", "Lvet/inpulse/libcomm/core/protocol/ProtocolParseException;", "cmdByte", "getNotEnoughBytesException", "neededBytes", "", "readMacAddressString", "Lvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress;", "Companion", "libcomm"})
public abstract class Protocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy commandsToBytesMapping$delegate = LazyKt.lazy(() -> Protocol.commandsToBytesMapping_delegate$lambda$0(this));
    public static final int PROTOCOL_UNKNOWN_MESSAGE_TYPE_BYTE = 255;

    public abstract void serialize(@NotNull Message var1, @NotNull BufferedSink var2);

    @NotNull
    public abstract Object deserialize-IoAF18A(@NotNull BufferedSource var1);

    @Nullable
    public abstract Byte mapMessageTypeToByte(@NotNull MessageType var1);

    private final Pair<MessageType[], int[]> getCommandsToBytesMapping() {
        Lazy lazy = this.commandsToBytesMapping$delegate;
        return (Pair)lazy.getValue();
    }

    public final int byteForType(@NotNull MessageType messageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)messageType), (String)"messageType");
        return ((int[])this.getCommandsToBytesMapping().getSecond())[messageType.ordinal()];
    }

    @NotNull
    public final MessageType typeForByte(byte by) {
        byte unsigned = UByte.constructor-impl((byte)by);
        if (by > 255) {
            return MessageType.Unknown;
        }
        return ((MessageType[])this.getCommandsToBytesMapping().getFirst())[unsigned & 0xFF];
    }

    @NotNull
    protected final Void throwUnsupportedMessageSerialization(@NotNull Message message2, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        throw new ProtocolSerializationException(tag + ": message is not supported by this protocol. Message: " + message2 + ".", null, 2, null);
    }

    @NotNull
    protected final ProtocolParseException getUnsupportedMessageParsing(byte cmdByte, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return new ProtocolParseException(tag + ": message is not supported by this protocol. cmd byte: " + HexPrinterKt.toHex(cmdByte), null, 2, null);
    }

    @NotNull
    protected final ProtocolParseException getNotEnoughBytesException(@NotNull MessageType messageType, long neededBytes, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)messageType), (String)"messageType");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return new ProtocolParseException(tag + ": Needed " + neededBytes + " to deserialize " + messageType + ".", null, 2, null);
    }

    @NotNull
    public final RemoteAddress readMacAddressString(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String string = source.readUtf8(17L).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String macAddress = string;
        return new RemoteAddress(macAddress);
    }

    private static final Pair commandsToBytesMapping_delegate$lambda$0(Protocol this$0) {
        EnumEntries<MessageType> values = MessageType.getEntries();
        int commandsCapacity = values.size();
        int messagesCapacity = (0xFFFFFFFF & 0xFF) + 1;
        int n = 0;
        MessageType[] messageTypeArray = new MessageType[messagesCapacity];
        while (n < messagesCapacity) {
            int n2 = n++;
            messageTypeArray[n2] = MessageType.Unknown;
        }
        MessageType[] messageTypes = messageTypeArray;
        int n3 = 0;
        int[] nArray = new int[commandsCapacity];
        while (n3 < commandsCapacity) {
            int n4 = n3++;
            nArray[n4] = 255;
        }
        int[] commands = nArray;
        for (MessageType type : values) {
            Byte by = this$0.mapMessageTypeToByte(type);
            if (by == null) {
                continue;
            }
            byte by2 = by;
            int index = UByte.constructor-impl((byte)by2) & 0xFF;
            messageTypes[index] = type;
            commands[type.ordinal()] = by2;
        }
        return TuplesKt.to((Object)messageTypes, (Object)commands);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lvet/inpulse/libcomm/core/protocol/Protocol$Companion;", "", "<init>", "()V", "PROTOCOL_UNKNOWN_MESSAGE_TYPE_BYTE", "", "libcomm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

