/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.device.data.BatteryInfo;
import vet.inpulse.libcomm.core.device.data.NibpStatus;
import vet.inpulse.libcomm.core.device.data.PpgCalibrationParameters;
import vet.inpulse.libcomm.core.device.data.PpgDiagnosis;
import vet.inpulse.libcomm.core.device.data.PpgSampleStatus;
import vet.inpulse.libcomm.core.device.data.PpgState;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.protocol.Protocol;
import vet.inpulse.libcomm.core.protocol.message.Ack;
import vet.inpulse.libcomm.core.protocol.message.BatteryInfoMessage;
import vet.inpulse.libcomm.core.protocol.message.Connect;
import vet.inpulse.libcomm.core.protocol.message.Disconnect;
import vet.inpulse.libcomm.core.protocol.message.EcgPpgData;
import vet.inpulse.libcomm.core.protocol.message.GetBatteryInfo;
import vet.inpulse.libcomm.core.protocol.message.GetInfo;
import vet.inpulse.libcomm.core.protocol.message.GetMac;
import vet.inpulse.libcomm.core.protocol.message.GetNibpCalibrationParameters;
import vet.inpulse.libcomm.core.protocol.message.GoToBootloader;
import vet.inpulse.libcomm.core.protocol.message.Message;
import vet.inpulse.libcomm.core.protocol.message.MessageType;
import vet.inpulse.libcomm.core.protocol.message.ModulePacket;
import vet.inpulse.libcomm.core.protocol.message.MonitorEcgSample;
import vet.inpulse.libcomm.core.protocol.message.MonitorPpgSample;
import vet.inpulse.libcomm.core.protocol.message.MyInfo;
import vet.inpulse.libcomm.core.protocol.message.MyMac;
import vet.inpulse.libcomm.core.protocol.message.Nack;
import vet.inpulse.libcomm.core.protocol.message.NibpCalibrationParameters;
import vet.inpulse.libcomm.core.protocol.message.NibpDataMessage;
import vet.inpulse.libcomm.core.protocol.message.NibpModuleSample;
import vet.inpulse.libcomm.core.protocol.message.NibpProcedureCanceledByDevice;
import vet.inpulse.libcomm.core.protocol.message.NibpProcedurePeakFound;
import vet.inpulse.libcomm.core.protocol.message.NibpProcedureStartedByDevice;
import vet.inpulse.libcomm.core.protocol.message.Ping;
import vet.inpulse.libcomm.core.protocol.message.Pong;
import vet.inpulse.libcomm.core.protocol.message.PpgDiagnosisMessage;
import vet.inpulse.libcomm.core.protocol.message.PpgGetDiagnosis;
import vet.inpulse.libcomm.core.protocol.message.PpgGetParameters;
import vet.inpulse.libcomm.core.protocol.message.PpgParameters;
import vet.inpulse.libcomm.core.protocol.message.PpgSetParameters;
import vet.inpulse.libcomm.core.protocol.message.PpgStartCalibration;
import vet.inpulse.libcomm.core.protocol.message.SetMac;
import vet.inpulse.libcomm.core.protocol.message.SetNibpCalibrationParameters;
import vet.inpulse.libcomm.core.protocol.message.SetNibpCalibrationPressure;
import vet.inpulse.libcomm.core.protocol.message.StartEcgPpg;
import vet.inpulse.libcomm.core.protocol.message.StartNibp;
import vet.inpulse.libcomm.core.protocol.message.StartNibpCalibration;
import vet.inpulse.libcomm.core.protocol.message.StartTemp;
import vet.inpulse.libcomm.core.protocol.message.StopAll;
import vet.inpulse.libcomm.core.protocol.message.StopNibp;
import vet.inpulse.libcomm.core.protocol.message.TempDataMessage;
import vet.inpulse.libcomm.core.protocol.message.TempModuleSample;
import vet.inpulse.libcomm.core.protocol.nibp.NibpMessageSerializer;
import vet.inpulse.libcomm.core.protocol.payloadSerializer.impl.BatteryInfoSerializer;
import vet.inpulse.libcomm.core.protocol.payloadSerializer.impl.MyInfoSerializer;
import vet.inpulse.libcomm.core.protocol.ppg.PpgCommonSerializer;
import vet.inpulse.shared.log.LoggerInterface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 B2\u00020\u0001:\u0001BB/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0015\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\u0014\u0010%\u001a\u00020\u000f*\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0002J\f\u0010(\u001a\u00020'*\u00020\u001aH\u0002J\u0014\u0010)\u001a\u00020\u000f*\u00020\u00132\u0006\u0010&\u001a\u00020*H\u0002J\f\u0010+\u001a\u00020**\u00020\u001aH\u0002J\u0014\u0010,\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010-\u001a\u00020\u0016*\u00020\u001aH\u0002J\u0014\u0010.\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010/\u001a\u00020\u0016*\u00020\u001aH\u0002J \u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020!H\u0002J\u0014\u00104\u001a\u00020\u000f*\u00020\u00132\u0006\u00105\u001a\u000206H\u0002J\f\u00107\u001a\u000206*\u00020\u001aH\u0002J\u0014\u00108\u001a\u00020\u000f*\u00020\u00132\u0006\u00105\u001a\u000209H\u0002J\f\u0010:\u001a\u000209*\u00020\u001aH\u0002J\u0014\u0010;\u001a\u00020\u000f*\u00020\u00132\u0006\u0010<\u001a\u00020=H\u0002J\f\u0010>\u001a\u00020=*\u00020\u001aH\u0002J\u0014\u0010?\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u0010\u001a\u00020@H\u0002J\f\u0010A\u001a\u00020@*\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006C"}, d2={"Lvet/inpulse/libcomm/core/protocol/MonitorBasicProtocol;", "Lvet/inpulse/libcomm/core/protocol/Protocol;", "nibpSamplesPerPacket", "", "supportsPpgDiagnosis", "", "supportsPpgCalibrationV2", "supportsPpgSampleV2", "<init>", "(IZZZ)V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "getLogger", "()Lvet/inpulse/shared/log/LoggerInterface;", "serialize", "", "message", "Lvet/inpulse/libcomm/core/protocol/message/Message;", "sink", "Lokio/BufferedSink;", "writePpgParameters", "state", "Lvet/inpulse/libcomm/core/device/data/PpgState;", "deserialize", "Lkotlin/Result;", "source", "Lokio/BufferedSource;", "deserialize-IoAF18A", "(Lokio/BufferedSource;)Ljava/lang/Object;", "readPpgDiagnosis", "Lvet/inpulse/libcomm/core/device/data/PpgDiagnosis;", "readPpgState", "mapMessageTypeToByte", "", "type", "Lvet/inpulse/libcomm/core/protocol/message/MessageType;", "(Lvet/inpulse/libcomm/core/protocol/message/MessageType;)Ljava/lang/Byte;", "writeEcgSample", "sample", "Lvet/inpulse/libcomm/core/protocol/message/MonitorEcgSample;", "readEcgSample", "writePpgSample", "Lvet/inpulse/libcomm/core/protocol/message/MonitorPpgSample;", "readPpgSample", "writePpgStateV1", "readPpgStateV1", "writePpgStateV2", "readPpgStateV2", "assembleBitField", "upper", "lower", "maskLower", "writePpgCalibrationParametersV1", "params", "Lvet/inpulse/libcomm/core/device/data/PpgCalibrationParameters$V1;", "readPpgCalibrationParametersV1", "writePpgCalibrationParametersV2", "Lvet/inpulse/libcomm/core/device/data/PpgCalibrationParameters$V2;", "readPpgCalibrationParametersV2", "writePpgControlPhaseConfig", "config", "Lvet/inpulse/libcomm/core/device/data/PpgCalibrationParameters$ControlPhaseConfig;", "readPpgControlPhaseConfig", "serializeBatteryInfo", "Lvet/inpulse/libcomm/core/protocol/message/BatteryInfoMessage;", "deserializeBatteryInfo", "Companion", "libcomm"})
@SourceDebugExtension(value={"SMAP\nMonitorBasicProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitorBasicProtocol.kt\nvet/inpulse/libcomm/core/protocol/MonitorBasicProtocol\n+ 2 SourceByteUtils.kt\nvet/inpulse/libcomm/core/util/SourceByteUtilsKt\n*L\n1#1,744:1\n148#2:745\n148#2:746\n148#2:747\n11#2,3:748\n11#2,3:751\n43#2,7:754\n43#2,7:761\n43#2,7:768\n26#2:775\n11#2,3:776\n27#2:779\n11#2,3:780\n28#2:783\n11#2,3:784\n29#2:787\n26#2:788\n11#2,3:789\n27#2:792\n11#2,3:793\n28#2:796\n11#2,3:797\n29#2:800\n26#2:801\n11#2,3:802\n27#2:805\n11#2,3:806\n28#2:809\n11#2,3:810\n29#2:813\n136#2,7:814\n136#2,7:821\n136#2,7:828\n136#2,7:835\n97#2:842\n11#2,3:843\n98#2:846\n11#2,3:847\n99#2:850\n11#2,3:851\n100#2:854\n97#2:855\n11#2,3:856\n98#2:859\n11#2,3:860\n99#2:863\n11#2,3:864\n100#2:867\n97#2:868\n11#2,3:869\n98#2:872\n11#2,3:873\n99#2:876\n11#2,3:877\n100#2:880\n97#2:881\n11#2,3:882\n98#2:885\n11#2,3:886\n99#2:889\n11#2,3:890\n100#2:893\n11#2,3:894\n11#2,3:897\n11#2,3:900\n11#2,3:903\n11#2,3:906\n11#2,3:909\n11#2,3:912\n11#2,3:915\n11#2,3:918\n11#2,3:921\n11#2,3:924\n11#2,3:927\n11#2,3:930\n11#2,3:933\n11#2,3:936\n11#2,3:939\n11#2,3:942\n11#2,3:945\n11#2,3:948\n11#2,3:951\n11#2,3:954\n11#2,3:957\n11#2,3:960\n11#2,3:963\n11#2,3:966\n11#2,3:969\n11#2,3:972\n11#2,3:975\n11#2,3:978\n11#2,3:981\n11#2,3:984\n11#2,3:987\n11#2,3:990\n11#2,3:993\n136#2,7:996\n136#2,7:1003\n136#2,7:1010\n136#2,7:1017\n136#2,7:1024\n136#2,7:1031\n136#2,7:1038\n136#2,7:1045\n11#2,3:1052\n11#2,3:1055\n11#2,3:1058\n97#2:1061\n11#2,3:1062\n98#2:1065\n11#2,3:1066\n99#2:1069\n11#2,3:1070\n100#2:1073\n97#2:1074\n11#2,3:1075\n98#2:1078\n11#2,3:1079\n99#2:1082\n11#2,3:1083\n100#2:1086\n97#2:1087\n11#2,3:1088\n98#2:1091\n11#2,3:1092\n99#2:1095\n11#2,3:1096\n100#2:1099\n97#2:1100\n11#2,3:1101\n98#2:1104\n11#2,3:1105\n99#2:1108\n11#2,3:1109\n100#2:1112\n97#2:1113\n11#2,3:1114\n98#2:1117\n11#2,3:1118\n99#2:1121\n11#2,3:1122\n100#2:1125\n97#2:1126\n11#2,3:1127\n98#2:1130\n11#2,3:1131\n99#2:1134\n11#2,3:1135\n100#2:1138\n97#2:1139\n11#2,3:1140\n98#2:1143\n11#2,3:1144\n99#2:1147\n11#2,3:1148\n100#2:1151\n97#2:1152\n11#2,3:1153\n98#2:1156\n11#2,3:1157\n99#2:1160\n11#2,3:1161\n100#2:1164\n*S KotlinDebug\n*F\n+ 1 MonitorBasicProtocol.kt\nvet/inpulse/libcomm/core/protocol/MonitorBasicProtocol\n*L\n257#1:745\n258#1:746\n259#1:747\n341#1:748,3\n342#1:751,3\n406#1:754,7\n407#1:761,7\n408#1:768,7\n413#1:775\n413#1:776,3\n413#1:779\n413#1:780,3\n413#1:783\n413#1:784,3\n413#1:787\n414#1:788\n414#1:789,3\n414#1:792\n414#1:793,3\n414#1:796\n414#1:797,3\n414#1:800\n415#1:801\n415#1:802,3\n415#1:805\n415#1:806,3\n415#1:809\n415#1:810,3\n415#1:813\n431#1:814,7\n432#1:821,7\n433#1:828,7\n434#1:835,7\n441#1:842\n441#1:843,3\n441#1:846\n441#1:847,3\n441#1:850\n441#1:851,3\n441#1:854\n442#1:855\n442#1:856,3\n442#1:859\n442#1:860,3\n442#1:863\n442#1:864,3\n442#1:867\n443#1:868\n443#1:869,3\n443#1:872\n443#1:873,3\n443#1:876\n443#1:877,3\n443#1:880\n444#1:881\n444#1:882,3\n444#1:885\n444#1:886,3\n444#1:889\n444#1:890,3\n444#1:893\n471#1:894,3\n472#1:897,3\n473#1:900,3\n474#1:903,3\n475#1:906,3\n476#1:909,3\n477#1:912,3\n502#1:915,3\n503#1:918,3\n504#1:921,3\n505#1:924,3\n506#1:927,3\n596#1:930,3\n597#1:933,3\n598#1:936,3\n599#1:939,3\n600#1:942,3\n601#1:945,3\n602#1:948,3\n603#1:951,3\n604#1:954,3\n605#1:957,3\n606#1:960,3\n608#1:963,3\n609#1:966,3\n610#1:969,3\n611#1:972,3\n612#1:975,3\n613#1:978,3\n614#1:981,3\n615#1:984,3\n616#1:987,3\n617#1:990,3\n657#1:993,3\n675#1:996,7\n676#1:1003,7\n677#1:1010,7\n678#1:1017,7\n679#1:1024,7\n680#1:1031,7\n681#1:1038,7\n682#1:1045,7\n687#1:1052,3\n688#1:1055,3\n689#1:1058,3\n691#1:1061\n691#1:1062,3\n691#1:1065\n691#1:1066,3\n691#1:1069\n691#1:1070,3\n691#1:1073\n692#1:1074\n692#1:1075,3\n692#1:1078\n692#1:1079,3\n692#1:1082\n692#1:1083,3\n692#1:1086\n693#1:1087\n693#1:1088,3\n693#1:1091\n693#1:1092,3\n693#1:1095\n693#1:1096,3\n693#1:1099\n694#1:1100\n694#1:1101,3\n694#1:1104\n694#1:1105,3\n694#1:1108\n694#1:1109,3\n694#1:1112\n695#1:1113\n695#1:1114,3\n695#1:1117\n695#1:1118,3\n695#1:1121\n695#1:1122,3\n695#1:1125\n696#1:1126\n696#1:1127,3\n696#1:1130\n696#1:1131,3\n696#1:1134\n696#1:1135,3\n696#1:1138\n697#1:1139\n697#1:1140,3\n697#1:1143\n697#1:1144,3\n697#1:1147\n697#1:1148,3\n697#1:1151\n698#1:1152\n698#1:1153,3\n698#1:1156\n698#1:1157,3\n698#1:1160\n698#1:1161,3\n698#1:1164\n*E\n"})
public final class MonitorBasicProtocol
extends Protocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int nibpSamplesPerPacket;
    private final boolean supportsPpgDiagnosis;
    private final boolean supportsPpgCalibrationV2;
    private final boolean supportsPpgSampleV2;
    @NotNull
    private final LoggerInterface logger;
    @NotNull
    public static final String TAG = "MonitorBasicProtocol";

    public MonitorBasicProtocol(int nibpSamplesPerPacket, boolean supportsPpgDiagnosis, boolean supportsPpgCalibrationV2, boolean supportsPpgSampleV2) {
        this.nibpSamplesPerPacket = nibpSamplesPerPacket;
        this.supportsPpgDiagnosis = supportsPpgDiagnosis;
        this.supportsPpgCalibrationV2 = supportsPpgCalibrationV2;
        this.supportsPpgSampleV2 = supportsPpgSampleV2;
        this.logger = InPulseLoggerKt.getLibcommLogModule().getLogger(TAG);
    }

    public /* synthetic */ MonitorBasicProtocol(int n, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        if ((n2 & 8) != 0) {
            bl3 = true;
        }
        this(n, bl, bl2, bl3);
    }

    @NotNull
    public final LoggerInterface getLogger() {
        return this.logger;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void serialize(@NotNull Message message2, @NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int cmdByte = this.byteForType(message2.getType());
        if (cmdByte == 255) {
            this.throwUnsupportedMessageSerialization(message2, TAG);
            throw new KotlinNothingValueException();
        }
        sink.writeByte(cmdByte);
        Message message3 = message2;
        if (message3 instanceof Ack) {
            sink.writeByte(this.byteForType(((Ack)message2).getAckedMessage()));
            return;
        }
        if (message3 instanceof Nack) {
            sink.writeByte(this.byteForType(((Nack)message2).getNackedMessage()));
            return;
        }
        if (message3 instanceof MyInfo) {
            MyInfoSerializer.INSTANCE.serializePayload(sink, (MyInfo)message2);
            return;
        }
        if (message3 instanceof MyMac) {
            sink.writeUtf8(((MyMac)message2).getMacAddress().toString());
            return;
        }
        if (message3 instanceof BatteryInfoMessage) {
            BatteryInfoSerializer.INSTANCE.serializePayload(sink, (BatteryInfoMessage)message2);
            return;
        }
        if (message3 instanceof TempDataMessage) {
            int packetId = ((TempDataMessage)message2).getData().getSampleIdOfFirst() * ((TempDataMessage)message2).getData().getSamples().size();
            sink.writeIntLe(packetId);
            Iterator<TempModuleSample> iterator = ((TempDataMessage)message2).getData().getSamples().iterator();
            while (iterator.hasNext()) {
                TempModuleSample s = iterator.next();
                sink.writeShort((int)s.getRawTemp1());
                sink.writeShort((int)s.getRawTemp2());
            }
            return;
        }
        if (message3 instanceof EcgPpgData) {
            sink.writeIntLe(((EcgPpgData)message2).getPacketId());
            this.writeEcgSample(sink, ((EcgPpgData)message2).getEcgSample1());
            this.writeEcgSample(sink, ((EcgPpgData)message2).getEcgSample2());
            this.writePpgSample(sink, ((EcgPpgData)message2).getPpgSample());
            return;
        }
        if (message3 instanceof NibpDataMessage) {
            ModulePacket<NibpModuleSample> sample = ((NibpDataMessage)message2).getData();
            int packetId = sample.getSampleIdOfFirst() / sample.getSamples().size();
            sink.writeIntLe(packetId);
            int i = 0;
            int n = ((Collection)sample.getSamples()).size();
            while (i < n) {
                NibpModuleSample s = sample.getSamples().get(i);
                sink.writeIntLe(Float.floatToIntBits(s.getBloodPressure()));
                sink.writeByte((int)s.getStatus().getStatusValue());
                ++i;
            }
            return;
        }
        if (message3 instanceof StartNibp) {
            NibpMessageSerializer.Companion.writeStartNibp(sink, (StartNibp)message2);
            return;
        }
        if (message3 instanceof PpgSetParameters) {
            this.writePpgParameters(sink, ((PpgSetParameters)message2).getParams());
            return;
        }
        if (message3 instanceof PpgParameters) {
            this.writePpgParameters(sink, ((PpgParameters)message2).getParams());
            return;
        }
        if (message3 instanceof PpgDiagnosisMessage) {
            if (!this.supportsPpgDiagnosis) {
                this.throwUnsupportedMessageSerialization(message2, TAG);
                throw new KotlinNothingValueException();
            }
            PpgCommonSerializer.INSTANCE.writePpgDiagnosis(sink, ((PpgDiagnosisMessage)message2).getDiagnosis());
            return;
        }
        if (message3 instanceof PpgStartCalibration) {
            if (((PpgStartCalibration)message2).getParams() instanceof PpgCalibrationParameters.V1 && !this.supportsPpgCalibrationV2) {
                this.writePpgCalibrationParametersV1(sink, (PpgCalibrationParameters.V1)((PpgStartCalibration)message2).getParams());
                return;
            }
            if (((PpgStartCalibration)message2).getParams() instanceof PpgCalibrationParameters.V2 && this.supportsPpgCalibrationV2) {
                this.writePpgCalibrationParametersV2(sink, (PpgCalibrationParameters.V2)((PpgStartCalibration)message2).getParams());
                return;
            }
            this.throwUnsupportedMessageSerialization(message2, TAG);
            throw new KotlinNothingValueException();
        }
        if (message3 instanceof NibpCalibrationParameters) {
            NibpMessageSerializer.Companion.writeNibpCalibrationParameters(sink, ((NibpCalibrationParameters)message2).getCalibrationGain());
            return;
        }
        if (message3 instanceof SetNibpCalibrationParameters) {
            NibpMessageSerializer.Companion.writeSetNibpCalibrationParameters(sink, ((SetNibpCalibrationParameters)message2).getCalibrationGain());
            return;
        }
        if (message3 instanceof SetNibpCalibrationPressure) {
            NibpMessageSerializer.Companion.writeSetNibpCalibrationPressure(sink, ((SetNibpCalibrationPressure)message2).getPressure());
            return;
        }
        if (Intrinsics.areEqual((Object)message3, (Object)Connect.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)Disconnect.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)GetBatteryInfo.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)GetInfo.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)GetMac.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)PpgGetParameters.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)PpgGetDiagnosis.INSTANCE)) {
            if (this.supportsPpgDiagnosis) return;
            this.throwUnsupportedMessageSerialization(message2, TAG);
            throw new KotlinNothingValueException();
        }
        if (Intrinsics.areEqual((Object)message3, (Object)GoToBootloader.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)Ping.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)Pong.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)StartEcgPpg.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)StartTemp.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)StopAll.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)StopNibp.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)GetNibpCalibrationParameters.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)StartNibpCalibration.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)NibpProcedureStartedByDevice.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)NibpProcedureCanceledByDevice.INSTANCE)) return;
        if (Intrinsics.areEqual((Object)message3, (Object)NibpProcedurePeakFound.INSTANCE)) return;
        this.throwUnsupportedMessageSerialization(message2, TAG);
        throw new KotlinNothingValueException();
    }

    private final void writePpgParameters(BufferedSink sink, PpgState state) {
        if (this.supportsPpgCalibrationV2) {
            this.writePpgStateV2(sink, state);
        } else {
            this.writePpgStateV1(sink, state);
        }
    }

    @Override
    @NotNull
    public Object deserialize-IoAF18A(@NotNull BufferedSource source) {
        Message message2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        byte cmdByte = source.readByte();
        switch (WhenMappings.$EnumSwitchMapping$0[this.typeForByte(cmdByte).ordinal()]) {
            case 1: {
                byte acked = source.readByte();
                message2 = new Ack(this.typeForByte(acked));
                break;
            }
            case 2: {
                byte nacked = source.readByte();
                message2 = new Nack(this.typeForByte(nacked));
                break;
            }
            case 3: {
                message2 = Ping.INSTANCE;
                break;
            }
            case 4: {
                message2 = Pong.INSTANCE;
                break;
            }
            case 5: {
                message2 = Connect.INSTANCE;
                break;
            }
            case 6: {
                message2 = Disconnect.INSTANCE;
                break;
            }
            case 7: {
                message2 = GetInfo.INSTANCE;
                break;
            }
            case 8: {
                message2 = MyInfoSerializer.INSTANCE.deserializePayload(source);
                break;
            }
            case 9: {
                message2 = GetMac.INSTANCE;
                break;
            }
            case 10: {
                message2 = new MyMac(this.readMacAddressString(source));
                break;
            }
            case 11: {
                message2 = new SetMac(this.readMacAddressString(source));
                break;
            }
            case 12: {
                int packetId = source.readIntLe();
                short rawTemp1 = source.readShort();
                short rawTemp2 = source.readShort();
                TempModuleSample sample = new TempModuleSample(rawTemp1, rawTemp2);
                message2 = new TempDataMessage(new ModulePacket<TempModuleSample>(packetId, CollectionsKt.listOf((Object)sample), null));
                break;
            }
            case 13: {
                int packetId = source.readIntLe();
                int sampleIdOfFirst = packetId * this.nibpSamplesPerPacket;
                int sample = this.nibpSamplesPerPacket;
                ArrayList<NibpModuleSample> arrayList = new ArrayList<NibpModuleSample>(sample);
                int n = 0;
                while (n < sample) {
                    int n2;
                    int n3 = n2 = n++;
                    ArrayList<NibpModuleSample> arrayList2 = arrayList;
                    boolean bl = false;
                    float bloodPressure = Float.intBitsToFloat(source.readIntLe());
                    NibpStatus status = NibpStatus.Companion.withValue(source.readByte());
                    arrayList2.add(new NibpModuleSample(bloodPressure, status, null, null, null, 28, null));
                }
                List samples = arrayList;
                message2 = new NibpDataMessage(new ModulePacket<NibpModuleSample>(sampleIdOfFirst, samples, null));
                break;
            }
            case 14: {
                short maxPressure = source.readShortLe();
                short slope = source.readShortLe();
                byte finalCuffPressure = source.readByte();
                byte minimumCurrent = source.readByte();
                byte noCuffTime = source.readByte();
                BufferedSource $this$readFloat$iv = source;
                boolean $i$f$readFloat = false;
                float controlP = Float.intBitsToFloat($this$readFloat$iv.readIntLe());
                BufferedSource $this$readFloat$iv2 = source;
                boolean $i$f$readFloat2 = false;
                float controlI = Float.intBitsToFloat($this$readFloat$iv2.readIntLe());
                BufferedSource $this$readFloat$iv3 = source;
                boolean $i$f$readFloat3 = false;
                float controlD = Float.intBitsToFloat($this$readFloat$iv3.readIntLe());
                message2 = new StartNibp(maxPressure, slope, finalCuffPressure, minimumCurrent, noCuffTime, controlP, controlI, controlD);
                break;
            }
            case 15: {
                Object maxPressure = NibpMessageSerializer.Companion.readNibpCalibrationParameters-IoAF18A(source);
                ResultKt.throwOnFailure((Object)maxPressure);
                message2 = (Message)maxPressure;
                break;
            }
            case 16: {
                Object maxPressure = NibpMessageSerializer.Companion.readSetNibpCalibrationParameters-IoAF18A(source);
                ResultKt.throwOnFailure((Object)maxPressure);
                message2 = (Message)maxPressure;
                break;
            }
            case 17: {
                Object maxPressure = NibpMessageSerializer.Companion.readSetNibpCalibrationPressure-IoAF18A(source);
                ResultKt.throwOnFailure((Object)maxPressure);
                message2 = (Message)maxPressure;
                break;
            }
            case 18: {
                int packetId = source.readIntLe();
                MonitorEcgSample ecgSample1 = this.readEcgSample(source);
                MonitorEcgSample ecgSample2 = this.readEcgSample(source);
                MonitorPpgSample ppgSample = this.readPpgSample(source);
                message2 = new EcgPpgData(packetId, ecgSample1, ecgSample2, ppgSample);
                break;
            }
            case 19: {
                if (!this.supportsPpgDiagnosis) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)this.getUnsupportedMessageParsing(cmdByte, TAG)));
                }
                PpgDiagnosis diagnosis = this.readPpgDiagnosis(source);
                message2 = new PpgDiagnosisMessage(diagnosis);
                break;
            }
            case 20: {
                PpgState params = this.readPpgState(source);
                message2 = new PpgSetParameters(params);
                break;
            }
            case 21: {
                PpgState params = this.readPpgState(source);
                message2 = new PpgParameters(params);
                break;
            }
            case 22: {
                PpgCalibrationParameters params = this.supportsPpgCalibrationV2 ? (PpgCalibrationParameters)this.readPpgCalibrationParametersV2(source) : (PpgCalibrationParameters)this.readPpgCalibrationParametersV1(source);
                message2 = new PpgStartCalibration(params);
                break;
            }
            case 23: {
                message2 = this.deserializeBatteryInfo(source);
                break;
            }
            case 24: {
                message2 = StartEcgPpg.INSTANCE;
                break;
            }
            case 25: {
                message2 = StartTemp.INSTANCE;
                break;
            }
            case 26: {
                message2 = StopAll.INSTANCE;
                break;
            }
            case 27: {
                message2 = StopNibp.INSTANCE;
                break;
            }
            case 28: {
                message2 = StartNibpCalibration.INSTANCE;
                break;
            }
            case 29: {
                message2 = GetNibpCalibrationParameters.INSTANCE;
                break;
            }
            case 30: {
                message2 = NibpProcedurePeakFound.INSTANCE;
                break;
            }
            case 31: {
                message2 = NibpProcedureStartedByDevice.INSTANCE;
                break;
            }
            case 32: {
                message2 = NibpProcedureCanceledByDevice.INSTANCE;
                break;
            }
            case 33: {
                message2 = PpgGetParameters.INSTANCE;
                break;
            }
            case 34: {
                if (!this.supportsPpgDiagnosis) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)this.getUnsupportedMessageParsing(cmdByte, TAG)));
                }
                message2 = PpgGetDiagnosis.INSTANCE;
                break;
            }
            case 35: {
                message2 = GetBatteryInfo.INSTANCE;
                break;
            }
            case 36: {
                message2 = GoToBootloader.INSTANCE;
                break;
            }
            default: {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)this.getUnsupportedMessageParsing(cmdByte, TAG)));
            }
        }
        Message message3 = message2;
        return Result.constructor-impl((Object)message3);
    }

    private final PpgDiagnosis readPpgDiagnosis(BufferedSource $this$readPpgDiagnosis) {
        BufferedSource $this$readByteAsInt$iv = $this$readPpgDiagnosis;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int b1 = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = $this$readPpgDiagnosis;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int b2 = $this$asInt$iv$iv2 & 0xFF;
        return new PpgDiagnosis((b1 & 0x10) > 0, (b1 & 8) > 0, (b1 & 4) > 0, (b1 & 2) > 0, (b1 & 1) > 0, (b2 & 0x80) > 0, (b2 & 0x40) > 0, (b2 & 0x20) > 0, (b2 & 0x10) > 0, (b2 & 8) > 0, (b2 & 4) > 0, (b2 & 2) > 0, (b2 & 1) > 0);
    }

    private final PpgState readPpgState(BufferedSource source) {
        return this.supportsPpgSampleV2 ? this.readPpgStateV2(source) : this.readPpgStateV1(source);
    }

    @Override
    @NotNull
    public Byte mapMessageTypeToByte(@NotNull MessageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return (byte)(switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> 0;
            case 2 -> 1;
            case 3 -> 4;
            case 4 -> 5;
            case 5 -> 16;
            case 6 -> 17;
            case 7 -> 21;
            case 8 -> 22;
            case 24 -> 32;
            case 14 -> 33;
            case 25 -> 34;
            case 27 -> 37;
            case 32 -> 38;
            case 26 -> 39;
            case 31 -> 40;
            case 30 -> 41;
            case 28 -> 42;
            case 17 -> 43;
            case 16 -> 44;
            case 29 -> 45;
            case 15 -> 46;
            case 9 -> 48;
            case 10 -> 49;
            case 23 -> 50;
            case 18 -> 64;
            case 13 -> 65;
            case 12 -> 66;
            case 33 -> 80;
            case 20 -> 81;
            case 21 -> 82;
            case 22 -> 83;
            case 34 -> 87;
            case 19 -> 88;
            case 36 -> 137;
            default -> 255;
        });
    }

    private final void writeEcgSample(BufferedSink $this$writeEcgSample, MonitorEcgSample sample) {
        BufferedSink $this$write24BitInt$iv;
        $this$writeEcgSample.writeByte((int)sample.getLeadOff());
        BufferedSink bufferedSink = $this$writeEcgSample;
        int i$iv = sample.getLead1();
        boolean $i$f$write24BitInt = false;
        int a$iv = (i$iv & 0xFF0000) >> 16;
        int b$iv = (i$iv & 0xFF00) >> 8;
        int c$iv = i$iv & 0xFF;
        $this$write24BitInt$iv.writeByte(a$iv);
        $this$write24BitInt$iv.writeByte(b$iv);
        $this$write24BitInt$iv.writeByte(c$iv);
        $this$write24BitInt$iv = $this$writeEcgSample;
        i$iv = sample.getLead2();
        $i$f$write24BitInt = false;
        a$iv = (i$iv & 0xFF0000) >> 16;
        b$iv = (i$iv & 0xFF00) >> 8;
        c$iv = i$iv & 0xFF;
        $this$write24BitInt$iv.writeByte(a$iv);
        $this$write24BitInt$iv.writeByte(b$iv);
        $this$write24BitInt$iv.writeByte(c$iv);
        $this$write24BitInt$iv = $this$writeEcgSample;
        i$iv = sample.getLead3();
        $i$f$write24BitInt = false;
        a$iv = (i$iv & 0xFF0000) >> 16;
        b$iv = (i$iv & 0xFF00) >> 8;
        c$iv = i$iv & 0xFF;
        $this$write24BitInt$iv.writeByte(a$iv);
        $this$write24BitInt$iv.writeByte(b$iv);
        $this$write24BitInt$iv.writeByte(c$iv);
    }

    private final MonitorEcgSample readEcgSample(BufferedSource $this$readEcgSample) {
        byte leadOff = $this$readEcgSample.readByte();
        BufferedSource $this$read24BitUInt$iv = $this$readEcgSample;
        boolean $i$f$read24BitUInt = false;
        BufferedSource $this$readByteAsInt$iv$iv = $this$read24BitUInt$iv;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv$iv = $this$readByteAsInt$iv$iv.readByte();
        boolean $i$f$asInt = false;
        int b2$iv = $this$asInt$iv$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv2 = $this$read24BitUInt$iv;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv$iv2 = $this$readByteAsInt$iv$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int b1$iv = $this$asInt$iv$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv3 = $this$read24BitUInt$iv;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int b0$iv = $this$asInt$iv$iv$iv3 & 0xFF;
        int lead1 = b2$iv << 16 | b1$iv << 8 | b0$iv;
        BufferedSource $this$read24BitUInt$iv2 = $this$readEcgSample;
        boolean $i$f$read24BitUInt2 = false;
        $this$readByteAsInt$iv$iv = $this$read24BitUInt$iv2;
        $i$f$readByteAsInt = false;
        $this$asInt$iv$iv$iv2 = $this$readByteAsInt$iv$iv.readByte();
        boolean $i$f$asInt4 = false;
        int b2$iv2 = $this$asInt$iv$iv$iv2 & 0xFF;
        $this$readByteAsInt$iv$iv = $this$read24BitUInt$iv2;
        $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv$iv4 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt3 = false;
        int b1$iv2 = $this$asInt$iv$iv$iv4 & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv4 = $this$read24BitUInt$iv2;
        boolean $i$f$readByteAsInt4 = false;
        byte $this$asInt$iv$iv$iv5 = $this$readByteAsInt$iv$iv4.readByte();
        boolean $i$f$asInt5 = false;
        int b0$iv2 = $this$asInt$iv$iv$iv5 & 0xFF;
        int lead2 = b2$iv2 << 16 | b1$iv2 << 8 | b0$iv2;
        BufferedSource $this$read24BitUInt$iv3 = $this$readEcgSample;
        boolean $i$f$read24BitUInt3 = false;
        $this$readByteAsInt$iv$iv = $this$read24BitUInt$iv3;
        $i$f$readByteAsInt = false;
        $this$asInt$iv$iv$iv4 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt2 = false;
        int b2$iv3 = $this$asInt$iv$iv$iv4 & 0xFF;
        $this$readByteAsInt$iv$iv = $this$read24BitUInt$iv3;
        $i$f$readByteAsInt4 = false;
        $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt5 = false;
        int b1$iv3 = $this$asInt$iv$iv$iv3 & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv5 = $this$read24BitUInt$iv3;
        boolean $i$f$readByteAsInt5 = false;
        byte $this$asInt$iv$iv$iv6 = $this$readByteAsInt$iv$iv5.readByte();
        boolean $i$f$asInt6 = false;
        int b0$iv3 = $this$asInt$iv$iv$iv6 & 0xFF;
        int lead3 = b2$iv3 << 16 | b1$iv3 << 8 | b0$iv3;
        return new MonitorEcgSample(leadOff, lead1, lead2, lead3);
    }

    private final void writePpgSample(BufferedSink $this$writePpgSample, MonitorPpgSample sample) {
        MonitorPpgSample monitorPpgSample = sample;
        if (monitorPpgSample instanceof MonitorPpgSample.V1) {
            $this$writePpgSample.writeIntLe(((MonitorPpgSample.V1)sample).getRed());
            $this$writePpgSample.writeIntLe(((MonitorPpgSample.V1)sample).getInfraRed());
            $this$writePpgSample.writeByte((int)((MonitorPpgSample.V1)sample).getStatus().getByte());
            PpgState state = ((MonitorPpgSample.V1)sample).getState();
            if (state != null) {
                this.writePpgStateV1($this$writePpgSample, state);
            }
        } else if (monitorPpgSample instanceof MonitorPpgSample.V2) {
            BufferedSink $this$write22BitInt$iv;
            BufferedSink state = $this$writePpgSample;
            int value$iv = ((MonitorPpgSample.V2)sample).getRed();
            boolean $i$f$write22BitInt = false;
            int b0$iv = value$iv & 0xFF;
            int b1$iv = value$iv >> 8 & 0xFF;
            int b2$iv = value$iv >> 16 & 0x3F;
            $this$write22BitInt$iv.writeByte(b2$iv);
            $this$write22BitInt$iv.writeByte(b1$iv);
            $this$write22BitInt$iv.writeByte(b0$iv);
            $this$write22BitInt$iv = $this$writePpgSample;
            value$iv = ((MonitorPpgSample.V2)sample).getInfraRed();
            $i$f$write22BitInt = false;
            b0$iv = value$iv & 0xFF;
            b1$iv = value$iv >> 8 & 0xFF;
            b2$iv = value$iv >> 16 & 0x3F;
            $this$write22BitInt$iv.writeByte(b2$iv);
            $this$write22BitInt$iv.writeByte(b1$iv);
            $this$write22BitInt$iv.writeByte(b0$iv);
            $this$write22BitInt$iv = $this$writePpgSample;
            value$iv = ((MonitorPpgSample.V2)sample).getRedLight();
            $i$f$write22BitInt = false;
            b0$iv = value$iv & 0xFF;
            b1$iv = value$iv >> 8 & 0xFF;
            b2$iv = value$iv >> 16 & 0x3F;
            $this$write22BitInt$iv.writeByte(b2$iv);
            $this$write22BitInt$iv.writeByte(b1$iv);
            $this$write22BitInt$iv.writeByte(b0$iv);
            $this$write22BitInt$iv = $this$writePpgSample;
            value$iv = ((MonitorPpgSample.V2)sample).getInfraRedLight();
            $i$f$write22BitInt = false;
            b0$iv = value$iv & 0xFF;
            b1$iv = value$iv >> 8 & 0xFF;
            b2$iv = value$iv >> 16 & 0x3F;
            $this$write22BitInt$iv.writeByte(b2$iv);
            $this$write22BitInt$iv.writeByte(b1$iv);
            $this$write22BitInt$iv.writeByte(b0$iv);
            this.writePpgStateV2($this$writePpgSample, ((MonitorPpgSample.V2)sample).getState());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final MonitorPpgSample readPpgSample(BufferedSource $this$readPpgSample) {
        MonitorPpgSample monitorPpgSample;
        if (this.supportsPpgSampleV2) {
            BufferedSource $this$read22BitInt$iv = $this$readPpgSample;
            boolean $i$f$read22BitInt = false;
            BufferedSource $this$readByteAsInt$iv$iv = $this$read22BitInt$iv;
            boolean $i$f$readByteAsInt = false;
            byte $this$asInt$iv$iv$iv = $this$readByteAsInt$iv$iv.readByte();
            boolean $i$f$asInt = false;
            int b2$iv = $this$asInt$iv$iv$iv & 0xFF;
            BufferedSource $this$readByteAsInt$iv$iv2 = $this$read22BitInt$iv;
            boolean $i$f$readByteAsInt2 = false;
            byte $this$asInt$iv$iv$iv2 = $this$readByteAsInt$iv$iv2.readByte();
            boolean $i$f$asInt2 = false;
            int b1$iv = $this$asInt$iv$iv$iv2 & 0xFF;
            BufferedSource $this$readByteAsInt$iv$iv3 = $this$read22BitInt$iv;
            boolean $i$f$readByteAsInt3 = false;
            byte $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv3.readByte();
            boolean $i$f$asInt3 = false;
            int b0$iv = $this$asInt$iv$iv$iv3 & 0xFF;
            int red = (b2$iv << 26 | b1$iv << 18 | b0$iv << 10) >> 10;
            BufferedSource $this$read22BitInt$iv2 = $this$readPpgSample;
            boolean $i$f$read22BitInt2 = false;
            $this$readByteAsInt$iv$iv = $this$read22BitInt$iv2;
            $i$f$readByteAsInt = false;
            $this$asInt$iv$iv$iv2 = $this$readByteAsInt$iv$iv.readByte();
            boolean $i$f$asInt4 = false;
            int b2$iv2 = $this$asInt$iv$iv$iv2 & 0xFF;
            $this$readByteAsInt$iv$iv = $this$read22BitInt$iv2;
            $i$f$readByteAsInt3 = false;
            byte $this$asInt$iv$iv$iv4 = $this$readByteAsInt$iv$iv.readByte();
            $i$f$asInt3 = false;
            int b1$iv2 = $this$asInt$iv$iv$iv4 & 0xFF;
            BufferedSource $this$readByteAsInt$iv$iv4 = $this$read22BitInt$iv2;
            boolean $i$f$readByteAsInt4 = false;
            byte $this$asInt$iv$iv$iv5 = $this$readByteAsInt$iv$iv4.readByte();
            boolean $i$f$asInt5 = false;
            int b0$iv2 = $this$asInt$iv$iv$iv5 & 0xFF;
            int infraRed = (b2$iv2 << 26 | b1$iv2 << 18 | b0$iv2 << 10) >> 10;
            BufferedSource $this$read22BitInt$iv3 = $this$readPpgSample;
            boolean $i$f$read22BitInt3 = false;
            $this$readByteAsInt$iv$iv = $this$read22BitInt$iv3;
            $i$f$readByteAsInt = false;
            $this$asInt$iv$iv$iv4 = $this$readByteAsInt$iv$iv.readByte();
            $i$f$asInt2 = false;
            int b2$iv3 = $this$asInt$iv$iv$iv4 & 0xFF;
            $this$readByteAsInt$iv$iv = $this$read22BitInt$iv3;
            $i$f$readByteAsInt4 = false;
            $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv.readByte();
            $i$f$asInt5 = false;
            int b1$iv3 = $this$asInt$iv$iv$iv3 & 0xFF;
            BufferedSource $this$readByteAsInt$iv$iv5 = $this$read22BitInt$iv3;
            boolean $i$f$readByteAsInt5 = false;
            byte $this$asInt$iv$iv$iv6 = $this$readByteAsInt$iv$iv5.readByte();
            boolean $i$f$asInt6 = false;
            int b0$iv3 = $this$asInt$iv$iv$iv6 & 0xFF;
            int redLight = (b2$iv3 << 26 | b1$iv3 << 18 | b0$iv3 << 10) >> 10;
            BufferedSource $this$read22BitInt$iv4 = $this$readPpgSample;
            boolean $i$f$read22BitInt4 = false;
            $this$readByteAsInt$iv$iv = $this$read22BitInt$iv4;
            $i$f$readByteAsInt = false;
            $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv.readByte();
            $i$f$asInt3 = false;
            int b2$iv4 = $this$asInt$iv$iv$iv3 & 0xFF;
            $this$readByteAsInt$iv$iv = $this$read22BitInt$iv4;
            $i$f$readByteAsInt5 = false;
            $this$asInt$iv$iv$iv5 = $this$readByteAsInt$iv$iv.readByte();
            $i$f$asInt6 = false;
            int b1$iv4 = $this$asInt$iv$iv$iv5 & 0xFF;
            BufferedSource $this$readByteAsInt$iv$iv6 = $this$read22BitInt$iv4;
            boolean $i$f$readByteAsInt6 = false;
            byte $this$asInt$iv$iv$iv7 = $this$readByteAsInt$iv$iv6.readByte();
            boolean $i$f$asInt7 = false;
            int b0$iv4 = $this$asInt$iv$iv$iv7 & 0xFF;
            int infraRedLight = (b2$iv4 << 26 | b1$iv4 << 18 | b0$iv4 << 10) >> 10;
            PpgState ppgState = this.readPpgStateV2($this$readPpgSample);
            monitorPpgSample = new MonitorPpgSample.V2(red, infraRed, redLight, infraRedLight, ppgState);
        } else {
            int red = $this$readPpgSample.readIntLe();
            int infraRed = $this$readPpgSample.readIntLe();
            byte status = $this$readPpgSample.readByte();
            PpgState state = $this$readPpgSample.request(7L) ? this.readPpgStateV1($this$readPpgSample) : null;
            monitorPpgSample = new MonitorPpgSample.V1(PpgSampleStatus.Companion.fromByte(status), red, infraRed, state);
        }
        return monitorPpgSample;
    }

    private final void writePpgStateV1(BufferedSink $this$writePpgStateV1, PpgState state) {
        $this$writePpgStateV1.writeByte(state.getGainRed1());
        $this$writePpgStateV1.writeByte(state.getGainRed2());
        $this$writePpgStateV1.writeByte(state.getLedRed());
        $this$writePpgStateV1.writeByte(state.getGainIR1());
        $this$writePpgStateV1.writeByte(state.getGainIR2());
        $this$writePpgStateV1.writeByte(state.getLedIR());
        $this$writePpgStateV1.writeByte(state.getAmbdac());
    }

    private final PpgState readPpgStateV1(BufferedSource $this$readPpgStateV1) {
        BufferedSource $this$readByteAsInt$iv = $this$readPpgStateV1;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int gainRed1 = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = $this$readPpgStateV1;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int gainRed2 = $this$asInt$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv3 = $this$readPpgStateV1;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv3 = $this$readByteAsInt$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int ledRed = $this$asInt$iv$iv3 & 0xFF;
        BufferedSource $this$readByteAsInt$iv4 = $this$readPpgStateV1;
        boolean $i$f$readByteAsInt4 = false;
        byte $this$asInt$iv$iv4 = $this$readByteAsInt$iv4.readByte();
        boolean $i$f$asInt4 = false;
        int gainIr1 = $this$asInt$iv$iv4 & 0xFF;
        BufferedSource $this$readByteAsInt$iv5 = $this$readPpgStateV1;
        boolean $i$f$readByteAsInt5 = false;
        byte $this$asInt$iv$iv5 = $this$readByteAsInt$iv5.readByte();
        boolean $i$f$asInt5 = false;
        int gainIr2 = $this$asInt$iv$iv5 & 0xFF;
        BufferedSource $this$readByteAsInt$iv6 = $this$readPpgStateV1;
        boolean $i$f$readByteAsInt6 = false;
        byte $this$asInt$iv$iv6 = $this$readByteAsInt$iv6.readByte();
        boolean $i$f$asInt6 = false;
        int ledIr = $this$asInt$iv$iv6 & 0xFF;
        BufferedSource $this$readByteAsInt$iv7 = $this$readPpgStateV1;
        boolean $i$f$readByteAsInt7 = false;
        byte $this$asInt$iv$iv7 = $this$readByteAsInt$iv7.readByte();
        boolean $i$f$asInt7 = false;
        int ambdac = $this$asInt$iv$iv7 & 0xFF;
        return new PpgState(gainRed1, gainRed2, ledRed, gainIr1, gainIr2, ledIr, ambdac, PpgSampleStatus.NONE);
    }

    private final void writePpgStateV2(BufferedSink $this$writePpgStateV2, PpgState state) {
        int b0 = this.assembleBitField((byte)state.getGainRed1(), (byte)state.getGainRed2(), (byte)15);
        int b1 = this.assembleBitField((byte)state.getGainIR1(), (byte)state.getGainIR1(), (byte)15);
        int b4 = this.assembleBitField(state.getStatus().getByte(), (byte)state.getAmbdac(), (byte)15);
        $this$writePpgStateV2.writeByte(b0);
        $this$writePpgStateV2.writeByte(b1);
        $this$writePpgStateV2.writeByte(state.getLedRed());
        $this$writePpgStateV2.writeByte(state.getLedIR());
        $this$writePpgStateV2.writeByte(b4);
    }

    private final PpgState readPpgStateV2(BufferedSource $this$readPpgStateV2) {
        BufferedSource $this$readByteAsInt$iv = $this$readPpgStateV2;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int b0 = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = $this$readPpgStateV2;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int b1 = $this$asInt$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv3 = $this$readPpgStateV2;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv3 = $this$readByteAsInt$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int ledRed = $this$asInt$iv$iv3 & 0xFF;
        BufferedSource $this$readByteAsInt$iv4 = $this$readPpgStateV2;
        boolean $i$f$readByteAsInt4 = false;
        byte $this$asInt$iv$iv4 = $this$readByteAsInt$iv4.readByte();
        boolean $i$f$asInt4 = false;
        int ledIr = $this$asInt$iv$iv4 & 0xFF;
        BufferedSource $this$readByteAsInt$iv5 = $this$readPpgStateV2;
        boolean $i$f$readByteAsInt5 = false;
        byte $this$asInt$iv$iv5 = $this$readByteAsInt$iv5.readByte();
        boolean $i$f$asInt5 = false;
        int b4 = $this$asInt$iv$iv5 & 0xFF;
        int gainRed1 = (b0 & 0xF0) >> 4;
        int gainRed2 = b0 & 0xF;
        int gainIr1 = (b1 & 0xF0) >> 4;
        int gainIr2 = b1 & 0xF;
        byte statusRaw = (byte)((b4 & 0xF0) >> 4);
        int ambdac = b4 & 0xF;
        PpgSampleStatus status = PpgSampleStatus.Companion.fromByte(statusRaw);
        return new PpgState(gainRed1, gainRed2, ledRed, gainIr1, gainIr2, ledIr, ambdac, status);
    }

    private final int assembleBitField(byte upper, byte lower, byte maskLower) {
        byte maskUpper = ~maskLower;
        int shift = Integer.numberOfTrailingZeros(maskUpper | 0x100);
        int resultUpper = (byte)(upper & maskUpper) << shift;
        byte resultLower = (byte)(lower & maskLower);
        return resultUpper & resultLower;
    }

    private final void writePpgCalibrationParametersV1(BufferedSink $this$writePpgCalibrationParametersV1, PpgCalibrationParameters.V1 params) {
        int coercedMinGain1Red = RangesKt.coerceIn((int)params.getMinGain1Red(), (int)1, (int)7);
        int coercedMaxGain1Red = RangesKt.coerceIn((int)params.getMaxGain1Red(), (int)coercedMinGain1Red, (int)7);
        int coercedMinGain2Red = RangesKt.coerceIn((int)params.getMinGain2Red(), (int)0, (int)4);
        int coercedMaxGain2Red = RangesKt.coerceIn((int)params.getMaxGain2Red(), (int)coercedMinGain2Red, (int)4);
        int coercedMinGain1Infrared = RangesKt.coerceIn((int)params.getMinGain1Infrared(), (int)1, (int)7);
        int coercedMaxGain1Infrared = RangesKt.coerceIn((int)params.getMaxGain1Infrared(), (int)coercedMinGain1Infrared, (int)7);
        int coercedMinGain2Infrared = RangesKt.coerceIn((int)params.getMinGain2Infrared(), (int)0, (int)4);
        int coercedMaxGain2Infrared = RangesKt.coerceIn((int)params.getMaxGain2Infrared(), (int)coercedMinGain2Infrared, (int)4);
        int coercedMinAmbdac = RangesKt.coerceIn((int)params.getMinAmbdac(), (int)0, (int)10);
        int coercedMaxAmbdac = RangesKt.coerceIn((int)params.getMaxAmbdac(), (int)coercedMinAmbdac, (int)10);
        int maxBright = params.getMaxBright();
        PpgState initial = params.getInitialCalibrationState();
        int gainRed1 = RangesKt.coerceIn((int)initial.getGainRed1(), (int)coercedMinGain1Red, (int)coercedMaxGain1Red);
        int gainRed2 = RangesKt.coerceIn((int)initial.getGainRed2(), (int)coercedMinGain2Red, (int)coercedMaxGain2Red);
        int ledRed = RangesKt.coerceIn((int)initial.getLedRed(), (int)0, (int)maxBright);
        int gainIR1 = RangesKt.coerceIn((int)initial.getGainIR1(), (int)coercedMinGain1Infrared, (int)coercedMaxGain1Infrared);
        int gainIR2 = RangesKt.coerceIn((int)initial.getGainIR2(), (int)coercedMinGain2Infrared, (int)coercedMaxGain2Infrared);
        int ledIr = RangesKt.coerceIn((int)initial.getLedIR(), (int)0, (int)maxBright);
        int ambdac = RangesKt.coerceIn((int)initial.getAmbdac(), (int)coercedMinAmbdac, (int)coercedMaxAmbdac);
        $this$writePpgCalibrationParametersV1.writeByte(gainRed1);
        $this$writePpgCalibrationParametersV1.writeByte(gainRed2);
        $this$writePpgCalibrationParametersV1.writeByte(ledRed);
        $this$writePpgCalibrationParametersV1.writeByte(gainIR1);
        $this$writePpgCalibrationParametersV1.writeByte(gainIR2);
        $this$writePpgCalibrationParametersV1.writeByte(ledIr);
        $this$writePpgCalibrationParametersV1.writeByte(ambdac);
        $this$writePpgCalibrationParametersV1.writeByte(params.getSaturationPositive());
        $this$writePpgCalibrationParametersV1.writeByte(params.getSaturationNegative());
        $this$writePpgCalibrationParametersV1.writeByte(params.getOperationRangePositive());
        $this$writePpgCalibrationParametersV1.writeByte(params.getOperationRangeNegative());
        $this$writePpgCalibrationParametersV1.writeByte(params.getLeadoffThresholdPositive());
        $this$writePpgCalibrationParametersV1.writeByte(params.getLeadoffThresholdNegative());
        $this$writePpgCalibrationParametersV1.writeByte(params.getControlWindow());
        $this$writePpgCalibrationParametersV1.writeByte(params.getControlWindowActive());
        $this$writePpgCalibrationParametersV1.writeByte(params.getMaxBright());
        $this$writePpgCalibrationParametersV1.writeByte(params.getMinBright());
        $this$writePpgCalibrationParametersV1.writeByte(params.getStepBright());
        $this$writePpgCalibrationParametersV1.writeByte(coercedMinGain1Red);
        $this$writePpgCalibrationParametersV1.writeByte(coercedMaxGain1Red);
        $this$writePpgCalibrationParametersV1.writeByte(coercedMinGain2Red);
        $this$writePpgCalibrationParametersV1.writeByte(coercedMaxGain2Red);
        $this$writePpgCalibrationParametersV1.writeByte(coercedMinGain1Infrared);
        $this$writePpgCalibrationParametersV1.writeByte(coercedMaxGain1Infrared);
        $this$writePpgCalibrationParametersV1.writeByte(coercedMinGain2Infrared);
        $this$writePpgCalibrationParametersV1.writeByte(coercedMaxGain2Infrared);
        $this$writePpgCalibrationParametersV1.writeByte(coercedMinAmbdac);
        $this$writePpgCalibrationParametersV1.writeByte(coercedMaxAmbdac);
    }

    private final PpgCalibrationParameters.V1 readPpgCalibrationParametersV1(BufferedSource $this$readPpgCalibrationParametersV1) {
        PpgState initialState = this.readPpgStateV1($this$readPpgCalibrationParametersV1);
        BufferedSource $this$readByteAsInt$iv = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int saturationPositive = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int saturationNegative = $this$asInt$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv3 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv3 = $this$readByteAsInt$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int operationRangePositive = $this$asInt$iv$iv3 & 0xFF;
        BufferedSource $this$readByteAsInt$iv4 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt4 = false;
        byte $this$asInt$iv$iv4 = $this$readByteAsInt$iv4.readByte();
        boolean $i$f$asInt4 = false;
        int operationRangeNegative = $this$asInt$iv$iv4 & 0xFF;
        BufferedSource $this$readByteAsInt$iv5 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt5 = false;
        byte $this$asInt$iv$iv5 = $this$readByteAsInt$iv5.readByte();
        boolean $i$f$asInt5 = false;
        int leadOffThresholdPositive = $this$asInt$iv$iv5 & 0xFF;
        BufferedSource $this$readByteAsInt$iv6 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt6 = false;
        byte $this$asInt$iv$iv6 = $this$readByteAsInt$iv6.readByte();
        boolean $i$f$asInt6 = false;
        int leadOffThresholdNegative = $this$asInt$iv$iv6 & 0xFF;
        BufferedSource $this$readByteAsInt$iv7 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt7 = false;
        byte $this$asInt$iv$iv7 = $this$readByteAsInt$iv7.readByte();
        boolean $i$f$asInt7 = false;
        int controlWindow = $this$asInt$iv$iv7 & 0xFF;
        BufferedSource $this$readByteAsInt$iv8 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt8 = false;
        byte $this$asInt$iv$iv8 = $this$readByteAsInt$iv8.readByte();
        boolean $i$f$asInt8 = false;
        int controlWindowActive = $this$asInt$iv$iv8 & 0xFF;
        BufferedSource $this$readByteAsInt$iv9 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt9 = false;
        byte $this$asInt$iv$iv9 = $this$readByteAsInt$iv9.readByte();
        boolean $i$f$asInt9 = false;
        int maxBright = $this$asInt$iv$iv9 & 0xFF;
        BufferedSource $this$readByteAsInt$iv10 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt10 = false;
        byte $this$asInt$iv$iv10 = $this$readByteAsInt$iv10.readByte();
        boolean $i$f$asInt10 = false;
        int minBright = $this$asInt$iv$iv10 & 0xFF;
        BufferedSource $this$readByteAsInt$iv11 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt11 = false;
        byte $this$asInt$iv$iv11 = $this$readByteAsInt$iv11.readByte();
        boolean $i$f$asInt11 = false;
        int stepBright = $this$asInt$iv$iv11 & 0xFF;
        BufferedSource $this$readByteAsInt$iv12 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt12 = false;
        byte $this$asInt$iv$iv12 = $this$readByteAsInt$iv12.readByte();
        boolean $i$f$asInt12 = false;
        int minGain1Red = $this$asInt$iv$iv12 & 0xFF;
        BufferedSource $this$readByteAsInt$iv13 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt13 = false;
        byte $this$asInt$iv$iv13 = $this$readByteAsInt$iv13.readByte();
        boolean $i$f$asInt13 = false;
        int maxGain1Red = $this$asInt$iv$iv13 & 0xFF;
        BufferedSource $this$readByteAsInt$iv14 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt14 = false;
        byte $this$asInt$iv$iv14 = $this$readByteAsInt$iv14.readByte();
        boolean $i$f$asInt14 = false;
        int minGain2Red = $this$asInt$iv$iv14 & 0xFF;
        BufferedSource $this$readByteAsInt$iv15 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt15 = false;
        byte $this$asInt$iv$iv15 = $this$readByteAsInt$iv15.readByte();
        boolean $i$f$asInt15 = false;
        int maxGain2Red = $this$asInt$iv$iv15 & 0xFF;
        BufferedSource $this$readByteAsInt$iv16 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt16 = false;
        byte $this$asInt$iv$iv16 = $this$readByteAsInt$iv16.readByte();
        boolean $i$f$asInt16 = false;
        int minGain1Infrared = $this$asInt$iv$iv16 & 0xFF;
        BufferedSource $this$readByteAsInt$iv17 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt17 = false;
        byte $this$asInt$iv$iv17 = $this$readByteAsInt$iv17.readByte();
        boolean $i$f$asInt17 = false;
        int maxGain1Infrared = $this$asInt$iv$iv17 & 0xFF;
        BufferedSource $this$readByteAsInt$iv18 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt18 = false;
        byte $this$asInt$iv$iv18 = $this$readByteAsInt$iv18.readByte();
        boolean $i$f$asInt18 = false;
        int minGain2Infrared = $this$asInt$iv$iv18 & 0xFF;
        BufferedSource $this$readByteAsInt$iv19 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt19 = false;
        byte $this$asInt$iv$iv19 = $this$readByteAsInt$iv19.readByte();
        boolean $i$f$asInt19 = false;
        int maxGain2Infrared = $this$asInt$iv$iv19 & 0xFF;
        BufferedSource $this$readByteAsInt$iv20 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt20 = false;
        byte $this$asInt$iv$iv20 = $this$readByteAsInt$iv20.readByte();
        boolean $i$f$asInt20 = false;
        int minAmbdac = $this$asInt$iv$iv20 & 0xFF;
        BufferedSource $this$readByteAsInt$iv21 = $this$readPpgCalibrationParametersV1;
        boolean $i$f$readByteAsInt21 = false;
        byte $this$asInt$iv$iv21 = $this$readByteAsInt$iv21.readByte();
        boolean $i$f$asInt21 = false;
        int maxAmbdac = $this$asInt$iv$iv21 & 0xFF;
        return new PpgCalibrationParameters.V1(initialState, saturationPositive, saturationNegative, operationRangePositive, operationRangeNegative, leadOffThresholdPositive, leadOffThresholdNegative, controlWindow, controlWindowActive, maxBright, minBright, stepBright, minGain1Red, maxGain1Red, minGain2Red, maxGain2Red, minGain1Infrared, maxGain1Infrared, minGain2Infrared, maxGain2Infrared, minAmbdac, maxAmbdac);
    }

    private final void writePpgCalibrationParametersV2(BufferedSink $this$writePpgCalibrationParametersV2, PpgCalibrationParameters.V2 params) {
        this.writePpgStateV2($this$writePpgCalibrationParametersV2, params.getLeadOffEvaluationState());
        this.writePpgStateV2($this$writePpgCalibrationParametersV2, params.getInitialCalibrationState());
        $this$writePpgCalibrationParametersV2.writeByte(params.getControlWindow());
        for (PpgCalibrationParameters.ControlPhaseConfig c : params.getControlPhaseConfigOrder()) {
            this.writePpgControlPhaseConfig($this$writePpgCalibrationParametersV2, c);
        }
    }

    private final PpgCalibrationParameters.V2 readPpgCalibrationParametersV2(BufferedSource $this$readPpgCalibrationParametersV2) {
        PpgState leadOffEvaluationState = this.readPpgStateV2($this$readPpgCalibrationParametersV2);
        PpgState initialCalibrationState = this.readPpgStateV2($this$readPpgCalibrationParametersV2);
        BufferedSource $this$readByteAsInt$iv = $this$readPpgCalibrationParametersV2;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int controlWindow = $this$asInt$iv$iv & 0xFF;
        List phases = new ArrayList();
        while ($this$readPpgCalibrationParametersV2.request(28L)) {
            ((Collection)phases).add(this.readPpgControlPhaseConfig($this$readPpgCalibrationParametersV2));
        }
        return new PpgCalibrationParameters.V2(leadOffEvaluationState, initialCalibrationState, controlWindow, phases);
    }

    private final void writePpgControlPhaseConfig(BufferedSink $this$writePpgControlPhaseConfig, PpgCalibrationParameters.ControlPhaseConfig config) {
        BufferedSink $this$write22BitInt$iv;
        $this$writePpgControlPhaseConfig.writeByte((int)config.getControlPhase().getHwByte());
        $this$writePpgControlPhaseConfig.writeByte(config.getMinValue());
        $this$writePpgControlPhaseConfig.writeByte(config.getMaxValue());
        $this$writePpgControlPhaseConfig.writeByte(config.getStep());
        BufferedSink bufferedSink = $this$writePpgControlPhaseConfig;
        int value$iv = config.getRedMin();
        boolean $i$f$write22BitInt = false;
        int b0$iv = value$iv & 0xFF;
        int b1$iv = value$iv >> 8 & 0xFF;
        int b2$iv = value$iv >> 16 & 0x3F;
        $this$write22BitInt$iv.writeByte(b2$iv);
        $this$write22BitInt$iv.writeByte(b1$iv);
        $this$write22BitInt$iv.writeByte(b0$iv);
        $this$write22BitInt$iv = $this$writePpgControlPhaseConfig;
        value$iv = config.getRedMax();
        $i$f$write22BitInt = false;
        b0$iv = value$iv & 0xFF;
        b1$iv = value$iv >> 8 & 0xFF;
        b2$iv = value$iv >> 16 & 0x3F;
        $this$write22BitInt$iv.writeByte(b2$iv);
        $this$write22BitInt$iv.writeByte(b1$iv);
        $this$write22BitInt$iv.writeByte(b0$iv);
        $this$write22BitInt$iv = $this$writePpgControlPhaseConfig;
        value$iv = config.getARedMin();
        $i$f$write22BitInt = false;
        b0$iv = value$iv & 0xFF;
        b1$iv = value$iv >> 8 & 0xFF;
        b2$iv = value$iv >> 16 & 0x3F;
        $this$write22BitInt$iv.writeByte(b2$iv);
        $this$write22BitInt$iv.writeByte(b1$iv);
        $this$write22BitInt$iv.writeByte(b0$iv);
        $this$write22BitInt$iv = $this$writePpgControlPhaseConfig;
        value$iv = config.getARedMax();
        $i$f$write22BitInt = false;
        b0$iv = value$iv & 0xFF;
        b1$iv = value$iv >> 8 & 0xFF;
        b2$iv = value$iv >> 16 & 0x3F;
        $this$write22BitInt$iv.writeByte(b2$iv);
        $this$write22BitInt$iv.writeByte(b1$iv);
        $this$write22BitInt$iv.writeByte(b0$iv);
        $this$write22BitInt$iv = $this$writePpgControlPhaseConfig;
        value$iv = config.getIrMin();
        $i$f$write22BitInt = false;
        b0$iv = value$iv & 0xFF;
        b1$iv = value$iv >> 8 & 0xFF;
        b2$iv = value$iv >> 16 & 0x3F;
        $this$write22BitInt$iv.writeByte(b2$iv);
        $this$write22BitInt$iv.writeByte(b1$iv);
        $this$write22BitInt$iv.writeByte(b0$iv);
        $this$write22BitInt$iv = $this$writePpgControlPhaseConfig;
        value$iv = config.getIrMax();
        $i$f$write22BitInt = false;
        b0$iv = value$iv & 0xFF;
        b1$iv = value$iv >> 8 & 0xFF;
        b2$iv = value$iv >> 16 & 0x3F;
        $this$write22BitInt$iv.writeByte(b2$iv);
        $this$write22BitInt$iv.writeByte(b1$iv);
        $this$write22BitInt$iv.writeByte(b0$iv);
        $this$write22BitInt$iv = $this$writePpgControlPhaseConfig;
        value$iv = config.getAIrMin();
        $i$f$write22BitInt = false;
        b0$iv = value$iv & 0xFF;
        b1$iv = value$iv >> 8 & 0xFF;
        b2$iv = value$iv >> 16 & 0x3F;
        $this$write22BitInt$iv.writeByte(b2$iv);
        $this$write22BitInt$iv.writeByte(b1$iv);
        $this$write22BitInt$iv.writeByte(b0$iv);
        $this$write22BitInt$iv = $this$writePpgControlPhaseConfig;
        value$iv = config.getAIrMax();
        $i$f$write22BitInt = false;
        b0$iv = value$iv & 0xFF;
        b1$iv = value$iv >> 8 & 0xFF;
        b2$iv = value$iv >> 16 & 0x3F;
        $this$write22BitInt$iv.writeByte(b2$iv);
        $this$write22BitInt$iv.writeByte(b1$iv);
        $this$write22BitInt$iv.writeByte(b0$iv);
    }

    private final PpgCalibrationParameters.ControlPhaseConfig readPpgControlPhaseConfig(BufferedSource $this$readPpgControlPhaseConfig) {
        byte phase = $this$readPpgControlPhaseConfig.readByte();
        BufferedSource $this$readByteAsInt$iv = $this$readPpgControlPhaseConfig;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int minValue = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = $this$readPpgControlPhaseConfig;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int maxValue = $this$asInt$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv3 = $this$readPpgControlPhaseConfig;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv3 = $this$readByteAsInt$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int step = $this$asInt$iv$iv3 & 0xFF;
        BufferedSource $this$read22BitInt$iv = $this$readPpgControlPhaseConfig;
        boolean $i$f$read22BitInt = false;
        BufferedSource $this$readByteAsInt$iv$iv = $this$read22BitInt$iv;
        boolean $i$f$readByteAsInt4 = false;
        byte $this$asInt$iv$iv$iv = $this$readByteAsInt$iv$iv.readByte();
        boolean $i$f$asInt4 = false;
        int b2$iv = $this$asInt$iv$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv2 = $this$read22BitInt$iv;
        boolean $i$f$readByteAsInt5 = false;
        byte $this$asInt$iv$iv$iv2 = $this$readByteAsInt$iv$iv2.readByte();
        boolean $i$f$asInt5 = false;
        int b1$iv = $this$asInt$iv$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv3 = $this$read22BitInt$iv;
        boolean $i$f$readByteAsInt6 = false;
        byte $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv3.readByte();
        boolean $i$f$asInt6 = false;
        int b0$iv = $this$asInt$iv$iv$iv3 & 0xFF;
        int redMin = (b2$iv << 26 | b1$iv << 18 | b0$iv << 10) >> 10;
        BufferedSource $this$read22BitInt$iv2 = $this$readPpgControlPhaseConfig;
        boolean $i$f$read22BitInt2 = false;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv2;
        $i$f$readByteAsInt = false;
        $this$asInt$iv$iv$iv2 = $this$readByteAsInt$iv$iv.readByte();
        boolean $i$f$asInt7 = false;
        int b2$iv2 = $this$asInt$iv$iv$iv2 & 0xFF;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv2;
        $i$f$readByteAsInt6 = false;
        byte $this$asInt$iv$iv$iv4 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt6 = false;
        int b1$iv2 = $this$asInt$iv$iv$iv4 & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv4 = $this$read22BitInt$iv2;
        boolean $i$f$readByteAsInt7 = false;
        byte $this$asInt$iv$iv$iv5 = $this$readByteAsInt$iv$iv4.readByte();
        boolean $i$f$asInt8 = false;
        int b0$iv2 = $this$asInt$iv$iv$iv5 & 0xFF;
        int redMax = (b2$iv2 << 26 | b1$iv2 << 18 | b0$iv2 << 10) >> 10;
        BufferedSource $this$read22BitInt$iv3 = $this$readPpgControlPhaseConfig;
        boolean $i$f$read22BitInt3 = false;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv3;
        $i$f$readByteAsInt = false;
        $this$asInt$iv$iv$iv4 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt5 = false;
        int b2$iv3 = $this$asInt$iv$iv$iv4 & 0xFF;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv3;
        $i$f$readByteAsInt7 = false;
        $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt8 = false;
        int b1$iv3 = $this$asInt$iv$iv$iv3 & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv5 = $this$read22BitInt$iv3;
        boolean $i$f$readByteAsInt8 = false;
        byte $this$asInt$iv$iv$iv6 = $this$readByteAsInt$iv$iv5.readByte();
        boolean $i$f$asInt9 = false;
        int b0$iv3 = $this$asInt$iv$iv$iv6 & 0xFF;
        int aRedMin = (b2$iv3 << 26 | b1$iv3 << 18 | b0$iv3 << 10) >> 10;
        BufferedSource $this$read22BitInt$iv4 = $this$readPpgControlPhaseConfig;
        boolean $i$f$read22BitInt4 = false;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv4;
        $i$f$readByteAsInt = false;
        $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt6 = false;
        int b2$iv4 = $this$asInt$iv$iv$iv3 & 0xFF;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv4;
        $i$f$readByteAsInt8 = false;
        $this$asInt$iv$iv$iv5 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt9 = false;
        int b1$iv4 = $this$asInt$iv$iv$iv5 & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv6 = $this$read22BitInt$iv4;
        boolean $i$f$readByteAsInt9 = false;
        byte $this$asInt$iv$iv$iv7 = $this$readByteAsInt$iv$iv6.readByte();
        boolean $i$f$asInt10 = false;
        int b0$iv4 = $this$asInt$iv$iv$iv7 & 0xFF;
        int aRedMax = (b2$iv4 << 26 | b1$iv4 << 18 | b0$iv4 << 10) >> 10;
        BufferedSource $this$read22BitInt$iv5 = $this$readPpgControlPhaseConfig;
        boolean $i$f$read22BitInt5 = false;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv5;
        $i$f$readByteAsInt = false;
        $this$asInt$iv$iv$iv5 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt8 = false;
        int b2$iv5 = $this$asInt$iv$iv$iv5 & 0xFF;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv5;
        $i$f$readByteAsInt9 = false;
        $this$asInt$iv$iv$iv6 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt10 = false;
        int b1$iv5 = $this$asInt$iv$iv$iv6 & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv7 = $this$read22BitInt$iv5;
        boolean $i$f$readByteAsInt10 = false;
        byte $this$asInt$iv$iv$iv8 = $this$readByteAsInt$iv$iv7.readByte();
        boolean $i$f$asInt11 = false;
        int b0$iv5 = $this$asInt$iv$iv$iv8 & 0xFF;
        int irMin = (b2$iv5 << 26 | b1$iv5 << 18 | b0$iv5 << 10) >> 10;
        BufferedSource $this$read22BitInt$iv6 = $this$readPpgControlPhaseConfig;
        boolean $i$f$read22BitInt6 = false;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv6;
        $i$f$readByteAsInt = false;
        $this$asInt$iv$iv$iv6 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt9 = false;
        int b2$iv6 = $this$asInt$iv$iv$iv6 & 0xFF;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv6;
        $i$f$readByteAsInt10 = false;
        $this$asInt$iv$iv$iv7 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt11 = false;
        int b1$iv6 = $this$asInt$iv$iv$iv7 & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv8 = $this$read22BitInt$iv6;
        boolean $i$f$readByteAsInt11 = false;
        byte $this$asInt$iv$iv$iv9 = $this$readByteAsInt$iv$iv8.readByte();
        boolean $i$f$asInt12 = false;
        int b0$iv6 = $this$asInt$iv$iv$iv9 & 0xFF;
        int irMax = (b2$iv6 << 26 | b1$iv6 << 18 | b0$iv6 << 10) >> 10;
        BufferedSource $this$read22BitInt$iv7 = $this$readPpgControlPhaseConfig;
        boolean $i$f$read22BitInt7 = false;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv7;
        $i$f$readByteAsInt = false;
        $this$asInt$iv$iv$iv7 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt10 = false;
        int b2$iv7 = $this$asInt$iv$iv$iv7 & 0xFF;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv7;
        $i$f$readByteAsInt11 = false;
        $this$asInt$iv$iv$iv8 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt12 = false;
        int b1$iv7 = $this$asInt$iv$iv$iv8 & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv9 = $this$read22BitInt$iv7;
        boolean $i$f$readByteAsInt12 = false;
        byte $this$asInt$iv$iv$iv10 = $this$readByteAsInt$iv$iv9.readByte();
        boolean $i$f$asInt13 = false;
        int b0$iv7 = $this$asInt$iv$iv$iv10 & 0xFF;
        int aIrMin = (b2$iv7 << 26 | b1$iv7 << 18 | b0$iv7 << 10) >> 10;
        BufferedSource $this$read22BitInt$iv8 = $this$readPpgControlPhaseConfig;
        boolean $i$f$read22BitInt8 = false;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv8;
        $i$f$readByteAsInt = false;
        $this$asInt$iv$iv$iv8 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt11 = false;
        int b2$iv8 = $this$asInt$iv$iv$iv8 & 0xFF;
        $this$readByteAsInt$iv$iv = $this$read22BitInt$iv8;
        $i$f$readByteAsInt12 = false;
        $this$asInt$iv$iv$iv9 = $this$readByteAsInt$iv$iv.readByte();
        $i$f$asInt13 = false;
        int b1$iv8 = $this$asInt$iv$iv$iv9 & 0xFF;
        BufferedSource $this$readByteAsInt$iv$iv10 = $this$read22BitInt$iv8;
        boolean $i$f$readByteAsInt13 = false;
        byte $this$asInt$iv$iv$iv11 = $this$readByteAsInt$iv$iv10.readByte();
        boolean $i$f$asInt14 = false;
        int b0$iv8 = $this$asInt$iv$iv$iv11 & 0xFF;
        int aIrMax = (b2$iv8 << 26 | b1$iv8 << 18 | b0$iv8 << 10) >> 10;
        return new PpgCalibrationParameters.ControlPhaseConfig(PpgCalibrationParameters.ControlPhase.Companion.fromByte(phase), minValue, maxValue, step, redMin, redMax, aRedMin, aRedMax, irMin, irMax, aIrMin, aIrMax);
    }

    private final void serializeBatteryInfo(BufferedSink $this$serializeBatteryInfo, BatteryInfoMessage message2) {
        BatteryInfo batteryInfo = message2.getInfo();
        if (batteryInfo instanceof BatteryInfo.Normal) {
            $this$serializeBatteryInfo.writeShortLe(((BatteryInfo.Normal)message2.getInfo()).getDurationInMinutes());
            $this$serializeBatteryInfo.writeShortLe(((BatteryInfo.Normal)message2.getInfo()).getCharge());
        } else if (!Intrinsics.areEqual((Object)batteryInfo, (Object)BatteryInfo.Unknown.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final BatteryInfoMessage deserializeBatteryInfo(BufferedSource $this$deserializeBatteryInfo) {
        BatteryInfo batteryInfo;
        try {
            short duration = $this$deserializeBatteryInfo.readShortLe();
            short charge = $this$deserializeBatteryInfo.readShortLe();
            batteryInfo = new BatteryInfo.Normal(duration, charge, null, null, 4, null);
        }
        catch (Exception ex) {
            LoggerInterface.w$default((LoggerInterface)this.logger, null, () -> MonitorBasicProtocol.deserializeBatteryInfo$lambda$1(ex), (int)1, null);
            batteryInfo = BatteryInfo.Unknown.INSTANCE;
        }
        BatteryInfo batteryInfo2 = batteryInfo;
        return new BatteryInfoMessage(batteryInfo2);
    }

    private static final String deserializeBatteryInfo$lambda$1(Exception $ex) {
        return "Failed to deserialize battery info: " + $ex.getMessage();
    }

    public MonitorBasicProtocol() {
        this(0, false, false, false, 15, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lvet/inpulse/libcomm/core/protocol/MonitorBasicProtocol$Companion;", "", "<init>", "()V", "TAG", "", "libcomm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageType.values().length];
            try {
                nArray[MessageType.Ack.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Nack.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Ping.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Pong.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Connect.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Disconnect.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetInfo.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.MyInfo.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetMac.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.MyMac.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SetMac.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.TempData.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.NibpData.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StartNibpProcedure.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.NibpCalibrationParameters.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SetNibpCalibrationParameters.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SetNibpCalibrationPressure.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.EcgPpgData.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgDiagnosis.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgSetParameters.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgParameters.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgStartCalibration.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.BatteryInfo.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StartEcgPpg.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StartTemp.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StopAll.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StopNibp.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StartNibpCalibration.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetNibpCalibrationParameters.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.NibpProcedurePeakFound.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.NibpProcedureStartedByDevice.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.NibpProcedureCanceledByDevice.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgGetParameters.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgGetDiagnosis.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetBatteryInfo.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GoToBootloader.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

