/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Utf8;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.device.data.AccessPoint;
import vet.inpulse.libcomm.core.device.data.BatteryInfo;
import vet.inpulse.libcomm.core.device.data.ButtonPress;
import vet.inpulse.libcomm.core.device.data.Ipv4Info;
import vet.inpulse.libcomm.core.device.data.NibpEvent;
import vet.inpulse.libcomm.core.device.data.NibpStatus;
import vet.inpulse.libcomm.core.device.data.PersistenceKey;
import vet.inpulse.libcomm.core.device.data.PersistenceType;
import vet.inpulse.libcomm.core.device.data.PersistenceValue;
import vet.inpulse.libcomm.core.device.data.PpgCalibrationParameters;
import vet.inpulse.libcomm.core.device.data.PpgDiagnosis;
import vet.inpulse.libcomm.core.device.data.PpgState;
import vet.inpulse.libcomm.core.device.data.WifiAuth;
import vet.inpulse.libcomm.core.device.data.WifiAuthMode;
import vet.inpulse.libcomm.core.device.data.WifiConfiguration;
import vet.inpulse.libcomm.core.device.data.WifiConnectionInfo;
import vet.inpulse.libcomm.core.device.data.WifiDisconnectReason;
import vet.inpulse.libcomm.core.device.data.WifiEvent;
import vet.inpulse.libcomm.core.device.data.WifiStatus;
import vet.inpulse.libcomm.core.locator.bluetooth.RemoteAddress;
import vet.inpulse.libcomm.core.network.Inet4AddressBuilder;
import vet.inpulse.libcomm.core.network.Inet6AddressBuilder;
import vet.inpulse.libcomm.core.network.IpAddress_jvmKt;
import vet.inpulse.libcomm.core.protocol.Protocol;
import vet.inpulse.libcomm.core.protocol.ProtocolParseException;
import vet.inpulse.libcomm.core.protocol.ProtocolSerializationException;
import vet.inpulse.libcomm.core.protocol.capno.RespironicsPacket;
import vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol;
import vet.inpulse.libcomm.core.protocol.message.Ack;
import vet.inpulse.libcomm.core.protocol.message.BatteryInfoMessage;
import vet.inpulse.libcomm.core.protocol.message.ButtonPressMessage;
import vet.inpulse.libcomm.core.protocol.message.CapnoData;
import vet.inpulse.libcomm.core.protocol.message.DeviceStreamModule;
import vet.inpulse.libcomm.core.protocol.message.EcgDataMessage;
import vet.inpulse.libcomm.core.protocol.message.EcgGain;
import vet.inpulse.libcomm.core.protocol.message.EcgGetPadsStatus;
import vet.inpulse.libcomm.core.protocol.message.EcgModuleSample;
import vet.inpulse.libcomm.core.protocol.message.EcgPadsControl;
import vet.inpulse.libcomm.core.protocol.message.EcgPadsStatus;
import vet.inpulse.libcomm.core.protocol.message.EcgSamplingRate;
import vet.inpulse.libcomm.core.protocol.message.FriendlyName;
import vet.inpulse.libcomm.core.protocol.message.GetBatteryInfo;
import vet.inpulse.libcomm.core.protocol.message.GetFriendlyName;
import vet.inpulse.libcomm.core.protocol.message.GetInfo;
import vet.inpulse.libcomm.core.protocol.message.GetNibpCalibrationParameters;
import vet.inpulse.libcomm.core.protocol.message.GetRawBatteryInfo;
import vet.inpulse.libcomm.core.protocol.message.GetSerialNumber;
import vet.inpulse.libcomm.core.protocol.message.Message;
import vet.inpulse.libcomm.core.protocol.message.MessageType;
import vet.inpulse.libcomm.core.protocol.message.ModuleConfig;
import vet.inpulse.libcomm.core.protocol.message.ModulePacket;
import vet.inpulse.libcomm.core.protocol.message.MyInfo;
import vet.inpulse.libcomm.core.protocol.message.Nack;
import vet.inpulse.libcomm.core.protocol.message.NibpCalibrationParameters;
import vet.inpulse.libcomm.core.protocol.message.NibpDataMessage;
import vet.inpulse.libcomm.core.protocol.message.NibpEventMessage;
import vet.inpulse.libcomm.core.protocol.message.NibpModuleSample;
import vet.inpulse.libcomm.core.protocol.message.OptionalData;
import vet.inpulse.libcomm.core.protocol.message.OptionalDataType;
import vet.inpulse.libcomm.core.protocol.message.OtaAbort;
import vet.inpulse.libcomm.core.protocol.message.OtaAckChunk;
import vet.inpulse.libcomm.core.protocol.message.OtaChunk;
import vet.inpulse.libcomm.core.protocol.message.OtaCommit;
import vet.inpulse.libcomm.core.protocol.message.OtaStart;
import vet.inpulse.libcomm.core.protocol.message.PersistenceGetKeys;
import vet.inpulse.libcomm.core.protocol.message.PersistenceGetValue;
import vet.inpulse.libcomm.core.protocol.message.PersistenceKeys;
import vet.inpulse.libcomm.core.protocol.message.PersistenceSetValue;
import vet.inpulse.libcomm.core.protocol.message.PersistenceValue;
import vet.inpulse.libcomm.core.protocol.message.Ping;
import vet.inpulse.libcomm.core.protocol.message.Pong;
import vet.inpulse.libcomm.core.protocol.message.PpgDataMessage;
import vet.inpulse.libcomm.core.protocol.message.PpgDiagnosisMessage;
import vet.inpulse.libcomm.core.protocol.message.PpgGetDiagnosis;
import vet.inpulse.libcomm.core.protocol.message.PpgGetParameters;
import vet.inpulse.libcomm.core.protocol.message.PpgModuleSample;
import vet.inpulse.libcomm.core.protocol.message.PpgParameters;
import vet.inpulse.libcomm.core.protocol.message.PpgSamplingRate;
import vet.inpulse.libcomm.core.protocol.message.PpgSetParameters;
import vet.inpulse.libcomm.core.protocol.message.PpgStartCalibration;
import vet.inpulse.libcomm.core.protocol.message.RawBatteryInfo;
import vet.inpulse.libcomm.core.protocol.message.RgbLedExecuteCmd;
import vet.inpulse.libcomm.core.protocol.message.SerialNumber;
import vet.inpulse.libcomm.core.protocol.message.SetFriendlyName;
import vet.inpulse.libcomm.core.protocol.message.SetNibpCalibrationParameters;
import vet.inpulse.libcomm.core.protocol.message.SetNibpCalibrationPressure;
import vet.inpulse.libcomm.core.protocol.message.SetSerialNumber;
import vet.inpulse.libcomm.core.protocol.message.StartAcquisition;
import vet.inpulse.libcomm.core.protocol.message.StartNibp;
import vet.inpulse.libcomm.core.protocol.message.StartNibpCalibration;
import vet.inpulse.libcomm.core.protocol.message.StopAcquisition;
import vet.inpulse.libcomm.core.protocol.message.StopAll;
import vet.inpulse.libcomm.core.protocol.message.StopNibp;
import vet.inpulse.libcomm.core.protocol.message.TempDataMessage;
import vet.inpulse.libcomm.core.protocol.message.TempModuleSample;
import vet.inpulse.libcomm.core.protocol.message.TempSamplingRate;
import vet.inpulse.libcomm.core.protocol.message.Timestamp;
import vet.inpulse.libcomm.core.protocol.message.WifiConfigurationMessage;
import vet.inpulse.libcomm.core.protocol.message.WifiConnect;
import vet.inpulse.libcomm.core.protocol.message.WifiDisconnect;
import vet.inpulse.libcomm.core.protocol.message.WifiEventMessage;
import vet.inpulse.libcomm.core.protocol.message.WifiGetConfiguration;
import vet.inpulse.libcomm.core.protocol.message.WifiGetStatus;
import vet.inpulse.libcomm.core.protocol.message.WifiStartScan;
import vet.inpulse.libcomm.core.protocol.message.WifiStatusMessage;
import vet.inpulse.libcomm.core.protocol.message.WifiStopScan;
import vet.inpulse.libcomm.core.protocol.nibp.NibpMessageSerializer;
import vet.inpulse.libcomm.core.protocol.payloadSerializer.impl.MyInfoSerializer;
import vet.inpulse.libcomm.core.protocol.ppg.PpgCommonSerializer;
import vet.inpulse.libcomm.core.util.RgbColor;
import vet.inpulse.libcomm.core.util.RgbEffect;
import vet.inpulse.libcomm.core.util.RgbLedCmd;
import vet.inpulse.libcomm.core.util.RgbTransition;
import vet.inpulse.libcomm.core.util.SourceByteUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lvet/inpulse/libcomm/core/protocol/InPulseProtocolV2;", "Lvet/inpulse/libcomm/core/protocol/Protocol;", "<init>", "()V", "capnoBuffer", "", "serialize", "", "message", "Lvet/inpulse/libcomm/core/protocol/message/Message;", "sink", "Lokio/BufferedSink;", "deserialize", "Lkotlin/Result;", "source", "Lokio/BufferedSource;", "deserialize-IoAF18A", "(Lokio/BufferedSource;)Ljava/lang/Object;", "readPersistenceValue", "Lvet/inpulse/libcomm/core/device/data/PersistenceValue;", "k", "Lvet/inpulse/libcomm/core/device/data/PersistenceKey;", "writePersistenceValue", "value", "readPersistenceKey", "writePersistenceKey", "key", "mapMessageTypeToByte", "", "type", "Lvet/inpulse/libcomm/core/protocol/message/MessageType;", "(Lvet/inpulse/libcomm/core/protocol/message/MessageType;)Ljava/lang/Byte;", "Companion", "libcomm"})
@SourceDebugExtension(value={"SMAP\nInPulseProtocolV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InPulseProtocolV2.kt\nvet/inpulse/libcomm/core/protocol/InPulseProtocolV2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SourceByteUtils.kt\nvet/inpulse/libcomm/core/util/SourceByteUtilsKt\n*L\n1#1,1302:1\n1869#2,2:1303\n11#3,3:1305\n11#3,3:1308\n11#3,3:1311\n*S KotlinDebug\n*F\n+ 1 InPulseProtocolV2.kt\nvet/inpulse/libcomm/core/protocol/InPulseProtocolV2\n*L\n636#1:1303,2\n987#1:1305,3\n1085#1:1308,3\n1089#1:1311,3\n*E\n"})
public final class InPulseProtocolV2
extends Protocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] capnoBuffer = new byte[8192];
    @NotNull
    public static final String TAG = "InPulseProtocolV2";

    @Override
    public void serialize(@NotNull Message message2, @NotNull BufferedSink sink) {
        block51: {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            try {
                int cmdByte = this.byteForType(message2.getType());
                if (cmdByte == 255) {
                    throw new ProtocolSerializationException("InPulseProtocolV2: Cannot serialize message " + message2 + ".", null, 2, null);
                }
                sink.writeByte(cmdByte);
                Message message3 = message2;
                if (message3 instanceof Ack) {
                    sink.writeByte(this.byteForType(((Ack)message2).getAckedMessage()));
                    break block51;
                }
                if (message3 instanceof Nack) {
                    sink.writeByte(this.byteForType(((Nack)message2).getNackedMessage()));
                    break block51;
                }
                if (message3 instanceof StartAcquisition) {
                    for (ModuleConfig c : ((StartAcquisition)message2).getModuleConfigs()) {
                        BufferedSink bufferedSink;
                        sink.writeByte((int)c.getType());
                        sink.writeByte((int)c.getSize());
                        ModuleConfig moduleConfig = c;
                        if (moduleConfig instanceof ModuleConfig.Ecg) {
                            sink.writeByte((int)((ModuleConfig.Ecg)c).getSamplingRate().getProtocolByte());
                            bufferedSink = sink.writeByte((int)((ModuleConfig.Ecg)c).getGain().getByteValue());
                            continue;
                        }
                        if (moduleConfig instanceof ModuleConfig.Ppg) {
                            bufferedSink = sink.writeByte((int)((ModuleConfig.Ppg)c).getSamplingRate().getProtocolByte());
                            continue;
                        }
                        if (moduleConfig instanceof ModuleConfig.Temperature) {
                            bufferedSink = sink.writeByte((int)((ModuleConfig.Temperature)c).getSamplingRate().getValue());
                            continue;
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    break block51;
                }
                if (message3 instanceof StopAcquisition) {
                    sink.writeByte(((StopAcquisition)message2).getModules().size());
                    Iterable $this$forEach$iv = ((StopAcquisition)message2).getModules();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DeviceStreamModule module = (DeviceStreamModule)((Object)element$iv);
                        boolean bl = false;
                        sink.writeByte((int)module.getType());
                    }
                    break block51;
                }
                if (message3 instanceof EcgDataMessage) {
                    InPulseProtocolV2.Companion.serializeEcgData(sink, ((EcgDataMessage)message2).getData());
                    break block51;
                }
                if (message3 instanceof CapnoData) {
                    ArraysKt.fill$default((byte[])this.capnoBuffer, (byte)0, (int)0, (int)0, (int)6, null);
                    int written = 0;
                    for (RespironicsPacket p : ((CapnoData)message2).getData()) {
                        written += RespironicsProtocol.Companion.serializePacket(p, this.capnoBuffer, written, this.capnoBuffer.length - written);
                    }
                    sink.write(this.capnoBuffer, 0, written);
                    break block51;
                }
                if (message3 instanceof ButtonPressMessage) {
                    sink.writeIntLe(((ButtonPressMessage)message2).getButtonPress-1U4v_RY());
                    break block51;
                }
                if (message3 instanceof OtaChunk) {
                    sink.writeIntLe(((OtaChunk)message2).getSequenceNumber());
                    sink.writeShortLe(((OtaChunk)message2).getLength());
                    sink.write(((OtaChunk)message2).getData(), 0, ((OtaChunk)message2).getLength());
                    sink.writeIntLe(((OtaChunk)message2).getOffset());
                    break block51;
                }
                if (message3 instanceof OtaStart) {
                    sink.writeByte(((OtaStart)message2).getNewVersionNumber());
                    sink.writeIntLe(((OtaStart)message2).getTotalSize());
                    sink.writeByte(((OtaStart)message2).getParallel() ? 1 : 0);
                    break block51;
                }
                if (message3 instanceof OtaAckChunk) {
                    sink.writeIntLe(((OtaAckChunk)message2).getSequenceNumber());
                    sink.writeByte(((OtaAckChunk)message2).getSuccess() ? 1 : 0);
                    break block51;
                }
                if (message3 instanceof PersistenceKeys) {
                    int size = ((PersistenceKeys)message2).getKeys().size();
                    sink.writeByte(size);
                    for (PersistenceKey k : ((PersistenceKeys)message2).getKeys()) {
                        this.writePersistenceKey(sink, k);
                    }
                    break block51;
                }
                if (message3 instanceof PersistenceGetValue) {
                    this.writePersistenceKey(sink, ((PersistenceGetValue)message2).getKey());
                    break block51;
                }
                if (message3 instanceof PersistenceSetValue) {
                    this.writePersistenceKey(sink, ((PersistenceSetValue)message2).getValue().getKey());
                    this.writePersistenceValue(sink, ((PersistenceSetValue)message2).getValue());
                    break block51;
                }
                if (message3 instanceof PersistenceValue) {
                    this.writePersistenceKey(sink, ((PersistenceValue)message2).getValue().getKey());
                    this.writePersistenceValue(sink, ((PersistenceValue)message2).getValue());
                    break block51;
                }
                if (message3 instanceof WifiConnect) {
                    Companion.serializeWifiConnect(((WifiConnect)message2).getConnection(), sink);
                    break block51;
                }
                if (message3 instanceof MyInfo) {
                    MyInfoSerializer.INSTANCE.serializePayload(sink, (MyInfo)message2);
                    break block51;
                }
                if (message3 instanceof WifiEventMessage) {
                    Companion.serializeWifiEvent(((WifiEventMessage)message2).getEvent(), sink);
                    break block51;
                }
                if (message3 instanceof WifiStatusMessage) {
                    Companion.serializeWifiStatus(((WifiStatusMessage)message2).getStatus(), sink);
                    break block51;
                }
                if (message3 instanceof WifiConfigurationMessage) {
                    InPulseProtocolV2.Companion.serializeWifiConfiguration(sink, ((WifiConfigurationMessage)message2).getConfiguration());
                    break block51;
                }
                if (message3 instanceof BatteryInfoMessage) {
                    Companion.serializeBatteryInfoV2(sink, ((BatteryInfoMessage)message2).getInfo());
                    break block51;
                }
                if (message3 instanceof SetFriendlyName) {
                    long length = Utf8.size$default((String)((SetFriendlyName)message2).getFriendlyName(), (int)0, (int)0, (int)3, null);
                    sink.writeByte((int)length);
                    sink.writeUtf8(((SetFriendlyName)message2).getFriendlyName());
                    break block51;
                }
                if (message3 instanceof FriendlyName) {
                    long length = Utf8.size$default((String)((FriendlyName)message2).getFriendlyName(), (int)0, (int)0, (int)3, null);
                    sink.writeByte((int)length);
                    sink.writeUtf8(((FriendlyName)message2).getFriendlyName());
                    break block51;
                }
                if (message3 instanceof SetSerialNumber) {
                    long length = Utf8.size$default((String)((SetSerialNumber)message2).getSerialNumber(), (int)0, (int)0, (int)3, null);
                    sink.writeByte((int)length);
                    sink.writeUtf8(((SetSerialNumber)message2).getSerialNumber());
                    break block51;
                }
                if (message3 instanceof SerialNumber) {
                    long length = Utf8.size$default((String)((SerialNumber)message2).getSerialNumber(), (int)0, (int)0, (int)3, null);
                    sink.writeByte((int)length);
                    sink.writeUtf8(((SerialNumber)message2).getSerialNumber());
                    break block51;
                }
                if (message3 instanceof PpgDataMessage) {
                    Companion.serializePpgData(sink, ((PpgDataMessage)message2).getData());
                    break block51;
                }
                if (message3 instanceof PpgStartCalibration) {
                    if (!(((PpgStartCalibration)message2).getParams() instanceof PpgCalibrationParameters.V2)) {
                        this.throwUnsupportedMessageSerialization(message2, TAG);
                        throw new KotlinNothingValueException();
                    }
                    PpgCalibrationParameters.V2 params = (PpgCalibrationParameters.V2)((PpgStartCalibration)message2).getParams();
                    PpgCommonSerializer.INSTANCE.writePpgCalibrationParametersV2(sink, params);
                    break block51;
                }
                if (message3 instanceof PpgDiagnosisMessage) {
                    PpgCommonSerializer.INSTANCE.writePpgDiagnosis(sink, ((PpgDiagnosisMessage)message2).getDiagnosis());
                    break block51;
                }
                if (message3 instanceof PpgSetParameters) {
                    PpgCommonSerializer.INSTANCE.writePpgStateV2(sink, ((PpgSetParameters)message2).getParams());
                    break block51;
                }
                if (message3 instanceof StartNibp) {
                    NibpMessageSerializer.Companion.writeStartNibp(sink, (StartNibp)message2);
                    break block51;
                }
                if (message3 instanceof SetNibpCalibrationPressure) {
                    NibpMessageSerializer.Companion.writeSetNibpCalibrationPressure(sink, ((SetNibpCalibrationPressure)message2).getPressure());
                    break block51;
                }
                if (message3 instanceof NibpCalibrationParameters) {
                    NibpMessageSerializer.Companion.writeSetNibpCalibrationParameters(sink, ((NibpCalibrationParameters)message2).getCalibrationGain());
                    break block51;
                }
                if (message3 instanceof SetNibpCalibrationParameters) {
                    NibpMessageSerializer.Companion.writeSetNibpCalibrationParameters(sink, ((SetNibpCalibrationParameters)message2).getCalibrationGain());
                    break block51;
                }
                if (message3 instanceof NibpDataMessage) {
                    Companion.serializeNibpData(sink, ((NibpDataMessage)message2).getData());
                    break block51;
                }
                if (message3 instanceof NibpEventMessage) {
                    sink.writeByte((int)((NibpEventMessage)message2).getEvent().getEventByte());
                    break block51;
                }
                if (message3 instanceof TempDataMessage) {
                    Companion.serializeTempData(sink, ((TempDataMessage)message2).getData());
                    break block51;
                }
                if (message3 instanceof RawBatteryInfo) {
                    sink.writeByte(((RawBatteryInfo)message2).getFuelGaugeRegisters().length);
                    for (short sh : ((RawBatteryInfo)message2).getFuelGaugeRegisters()) {
                        sink.writeShortLe((int)sh);
                    }
                    break block51;
                }
                if (message3 instanceof EcgPadsControl) {
                    int n = ((EcgPadsControl)message2).getPadIsOn() ? 1 : 0;
                    sink.writeByte(n);
                    break block51;
                }
                if (message3 instanceof EcgPadsStatus) {
                    int n = ((EcgPadsStatus)message2).getPadIsOn() ? 1 : 0;
                    sink.writeByte(n);
                    break block51;
                }
                if (Intrinsics.areEqual((Object)message3, (Object)Ping.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)Pong.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetBatteryInfo.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetRawBatteryInfo.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetFriendlyName.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetSerialNumber.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetInfo.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)PpgGetDiagnosis.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetNibpCalibrationParameters.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)PersistenceGetKeys.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)OtaAbort.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)OtaCommit.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)StopAll.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)StartNibpCalibration.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)StopNibp.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)EcgGetPadsStatus.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)WifiDisconnect.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)WifiStartScan.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)WifiStopScan.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)WifiGetStatus.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)WifiGetConfiguration.INSTANCE)) break block51;
                if (message3 instanceof RgbLedExecuteCmd) {
                    Companion.serializeRgbLedCmdMessage(sink, (RgbLedExecuteCmd)message2);
                    break block51;
                }
                throw new IllegalArgumentException("Unsupported message by this protocol.");
            }
            catch (Exception e) {
                throw new ProtocolSerializationException("Error serializing message. Message: " + message2, e);
            }
        }
    }

    @Override
    @NotNull
    public Object deserialize-IoAF18A(@NotNull BufferedSource source) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            byte cmdByte = source.readByte();
            MessageType messageType = this.typeForByte(cmdByte);
            object = switch (WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
                case 1 -> {
                    byte ackedCommand = source.readByte();
                    yield Result.constructor-impl((Object)new Ack(this.typeForByte(ackedCommand)));
                }
                case 2 -> {
                    byte nackedCommand = source.readByte();
                    yield Result.constructor-impl((Object)new Nack(this.typeForByte(nackedCommand)));
                }
                case 3 -> {
                    byte protocolVersion = source.readByte();
                    byte deviceType = source.readByte();
                    byte firmwareVersion = source.readByte();
                    String macAddress = source.readUtf8(17L);
                    String v1 = macAddress.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toUpperCase(...)");
                    yield Result.constructor-impl((Object)new MyInfo(protocolVersion, deviceType, firmwareVersion, new RemoteAddress(v1), null, null, null, null, null, 496, null));
                }
                case 4 -> {
                    int samplingRate;
                    List configs = new ArrayList();
                    while (source.request(2L)) {
                        byte type = source.readByte();
                        byte size = source.readByte();
                        byte macAddress = type;
                        if (macAddress == DeviceStreamModule.ECG.getType()) {
                            samplingRate = source.readByte();
                            byte gain = source.readByte();
                            ModuleConfig.Ecg c = new ModuleConfig.Ecg(EcgSamplingRate.Companion.fromByte((byte)samplingRate), EcgGain.Companion.fromByte(gain));
                            configs.add(c);
                            continue;
                        }
                        if (macAddress == DeviceStreamModule.PPG.getType()) {
                            samplingRate = source.readByte();
                            ModuleConfig.Ppg c = new ModuleConfig.Ppg(PpgSamplingRate.Companion.fromByte((byte)samplingRate));
                            configs.add(c);
                            continue;
                        }
                        if (macAddress == DeviceStreamModule.TEMPERATURE.getType()) {
                            samplingRate = source.readByte();
                            ModuleConfig.Temperature c = new ModuleConfig.Temperature(TempSamplingRate.Companion.fromByte((byte)samplingRate));
                            configs.add(c);
                            continue;
                        }
                        source.skip((long)size);
                    }
                    yield Result.constructor-impl((Object)new StartAcquisition(configs));
                }
                case 5 -> {
                    int samplingRate;
                    int modulesSize = source.readByte();
                    ArrayList<DeviceStreamModule> size = new ArrayList<DeviceStreamModule>(modulesSize);
                    int macAddress = 0;
                    while (macAddress < modulesSize) {
                        int c = samplingRate = macAddress++;
                        ArrayList<DeviceStreamModule> var12_85 = size;
                        boolean $i$a$-List-InPulseProtocolV2$deserialize$modules$1 = false;
                        byte type = source.readByte();
                        DeviceStreamModule v2 = DeviceStreamModule.Companion.fromTypeOrNull(type);
                        if (v2 == null) {
                            throw new ProtocolParseException("StopAcquisition with unknown module: " + type, null, 2, null);
                        }
                        var12_85.add(v2);
                    }
                    List modules = size;
                    yield Result.constructor-impl((Object)new StopAcquisition(modules));
                }
                case 6 -> {
                    ModulePacket<EcgModuleSample> p = Companion.deserializeEcgData(source);
                    EcgDataMessage m = new EcgDataMessage(p);
                    yield Result.constructor-impl((Object)m);
                }
                case 7 -> NibpMessageSerializer.Companion.readStartNibp-IoAF18A(source);
                case 8 -> {
                    ModulePacket<PpgModuleSample> data = Companion.deserializePpgData(source);
                    yield Result.constructor-impl((Object)new PpgDataMessage(data));
                }
                case 9 -> {
                    PpgCalibrationParameters.V2 calibrationParameters = PpgCommonSerializer.INSTANCE.readPpgCalibrationParametersV2(source);
                    yield Result.constructor-impl((Object)new PpgStartCalibration(calibrationParameters));
                }
                case 10 -> {
                    PpgDiagnosis diagnosis = PpgCommonSerializer.INSTANCE.readPpgDiagnosis(source);
                    yield Result.constructor-impl((Object)new PpgDiagnosisMessage(diagnosis));
                }
                case 11 -> {
                    ModulePacket<NibpModuleSample> samples = Companion.deserializeNibpData(source);
                    yield Result.constructor-impl((Object)new NibpDataMessage(samples));
                }
                case 12 -> {
                    ModulePacket<TempModuleSample> samples = Companion.deserializeTempData(source);
                    yield Result.constructor-impl((Object)new TempDataMessage(samples));
                }
                case 13 -> {
                    List capnoMessages = new ArrayList();
                    while (source.request(2L)) {
                        RespironicsPacket readPacket = RespironicsProtocol.Companion.deserializeMessage(source);
                        if (readPacket != null) {
                            ((Collection)capnoMessages).add(readPacket);
                        }
                        if (readPacket != null) continue;
                    }
                    yield Result.constructor-impl((Object)new CapnoData(capnoMessages));
                }
                case 14 -> {
                    byte eventType = source.readByte();
                    WifiEvent event = Companion.deserializeWifiEvent(eventType, source);
                    yield Result.constructor-impl((Object)new WifiEventMessage(event));
                }
                case 15 -> {
                    WifiStatus status = Companion.deserializeWifiStatus(source);
                    yield Result.constructor-impl((Object)new WifiStatusMessage(status));
                }
                case 16 -> {
                    WifiConfiguration configuration = Companion.deserializeWifiConfiguration(source);
                    yield Result.constructor-impl((Object)new WifiConfigurationMessage(configuration));
                }
                case 17 -> {
                    int rawButtonPress = source.readIntLe();
                    yield Result.constructor-impl((Object)new ButtonPressMessage(ButtonPress.constructor-impl(rawButtonPress), null));
                }
                case 18 -> {
                    BufferedSource $this$readByteAsInt$iv = source;
                    boolean $i$f$readByteAsInt = false;
                    byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
                    int $i$f$asInt = 0;
                    int newVersion = $this$asInt$iv$iv & 0xFF;
                    int totalSize = source.readIntLe();
                    boolean parallel = source.request(1L) ? source.readByte() == 1 : false;
                    yield Result.constructor-impl((Object)new OtaStart(newVersion, totalSize, parallel));
                }
                case 19 -> {
                    int sequenceNumber = source.readIntLe();
                    short length = source.readShortLe();
                    byte[] data = source.readByteArray((long)length);
                    int offset = source.readIntLe();
                    yield Result.constructor-impl((Object)new OtaChunk(sequenceNumber, data, offset, length));
                }
                case 20 -> Result.constructor-impl((Object)OtaAbort.INSTANCE);
                case 21 -> Result.constructor-impl((Object)OtaCommit.INSTANCE);
                case 22 -> {
                    int sequenceNumber = source.readIntLe();
                    boolean success = source.readByte() != 0;
                    yield Result.constructor-impl((Object)new OtaAckChunk(sequenceNumber, success));
                }
                case 23 -> {
                    int numKeys = source.readByte();
                    List keys = new ArrayList();
                    for (int i = 0; i < numKeys; ++i) {
                        PersistenceKey key = this.readPersistenceKey(source);
                        ((Collection)keys).add(key);
                    }
                    yield Result.constructor-impl((Object)new PersistenceKeys(keys));
                }
                case 24 -> {
                    PersistenceKey k = this.readPersistenceKey(source);
                    yield Result.constructor-impl((Object)new PersistenceGetValue(k));
                }
                case 25 -> {
                    PersistenceKey k = this.readPersistenceKey(source);
                    vet.inpulse.libcomm.core.device.data.PersistenceValue value = this.readPersistenceValue(k, source);
                    if (value != null) {
                        yield Result.constructor-impl((Object)new PersistenceSetValue(value));
                    }
                    yield Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException("Cant read value")));
                }
                case 26 -> {
                    PersistenceKey k = this.readPersistenceKey(source);
                    vet.inpulse.libcomm.core.device.data.PersistenceValue v = this.readPersistenceValue(k, source);
                    if (v != null) {
                        yield Result.constructor-impl((Object)new PersistenceValue(v));
                    }
                    yield Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException("Cant read value")));
                }
                case 27 -> Companion.deserializeBatteryInfoV2-IoAF18A(source);
                case 28 -> {
                    int $i$f$asInt;
                    int length = source.readByte();
                    long need = (long)length * 2L;
                    if (source.request(need)) {
                        $i$f$asInt = 0;
                        short[] var9_80 = new short[length];
                        while ($i$f$asInt < length) {
                            int var10_83 = $i$f$asInt++;
                            var9_80[var10_83] = source.readShortLe();
                        }
                        short[] regs = var9_80;
                        yield Result.constructor-impl((Object)new RawBatteryInfo(regs));
                    }
                    yield Result.constructor-impl((Object)ResultKt.createFailure((Throwable)this.getNotEnoughBytesException(messageType, need, TAG)));
                }
                case 29 -> {
                    long length = source.readByte();
                    String friendlyName = source.readUtf8(length);
                    yield Result.constructor-impl((Object)new SetFriendlyName(friendlyName));
                }
                case 30 -> {
                    long length = source.readByte();
                    String friendlyName = source.readUtf8(length);
                    yield Result.constructor-impl((Object)new FriendlyName(friendlyName));
                }
                case 31 -> {
                    long length = source.readByte();
                    String serialNumber = source.readUtf8(length);
                    yield Result.constructor-impl((Object)new SetSerialNumber(serialNumber));
                }
                case 32 -> {
                    long length = source.readByte();
                    String serialNumber = source.readUtf8(length);
                    yield Result.constructor-impl((Object)new SerialNumber(serialNumber));
                }
                case 33 -> {
                    BufferedSource $this$readByteAsInt$iv = source;
                    boolean $i$f$readByteAsInt = false;
                    byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
                    int $i$f$asInt = 0;
                    boolean padIsOn = ($this$asInt$iv$iv & 0xFF) == 1;
                    yield Result.constructor-impl((Object)new EcgPadsControl(padIsOn));
                }
                case 34 -> {
                    BufferedSource $this$readByteAsInt$iv = source;
                    boolean $i$f$readByteAsInt = false;
                    byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
                    int $i$f$asInt = 0;
                    boolean padIsOn = ($this$asInt$iv$iv & 0xFF) == 1;
                    yield Result.constructor-impl((Object)new EcgPadsStatus(padIsOn));
                }
                case 35 -> Result.constructor-impl((Object)Ping.INSTANCE);
                case 36 -> Result.constructor-impl((Object)Pong.INSTANCE);
                case 37 -> Result.constructor-impl((Object)GetInfo.INSTANCE);
                case 38 -> Result.constructor-impl((Object)StopAll.INSTANCE);
                case 39 -> Result.constructor-impl((Object)StopNibp.INSTANCE);
                case 40 -> Result.constructor-impl((Object)GetBatteryInfo.INSTANCE);
                case 41 -> Result.constructor-impl((Object)GetRawBatteryInfo.INSTANCE);
                case 42 -> Result.constructor-impl((Object)GetSerialNumber.INSTANCE);
                case 43 -> Result.constructor-impl((Object)GetSerialNumber.INSTANCE);
                case 44 -> {
                    byte eventByte = source.readByte();
                    NibpEvent event = NibpEvent.Companion.withValue(eventByte);
                    yield Result.constructor-impl((Object)new NibpEventMessage(event));
                }
                case 45 -> Result.constructor-impl((Object)StartNibpCalibration.INSTANCE);
                case 46 -> NibpMessageSerializer.Companion.readNibpCalibrationParameters-IoAF18A(source);
                case 47 -> Result.constructor-impl((Object)GetNibpCalibrationParameters.INSTANCE);
                case 48 -> NibpMessageSerializer.Companion.readSetNibpCalibrationParameters-IoAF18A(source);
                case 49 -> NibpMessageSerializer.Companion.readSetNibpCalibrationPressure-IoAF18A(source);
                case 50 -> Result.constructor-impl((Object)PpgGetDiagnosis.INSTANCE);
                case 51 -> Result.constructor-impl((Object)PpgGetParameters.INSTANCE);
                case 52 -> Result.constructor-impl((Object)new PpgParameters(PpgCommonSerializer.INSTANCE.readPpgStateV2(source)));
                case 53 -> Result.constructor-impl((Object)EcgGetPadsStatus.INSTANCE);
                case 54 -> Result.constructor-impl((Object)PersistenceGetKeys.INSTANCE);
                case 55 -> Companion.deserializeWifiConnect-IoAF18A(source);
                case 56 -> Result.constructor-impl((Object)WifiDisconnect.INSTANCE);
                case 57 -> Result.constructor-impl((Object)WifiStartScan.INSTANCE);
                case 58 -> Result.constructor-impl((Object)WifiStopScan.INSTANCE);
                case 59 -> Result.constructor-impl((Object)WifiGetStatus.INSTANCE);
                case 60 -> Result.constructor-impl((Object)WifiGetConfiguration.INSTANCE);
                case 61 -> Companion.deserializeRgbLedCmdMessage-IoAF18A(source);
                default -> throw this.getUnsupportedMessageParsing(cmdByte, TAG);
            };
        }
        catch (Exception e) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e));
        }
        return object;
    }

    private final vet.inpulse.libcomm.core.device.data.PersistenceValue readPersistenceValue(PersistenceKey k, BufferedSource source) {
        return switch (WhenMappings.$EnumSwitchMapping$1[k.getType().ordinal()]) {
            case 1 -> null;
            case 2 -> {
                int int = source.readIntLe();
                yield new PersistenceValue.PersistenceInt(k, int);
            }
            case 3 -> {
                long stringSize = source.readByte();
                String string = source.readUtf8(stringSize);
                yield new PersistenceValue.PersistenceString(k, string);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void writePersistenceValue(BufferedSink sink, vet.inpulse.libcomm.core.device.data.PersistenceValue value) {
        vet.inpulse.libcomm.core.device.data.PersistenceValue persistenceValue = value;
        if (persistenceValue instanceof PersistenceValue.PersistenceInt) {
            v0 = sink.writeIntLe(((PersistenceValue.PersistenceInt)value).getValue());
        } else if (persistenceValue instanceof PersistenceValue.PersistenceString) {
            long size = Utf8.size$default((String)((PersistenceValue.PersistenceString)value).getString(), (int)0, (int)0, (int)3, null);
            sink.writeByte((int)size);
            v0 = sink.writeUtf8(((PersistenceValue.PersistenceString)value).getString());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final PersistenceKey readPersistenceKey(BufferedSource source) {
        PersistenceType persistenceType;
        long keyLength = source.readByte();
        String key = StringsKt.decodeToString((byte[])source.readByteArray(keyLength));
        byte it = source.readByte();
        boolean bl = false;
        switch (it) {
            case 1: {
                persistenceType = PersistenceType.Integer;
                break;
            }
            case 2: {
                persistenceType = PersistenceType.String;
                break;
            }
            default: {
                persistenceType = PersistenceType.Unknown;
            }
        }
        PersistenceType type = persistenceType;
        return new PersistenceKey(key, type);
    }

    private final void writePersistenceKey(BufferedSink sink, PersistenceKey key) {
        sink.writeByte((int)Utf8.size$default((String)key.getKey(), (int)0, (int)0, (int)3, null));
        sink.writeUtf8(key.getKey());
        int type = switch (WhenMappings.$EnumSwitchMapping$1[key.getType().ordinal()]) {
            case 2 -> 1;
            case 3 -> 2;
            case 1 -> 0;
            default -> throw new NoWhenBranchMatchedException();
        };
        sink.writeByte(type);
    }

    @Override
    @Nullable
    public Byte mapMessageTypeToByte(@NotNull MessageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Integer n = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> 0;
            case 2 -> 1;
            case 35 -> 4;
            case 36 -> 5;
            case 37 -> 21;
            case 3 -> 22;
            case 4 -> 32;
            case 5 -> 33;
            case 38 -> 36;
            case 6 -> 64;
            case 8 -> 65;
            case 11 -> 66;
            case 12 -> 67;
            case 13 -> 68;
            case 7 -> 34;
            case 39 -> 35;
            case 44 -> 38;
            case 45 -> 42;
            case 49 -> 43;
            case 48 -> 44;
            case 47 -> 45;
            case 46 -> 46;
            case 40 -> 50;
            case 27 -> 51;
            case 41 -> 52;
            case 28 -> 53;
            case 42 -> 54;
            case 29 -> 55;
            case 30 -> 56;
            case 43 -> 57;
            case 31 -> 58;
            case 32 -> 59;
            case 51 -> 80;
            case 62 -> 81;
            case 52 -> 82;
            case 9 -> 83;
            case 50 -> 87;
            case 10 -> 88;
            case 33 -> 96;
            case 53 -> 97;
            case 34 -> 98;
            case 17 -> 128;
            case 18 -> 144;
            case 19 -> 145;
            case 21 -> 146;
            case 20 -> 147;
            case 22 -> 148;
            case 54 -> 160;
            case 23 -> 161;
            case 25 -> 162;
            case 24 -> 163;
            case 26 -> 164;
            case 14 -> 176;
            case 55 -> 177;
            case 56 -> 178;
            case 57 -> 179;
            case 58 -> 180;
            case 59 -> 181;
            case 15 -> 182;
            case 60 -> 183;
            case 16 -> 184;
            case 61 -> 192;
            default -> null;
        };
        return n != null ? Byte.valueOf((byte)n.intValue()) : null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J3\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\u0004\b\u0000\u0010\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0014\b\u0004\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0082\bJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010\u001a\u001a\u00020\u000bJ\u001c\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00122\u0006\u0010\u001a\u001a\u00020\u000bJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00122\u0006\u0010\u001a\u001a\u00020\u000bJ\u001c\u0010!\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020 0\u0012J;\u0010\"\u001a\u00020\r\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00122\u0014\b\u0004\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\r0\u0015H\u0082\bJ\u001e\u0010$\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0002J\u001c\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0012J\u0016\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(J\u001b\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\u0004\b,\u0010-J\u0016\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u0002002\u0006\u0010\u000e\u001a\u00020\u000fJ\u001b\u00101\u001a\b\u0012\u0004\u0012\u0002020*2\u0006\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\u0004\b3\u0010-J\u0016\u00104\u001a\u00020\r2\u0006\u00105\u001a\u0002062\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u00107\u001a\u0002062\u0006\u0010\u001a\u001a\u00020\u000bJ\u0016\u00108\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010'\u001a\u000209J\u000e\u0010:\u001a\u0002092\u0006\u0010\u001a\u001a\u00020\u000bJ\u0016\u0010;\u001a\u00020\r2\u0006\u0010<\u001a\u00020=2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010>\u001a\u00020=2\u0006\u0010\u001a\u001a\u00020\u000bJ\u0018\u0010?\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020AH\u0002J\u000e\u0010B\u001a\u00020A2\u0006\u0010\u001a\u001a\u00020\u000bJ\u0016\u0010C\u001a\u00020\r2\u0006\u0010D\u001a\u00020E2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010F\u001a\u00020E2\u0006\u0010G\u001a\u00020H2\u0006\u0010\u001a\u001a\u00020\u000bJ\u0016\u0010I\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010J\u001a\u00020KJ\u001b\u0010L\u001a\b\u0012\u0004\u0012\u00020K0*2\u0006\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\u0004\bM\u0010-R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lvet/inpulse/libcomm/core/protocol/InPulseProtocolV2$Companion;", "", "<init>", "()V", "TAG", "", "readOptionalData", "", "Lvet/inpulse/libcomm/core/protocol/message/OptionalDataType;", "Lvet/inpulse/libcomm/core/protocol/message/OptionalData;", "buffer", "Lokio/BufferedSource;", "serializeOptionalData", "", "sink", "Lokio/BufferedSink;", "data", "deserializeModuleData", "Lvet/inpulse/libcomm/core/protocol/message/ModulePacket;", "T", "readSample", "Lkotlin/Function1;", "deserializeEcgData", "Lvet/inpulse/libcomm/core/protocol/message/EcgModuleSample;", "deserializePpgData", "Lvet/inpulse/libcomm/core/protocol/message/PpgModuleSample;", "source", "serializePpgData", "packet", "deserializeNibpData", "Lvet/inpulse/libcomm/core/protocol/message/NibpModuleSample;", "deserializeTempData", "Lvet/inpulse/libcomm/core/protocol/message/TempModuleSample;", "serializeTempData", "serializeModuleData", "serializeSample", "serializeEcgData", "serializeNibpData", "serializeBatteryInfoV2", "info", "Lvet/inpulse/libcomm/core/device/data/BatteryInfo;", "deserializeBatteryInfoV2", "Lkotlin/Result;", "Lvet/inpulse/libcomm/core/protocol/message/BatteryInfoMessage;", "deserializeBatteryInfoV2-IoAF18A", "(Lokio/BufferedSource;)Ljava/lang/Object;", "serializeWifiConnect", "connection", "Lvet/inpulse/libcomm/core/device/data/WifiConnectionInfo;", "deserializeWifiConnect", "Lvet/inpulse/libcomm/core/protocol/message/WifiConnect;", "deserializeWifiConnect-IoAF18A", "serializeAccessPoint", "ap", "Lvet/inpulse/libcomm/core/device/data/AccessPoint;", "deserializeAccessPoint", "serializeIpv4Info", "Lvet/inpulse/libcomm/core/device/data/Ipv4Info;", "deserializeIpv4Info", "serializeWifiStatus", "status", "Lvet/inpulse/libcomm/core/device/data/WifiStatus;", "deserializeWifiStatus", "serializeWifiConfiguration", "configuration", "Lvet/inpulse/libcomm/core/device/data/WifiConfiguration;", "deserializeWifiConfiguration", "serializeWifiEvent", "event", "Lvet/inpulse/libcomm/core/device/data/WifiEvent;", "deserializeWifiEvent", "eventType", "", "serializeRgbLedCmdMessage", "message", "Lvet/inpulse/libcomm/core/protocol/message/RgbLedExecuteCmd;", "deserializeRgbLedCmdMessage", "deserializeRgbLedCmdMessage-IoAF18A", "libcomm"})
    @SourceDebugExtension(value={"SMAP\nInPulseProtocolV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InPulseProtocolV2.kt\nvet/inpulse/libcomm/core/protocol/InPulseProtocolV2$Companion\n+ 2 SourceByteUtils.kt\nvet/inpulse/libcomm/core/util/SourceByteUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1302:1\n164#1,4:1303\n169#1,7:1320\n164#1,4:1327\n169#1,7:1383\n247#1,4:1390\n252#1,4:1429\n164#1,12:1433\n164#1,12:1445\n247#1,9:1457\n247#1,4:1466\n252#1,4:1477\n247#1,9:1481\n19#2:1307\n11#2,12:1308\n104#2:1331\n11#2,3:1332\n105#2:1335\n11#2,3:1336\n106#2:1339\n11#2,3:1340\n107#2:1343\n104#2:1344\n11#2,3:1345\n105#2:1348\n11#2,3:1349\n106#2:1352\n11#2,3:1353\n107#2:1356\n104#2:1357\n11#2,3:1358\n105#2:1361\n11#2,3:1362\n106#2:1365\n11#2,3:1366\n107#2:1369\n104#2:1370\n11#2,3:1371\n105#2:1374\n11#2,3:1375\n106#2:1378\n11#2,3:1379\n107#2:1382\n52#2,7:1394\n52#2,7:1401\n52#2,7:1408\n52#2,7:1415\n52#2,7:1422\n43#2,7:1470\n1#3:1490\n*S KotlinDebug\n*F\n+ 1 InPulseProtocolV2.kt\nvet/inpulse/libcomm/core/protocol/InPulseProtocolV2$Companion\n*L\n178#1:1303,4\n178#1:1320,7\n193#1:1327,4\n193#1:1383,7\n202#1:1390,4\n202#1:1429,4\n211#1:1433,12\n230#1:1445,12\n240#1:1457,9\n258#1:1466,4\n258#1:1477,4\n277#1:1481,9\n184#1:1307\n184#1:1308,12\n194#1:1331\n194#1:1332,3\n194#1:1335\n194#1:1336,3\n194#1:1339\n194#1:1340,3\n194#1:1343\n195#1:1344\n195#1:1345,3\n195#1:1348\n195#1:1349,3\n195#1:1352\n195#1:1353,3\n195#1:1356\n196#1:1357\n196#1:1358,3\n196#1:1361\n196#1:1362,3\n196#1:1365\n196#1:1366,3\n196#1:1369\n197#1:1370\n197#1:1371,3\n197#1:1374\n197#1:1375,3\n197#1:1378\n197#1:1379,3\n197#1:1382\n203#1:1394,7\n204#1:1401,7\n205#1:1408,7\n206#1:1415,7\n207#1:1422,7\n271#1:1470,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<OptionalDataType, OptionalData> readOptionalData(BufferedSource buffer) {
            Map optionals = new LinkedHashMap();
            block4: while (buffer.request(2L)) {
                byte type = buffer.readByte();
                byte size = buffer.readByte();
                if (buffer.request((long)size)) {
                    switch (WhenMappings.$EnumSwitchMapping$0[OptionalDataType.Companion.fromByte(type).ordinal()]) {
                        case 1: {
                            if (!(size == OptionalDataType.TIMESTAMP.getSize())) {
                                boolean bl = false;
                                String string = "optional data size error. expected: " + OptionalDataType.TIMESTAMP.getSize() + ", got " + size + ".";
                                throw new IllegalArgumentException(string.toString());
                            }
                            optionals.put(OptionalDataType.TIMESTAMP, new Timestamp(buffer.readLongLe()));
                            continue block4;
                        }
                        case 2: {
                            buffer.skip((long)size);
                            continue block4;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return optionals;
            }
            return optionals;
        }

        private final void serializeOptionalData(BufferedSink sink, Map<OptionalDataType, ? extends OptionalData> data) {
            for (Map.Entry<OptionalDataType, ? extends OptionalData> entry : data.entrySet()) {
                OptionalDataType t = entry.getKey();
                OptionalData d = entry.getValue();
                sink.writeByte((int)t.getId());
                sink.writeByte((int)t.getSize());
                if (d instanceof Timestamp) {
                    sink.writeLongLe(((Timestamp)d).getTimestamp());
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        private final <T> ModulePacket<T> deserializeModuleData(BufferedSource buffer, Function1<? super BufferedSource, ? extends T> readSample) {
            boolean $i$f$deserializeModuleData = false;
            int sampleIdOfFirst = buffer.readIntLe();
            int numberOfSamples = buffer.readByte();
            ArrayList<Object> arrayList = new ArrayList<Object>(numberOfSamples);
            int n = 0;
            while (n < numberOfSamples) {
                int n2;
                int n3 = n2 = n++;
                ArrayList<Object> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(readSample.invoke((Object)buffer));
            }
            List samples = arrayList;
            Map<OptionalDataType, OptionalData> optional = !buffer.exhausted() ? this.readOptionalData(buffer) : null;
            return new ModulePacket(sampleIdOfFirst, samples, optional);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModulePacket<EcgModuleSample> deserializeEcgData(@NotNull BufferedSource buffer) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Companion companion = this;
            BufferedSource buffer$iv = buffer;
            boolean $i$f$deserializeModuleData = false;
            int sampleIdOfFirst$iv = buffer$iv.readIntLe();
            int numberOfSamples$iv = buffer$iv.readByte();
            ArrayList<EcgModuleSample> arrayList = new ArrayList<EcgModuleSample>(numberOfSamples$iv);
            for (int i = 0; i < numberOfSamples$iv; ++i) {
                int n;
                int n2 = n = i;
                ArrayList<EcgModuleSample> arrayList2 = arrayList;
                boolean bl = false;
                BufferedSource it = buffer$iv;
                boolean bl2 = false;
                byte nBytesChannels = buffer.readByte();
                byte[] leadOff = buffer.readByteArray(3L);
                int n3 = 0;
                int n4 = (nBytesChannels - 3) / 3;
                int[] nArray = new int[n4];
                while (n3 < n4) {
                    int n5 = n3++;
                    BufferedSource $this$read24BitInt$iv = buffer;
                    boolean $i$f$read24BitInt = false;
                    BufferedSource $this$readByteAsInt$iv$iv = $this$read24BitInt$iv;
                    boolean $i$f$readByteAsInt = false;
                    byte $this$asInt$iv$iv$iv = $this$readByteAsInt$iv$iv.readByte();
                    boolean $i$f$asInt = false;
                    int b2$iv = $this$asInt$iv$iv$iv & 0xFF;
                    BufferedSource $this$readByteAsInt$iv$iv2 = $this$read24BitInt$iv;
                    boolean $i$f$readByteAsInt2 = false;
                    byte $this$asInt$iv$iv$iv2 = $this$readByteAsInt$iv$iv2.readByte();
                    boolean $i$f$asInt2 = false;
                    int b1$iv = $this$asInt$iv$iv$iv2 & 0xFF;
                    BufferedSource $this$readByteAsInt$iv$iv3 = $this$read24BitInt$iv;
                    boolean $i$f$readByteAsInt3 = false;
                    byte $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv3.readByte();
                    boolean $i$f$asInt3 = false;
                    int b0$iv = $this$asInt$iv$iv$iv3 & 0xFF;
                    nArray[n5] = (b2$iv << 24 | b1$iv << 16 | b0$iv << 8) >> 8;
                }
                int[] channels = nArray;
                arrayList2.add(new EcgModuleSample(leadOff, channels));
            }
            List samples$iv = arrayList;
            Map<OptionalDataType, OptionalData> optional$iv = !buffer$iv.exhausted() ? super.readOptionalData(buffer$iv) : null;
            return new ModulePacket<EcgModuleSample>(sampleIdOfFirst$iv, samples$iv, optional$iv);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModulePacket<PpgModuleSample> deserializePpgData(@NotNull BufferedSource source) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Companion companion = this;
            BufferedSource buffer$iv = source;
            boolean $i$f$deserializeModuleData = false;
            int sampleIdOfFirst$iv = buffer$iv.readIntLe();
            int numberOfSamples$iv = buffer$iv.readByte();
            ArrayList<PpgModuleSample> arrayList = new ArrayList<PpgModuleSample>(numberOfSamples$iv);
            int n = 0;
            while (n < numberOfSamples$iv) {
                int n2;
                int n3 = n2 = n++;
                ArrayList<PpgModuleSample> arrayList2 = arrayList;
                boolean bl = false;
                BufferedSource it = buffer$iv;
                boolean bl2 = false;
                BufferedSource $this$read22BitIntLe$iv = source;
                boolean $i$f$read22BitIntLe = false;
                BufferedSource $this$readByteAsInt$iv$iv = $this$read22BitIntLe$iv;
                boolean $i$f$readByteAsInt = false;
                byte $this$asInt$iv$iv$iv = $this$readByteAsInt$iv$iv.readByte();
                boolean $i$f$asInt = false;
                int b0$iv = $this$asInt$iv$iv$iv & 0xFF;
                BufferedSource $this$readByteAsInt$iv$iv2 = $this$read22BitIntLe$iv;
                boolean $i$f$readByteAsInt2 = false;
                byte $this$asInt$iv$iv$iv2 = $this$readByteAsInt$iv$iv2.readByte();
                boolean $i$f$asInt2 = false;
                int b1$iv = $this$asInt$iv$iv$iv2 & 0xFF;
                BufferedSource $this$readByteAsInt$iv$iv3 = $this$read22BitIntLe$iv;
                boolean $i$f$readByteAsInt3 = false;
                byte $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv3.readByte();
                boolean $i$f$asInt3 = false;
                int b2$iv = $this$asInt$iv$iv$iv3 & 0xFF;
                int redRaw = (b2$iv << 26 | b1$iv << 18 | b0$iv << 10) >> 10;
                BufferedSource $this$read22BitIntLe$iv2 = source;
                boolean $i$f$read22BitIntLe2 = false;
                $this$readByteAsInt$iv$iv = $this$read22BitIntLe$iv2;
                $i$f$readByteAsInt = false;
                $this$asInt$iv$iv$iv2 = $this$readByteAsInt$iv$iv.readByte();
                boolean $i$f$asInt4 = false;
                int b0$iv2 = $this$asInt$iv$iv$iv2 & 0xFF;
                $this$readByteAsInt$iv$iv = $this$read22BitIntLe$iv2;
                $i$f$readByteAsInt3 = false;
                byte $this$asInt$iv$iv$iv4 = $this$readByteAsInt$iv$iv.readByte();
                $i$f$asInt3 = false;
                int b1$iv2 = $this$asInt$iv$iv$iv4 & 0xFF;
                BufferedSource $this$readByteAsInt$iv$iv4 = $this$read22BitIntLe$iv2;
                boolean $i$f$readByteAsInt4 = false;
                byte $this$asInt$iv$iv$iv5 = $this$readByteAsInt$iv$iv4.readByte();
                boolean $i$f$asInt5 = false;
                int b2$iv2 = $this$asInt$iv$iv$iv5 & 0xFF;
                int irRaw = (b2$iv2 << 26 | b1$iv2 << 18 | b0$iv2 << 10) >> 10;
                BufferedSource $this$read22BitIntLe$iv3 = source;
                boolean $i$f$read22BitIntLe3 = false;
                $this$readByteAsInt$iv$iv = $this$read22BitIntLe$iv3;
                $i$f$readByteAsInt = false;
                $this$asInt$iv$iv$iv4 = $this$readByteAsInt$iv$iv.readByte();
                $i$f$asInt2 = false;
                int b0$iv3 = $this$asInt$iv$iv$iv4 & 0xFF;
                $this$readByteAsInt$iv$iv = $this$read22BitIntLe$iv3;
                $i$f$readByteAsInt4 = false;
                $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv.readByte();
                $i$f$asInt5 = false;
                int b1$iv3 = $this$asInt$iv$iv$iv3 & 0xFF;
                BufferedSource $this$readByteAsInt$iv$iv5 = $this$read22BitIntLe$iv3;
                boolean $i$f$readByteAsInt5 = false;
                byte $this$asInt$iv$iv$iv6 = $this$readByteAsInt$iv$iv5.readByte();
                boolean $i$f$asInt6 = false;
                int b2$iv3 = $this$asInt$iv$iv$iv6 & 0xFF;
                int redLightRaw = (b2$iv3 << 26 | b1$iv3 << 18 | b0$iv3 << 10) >> 10;
                BufferedSource $this$read22BitIntLe$iv4 = source;
                boolean $i$f$read22BitIntLe4 = false;
                $this$readByteAsInt$iv$iv = $this$read22BitIntLe$iv4;
                $i$f$readByteAsInt = false;
                $this$asInt$iv$iv$iv3 = $this$readByteAsInt$iv$iv.readByte();
                $i$f$asInt3 = false;
                int b0$iv4 = $this$asInt$iv$iv$iv3 & 0xFF;
                $this$readByteAsInt$iv$iv = $this$read22BitIntLe$iv4;
                $i$f$readByteAsInt5 = false;
                $this$asInt$iv$iv$iv5 = $this$readByteAsInt$iv$iv.readByte();
                $i$f$asInt6 = false;
                int b1$iv4 = $this$asInt$iv$iv$iv5 & 0xFF;
                BufferedSource $this$readByteAsInt$iv$iv6 = $this$read22BitIntLe$iv4;
                boolean $i$f$readByteAsInt6 = false;
                byte $this$asInt$iv$iv$iv7 = $this$readByteAsInt$iv$iv6.readByte();
                boolean $i$f$asInt7 = false;
                int b2$iv4 = $this$asInt$iv$iv$iv7 & 0xFF;
                int irLightRaw = (b2$iv4 << 26 | b1$iv4 << 18 | b0$iv4 << 10) >> 10;
                PpgState state = PpgCommonSerializer.INSTANCE.readPpgStateV2(source);
                arrayList2.add(new PpgModuleSample(redRaw, irRaw, redLightRaw, irLightRaw, state));
            }
            List samples$iv = arrayList;
            Map<OptionalDataType, OptionalData> optional$iv = !buffer$iv.exhausted() ? super.readOptionalData(buffer$iv) : null;
            return new ModulePacket<PpgModuleSample>(sampleIdOfFirst$iv, samples$iv, optional$iv);
        }

        /*
         * WARNING - void declaration
         */
        public final void serializePpgData(@NotNull BufferedSink sink, @NotNull ModulePacket<PpgModuleSample> packet) {
            void sink$iv;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter(packet, (String)"packet");
            Companion companion = this;
            BufferedSink bufferedSink = sink;
            ModulePacket<PpgModuleSample> packet$iv = packet;
            boolean $i$f$serializeModuleData = false;
            sink$iv.writeIntLe(packet$iv.getSampleIdOfFirst());
            sink$iv.writeByte(packet$iv.getSamples().size());
            Iterator<PpgModuleSample> iterator = packet$iv.getSamples().iterator();
            while (iterator.hasNext()) {
                BufferedSink $this$write24BitIntLe$iv;
                PpgModuleSample s$iv;
                PpgModuleSample it = s$iv = iterator.next();
                boolean bl = false;
                BufferedSink bufferedSink2 = sink;
                int i$iv = it.getRedRaw();
                boolean $i$f$write24BitIntLe = false;
                int a$iv = (i$iv & 0xFF0000) >> 16;
                int b$iv = (i$iv & 0xFF00) >> 8;
                int c$iv = i$iv & 0xFF;
                $this$write24BitIntLe$iv.writeByte(c$iv);
                $this$write24BitIntLe$iv.writeByte(b$iv);
                $this$write24BitIntLe$iv.writeByte(a$iv);
                $this$write24BitIntLe$iv = sink;
                i$iv = it.getInfraredRaw();
                $i$f$write24BitIntLe = false;
                a$iv = (i$iv & 0xFF0000) >> 16;
                b$iv = (i$iv & 0xFF00) >> 8;
                c$iv = i$iv & 0xFF;
                $this$write24BitIntLe$iv.writeByte(c$iv);
                $this$write24BitIntLe$iv.writeByte(b$iv);
                $this$write24BitIntLe$iv.writeByte(a$iv);
                $this$write24BitIntLe$iv = sink;
                i$iv = it.getRedLightRaw();
                $i$f$write24BitIntLe = false;
                a$iv = (i$iv & 0xFF0000) >> 16;
                b$iv = (i$iv & 0xFF00) >> 8;
                c$iv = i$iv & 0xFF;
                $this$write24BitIntLe$iv.writeByte(c$iv);
                $this$write24BitIntLe$iv.writeByte(b$iv);
                $this$write24BitIntLe$iv.writeByte(a$iv);
                $this$write24BitIntLe$iv = sink;
                i$iv = it.getInfraredLightRaw();
                $i$f$write24BitIntLe = false;
                a$iv = (i$iv & 0xFF0000) >> 16;
                b$iv = (i$iv & 0xFF00) >> 8;
                c$iv = i$iv & 0xFF;
                $this$write24BitIntLe$iv.writeByte(c$iv);
                $this$write24BitIntLe$iv.writeByte(b$iv);
                $this$write24BitIntLe$iv.writeByte(a$iv);
                $this$write24BitIntLe$iv = sink;
                i$iv = it.getInfraredLightRaw();
                $i$f$write24BitIntLe = false;
                a$iv = (i$iv & 0xFF0000) >> 16;
                b$iv = (i$iv & 0xFF00) >> 8;
                c$iv = i$iv & 0xFF;
                $this$write24BitIntLe$iv.writeByte(c$iv);
                $this$write24BitIntLe$iv.writeByte(b$iv);
                $this$write24BitIntLe$iv.writeByte(a$iv);
                PpgCommonSerializer.INSTANCE.writePpgStateV2(sink, it.getCalibrationInfo());
            }
            if (packet$iv.getOptionalData() != null) {
                void this_$iv;
                super.serializeOptionalData((BufferedSink)sink$iv, packet$iv.getOptionalData());
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModulePacket<NibpModuleSample> deserializeNibpData(@NotNull BufferedSource source) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Companion companion = this;
            BufferedSource buffer$iv = source;
            boolean $i$f$deserializeModuleData = false;
            int sampleIdOfFirst$iv = buffer$iv.readIntLe();
            int numberOfSamples$iv = buffer$iv.readByte();
            ArrayList<NibpModuleSample> arrayList = new ArrayList<NibpModuleSample>(numberOfSamples$iv);
            int n = 0;
            while (n < numberOfSamples$iv) {
                int n2;
                int n3 = n2 = n++;
                ArrayList<NibpModuleSample> arrayList2 = arrayList;
                boolean bl = false;
                BufferedSource it = buffer$iv;
                boolean bl2 = false;
                int bpInt = it.readIntLe();
                byte status = it.readByte();
                int filter1Int = it.readIntLe();
                int filter2Int = it.readIntLe();
                int controlInt = it.readIntLe();
                float bloodPressure = Float.intBitsToFloat(bpInt);
                float filter1 = Float.intBitsToFloat(filter1Int);
                float filter2 = Float.intBitsToFloat(filter2Int);
                float control = Float.intBitsToFloat(controlInt);
                arrayList2.add(new NibpModuleSample(bloodPressure, NibpStatus.Companion.withValue(status), Float.valueOf(filter1), Float.valueOf(filter2), Float.valueOf(control)));
            }
            List samples$iv = arrayList;
            Map<OptionalDataType, OptionalData> optional$iv = !buffer$iv.exhausted() ? super.readOptionalData(buffer$iv) : null;
            return new ModulePacket<NibpModuleSample>(sampleIdOfFirst$iv, samples$iv, optional$iv);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModulePacket<TempModuleSample> deserializeTempData(@NotNull BufferedSource source) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Companion companion = this;
            BufferedSource buffer$iv = source;
            boolean $i$f$deserializeModuleData = false;
            int sampleIdOfFirst$iv = buffer$iv.readIntLe();
            int numberOfSamples$iv = buffer$iv.readByte();
            ArrayList<TempModuleSample> arrayList = new ArrayList<TempModuleSample>(numberOfSamples$iv);
            int n = 0;
            while (n < numberOfSamples$iv) {
                int n2;
                int n3 = n2 = n++;
                ArrayList<TempModuleSample> arrayList2 = arrayList;
                boolean bl = false;
                BufferedSource it = buffer$iv;
                boolean bl2 = false;
                short temp1 = source.readShort();
                short temp2 = source.readShort();
                arrayList2.add(new TempModuleSample(temp1, temp2));
            }
            List samples$iv = arrayList;
            Map<OptionalDataType, OptionalData> optional$iv = !buffer$iv.exhausted() ? super.readOptionalData(buffer$iv) : null;
            return new ModulePacket<TempModuleSample>(sampleIdOfFirst$iv, samples$iv, optional$iv);
        }

        /*
         * WARNING - void declaration
         */
        public final void serializeTempData(@NotNull BufferedSink sink, @NotNull ModulePacket<TempModuleSample> packet) {
            void sink$iv;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter(packet, (String)"packet");
            Companion companion = this;
            BufferedSink bufferedSink = sink;
            ModulePacket<TempModuleSample> packet$iv = packet;
            boolean $i$f$serializeModuleData = false;
            sink$iv.writeIntLe(packet$iv.getSampleIdOfFirst());
            sink$iv.writeByte(packet$iv.getSamples().size());
            Iterator<TempModuleSample> iterator = packet$iv.getSamples().iterator();
            while (iterator.hasNext()) {
                TempModuleSample s$iv;
                TempModuleSample it = s$iv = iterator.next();
                boolean bl = false;
                sink.writeShort((int)it.getRawTemp1());
                sink.writeShort((int)it.getRawTemp2());
            }
            if (packet$iv.getOptionalData() != null) {
                void this_$iv;
                super.serializeOptionalData((BufferedSink)sink$iv, packet$iv.getOptionalData());
            }
        }

        private final <T> void serializeModuleData(BufferedSink sink, ModulePacket<T> packet, Function1<? super T, Unit> serializeSample) {
            boolean $i$f$serializeModuleData = false;
            sink.writeIntLe(packet.getSampleIdOfFirst());
            sink.writeByte(packet.getSamples().size());
            for (T s : packet.getSamples()) {
                serializeSample.invoke(s);
            }
            if (packet.getOptionalData() != null) {
                this.serializeOptionalData(sink, packet.getOptionalData());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void serializeEcgData(BufferedSink sink, ModulePacket<EcgModuleSample> packet) {
            void sink$iv;
            Companion companion = this;
            BufferedSink bufferedSink = sink;
            ModulePacket<EcgModuleSample> packet$iv = packet;
            boolean $i$f$serializeModuleData = false;
            sink$iv.writeIntLe(packet$iv.getSampleIdOfFirst());
            sink$iv.writeByte(packet$iv.getSamples().size());
            Iterator<EcgModuleSample> iterator = packet$iv.getSamples().iterator();
            while (iterator.hasNext()) {
                EcgModuleSample s$iv;
                EcgModuleSample s = s$iv = iterator.next();
                boolean bl = false;
                sink.writeByte(s.getChannels().length * 3 + 3);
                if (s.getLeadOff() == null) {
                    sink.writeByte(0);
                    sink.writeByte(0);
                    v0 = sink.writeByte(0);
                } else {
                    v0 = sink.write(s.getLeadOff());
                }
                for (int c : s.getChannels()) {
                    void $this$write24BitInt$iv;
                    BufferedSink bufferedSink2 = sink;
                    int i$iv = c;
                    boolean $i$f$write24BitInt = false;
                    int a$iv = (i$iv & 0xFF0000) >> 16;
                    int b$iv = (i$iv & 0xFF00) >> 8;
                    int c$iv = i$iv & 0xFF;
                    $this$write24BitInt$iv.writeByte(a$iv);
                    $this$write24BitInt$iv.writeByte(b$iv);
                    $this$write24BitInt$iv.writeByte(c$iv);
                }
            }
            if (packet$iv.getOptionalData() != null) {
                void this_$iv;
                super.serializeOptionalData((BufferedSink)sink$iv, packet$iv.getOptionalData());
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void serializeNibpData(@NotNull BufferedSink sink, @NotNull ModulePacket<NibpModuleSample> packet) {
            void sink$iv;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter(packet, (String)"packet");
            Companion companion = this;
            BufferedSink bufferedSink = sink;
            ModulePacket<NibpModuleSample> packet$iv = packet;
            boolean $i$f$serializeModuleData = false;
            sink$iv.writeIntLe(packet$iv.getSampleIdOfFirst());
            sink$iv.writeByte(packet$iv.getSamples().size());
            Iterator<NibpModuleSample> iterator = packet$iv.getSamples().iterator();
            while (iterator.hasNext()) {
                NibpModuleSample s$iv;
                NibpModuleSample it = s$iv = iterator.next();
                boolean bl = false;
                sink.writeIntLe(Float.floatToIntBits(it.getBloodPressure()));
                sink.writeByte((int)it.getStatus().getStatusValue());
                Float f = it.getFilter1();
                sink.writeIntLe(f != null ? Float.floatToIntBits(f.floatValue()) : 0);
                Float f2 = it.getFilter2();
                sink.writeIntLe(f2 != null ? Float.floatToIntBits(f2.floatValue()) : 0);
                Float f3 = it.getControl();
                sink.writeIntLe(f3 != null ? Float.floatToIntBits(f3.floatValue()) : 0);
            }
            if (packet$iv.getOptionalData() != null) {
                void this_$iv;
                super.serializeOptionalData((BufferedSink)sink$iv, packet$iv.getOptionalData());
            }
        }

        public final void serializeBatteryInfoV2(@NotNull BufferedSink sink, @NotNull BatteryInfo info) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            BatteryInfo batteryInfo = info;
            if (batteryInfo instanceof BatteryInfo.Normal) {
                BufferedSink bufferedSink = ((BatteryInfo.Normal)info).getTempKelvinTimes10() != null ? sink.writeShortLe(((BatteryInfo.Normal)info).getTempKelvinTimes10().intValue()) : sink.writeShortLe(0);
                sink.writeShortLe(((BatteryInfo.Normal)info).getCharge());
                sink.writeShortLe(((BatteryInfo.Normal)info).getDurationInMinutes());
                sink.writeByte(SourceByteUtilsKt.toBooleanByte(((BatteryInfo.Normal)info).isCharging()));
            } else if (!Intrinsics.areEqual((Object)batteryInfo, (Object)BatteryInfo.Unknown.INSTANCE)) {
                throw new NoWhenBranchMatchedException();
            }
        }

        @NotNull
        public final Object deserializeBatteryInfoV2-IoAF18A(@NotNull BufferedSource source) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (source.request(7L)) {
                short tempKelvin = source.readShortLe();
                short charge = source.readShortLe();
                short duration = source.readShortLe();
                boolean isCharging = source.readByte() != 0;
                BatteryInfo.Normal info = new BatteryInfo.Normal(duration, charge, Integer.valueOf(tempKelvin), isCharging);
                object = Result.constructor-impl((Object)new BatteryInfoMessage(info));
            } else {
                object = Result.constructor-impl((Object)new BatteryInfoMessage(BatteryInfo.Unknown.INSTANCE));
            }
            return object;
        }

        public final void serializeWifiConnect(@NotNull WifiConnectionInfo connection, @NotNull BufferedSink sink) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            long ssidSize = Utf8.size$default((String)connection.getSsid(), (int)0, (int)0, (int)3, null);
            if (!(ssidSize <= 32L)) {
                boolean $i$a$-require-InPulseProtocolV2$Companion$serializeWifiConnect$32 = false;
                String $i$a$-require-InPulseProtocolV2$Companion$serializeWifiConnect$32 = "ssid size is too big: " + ssidSize + ".";
                throw new IllegalArgumentException($i$a$-require-InPulseProtocolV2$Companion$serializeWifiConnect$32.toString());
            }
            sink.writeByte((int)ssidSize);
            sink.writeUtf8(connection.getSsid());
            WifiAuth auth = connection.getWifiAuth();
            if (Intrinsics.areEqual((Object)auth, (Object)WifiAuth.Open.INSTANCE)) {
                v0 = sink.writeByte(auth.getMode().getByte());
            } else if (auth instanceof WifiAuth.PreSharedKey) {
                sink.writeByte(((WifiAuth.PreSharedKey)auth).getMode().getByte());
                long passwordSize = Utf8.size$default((String)((WifiAuth.PreSharedKey)auth).getPassword(), (int)0, (int)0, (int)3, null);
                if (!(passwordSize <= 64L)) {
                    boolean bl = false;
                    String string = "Password size is too big: " + passwordSize + ".";
                    throw new IllegalArgumentException(string.toString());
                }
                sink.writeByte((int)passwordSize);
                v0 = sink.writeUtf8(((WifiAuth.PreSharedKey)auth).getPassword());
            } else if (Intrinsics.areEqual((Object)auth, (Object)WifiAuth.Wpa2Enterprise.INSTANCE)) {
                v0 = sink.writeByte(auth.getMode().getByte());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }

        @NotNull
        public final Object deserializeWifiConnect-IoAF18A(@NotNull BufferedSource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            long ssidSize = source.readByte();
            String ssid = source.readUtf8(ssidSize);
            byte authByte = source.readByte();
            WifiAuthMode authMode = WifiAuthMode.Companion.fromByte(authByte);
            return switch (WhenMappings.$EnumSwitchMapping$1[authMode.ordinal()]) {
                case 1 -> Result.constructor-impl((Object)new WifiConnect(new WifiConnectionInfo(ssid, WifiAuth.Open.INSTANCE)));
                case 2, 3, 4, 5, 6, 7, 8 -> {
                    long passwordSize = source.readByte();
                    String password = source.readUtf8(passwordSize);
                    yield Result.constructor-impl((Object)new WifiConnect(new WifiConnectionInfo(ssid, new WifiAuth.PreSharedKey(authMode, password))));
                }
                case 9 -> Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new ProtocolParseException("WifiAuthMode unsupported", null, 2, null)));
                case 10 -> Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new ProtocolParseException("WifiAuthMode unsupported", null, 2, null)));
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public final void serializeAccessPoint(@NotNull AccessPoint ap, @NotNull BufferedSink sink) {
            Intrinsics.checkNotNullParameter((Object)ap, (String)"ap");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            sink.writeByte((int)Utf8.size$default((String)ap.getSsid(), (int)0, (int)0, (int)3, null));
            sink.writeUtf8(ap.getSsid());
            sink.write(ap.getBssid().toByteArray());
            sink.writeByte(ap.getAuthMode().getByte());
            sink.writeByte(ap.getRssi());
        }

        @NotNull
        public final AccessPoint deserializeAccessPoint(@NotNull BufferedSource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            long ssidSize = source.readByte();
            String ssid = source.readUtf8(ssidSize);
            byte[] bssid = source.readByteArray(6L);
            byte authModeByte = source.readByte();
            WifiAuthMode authMode = WifiAuthMode.Companion.fromByte(authModeByte);
            byte rssi = source.readByte();
            return new AccessPoint(ssid, RemoteAddress.Companion.fromByteArray$default(RemoteAddress.Companion, bssid, 0, 2, null), authMode, rssi);
        }

        public final void serializeIpv4Info(@NotNull BufferedSink sink, @NotNull Ipv4Info info) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            sink.write(IpAddress_jvmKt.getAddressBytes(info.getIpv4()));
            sink.write(IpAddress_jvmKt.getAddressBytes(info.getNetmask()));
            sink.write(IpAddress_jvmKt.getAddressBytes(info.getGateway()));
        }

        @NotNull
        public final Ipv4Info deserializeIpv4Info(@NotNull BufferedSource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            byte[] ip = source.readByteArray(4L);
            byte[] netmask = source.readByteArray(4L);
            byte[] gateway = source.readByteArray(4L);
            return new Ipv4Info(Inet4AddressBuilder.INSTANCE.getByAddress(ip), Inet4AddressBuilder.INSTANCE.getByAddress(netmask), Inet4AddressBuilder.INSTANCE.getByAddress(gateway));
        }

        public final void serializeWifiStatus(@NotNull WifiStatus status, @NotNull BufferedSink sink) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            sink.writeByte((int)status.getType().getByte());
            if (status instanceof WifiStatus.Connected) {
                this.serializeAccessPoint(((WifiStatus.Connected)status).getAp(), sink);
                this.serializeIpv4Info(sink, ((WifiStatus.Connected)status).getInfo());
            }
        }

        @NotNull
        public final WifiStatus deserializeWifiStatus(@NotNull BufferedSource source) {
            WifiStatus wifiStatus;
            byte statusType;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            byte by = statusType = source.readByte();
            if (by == WifiStatus.Type.Disconnected.getByte()) {
                wifiStatus = WifiStatus.Disconnected.INSTANCE;
            } else {
                if (by == WifiStatus.Type.Connected.getByte()) {
                    AccessPoint ap = this.deserializeAccessPoint(source);
                    Ipv4Info info = this.deserializeIpv4Info(source);
                    return new WifiStatus.Connected(ap, info);
                }
                wifiStatus = WifiStatus.Unknown.INSTANCE;
            }
            return wifiStatus;
        }

        private final void serializeWifiConfiguration(BufferedSink sink, WifiConfiguration configuration) {
            sink.writeByte((int)Utf8.size$default((String)configuration.getSsid(), (int)0, (int)0, (int)3, null));
            sink.writeUtf8(configuration.getSsid());
            sink.writeByte(configuration.getWifiAuthMode().getByte());
        }

        @NotNull
        public final WifiConfiguration deserializeWifiConfiguration(@NotNull BufferedSource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            long ssidLength = source.readByte();
            String ssid = source.readUtf8(ssidLength);
            byte authModeByte = source.readByte();
            return new WifiConfiguration(ssid, WifiAuthMode.Companion.fromByte(authModeByte));
        }

        public final void serializeWifiEvent(@NotNull WifiEvent event, @NotNull BufferedSink sink) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            sink.writeByte((int)event.getByte().getByte());
            WifiEvent wifiEvent = event;
            if (wifiEvent instanceof WifiEvent.AccessPointFound) {
                this.serializeAccessPoint(((WifiEvent.AccessPointFound)event).getAp(), sink);
            } else if (wifiEvent instanceof WifiEvent.Connected) {
                this.serializeAccessPoint(((WifiEvent.Connected)event).getAp(), sink);
            } else if (wifiEvent instanceof WifiEvent.Disconnected) {
                sink.writeByte(((WifiEvent.Disconnected)event).getReason().getByte());
            } else if (wifiEvent instanceof WifiEvent.GotIpv4) {
                this.serializeAccessPoint(((WifiEvent.GotIpv4)event).getAp(), sink);
                this.serializeIpv4Info(sink, ((WifiEvent.GotIpv4)event).getInfo());
            } else if (wifiEvent instanceof WifiEvent.GotIpv6) {
                this.serializeAccessPoint(((WifiEvent.GotIpv6)event).getAp(), sink);
                sink.write(IpAddress_jvmKt.getAddressBytes(((WifiEvent.GotIpv6)event).getIpv6()));
            } else if (wifiEvent instanceof WifiEvent.LostIpv4) {
                this.serializeAccessPoint(((WifiEvent.LostIpv4)event).getAp(), sink);
            } else if (wifiEvent instanceof WifiEvent.LostIpv6) {
                this.serializeAccessPoint(((WifiEvent.LostIpv6)event).getAp(), sink);
            } else if (!(Intrinsics.areEqual((Object)wifiEvent, (Object)WifiEvent.ScanFinished.INSTANCE) || Intrinsics.areEqual((Object)wifiEvent, (Object)WifiEvent.ScanStarted.INSTANCE) || Intrinsics.areEqual((Object)wifiEvent, (Object)WifiEvent.Unknown.INSTANCE))) {
                throw new NoWhenBranchMatchedException();
            }
        }

        @NotNull
        public final WifiEvent deserializeWifiEvent(byte eventType, @NotNull BufferedSource source) {
            WifiEvent wifiEvent;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            byte by = eventType;
            if (by == WifiEvent.Type.ScanStarted.getByte()) {
                wifiEvent = WifiEvent.ScanStarted.INSTANCE;
            } else if (by == WifiEvent.Type.ScanFinished.getByte()) {
                wifiEvent = WifiEvent.ScanFinished.INSTANCE;
            } else if (by == WifiEvent.Type.AccessPointFound.getByte()) {
                wifiEvent = new WifiEvent.AccessPointFound(this.deserializeAccessPoint(source));
            } else if (by == WifiEvent.Type.Connected.getByte()) {
                wifiEvent = new WifiEvent.Connected(this.deserializeAccessPoint(source));
            } else if (by == WifiEvent.Type.Disconnected.getByte()) {
                wifiEvent = new WifiEvent.Disconnected(WifiDisconnectReason.Companion.fromByte(source.readByte()));
            } else if (by == WifiEvent.Type.GotIpv4.getByte()) {
                AccessPoint ap = this.deserializeAccessPoint(source);
                Ipv4Info info = this.deserializeIpv4Info(source);
                wifiEvent = new WifiEvent.GotIpv4(ap, info);
            } else if (by == WifiEvent.Type.LostIpv4.getByte()) {
                wifiEvent = new WifiEvent.LostIpv4(this.deserializeAccessPoint(source));
            } else if (by == WifiEvent.Type.GotIpv6.getByte()) {
                AccessPoint ap = this.deserializeAccessPoint(source);
                byte[] ip = source.readByteArray(16L);
                wifiEvent = new WifiEvent.GotIpv6(ap, Inet6AddressBuilder.INSTANCE.getByAddress(ip));
            } else {
                wifiEvent = by == WifiEvent.Type.LostIpv6.getByte() ? (WifiEvent)new WifiEvent.LostIpv6(this.deserializeAccessPoint(source)) : (WifiEvent)WifiEvent.Unknown.INSTANCE;
            }
            return wifiEvent;
        }

        public final void serializeRgbLedCmdMessage(@NotNull BufferedSink sink, @NotNull RgbLedExecuteCmd message2) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            sink.writeByte(message2.getCommands().size());
            sink.writeByte(18);
            for (RgbLedCmd cmd : message2.getCommands()) {
                sink.writeByte(cmd.getColor().getR-w2LRezQ() & 0xFF);
                sink.writeByte(cmd.getColor().getG-w2LRezQ() & 0xFF);
                sink.writeByte(cmd.getColor().getB-w2LRezQ() & 0xFF);
                sink.writeByte((int)cmd.getTransition().getTransitionByte());
                sink.writeInt(cmd.getTransitionTimeMs());
                sink.writeByte((int)cmd.getEffect().getEffectByte());
                sink.writeInt(cmd.getEffectPeriodMs());
                sink.writeByte(cmd.getRepeat() ? 1 : 0);
                sink.writeInt(cmd.getRepeatTimes());
            }
        }

        @NotNull
        public final Object deserializeRgbLedCmdMessage-IoAF18A(@NotNull BufferedSource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int listSize = source.readByte();
            byte elementSize = source.readByte();
            ArrayList<RgbLedCmd> arrayList = new ArrayList<RgbLedCmd>(listSize);
            for (int i = 0; i < listSize; ++i) {
                int n;
                int n2 = n = i;
                ArrayList<RgbLedCmd> arrayList2 = arrayList;
                boolean bl = false;
                int bytesRead = 0;
                byte r = source.readByte();
                byte g = source.readByte();
                byte b = source.readByte();
                bytesRead += 3;
                byte transitionByte = source.readByte();
                int transitionTimeMs = source.readInt();
                bytesRead += 5;
                byte effectByte = source.readByte();
                int effectPeriodMs = source.readInt();
                bytesRead += 5;
                boolean repeat = source.readByte() != 0;
                int repeatTimes = source.readInt();
                source.skip((long)(elementSize - (bytesRead += 5)));
                RgbColor color = new RgbColor(UByte.constructor-impl((byte)r), UByte.constructor-impl((byte)g), UByte.constructor-impl((byte)b), null);
                RgbTransition transition = RgbTransition.Companion.fromByte(transitionByte);
                RgbEffect effect = RgbEffect.Companion.fromByte(effectByte);
                arrayList2.add(new RgbLedCmd(color, transition, transitionTimeMs, effect, effectPeriodMs, repeat, repeatTimes));
            }
            List commands = arrayList;
            return Result.constructor-impl((Object)new RgbLedExecuteCmd(commands));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[OptionalDataType.values().length];
                try {
                    nArray[OptionalDataType.TIMESTAMP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptionalDataType.UNKNOWN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[WifiAuthMode.values().length];
                try {
                    nArray[WifiAuthMode.Open.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WifiAuthMode.Wep.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WifiAuthMode.WpaPsk.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WifiAuthMode.Wpa2Psk.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WifiAuthMode.WpaWpa2Psk.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WifiAuthMode.Wpa3Psk.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WifiAuthMode.Wpa2Wpa3Psk.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WifiAuthMode.WapiPsk.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WifiAuthMode.Wpa2Enterprise.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WifiAuthMode.Unsupported.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MessageType.values().length];
            try {
                nArray[MessageType.Ack.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Nack.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.MyInfo.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StartAcquisition.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StopAcquisition.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.EcgData.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StartNibpProcedure.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgData.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgStartCalibration.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgDiagnosis.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.NibpData.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.TempData.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.CapnoData.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.WifiEvent.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.WifiStatus.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.WifiConfiguration.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.ButtonEvent.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.OtaStart.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.OtaChunk.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.OtaAbort.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.OtaCommit.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.OtaAckChunk.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PersistenceKeys.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PersistenceGetValue.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PersistenceSetValue.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PersistenceValue.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.BatteryInfo.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.RawBatteryInfo.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SetFriendlyName.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.FriendlyName.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SetSerialNumber.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SerialNumber.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.EcgPadsControl.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.EcgPadsStatus.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Ping.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Pong.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetInfo.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StopAll.ordinal()] = 38;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StopNibp.ordinal()] = 39;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetBatteryInfo.ordinal()] = 40;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetRawBatteryInfo.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetFriendlyName.ordinal()] = 42;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetSerialNumber.ordinal()] = 43;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.NibpEvent.ordinal()] = 44;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StartNibpCalibration.ordinal()] = 45;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.NibpCalibrationParameters.ordinal()] = 46;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetNibpCalibrationParameters.ordinal()] = 47;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SetNibpCalibrationParameters.ordinal()] = 48;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SetNibpCalibrationPressure.ordinal()] = 49;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgGetDiagnosis.ordinal()] = 50;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgGetParameters.ordinal()] = 51;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgParameters.ordinal()] = 52;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.EcgGetPadsStatus.ordinal()] = 53;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PersistenceGetKeys.ordinal()] = 54;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.WifiConnect.ordinal()] = 55;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.WifiDisconnect.ordinal()] = 56;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.WifiStartScan.ordinal()] = 57;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.WifiStopScan.ordinal()] = 58;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.WifiGetStatus.ordinal()] = 59;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.WifiGetConfiguration.ordinal()] = 60;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.RgbLedExecuteCmd.ordinal()] = 61;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PpgSetParameters.ordinal()] = 62;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PersistenceType.values().length];
            try {
                nArray[PersistenceType.Unknown.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PersistenceType.Integer.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PersistenceType.String.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

