/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.mdns;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.mdns.DnsMessage;
import vet.inpulse.libcomm.core.mdns.DnsRecordsKt;
import vet.inpulse.libcomm.core.mdns.MdnsDefs;
import vet.inpulse.libcomm.core.mdns.MdnsMessage;
import vet.inpulse.libcomm.core.mdns.MdnsSocket;
import vet.inpulse.libcomm.core.network.NetworkInterfaceUtils;
import vet.inpulse.shared.log.LoggerInterface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0002;<B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020(J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020!0*J\u0006\u0010+\u001a\u00020,J\u0018\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u000200H\u0002J\u001c\u00101\u001a\u000202*\u0002032\u0006\u0010$\u001a\u00020%2\u0006\u00104\u001a\u00020(H\u0002J \u00105\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(06*\u0002032\u0006\u00107\u001a\u000202H\u0002J\u0006\u00108\u001a\u00020#J\b\u00109\u001a\u0004\u0018\u00010:R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u00108B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R/\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00188B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0017\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lvet/inpulse/libcomm/core/mdns/MdnsSocket;", "", "port", "", "replay", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "<init>", "(IILkotlinx/coroutines/CoroutineDispatcher;)V", "getPort", "()I", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<set-?>", "Lkotlinx/coroutines/Job;", "receiveJob", "getReceiveJob", "()Lkotlinx/coroutines/Job;", "setReceiveJob", "(Lkotlinx/coroutines/Job;)V", "receiveJob$delegate", "Lkotlinx/atomicfu/AtomicRef;", "Lvet/inpulse/libcomm/core/mdns/MdnsSocket$SocketAndInterfaces;", "socket", "getSocket", "()Lvet/inpulse/libcomm/core/mdns/MdnsSocket$SocketAndInterfaces;", "setSocket", "(Lvet/inpulse/libcomm/core/mdns/MdnsSocket$SocketAndInterfaces;)V", "socket$delegate", "receivedMessages", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lvet/inpulse/libcomm/core/mdns/MdnsMessage;", "broadcastMessage", "", "message", "Lvet/inpulse/libcomm/core/mdns/DnsMessage;", "sendMessageTo", "to", "Ljava/net/InetSocketAddress;", "receiveMessage", "Lkotlinx/coroutines/flow/SharedFlow;", "open", "", "receiveMessages", "parentJob", "s", "Ljava/net/MulticastSocket;", "sendDnsMessage", "", "Ljava/net/DatagramSocket;", "address", "receiveDnsResponse", "Lkotlin/Pair;", "receiveBuffer", "close", "localSocketAddress", "Ljava/net/SocketAddress;", "SocketAndInterfaces", "Companion", "libcomm"})
@SourceDebugExtension(value={"SMAP\nMdnsSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MdnsSocket.kt\nvet/inpulse/libcomm/core/mdns/MdnsSocket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1869#2,2:177\n*S KotlinDebug\n*F\n+ 1 MdnsSocket.kt\nvet/inpulse/libcomm/core/mdns/MdnsSocket\n*L\n97#1:177,2\n*E\n"})
public final class MdnsSocket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int port;
    @NotNull
    private final LoggerInterface logger;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AtomicRef receiveJob$delegate;
    @NotNull
    private final AtomicRef socket$delegate;
    @NotNull
    private final MutableSharedFlow<MdnsMessage> receivedMessages;
    @NotNull
    private static final InetSocketAddress MDNS_ADDRESS = new InetSocketAddress(MdnsDefs.INSTANCE.getMDNS_IPv4_IP(), 5353);

    public MdnsSocket(int port, int replay, @NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.port = port;
        this.logger = InPulseLoggerKt.getLibcommLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)dispatcher));
        this.receiveJob$delegate = AtomicFU.atomic(null);
        this.socket$delegate = AtomicFU.atomic(null);
        this.receivedMessages = SharedFlowKt.MutableSharedFlow$default((int)replay, (int)0, null, (int)6, null);
    }

    public /* synthetic */ MdnsSocket(int n, int n2, CoroutineDispatcher coroutineDispatcher, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 5353;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        if ((n3 & 4) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        this(n, n2, coroutineDispatcher);
    }

    public final int getPort() {
        return this.port;
    }

    private final Job getReceiveJob() {
        AtomicRef atomicRef = this.receiveJob$delegate;
        return (Job)atomicRef.getValue();
    }

    private final void setReceiveJob(Job job2) {
        AtomicRef atomicRef = this.receiveJob$delegate;
        atomicRef.setValue((Object)job2);
    }

    private final SocketAndInterfaces getSocket() {
        AtomicRef atomicRef = this.socket$delegate;
        return (SocketAndInterfaces)atomicRef.getValue();
    }

    private final void setSocket(SocketAndInterfaces socketAndInterfaces) {
        AtomicRef atomicRef = this.socket$delegate;
        atomicRef.setValue((Object)socketAndInterfaces);
    }

    public final void broadcastMessage(@NotNull DnsMessage message2) {
        block1: {
            SocketAndInterfaces socketAndInterfaces;
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            SocketAndInterfaces socketAndInterfaces2 = this.getSocket();
            if (socketAndInterfaces2 == null) break block1;
            SocketAndInterfaces socketAndInterfaces3 = socketAndInterfaces = socketAndInterfaces2;
            boolean bl = false;
            MulticastSocket s = socketAndInterfaces3.component1();
            List<NetworkInterface> ifs = socketAndInterfaces3.component2();
            for (NetworkInterface i : ifs) {
                s.setNetworkInterface(i);
                this.sendDnsMessage(s, message2, MDNS_ADDRESS);
            }
        }
    }

    public final void sendMessageTo(@NotNull DnsMessage message2, @NotNull InetSocketAddress to) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Object object = this.getSocket();
            if (object == null || (object = ((SocketAndInterfaces)object).getSocket()) == null) break block0;
            this.sendDnsMessage((DatagramSocket)object, message2, to);
        }
    }

    @NotNull
    public final SharedFlow<MdnsMessage> receiveMessage() {
        return (SharedFlow)this.receivedMessages;
    }

    public final boolean open() {
        if (this.getReceiveJob() != null) {
            return false;
        }
        try {
            MulticastSocket multicastSocket;
            List<NetworkInterface> ifaces = NetworkInterfaceUtils.INSTANCE.getValidIPv4Interfaces();
            InetAddress ip = null;
            InetSocketAddress addr = new InetSocketAddress(ip, this.port);
            MulticastSocket socket = multicastSocket = new MulticastSocket(addr);
            boolean bl = false;
            Iterable $this$forEach$iv = ifaces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NetworkInterface it = (NetworkInterface)element$iv;
                boolean bl2 = false;
                socket.joinGroup(MDNS_ADDRESS, it);
            }
            MulticastSocket s = multicastSocket;
            this.logger.d(() -> MdnsSocket.open$lambda$3(s));
            this.setSocket(new SocketAndInterfaces(s, ifaces));
            CompletableJob newJob = JobKt.Job$default(null, (int)1, null);
            this.setReceiveJob(this.receiveMessages((Job)newJob, s));
            return true;
        }
        catch (Exception e) {
            this.logger.e((Throwable)e, MdnsSocket::open$lambda$4);
            return false;
        }
    }

    private final Job receiveMessages(Job parentJob, MulticastSocket s) {
        return BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)parentJob), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(s, this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MulticastSocket $s;
            final /* synthetic */ MdnsSocket this$0;
            {
                this.$s = $s;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                void $this$launch;
                Object object;
                DnsMessage message2;
                InetSocketAddress from;
                int n;
                MulticastSocket socket;
                Throwable throwable;
                MulticastSocket multicastSocket;
                MdnsSocket mdnsSocket;
                Closeable closeable;
                byte[] receiveBuffer;
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        receiveBuffer = new byte[2048];
                        closeable = this.$s;
                        mdnsSocket = this.this$0;
                        multicastSocket = this.$s;
                        throwable = null;
                        socket = (MulticastSocket)closeable;
                        n = 0;
                        break;
                    }
                    case 1: {
                        n = this.I$0;
                        from = (InetSocketAddress)this.L$7;
                        message2 = (DnsMessage)this.L$6;
                        socket = (MulticastSocket)this.L$5;
                        throwable = null;
                        multicastSocket = (MulticastSocket)this.L$4;
                        mdnsSocket = (MdnsSocket)this.L$3;
                        closeable = (Closeable)this.L$2;
                        receiveBuffer = (byte[])this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object = $result;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                throw throwable3;
                            }
                        }
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                    try {
                        Pair pair = MdnsSocket.access$receiveDnsResponse(mdnsSocket, socket, receiveBuffer);
                        message2 = (DnsMessage)pair.component1();
                        from = (InetSocketAddress)pair.component2();
                        MdnsSocket.access$getLogger$p(mdnsSocket).d(() -> receiveMessages.1.invokeSuspend$lambda$3$lambda$0(multicastSocket, from));
                        LoggerInterface.t$default((LoggerInterface)MdnsSocket.access$getLogger$p(mdnsSocket), null, () -> receiveMessages.1.invokeSuspend$lambda$3$lambda$1(message2), (int)1, null);
                        this.L$0 = $this$launch;
                        this.L$1 = receiveBuffer;
                        this.L$2 = closeable;
                        this.L$3 = mdnsSocket;
                        this.L$4 = multicastSocket;
                        this.L$5 = socket;
                        this.L$6 = SpillingKt.nullOutSpilledVariable((Object)message2);
                        this.L$7 = SpillingKt.nullOutSpilledVariable((Object)from);
                        this.I$0 = n;
                        this.label = 1;
                        object = MdnsSocket.access$getReceivedMessages$p(mdnsSocket).emit((Object)new MdnsMessage(message2, from), (Continuation)this);
                        if (object != object2) continue;
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                    }
                    catch (SocketException socketException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (Exception e) {
                        MdnsSocket.access$getLogger$p(mdnsSocket).v(() -> receiveMessages.1.invokeSuspend$lambda$3$lambda$2(e));
                    }
                    return object2;
                }
                Unit unit = Unit.INSTANCE;
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$3$lambda$0(MulticastSocket $s, InetSocketAddress $from) {
                return "Socket: " + $s.getLocalSocketAddress() + ": Received mDNS packet from address " + $from + ".";
            }

            private static final String invokeSuspend$lambda$3$lambda$1(DnsMessage $message) {
                return "RX <<< " + $message;
            }

            private static final String invokeSuspend$lambda$3$lambda$2(Exception $e) {
                return "mDNS message parse error: " + $e;
            }
        }), (int)2, null);
    }

    private final byte[] sendDnsMessage(DatagramSocket $this$sendDnsMessage, DnsMessage message2, InetSocketAddress address) {
        Buffer buffer = new Buffer();
        DnsRecordsKt.serializeDnsMessage(message2, (BufferedSink)buffer);
        byte[] data = buffer.readByteArray();
        DatagramPacket dg = new DatagramPacket(data, data.length, address);
        LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> MdnsSocket.sendDnsMessage$lambda$5(address, data), (int)1, null);
        $this$sendDnsMessage.send(dg);
        return data;
    }

    private final Pair<DnsMessage, InetSocketAddress> receiveDnsResponse(DatagramSocket $this$receiveDnsResponse, byte[] receiveBuffer) {
        DatagramPacket receiveDg = new DatagramPacket(receiveBuffer, receiveBuffer.length);
        $this$receiveDnsResponse.receive(receiveDg);
        LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> MdnsSocket.receiveDnsResponse$lambda$6(receiveDg, receiveBuffer), (int)1, null);
        DnsMessage dnsResponse = DnsRecordsKt.deserializeDnsMessage(receiveBuffer, 0, receiveDg.getLength());
        SocketAddress socketAddress = receiveDg.getSocketAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        return TuplesKt.to((Object)dnsResponse, (Object)((InetSocketAddress)socketAddress));
    }

    public final void close() {
        block1: {
            this.logger.d(() -> MdnsSocket.close$lambda$7(this));
            Job job2 = this.getReceiveJob();
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            SocketAndInterfaces toClose = this.getSocket();
            this.setSocket(null);
            Object object = toClose;
            if (object == null || (object = ((SocketAndInterfaces)object).getSocket()) == null) break block1;
            ((DatagramSocket)object).close();
        }
    }

    @Nullable
    public final SocketAddress localSocketAddress() {
        Object object = this.getSocket();
        return object != null && (object = ((SocketAndInterfaces)object).getSocket()) != null ? ((DatagramSocket)object).getLocalSocketAddress() : null;
    }

    private static final String open$lambda$3(MulticastSocket $s) {
        return "Opened socket at " + $s.getLocalSocketAddress() + ".";
    }

    private static final String open$lambda$4() {
        return "Could not open MulticastSockets";
    }

    private static final String sendDnsMessage$lambda$5(InetSocketAddress $address, byte[] $data) {
        return "sending: " + $address + " -> " + HexExtensionsKt.toHexString$default((byte[])$data, null, (int)1, null);
    }

    private static final String receiveDnsResponse$lambda$6(DatagramPacket $receiveDg, byte[] $receiveBuffer) {
        return "received: " + $receiveDg.getSocketAddress() + " <- " + HexExtensionsKt.toHexString$default((byte[])$receiveBuffer, (int)0, (int)$receiveDg.getLength(), null, (int)5, null);
    }

    private static final String close$lambda$7(MdnsSocket this$0) {
        Object object = this$0.getSocket();
        return "Closing socket at " + (object != null && (object = ((SocketAndInterfaces)object).getSocket()) != null ? ((DatagramSocket)object).getLocalSocketAddress() : null) + ".";
    }

    public MdnsSocket() {
        this(0, 0, null, 7, null);
    }

    public static final /* synthetic */ Pair access$receiveDnsResponse(MdnsSocket $this, DatagramSocket $receiver, byte[] receiveBuffer) {
        return $this.receiveDnsResponse($receiver, receiveBuffer);
    }

    public static final /* synthetic */ LoggerInterface access$getLogger$p(MdnsSocket $this) {
        return $this.logger;
    }

    public static final /* synthetic */ MutableSharedFlow access$getReceivedMessages$p(MdnsSocket $this) {
        return $this.receivedMessages;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lvet/inpulse/libcomm/core/mdns/MdnsSocket$Companion;", "", "<init>", "()V", "MDNS_ADDRESS", "Ljava/net/InetSocketAddress;", "getMDNS_ADDRESS", "()Ljava/net/InetSocketAddress;", "libcomm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InetSocketAddress getMDNS_ADDRESS() {
            return MDNS_ADDRESS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lvet/inpulse/libcomm/core/mdns/MdnsSocket$SocketAndInterfaces;", "", "socket", "Ljava/net/MulticastSocket;", "ifaces", "", "Ljava/net/NetworkInterface;", "<init>", "(Ljava/net/MulticastSocket;Ljava/util/List;)V", "getSocket", "()Ljava/net/MulticastSocket;", "getIfaces", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "libcomm"})
    private static final class SocketAndInterfaces {
        @NotNull
        private final MulticastSocket socket;
        @NotNull
        private final List<NetworkInterface> ifaces;

        public SocketAndInterfaces(@NotNull MulticastSocket socket, @NotNull List<NetworkInterface> ifaces) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter(ifaces, (String)"ifaces");
            this.socket = socket;
            this.ifaces = ifaces;
        }

        @NotNull
        public final MulticastSocket getSocket() {
            return this.socket;
        }

        @NotNull
        public final List<NetworkInterface> getIfaces() {
            return this.ifaces;
        }

        @NotNull
        public final MulticastSocket component1() {
            return this.socket;
        }

        @NotNull
        public final List<NetworkInterface> component2() {
            return this.ifaces;
        }

        @NotNull
        public final SocketAndInterfaces copy(@NotNull MulticastSocket socket, @NotNull List<NetworkInterface> ifaces) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter(ifaces, (String)"ifaces");
            return new SocketAndInterfaces(socket, ifaces);
        }

        public static /* synthetic */ SocketAndInterfaces copy$default(SocketAndInterfaces socketAndInterfaces, MulticastSocket multicastSocket, List list, int n, Object object) {
            if ((n & 1) != 0) {
                multicastSocket = socketAndInterfaces.socket;
            }
            if ((n & 2) != 0) {
                list = socketAndInterfaces.ifaces;
            }
            return socketAndInterfaces.copy(multicastSocket, list);
        }

        @NotNull
        public String toString() {
            return "SocketAndInterfaces(socket=" + this.socket + ", ifaces=" + this.ifaces + ")";
        }

        public int hashCode() {
            int result2 = this.socket.hashCode();
            result2 = result2 * 31 + ((Object)this.ifaces).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SocketAndInterfaces)) {
                return false;
            }
            SocketAndInterfaces socketAndInterfaces = (SocketAndInterfaces)other;
            if (!Intrinsics.areEqual((Object)this.socket, (Object)socketAndInterfaces.socket)) {
                return false;
            }
            return Intrinsics.areEqual(this.ifaces, socketAndInterfaces.ifaces);
        }
    }
}

