/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.io.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicLong;
import okio.Buffer;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.io.IOOperator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\u0018\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lvet/inpulse/libcomm/core/io/socket/SocketOperator;", "Lvet/inpulse/libcomm/core/io/IOOperator;", "address", "Ljava/net/InetAddress;", "port", "", "<init>", "(Ljava/net/InetAddress;I)V", "getAddress", "()Ljava/net/InetAddress;", "getPort", "()I", "socket", "Ljava/net/Socket;", "getSocket", "()Ljava/net/Socket;", "setSocket", "(Ljava/net/Socket;)V", "sockSink", "Lokio/Sink;", "sockSource", "Lokio/Source;", "getInterface", "Lvet/inpulse/libcomm/core/io/IOOperator$Interface;", "open", "", "tryToWriteOnIO", "", "source", "Lokio/Buffer;", "byteCount", "", "flush", "tryToReadFromIO", "sink", "timeout", "Lokio/Timeout;", "close", "bytesReceived", "Lkotlinx/atomicfu/AtomicLong;", "isOpened", "()Z", "libcomm"})
public final class SocketOperator
extends IOOperator {
    @NotNull
    private final InetAddress address;
    private final int port;
    @Nullable
    private Socket socket;
    @Nullable
    private Sink sockSink;
    @Nullable
    private Source sockSource;
    @NotNull
    private final AtomicLong bytesReceived;

    public SocketOperator(@NotNull InetAddress address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.address = address;
        this.port = port;
        this.bytesReceived = AtomicFU.atomic((long)0L);
    }

    @NotNull
    public final InetAddress getAddress() {
        return this.address;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final Socket getSocket() {
        return this.socket;
    }

    public final void setSocket(@Nullable Socket socket) {
        this.socket = socket;
    }

    @Override
    @NotNull
    public IOOperator.Interface getInterface() {
        return IOOperator.Interface.SOCKET_TCP;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean open() {
        this.bytesReceived.setValue(0L);
        if (this.isOpened()) {
            return true;
        }
        try {
            void $this$open_u24lambda_u240;
            Socket socket;
            Socket socket2 = socket = new Socket(this.address, this.port);
            SocketOperator socketOperator = this;
            boolean bl = false;
            this.sockSink = Okio.sink((Socket)$this$open_u24lambda_u240);
            this.sockSource = Okio.source((Socket)$this$open_u24lambda_u240);
            socketOperator.socket = socket;
        }
        catch (IOException ex) {
            this.socket = null;
        }
        return this.socket != null;
    }

    @Override
    public void tryToWriteOnIO(@NotNull Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.setTotalBytesWritten(this.getTotalBytesWritten() + byteCount);
        Sink sink = this.sockSink;
        if (sink == null) {
            throw new IOException("Failed to write: Socket is already closed");
        }
        sink.write(source, byteCount);
    }

    public void flush() throws IOException {
        block0: {
            Sink sink = this.sockSink;
            if (sink == null) break block0;
            sink.flush();
        }
    }

    @Override
    public long tryToReadFromIO(@NotNull Buffer sink, long byteCount) {
        long read;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Source source = this.sockSource;
        long l = read = source != null ? source.read(sink, byteCount) : -1L;
        if (read > 0L) {
            this.setTotalBytesRead(this.getTotalBytesRead() + read);
        }
        return read;
    }

    @NotNull
    public Timeout timeout() {
        Source source = this.sockSource;
        if (source == null || (source = source.timeout()) == null) {
            throw new IOException("Socket is already closed");
        }
        return source;
    }

    @Override
    public void close() {
        if (this.isOpened()) {
            try {
                Sink sink = this.sockSink;
                if (sink != null) {
                    sink.flush();
                }
                Socket socket = this.socket;
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isOpened() {
        Socket socket = this.socket;
        return socket != null ? !socket.isClosed() : false;
    }
}

