/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.io;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import okio.Buffer;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.shared.log.LoggerInterface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00060\u0003j\u0002`\u0004:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\u000eH&J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\u0018\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H&J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H&R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006#"}, d2={"Lvet/inpulse/libcomm/core/io/IOOperator;", "Lokio/Source;", "Lokio/Sink;", "Ljava/io/Closeable;", "Lokio/Closeable;", "<init>", "()V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "getInterface", "Lvet/inpulse/libcomm/core/io/IOOperator$Interface;", "open", "", "close", "", "isOpened", "()Z", "totalBytesRead", "", "getTotalBytesRead", "()J", "setTotalBytesRead", "(J)V", "totalBytesWritten", "getTotalBytesWritten", "setTotalBytesWritten", "read", "sink", "Lokio/Buffer;", "byteCount", "tryToReadFromIO", "write", "source", "tryToWriteOnIO", "Interface", "libcomm"})
public abstract class IOOperator
implements Source,
Sink,
Closeable {
    @NotNull
    private final LoggerInterface logger = InPulseLoggerKt.getLibcommIoLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
    private long totalBytesRead;
    private long totalBytesWritten;

    @NotNull
    public abstract Interface getInterface();

    public abstract boolean open();

    @Override
    public abstract void close();

    public abstract boolean isOpened();

    public long getTotalBytesRead() {
        return this.totalBytesRead;
    }

    public void setTotalBytesRead(long l) {
        this.totalBytesRead = l;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    public void setTotalBytesWritten(long l) {
        this.totalBytesWritten = l;
    }

    public long read(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> IOOperator.read$lambda$0(byteCount, this), (int)1, null);
        long numBytesReadFromIO = 0L;
        while (this.isOpened() && numBytesReadFromIO == 0L) {
            long l;
            try {
                l = this.tryToReadFromIO(sink, byteCount);
            }
            catch (Exception ex) {
                this.logger.d(() -> IOOperator.read$lambda$1(ex));
                if (this.isOpened()) {
                    this.logger.w((Throwable)ex, () -> IOOperator.read$lambda$2(ex));
                    throw ex;
                }
                l = -1L;
            }
            numBytesReadFromIO = l;
        }
        return this.isOpened() ? numBytesReadFromIO : -1L;
    }

    public abstract long tryToReadFromIO(@NotNull Buffer var1, long var2);

    public void write(@NotNull Buffer source, long byteCount) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.logger.v(() -> IOOperator.write$lambda$3(byteCount, this));
            if (this.isOpened()) {
                try {
                    this.logger.v(IOOperator::write$lambda$4);
                    this.tryToWriteOnIO(source, byteCount);
                    this.logger.v(IOOperator::write$lambda$5);
                }
                catch (Exception ex) {
                    this.logger.d(() -> IOOperator.write$lambda$6(ex));
                    if (!this.isOpened()) break block3;
                    this.logger.w((Throwable)ex, () -> IOOperator.write$lambda$7(ex));
                    throw ex;
                }
            }
        }
    }

    public abstract void tryToWriteOnIO(@NotNull Buffer var1, long var2);

    private static final String read$lambda$0(long $byteCount, IOOperator this$0) {
        return "read(byteCount: " + $byteCount + "). isOpened: " + this$0.isOpened();
    }

    private static final String read$lambda$1(Exception $ex) {
        return "Failed to read from IO due to " + $ex.getMessage();
    }

    private static final String read$lambda$2(Exception $ex) {
        return "Failed to read from IO while it was opened due to " + $ex.getMessage() + ". This error will go downstream";
    }

    private static final String write$lambda$3(long $byteCount, IOOperator this$0) {
        return "write(byteCount: " + $byteCount + "). isOpened: " + this$0.isOpened();
    }

    private static final String write$lambda$4() {
        return "tryToWriteOnIO()";
    }

    private static final String write$lambda$5() {
        return "wrote on IO";
    }

    private static final String write$lambda$6(Exception $ex) {
        return "Failed to write on IO due to " + $ex.getMessage() + ".";
    }

    private static final String write$lambda$7(Exception $ex) {
        return "Failed to write on IO while opened due to " + $ex.getMessage() + ". This error will go downstream";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0013"}, d2={"Lvet/inpulse/libcomm/core/io/IOOperator$Interface;", "", "id", "", "<init>", "(Ljava/lang/String;II)V", "getId", "()I", "VIRTUAL", "USB_SERIAL", "USB_HID", "BLUETOOTH_DONGLE", "BLUETOOTH_NATIVE", "SOCKET_TCP", "USB_NATIVE", "isBluetooth", "", "()Z", "isUsb", "libcomm"})
    public static final class Interface
    extends Enum<Interface> {
        private final int id;
        public static final /* enum */ Interface VIRTUAL = new Interface(1);
        public static final /* enum */ Interface USB_SERIAL = new Interface(2);
        public static final /* enum */ Interface USB_HID = new Interface(3);
        public static final /* enum */ Interface BLUETOOTH_DONGLE = new Interface(4);
        public static final /* enum */ Interface BLUETOOTH_NATIVE = new Interface(5);
        public static final /* enum */ Interface SOCKET_TCP = new Interface(6);
        public static final /* enum */ Interface USB_NATIVE = new Interface(7);
        private static final /* synthetic */ Interface[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Interface(int id) {
            this.id = id;
        }

        public final int getId() {
            return this.id;
        }

        public final boolean isBluetooth() {
            return this == BLUETOOTH_NATIVE || this == BLUETOOTH_DONGLE;
        }

        public final boolean isUsb() {
            return this == USB_HID || this == USB_SERIAL || this == USB_NATIVE;
        }

        public static Interface[] values() {
            return (Interface[])$VALUES.clone();
        }

        public static Interface valueOf(String value) {
            return Enum.valueOf(Interface.class, value);
        }

        @NotNull
        public static EnumEntries<Interface> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = interfaceArray = new Interface[]{Interface.VIRTUAL, Interface.USB_SERIAL, Interface.USB_HID, Interface.BLUETOOTH_DONGLE, Interface.BLUETOOTH_NATIVE, Interface.SOCKET_TCP, Interface.USB_NATIVE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

