/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.device.virtual.processors;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import kotlin.time.ComparableTimeMark;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.device.data.converters.DataConvertersKt;
import vet.inpulse.libcomm.core.device.virtual.processors.MessageProcessor;
import vet.inpulse.libcomm.core.device.virtual.processors.NibpMessageProcessor;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.protocol.message.Ack;
import vet.inpulse.libcomm.core.protocol.message.GetNibpCalibrationParameters;
import vet.inpulse.libcomm.core.protocol.message.Message;
import vet.inpulse.libcomm.core.protocol.message.ModulePacket;
import vet.inpulse.libcomm.core.protocol.message.Nack;
import vet.inpulse.libcomm.core.protocol.message.NibpDataMessage;
import vet.inpulse.libcomm.core.protocol.message.NibpModuleSample;
import vet.inpulse.libcomm.core.protocol.message.SetNibpCalibrationParameters;
import vet.inpulse.libcomm.core.protocol.message.SetNibpCalibrationPressure;
import vet.inpulse.libcomm.core.protocol.message.StartNibp;
import vet.inpulse.libcomm.core.protocol.message.StartNibpCalibration;
import vet.inpulse.libcomm.core.protocol.message.StopNibp;
import vet.inpulse.libcomm.core.util.CoroutineOperatorsKt;
import vet.inpulse.libcomm.core.util.data_generator.NibpSampleGenerator;
import vet.inpulse.shared.log.LoggerInterface;
import vet.inpulse.shared.models.NibpProcedureRequest;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0017\u001a\u00020\u0018*\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u0004H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u000fH\u0002J\f\u0010\u001e\u001a\u00020\u001d*\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lvet/inpulse/libcomm/core/device/virtual/processors/NibpMessageProcessor;", "Lvet/inpulse/libcomm/core/device/virtual/processors/MessageProcessor;", "nibpGenerators", "", "Lvet/inpulse/libcomm/core/util/data_generator/NibpSampleGenerator;", "timeSource", "Lkotlin/time/TimeSource$WithComparableMarks;", "samplingFrequency", "", "<init>", "(Ljava/util/List;Lkotlin/time/TimeSource$WithComparableMarks;F)V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "output", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lvet/inpulse/libcomm/core/protocol/message/Message;", "getOutput", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "lock", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "job", "Lkotlinx/coroutines/Job;", "isNullOrInactive", "", "currentGeneratorIndex", "", "getNextGenerator", "ack", "", "nack", "processMessage", "message", "scope", "Lkotlinx/coroutines/CoroutineScope;", "startNewNibpProcedure", "request", "Lvet/inpulse/shared/models/NibpProcedureRequest;", "libcomm"})
public final class NibpMessageProcessor
implements MessageProcessor {
    @NotNull
    private final List<NibpSampleGenerator> nibpGenerators;
    @NotNull
    private final TimeSource.WithComparableMarks timeSource;
    private final float samplingFrequency;
    @NotNull
    private final LoggerInterface logger;
    @NotNull
    private final MutableSharedFlow<Message> output;
    @NotNull
    private final Object lock;
    @Nullable
    private Job job;
    private int currentGeneratorIndex;

    public NibpMessageProcessor(@NotNull List<? extends NibpSampleGenerator> nibpGenerators, @NotNull TimeSource.WithComparableMarks timeSource, float samplingFrequency) {
        Intrinsics.checkNotNullParameter(nibpGenerators, (String)"nibpGenerators");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        this.nibpGenerators = nibpGenerators;
        this.timeSource = timeSource;
        this.samplingFrequency = samplingFrequency;
        this.logger = InPulseLoggerKt.getLibcommLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.output = SharedFlowKt.MutableSharedFlow$default((int)0, (int)2048, null, (int)5, null);
        this.lock = new Object();
    }

    public /* synthetic */ NibpMessageProcessor(List list, TimeSource.WithComparableMarks withComparableMarks, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            withComparableMarks = (TimeSource.WithComparableMarks)TimeSource.Monotonic.INSTANCE;
        }
        if ((n & 4) != 0) {
            f = 600.0f;
        }
        this(list, withComparableMarks, f);
    }

    @NotNull
    public MutableSharedFlow<Message> getOutput() {
        return this.output;
    }

    private final boolean isNullOrInactive(Job $this$isNullOrInactive) {
        return $this$isNullOrInactive == null || !$this$isNullOrInactive.isActive();
    }

    private final NibpSampleGenerator getNextGenerator() {
        int n = this.currentGeneratorIndex;
        this.currentGeneratorIndex = n + 1;
        NibpSampleGenerator gen = this.nibpGenerators.get(n);
        if (this.currentGeneratorIndex >= this.nibpGenerators.size()) {
            this.currentGeneratorIndex = 0;
        }
        return gen;
    }

    private final void ack(Message $this$ack) {
        this.getOutput().tryEmit((Object)new Ack($this$ack.getType()));
    }

    private final void nack(Message $this$nack) {
        this.getOutput().tryEmit((Object)new Nack($this$nack.getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(@NotNull Message message2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Message message3 = message2;
        if (Intrinsics.areEqual((Object)message3, (Object)GetNibpCalibrationParameters.INSTANCE)) {
            this.nack(message2);
        } else if (message3 instanceof StartNibp) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                this.logger.d(NibpMessageProcessor::processMessage$lambda$1$lambda$0);
                if (this.isNullOrInactive(this.job)) {
                    this.ack(message2);
                    this.job = this.startNewNibpProcedure(scope, DataConvertersKt.toDeviceData((StartNibp)message2));
                } else {
                    this.nack(message2);
                }
                Unit unit = Unit.INSTANCE;
            }
        } else if (Intrinsics.areEqual((Object)message3, (Object)StartNibpCalibration.INSTANCE)) {
            this.nack(message2);
        } else if (Intrinsics.areEqual((Object)message3, (Object)StopNibp.INSTANCE)) {
            Job job2 = this.job;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            this.job = null;
        } else if (message3 instanceof SetNibpCalibrationParameters) {
            this.nack(message2);
        } else if (message3 instanceof SetNibpCalibrationPressure) {
            this.nack(message2);
        }
    }

    private final Job startNewNibpProcedure(CoroutineScope scope, NibpProcedureRequest request) {
        return BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int I$0;
            long J$0;
            int label;
            final /* synthetic */ NibpMessageProcessor this$0;
            final /* synthetic */ NibpProcedureRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        NibpSampleGenerator generator = NibpMessageProcessor.access$getNextGenerator(this.this$0);
                        NibpMessageProcessor.access$getLogger$p(this.this$0).d(() -> startNewNibpProcedure.1.invokeSuspend$lambda$0(generator, this.this$0));
                        generator.requestNibpProcedure(this.$request);
                        int numSamplesPerPacket = 10;
                        Ref.IntRef sampleId = new Ref.IntRef();
                        Ref.BooleanRef finished = new Ref.BooleanRef();
                        long packetTs = MathKt.roundToLong((double)(1000000.0 / (double)NibpMessageProcessor.access$getSamplingFrequency$p(this.this$0) * (double)numSamplesPerPacket));
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)generator);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)sampleId);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)finished);
                        this.I$0 = numSamplesPerPacket;
                        this.J$0 = packetTs;
                        this.label = 1;
                        Object object2 = FlowKt.takeWhile((Flow)CoroutineOperatorsKt.timeInterval-NqJ4yvY$default(DurationKt.toDuration((long)packetTs, (DurationUnit)DurationUnit.MICROSECONDS), 0L, NibpMessageProcessor.access$getTimeSource$p(this.this$0), 2, null), (Function2)((Function2)new Function2<ComparableTimeMark, Continuation<? super Boolean>, Object>(finished, null){
                            int label;
                            final /* synthetic */ Ref.BooleanRef $finished;
                            {
                                this.$finished = $finished;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        return Boxing.boxBoolean((!this.$finished.element ? 1 : 0) != 0);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(ComparableTimeMark p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        })).collect(new FlowCollector(numSamplesPerPacket, sampleId, this.this$0, generator, finished){
                            final /* synthetic */ int $numSamplesPerPacket;
                            final /* synthetic */ Ref.IntRef $sampleId;
                            final /* synthetic */ NibpMessageProcessor this$0;
                            final /* synthetic */ NibpSampleGenerator $generator;
                            final /* synthetic */ Ref.BooleanRef $finished;
                            {
                                this.$numSamplesPerPacket = $numSamplesPerPacket;
                                this.$sampleId = $sampleId;
                                this.this$0 = $receiver;
                                this.$generator = $generator;
                                this.$finished = $finished;
                            }

                            public final Object emit(ComparableTimeMark it, Continuation<? super Unit> $completion) {
                                ArrayList<NibpModuleSample> arrayList = new ArrayList<NibpModuleSample>(this.$numSamplesPerPacket);
                                int n = this.$numSamplesPerPacket;
                                NibpSampleGenerator nibpSampleGenerator = this.$generator;
                                Ref.BooleanRef booleanRef = this.$finished;
                                ArrayList<NibpModuleSample> $this$emit_u24lambda_u240 = arrayList;
                                boolean bl = false;
                                for (int i = 0; i < n; ++i) {
                                    NibpModuleSample sample = (NibpModuleSample)nibpSampleGenerator.nextSample();
                                    if (sample == null) {
                                        booleanRef.element = true;
                                        break;
                                    }
                                    $this$emit_u24lambda_u240.add(sample);
                                }
                                ArrayList<NibpModuleSample> samples = arrayList;
                                ModulePacket<NibpModuleSample> packet = new ModulePacket<NibpModuleSample>(this.$sampleId.element, (List)samples, null);
                                this.$sampleId.element += samples.size();
                                this.this$0.getOutput().tryEmit((Object)new NibpDataMessage(packet));
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        long packetTs = this.J$0;
                        int numSamplesPerPacket = this.I$0;
                        Ref.BooleanRef finished = (Ref.BooleanRef)this.L$2;
                        Ref.IntRef sampleId = (Ref.IntRef)this.L$1;
                        NibpSampleGenerator generator = (NibpSampleGenerator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(NibpSampleGenerator $generator, NibpMessageProcessor this$0) {
                return "Starting a new nibp procedure with generator " + $generator + " (" + NibpMessageProcessor.access$getCurrentGeneratorIndex$p(this$0) + ")";
            }
        }), (int)3, null);
    }

    private static final String processMessage$lambda$1$lambda$0() {
        return "StartNibp called";
    }

    public static final /* synthetic */ NibpSampleGenerator access$getNextGenerator(NibpMessageProcessor $this) {
        return $this.getNextGenerator();
    }

    public static final /* synthetic */ LoggerInterface access$getLogger$p(NibpMessageProcessor $this) {
        return $this.logger;
    }

    public static final /* synthetic */ float access$getSamplingFrequency$p(NibpMessageProcessor $this) {
        return $this.samplingFrequency;
    }

    public static final /* synthetic */ TimeSource.WithComparableMarks access$getTimeSource$p(NibpMessageProcessor $this) {
        return $this.timeSource;
    }

    public static final /* synthetic */ int access$getCurrentGeneratorIndex$p(NibpMessageProcessor $this) {
        return $this.currentGeneratorIndex;
    }
}

