/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.device.virtual.processors;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.device.virtual.VirtualDevicesUtilsKt;
import vet.inpulse.libcomm.core.device.virtual.processors.MessageProcessor;
import vet.inpulse.libcomm.core.protocol.message.Ack;
import vet.inpulse.libcomm.core.protocol.message.DeviceStreamModule;
import vet.inpulse.libcomm.core.protocol.message.EcgDataMessage;
import vet.inpulse.libcomm.core.protocol.message.EcgModuleSample;
import vet.inpulse.libcomm.core.protocol.message.Message;
import vet.inpulse.libcomm.core.protocol.message.ModuleConfig;
import vet.inpulse.libcomm.core.protocol.message.ModulePacket;
import vet.inpulse.libcomm.core.protocol.message.Nack;
import vet.inpulse.libcomm.core.protocol.message.PpgDataMessage;
import vet.inpulse.libcomm.core.protocol.message.PpgGetDiagnosis;
import vet.inpulse.libcomm.core.protocol.message.PpgGetParameters;
import vet.inpulse.libcomm.core.protocol.message.PpgModuleSample;
import vet.inpulse.libcomm.core.protocol.message.PpgSetParameters;
import vet.inpulse.libcomm.core.protocol.message.PpgStartCalibration;
import vet.inpulse.libcomm.core.protocol.message.SetEcgGain;
import vet.inpulse.libcomm.core.protocol.message.StartAcquisition;
import vet.inpulse.libcomm.core.protocol.message.StopAcquisition;
import vet.inpulse.libcomm.core.protocol.message.StopAll;
import vet.inpulse.libcomm.core.protocol.message.TempDataMessage;
import vet.inpulse.libcomm.core.protocol.message.TempModuleSample;
import vet.inpulse.libcomm.core.util.data_generator.SampleGenerator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00020\u0018*\u0004\u0018\u00010\u0013H\u0002J\f\u0010\u0019\u001a\u00020\u0015*\u00020\rH\u0002J\f\u0010\u001a\u001a\u00020\u0015*\u00020\rH\u0002J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lvet/inpulse/libcomm/core/device/virtual/processors/InMonitorV2BasicStreamsMessageProcessor;", "Lvet/inpulse/libcomm/core/device/virtual/processors/MessageProcessor;", "ecgSampleGenerator", "Lvet/inpulse/libcomm/core/util/data_generator/SampleGenerator;", "Lvet/inpulse/libcomm/core/protocol/message/EcgModuleSample;", "ppgSampleGenerator", "Lvet/inpulse/libcomm/core/protocol/message/PpgModuleSample;", "tempSampleGenerator", "Lvet/inpulse/libcomm/core/protocol/message/TempModuleSample;", "<init>", "(Lvet/inpulse/libcomm/core/util/data_generator/SampleGenerator;Lvet/inpulse/libcomm/core/util/data_generator/SampleGenerator;Lvet/inpulse/libcomm/core/util/data_generator/SampleGenerator;)V", "output", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lvet/inpulse/libcomm/core/protocol/message/Message;", "getOutput", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "basicStreamJobs", "", "Lvet/inpulse/libcomm/core/protocol/message/DeviceStreamModule;", "Lkotlinx/coroutines/Job;", "cancelJob", "", "module", "isNullOrInactive", "", "ack", "nack", "processMessage", "message", "scope", "Lkotlinx/coroutines/CoroutineScope;", "startDefaultStreams", "moduleConfigs", "", "Lvet/inpulse/libcomm/core/protocol/message/ModuleConfig;", "Companion", "libcomm"})
@SourceDebugExtension(value={"SMAP\nInMonitorV2BasicStreamsMessageProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMonitorV2BasicStreamsMessageProcessor.kt\nvet/inpulse/libcomm/core/device/virtual/processors/InMonitorV2BasicStreamsMessageProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1869#2,2:147\n1869#2,2:149\n1869#2,2:151\n*S KotlinDebug\n*F\n+ 1 InMonitorV2BasicStreamsMessageProcessor.kt\nvet/inpulse/libcomm/core/device/virtual/processors/InMonitorV2BasicStreamsMessageProcessor\n*L\n71#1:147,2\n81#1:149,2\n104#1:151,2\n*E\n"})
public final class InMonitorV2BasicStreamsMessageProcessor
implements MessageProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SampleGenerator<EcgModuleSample> ecgSampleGenerator;
    @NotNull
    private final SampleGenerator<PpgModuleSample> ppgSampleGenerator;
    @NotNull
    private final SampleGenerator<TempModuleSample> tempSampleGenerator;
    @NotNull
    private final MutableSharedFlow<Message> output;
    @NotNull
    private final Map<DeviceStreamModule, Job> basicStreamJobs;
    @NotNull
    private static final String TAG = "InMonitorV2MessageProcessor";

    public InMonitorV2BasicStreamsMessageProcessor(@NotNull SampleGenerator<EcgModuleSample> ecgSampleGenerator, @NotNull SampleGenerator<PpgModuleSample> ppgSampleGenerator, @NotNull SampleGenerator<TempModuleSample> tempSampleGenerator) {
        Intrinsics.checkNotNullParameter(ecgSampleGenerator, (String)"ecgSampleGenerator");
        Intrinsics.checkNotNullParameter(ppgSampleGenerator, (String)"ppgSampleGenerator");
        Intrinsics.checkNotNullParameter(tempSampleGenerator, (String)"tempSampleGenerator");
        this.ecgSampleGenerator = ecgSampleGenerator;
        this.ppgSampleGenerator = ppgSampleGenerator;
        this.tempSampleGenerator = tempSampleGenerator;
        this.output = SharedFlowKt.MutableSharedFlow$default((int)0, (int)2048, null, (int)5, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)DeviceStreamModule.ECG), null), TuplesKt.to((Object)((Object)DeviceStreamModule.PPG), null), TuplesKt.to((Object)((Object)DeviceStreamModule.TEMPERATURE), null)};
        this.basicStreamJobs = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @NotNull
    public MutableSharedFlow<Message> getOutput() {
        return this.output;
    }

    private final void cancelJob(DeviceStreamModule module) {
        Job job2 = this.basicStreamJobs.get((Object)module);
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.basicStreamJobs.put(module, null);
    }

    private final boolean isNullOrInactive(Job $this$isNullOrInactive) {
        return $this$isNullOrInactive == null || !$this$isNullOrInactive.isActive();
    }

    private final void ack(Message $this$ack) {
        this.getOutput().tryEmit((Object)new Ack($this$ack.getType()));
    }

    private final void nack(Message $this$nack) {
        this.getOutput().tryEmit((Object)new Nack($this$nack.getType()));
    }

    @Override
    public void processMessage(@NotNull Message message2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Message message3 = message2;
        if (message3 instanceof StartAcquisition) {
            this.startDefaultStreams(scope, ((StartAcquisition)message2).getModuleConfigs());
            this.ack(message2);
        } else if (message3 instanceof StopAcquisition) {
            Iterable $this$forEach$iv = ((StopAcquisition)message2).getModules();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DeviceStreamModule module = (DeviceStreamModule)((Object)element$iv);
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[module.ordinal()]) {
                    case 1: {
                        this.cancelJob(DeviceStreamModule.ECG);
                        break;
                    }
                    case 2: {
                        this.cancelJob(DeviceStreamModule.PPG);
                        break;
                    }
                    case 3: {
                        this.cancelJob(DeviceStreamModule.TEMPERATURE);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            this.ack(message2);
        } else if (message3 instanceof StopAll) {
            Iterable $this$forEach$iv = (Iterable)DeviceStreamModule.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DeviceStreamModule it = (DeviceStreamModule)((Object)element$iv);
                boolean bl = false;
                this.cancelJob(it);
            }
            this.ack(message2);
        } else if (message3 instanceof SetEcgGain) {
            this.ack(message2);
        } else if (message3 instanceof PpgStartCalibration) {
            this.nack(message2);
        } else if (Intrinsics.areEqual((Object)message3, (Object)PpgGetDiagnosis.INSTANCE)) {
            this.nack(message2);
        } else if (Intrinsics.areEqual((Object)message3, (Object)PpgGetParameters.INSTANCE)) {
            this.nack(message2);
        } else if (message3 instanceof PpgSetParameters) {
            this.nack(message2);
        }
    }

    private final void startDefaultStreams(CoroutineScope scope, List<? extends ModuleConfig> moduleConfigs) {
        Iterable $this$forEach$iv = moduleConfigs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleConfig config = (ModuleConfig)element$iv;
            boolean bl = false;
            ModuleConfig moduleConfig = config;
            if (moduleConfig instanceof ModuleConfig.Ecg) {
                if (!this.isNullOrInactive(this.basicStreamJobs.get((Object)DeviceStreamModule.ECG))) continue;
                this.basicStreamJobs.put(DeviceStreamModule.ECG, VirtualDevicesUtilsKt.startPacketGeneratorInterval(scope, ((ModuleConfig.Ecg)config).getSamplingRate().getNominal(), 20, this.ecgSampleGenerator, arg_0 -> InMonitorV2BasicStreamsMessageProcessor.startDefaultStreams$lambda$5$lambda$2(this, arg_0)));
                continue;
            }
            if (moduleConfig instanceof ModuleConfig.Ppg) {
                if (!this.isNullOrInactive(this.basicStreamJobs.get((Object)DeviceStreamModule.PPG))) continue;
                this.basicStreamJobs.put(DeviceStreamModule.PPG, VirtualDevicesUtilsKt.startPacketGeneratorInterval(scope, ((ModuleConfig.Ppg)config).getSamplingRate().getNominal(), 20, this.ppgSampleGenerator, arg_0 -> InMonitorV2BasicStreamsMessageProcessor.startDefaultStreams$lambda$5$lambda$3(this, arg_0)));
                continue;
            }
            if (moduleConfig instanceof ModuleConfig.Temperature) {
                if (!this.isNullOrInactive(this.basicStreamJobs.get((Object)DeviceStreamModule.TEMPERATURE))) continue;
                this.basicStreamJobs.put(DeviceStreamModule.TEMPERATURE, VirtualDevicesUtilsKt.startPacketGeneratorInterval(scope, ((ModuleConfig.Temperature)config).getSamplingRate().getNominal(), 1, this.tempSampleGenerator, arg_0 -> InMonitorV2BasicStreamsMessageProcessor.startDefaultStreams$lambda$5$lambda$4(this, arg_0)));
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final Unit startDefaultStreams$lambda$5$lambda$2(InMonitorV2BasicStreamsMessageProcessor this$0, ModulePacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getOutput().tryEmit((Object)new EcgDataMessage(it));
        return Unit.INSTANCE;
    }

    private static final Unit startDefaultStreams$lambda$5$lambda$3(InMonitorV2BasicStreamsMessageProcessor this$0, ModulePacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getOutput().tryEmit((Object)new PpgDataMessage(it));
        return Unit.INSTANCE;
    }

    private static final Unit startDefaultStreams$lambda$5$lambda$4(InMonitorV2BasicStreamsMessageProcessor this$0, ModulePacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getOutput().tryEmit((Object)new TempDataMessage(it));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lvet/inpulse/libcomm/core/device/virtual/processors/InMonitorV2BasicStreamsMessageProcessor$Companion;", "", "<init>", "()V", "TAG", "", "libcomm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeviceStreamModule.values().length];
            try {
                nArray[DeviceStreamModule.ECG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceStreamModule.PPG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceStreamModule.TEMPERATURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

