/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.device.virtual.processors;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.time.ComparableTimeMark;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.device.virtual.processors.MessageProcessor;
import vet.inpulse.libcomm.core.protocol.capno.AvailableCapabilities;
import vet.inpulse.libcomm.core.protocol.capno.CO2Unit;
import vet.inpulse.libcomm.core.protocol.capno.CO2Waveform;
import vet.inpulse.libcomm.core.protocol.capno.GetAvailableCapabilities;
import vet.inpulse.libcomm.core.protocol.capno.GetCurrentCapabilities;
import vet.inpulse.libcomm.core.protocol.capno.GetSensorSettings;
import vet.inpulse.libcomm.core.protocol.capno.RespironicsPacket;
import vet.inpulse.libcomm.core.protocol.capno.SensorCapabilityFlags;
import vet.inpulse.libcomm.core.protocol.capno.SensorSetting;
import vet.inpulse.libcomm.core.protocol.capno.StartCO2DataMode;
import vet.inpulse.libcomm.core.protocol.message.CapnoData;
import vet.inpulse.libcomm.core.protocol.message.Message;
import vet.inpulse.libcomm.core.protocol.message.StopAll;
import vet.inpulse.libcomm.core.util.CoroutineOperatorsKt;
import vet.inpulse.libcomm.core.util.data_generator.SampleGenerator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f*\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lvet/inpulse/libcomm/core/device/virtual/processors/CapnoMessageProcessor;", "Lvet/inpulse/libcomm/core/device/virtual/processors/MessageProcessor;", "capnoSampleGenerator", "Lvet/inpulse/libcomm/core/util/data_generator/SampleGenerator;", "Lvet/inpulse/libcomm/core/protocol/capno/RespironicsPacket;", "<init>", "(Lvet/inpulse/libcomm/core/util/data_generator/SampleGenerator;)V", "output", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lvet/inpulse/libcomm/core/protocol/message/Message;", "getOutput", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "capnoJob", "Lkotlinx/coroutines/Job;", "isNullOrInactive", "", "processMessage", "", "message", "scope", "Lkotlinx/coroutines/CoroutineScope;", "libcomm"})
@SourceDebugExtension(value={"SMAP\nCapnoMessageProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapnoMessageProcessor.kt\nvet/inpulse/libcomm/core/device/virtual/processors/CapnoMessageProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1869#2,2:84\n*S KotlinDebug\n*F\n+ 1 CapnoMessageProcessor.kt\nvet/inpulse/libcomm/core/device/virtual/processors/CapnoMessageProcessor\n*L\n44#1:84,2\n*E\n"})
public final class CapnoMessageProcessor
implements MessageProcessor {
    @NotNull
    private final SampleGenerator<RespironicsPacket> capnoSampleGenerator;
    @NotNull
    private final MutableSharedFlow<Message> output;
    @Nullable
    private Job capnoJob;

    public CapnoMessageProcessor(@NotNull SampleGenerator<? extends RespironicsPacket> capnoSampleGenerator) {
        Intrinsics.checkNotNullParameter(capnoSampleGenerator, (String)"capnoSampleGenerator");
        this.capnoSampleGenerator = capnoSampleGenerator;
        this.output = SharedFlowKt.MutableSharedFlow$default((int)0, (int)2048, null, (int)5, null);
    }

    @NotNull
    public MutableSharedFlow<Message> getOutput() {
        return this.output;
    }

    private final boolean isNullOrInactive(Job $this$isNullOrInactive) {
        return $this$isNullOrInactive == null || !$this$isNullOrInactive.isActive();
    }

    @Override
    public void processMessage(@NotNull Message message2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Message message3 = message2;
        if (message3 instanceof CapnoData) {
            Iterable $this$forEach$iv = ((CapnoData)message2).getData();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RespironicsPacket packet = (RespironicsPacket)element$iv;
                boolean bl = false;
                RespironicsPacket respironicsPacket = packet;
                if (Intrinsics.areEqual((Object)respironicsPacket, (Object)StartCO2DataMode.INSTANCE)) {
                    if (!this.isNullOrInactive(this.capnoJob)) continue;
                    float fs = 100.0f;
                    long ts = MathKt.roundToLong((double)(1000000.0 / (double)fs));
                    this.capnoJob = CoroutineOperatorsKt.timeInterval-jKevqZI$default(scope, DurationKt.toDuration((long)ts, (DurationUnit)DurationUnit.MICROSECONDS), 0L, null, (Function2)new Function2<ComparableTimeMark, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ CapnoMessageProcessor this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    RespironicsPacket sample = (RespironicsPacket)CapnoMessageProcessor.access$getCapnoSampleGenerator$p(this.this$0).nextSample();
                                    while (!(sample instanceof CO2Waveform)) {
                                        sample = (RespironicsPacket)CapnoMessageProcessor.access$getCapnoSampleGenerator$p(this.this$0).nextSample();
                                    }
                                    CapnoMessageProcessor.access$processMessage$sendMsg(this.this$0, sample);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(ComparableTimeMark p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 6, null);
                    continue;
                }
                if (Intrinsics.areEqual((Object)respironicsPacket, (Object)GetAvailableCapabilities.INSTANCE)) {
                    CapnoMessageProcessor.processMessage$sendMsg(this, new AvailableCapabilities(CollectionsKt.listOf((Object)((Object)SensorCapabilityFlags.CO2Mainstream))));
                    continue;
                }
                if (Intrinsics.areEqual((Object)respironicsPacket, (Object)GetCurrentCapabilities.INSTANCE)) {
                    CapnoMessageProcessor.processMessage$sendMsg(this, new AvailableCapabilities(CollectionsKt.listOf((Object)((Object)SensorCapabilityFlags.CO2Mainstream))));
                    continue;
                }
                if (!(respironicsPacket instanceof GetSensorSettings) || !(((GetSensorSettings)packet).getSettings() instanceof SensorSetting.GetCurrentCO2Units)) continue;
                SensorSetting.CurrentCO2Units unit = new SensorSetting.CurrentCO2Units(CO2Unit.mmHg);
                CapnoMessageProcessor.processMessage$sendMsg(this, new GetSensorSettings(unit));
            }
        } else if (message3 instanceof StopAll) {
            Job job2 = this.capnoJob;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            this.capnoJob = null;
        }
    }

    private static final void processMessage$sendMsg(CapnoMessageProcessor this$0, RespironicsPacket msg) {
        this$0.getOutput().tryEmit((Object)new CapnoData(CollectionsKt.listOf((Object)msg)));
    }

    public static final /* synthetic */ SampleGenerator access$getCapnoSampleGenerator$p(CapnoMessageProcessor $this) {
        return $this.capnoSampleGenerator;
    }

    public static final /* synthetic */ void access$processMessage$sendMsg(CapnoMessageProcessor this$0, RespironicsPacket msg) {
        CapnoMessageProcessor.processMessage$sendMsg(this$0, msg);
    }
}

