/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.device.virtual.operator;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.device.DeviceType;
import vet.inpulse.libcomm.core.device.data.BatteryInfo;
import vet.inpulse.libcomm.core.device.data.NibpStatus;
import vet.inpulse.libcomm.core.device.data.PpgSampleStatus;
import vet.inpulse.libcomm.core.device.data.PpgState;
import vet.inpulse.libcomm.core.device.module.hardware.Ads129xCalculator;
import vet.inpulse.libcomm.core.device.virtual.operator.VirtualInMonitorBasicOperatorKt;
import vet.inpulse.libcomm.core.device.virtual.operator.VirtualOperator;
import vet.inpulse.libcomm.core.locator.bluetooth.RemoteAddress;
import vet.inpulse.libcomm.core.protocol.CodecSpec;
import vet.inpulse.libcomm.core.protocol.MonitorBasicProtocol;
import vet.inpulse.libcomm.core.protocol.Protocol;
import vet.inpulse.libcomm.core.protocol.message.Ack;
import vet.inpulse.libcomm.core.protocol.message.BatteryInfoMessage;
import vet.inpulse.libcomm.core.protocol.message.Connect;
import vet.inpulse.libcomm.core.protocol.message.EcgGain;
import vet.inpulse.libcomm.core.protocol.message.EcgPpgData;
import vet.inpulse.libcomm.core.protocol.message.GetInfo;
import vet.inpulse.libcomm.core.protocol.message.Message;
import vet.inpulse.libcomm.core.protocol.message.MessageType;
import vet.inpulse.libcomm.core.protocol.message.ModulePacket;
import vet.inpulse.libcomm.core.protocol.message.MonitorEcgSample;
import vet.inpulse.libcomm.core.protocol.message.MonitorPpgSample;
import vet.inpulse.libcomm.core.protocol.message.MyInfo;
import vet.inpulse.libcomm.core.protocol.message.Nack;
import vet.inpulse.libcomm.core.protocol.message.NibpDataMessage;
import vet.inpulse.libcomm.core.protocol.message.NibpModuleSample;
import vet.inpulse.libcomm.core.protocol.message.Ping;
import vet.inpulse.libcomm.core.protocol.message.Pong;
import vet.inpulse.libcomm.core.protocol.message.SetEcgGain;
import vet.inpulse.libcomm.core.protocol.message.SetNibpCalibrationParameters;
import vet.inpulse.libcomm.core.protocol.message.SetNibpCalibrationPressure;
import vet.inpulse.libcomm.core.protocol.message.StartEcgPpg;
import vet.inpulse.libcomm.core.protocol.message.StartNibp;
import vet.inpulse.libcomm.core.protocol.message.StartNibpCalibration;
import vet.inpulse.libcomm.core.protocol.message.StartTemp;
import vet.inpulse.libcomm.core.protocol.message.StopAll;
import vet.inpulse.libcomm.core.protocol.message.StopNibp;
import vet.inpulse.libcomm.core.protocol.message.TempDataMessage;
import vet.inpulse.libcomm.core.protocol.message.TempModuleSample;
import vet.inpulse.libcomm.core.util.data_generator.DataGenerator;
import vet.inpulse.libcomm.core.util.data_generator.SinusoidalGenerator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0016H\u0002J\b\u0010%\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+H\u0002J\b\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010;\u001a\u00020#H\u0002J\u0010\u0010A\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010B\u001a\u00020#H\u0002J\u0018\u0010C\u001a\u00020#2\u0006\u0010D\u001a\u00020E2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010F\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u00101\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00105\u001a\u00060\u001ej\u0002`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010=\u001a\u00060\u001ej\u0002`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010@\u001a\u00060\u001ej\u0002`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lvet/inpulse/libcomm/core/device/virtual/operator/VirtualInMonitorBasicOperator;", "Lvet/inpulse/libcomm/core/device/virtual/operator/VirtualOperator;", "protocol", "Lvet/inpulse/libcomm/core/protocol/Protocol;", "codecSpec", "Lvet/inpulse/libcomm/core/protocol/CodecSpec;", "ecgGenerator", "Lvet/inpulse/libcomm/core/util/data_generator/DataGenerator;", "ppgGenerator", "nibpGenerator", "remoteAddress", "Lvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress;", "<init>", "(Lvet/inpulse/libcomm/core/protocol/Protocol;Lvet/inpulse/libcomm/core/protocol/CodecSpec;Lvet/inpulse/libcomm/core/util/data_generator/DataGenerator;Lvet/inpulse/libcomm/core/util/data_generator/DataGenerator;Lvet/inpulse/libcomm/core/util/data_generator/DataGenerator;Lvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress;)V", "inflateSlopeStep", "", "peakSamples", "", "nibpDataBuffer", "", "currentNibpSampleId", "status", "Lvet/inpulse/libcomm/core/device/data/NibpStatus;", "calibrationTargetPressure", "peakSamplesRun", "currentPressure", "maxPressure", "minPressure", "slopeStep", "generateNibpPacket", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "nibpAcquisitionFuture", "Lkotlinx/coroutines/Job;", "resetNibpAcquisitionState", "", "initialStatus", "stopNibpAcquisition", "startNibpAcquisition", "eventLoop", "Lkotlinx/coroutines/CoroutineScope;", "setupNibpAcquisition", "newMessage", "Lvet/inpulse/libcomm/core/protocol/message/StartNibp;", "currentEcgPacketId", "getCurrentEcgPacketId", "()I", "setCurrentEcgPacketId", "(I)V", "ecgPpgDataBuffer", "adsCalculator", "Lvet/inpulse/libcomm/core/device/module/hardware/Ads129xCalculator;", "ecgPpgAcquisitionTask", "generateEcgPpgPacket", "generateEcgSample", "Lvet/inpulse/libcomm/core/protocol/message/MonitorEcgSample;", "generatePpgSample", "Lvet/inpulse/libcomm/core/protocol/message/MonitorPpgSample$V2;", "startEcgPpgAcquisition", "stopEcgPpgAcquisition", "batteryInfoTask", "generateBatteryInfo", "currentTempSampleId", "tempDataTask", "generateTempPacket", "startTempAcquisition", "stopTempAcquisition", "processMessage", "message", "Lvet/inpulse/libcomm/core/protocol/message/Message;", "startBatteryInfoPooling", "libcomm"})
public final class VirtualInMonitorBasicOperator
extends VirtualOperator {
    @NotNull
    private final DataGenerator ecgGenerator;
    @NotNull
    private final DataGenerator ppgGenerator;
    @NotNull
    private final DataGenerator nibpGenerator;
    @NotNull
    private final RemoteAddress remoteAddress;
    private final float inflateSlopeStep;
    private final int peakSamples;
    @NotNull
    private final float[] nibpDataBuffer;
    private int currentNibpSampleId;
    @NotNull
    private NibpStatus status;
    private float calibrationTargetPressure;
    private int peakSamplesRun;
    private float currentPressure;
    private float maxPressure;
    private float minPressure;
    private float slopeStep;
    @NotNull
    private final Runnable generateNibpPacket;
    @Nullable
    private Job nibpAcquisitionFuture;
    private int currentEcgPacketId;
    @NotNull
    private final float[] ecgPpgDataBuffer;
    private Ads129xCalculator adsCalculator;
    @Nullable
    private Job ecgPpgAcquisitionTask;
    @NotNull
    private final Runnable generateEcgPpgPacket;
    @Nullable
    private Job batteryInfoTask;
    @NotNull
    private final Runnable generateBatteryInfo;
    private int currentTempSampleId;
    @Nullable
    private Job tempDataTask;
    @NotNull
    private final Runnable generateTempPacket;

    public VirtualInMonitorBasicOperator(@NotNull Protocol protocol, @NotNull CodecSpec codecSpec, @NotNull DataGenerator ecgGenerator, @NotNull DataGenerator ppgGenerator, @NotNull DataGenerator nibpGenerator, @NotNull RemoteAddress remoteAddress) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)codecSpec, (String)"codecSpec");
        Intrinsics.checkNotNullParameter((Object)ecgGenerator, (String)"ecgGenerator");
        Intrinsics.checkNotNullParameter((Object)ppgGenerator, (String)"ppgGenerator");
        Intrinsics.checkNotNullParameter((Object)nibpGenerator, (String)"nibpGenerator");
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        super(protocol, codecSpec);
        this.ecgGenerator = ecgGenerator;
        this.ppgGenerator = ppgGenerator;
        this.nibpGenerator = nibpGenerator;
        this.remoteAddress = remoteAddress;
        this.inflateSlopeStep = 0.05f;
        this.peakSamples = 100;
        this.nibpDataBuffer = new float[1];
        this.status = NibpStatus.NONE;
        this.generateNibpPacket = () -> VirtualInMonitorBasicOperator.generateNibpPacket$lambda$1(this);
        this.ecgPpgDataBuffer = new float[3];
        this.generateEcgPpgPacket = () -> VirtualInMonitorBasicOperator.generateEcgPpgPacket$lambda$2(this);
        this.generateBatteryInfo = () -> VirtualInMonitorBasicOperator.generateBatteryInfo$lambda$3(this);
        this.generateTempPacket = () -> VirtualInMonitorBasicOperator.generateTempPacket$lambda$4(this);
    }

    public /* synthetic */ VirtualInMonitorBasicOperator(Protocol protocol, CodecSpec codecSpec, DataGenerator dataGenerator, DataGenerator dataGenerator2, DataGenerator dataGenerator3, RemoteAddress remoteAddress, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            protocol = new MonitorBasicProtocol(0, false, false, false, 15, null);
        }
        if ((n & 2) != 0) {
            codecSpec = new CodecSpec(1, 0L, 0L, null, 14, null);
        }
        if ((n & 4) != 0) {
            dataGenerator = new SinusoidalGenerator(500.0, 1.0, 1.0);
        }
        if ((n & 8) != 0) {
            dataGenerator2 = new SinusoidalGenerator(250.0, 1.0, 1.0);
        }
        if ((n & 0x10) != 0) {
            dataGenerator3 = new SinusoidalGenerator(600.0, 1.0, 1.0);
        }
        if ((n & 0x20) != 0) {
            remoteAddress = VirtualInMonitorBasicOperatorKt.access$getDefaultRemoteAddress$p();
        }
        this(protocol, codecSpec, dataGenerator, dataGenerator2, dataGenerator3, remoteAddress);
    }

    private final void resetNibpAcquisitionState(NibpStatus initialStatus) {
        this.status = initialStatus;
        this.peakSamplesRun = 0;
        this.currentPressure = 0.0f;
        this.nibpGenerator.reset();
    }

    private final void stopNibpAcquisition() {
        Job job2 = this.nibpAcquisitionFuture;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.nibpAcquisitionFuture = null;
    }

    private final void startNibpAcquisition(CoroutineScope eventLoop) {
        this.nibpAcquisitionFuture = this.scheduleAtFixedRate(eventLoop, this.generateNibpPacket, 0, 6666, DurationUnit.MICROSECONDS);
    }

    private final void setupNibpAcquisition(StartNibp newMessage) {
        this.maxPressure = newMessage.getMaxPressure();
        this.slopeStep = (float)newMessage.getSlope() / 600.0f;
        this.minPressure = newMessage.getFinalCuffPressure();
    }

    public final int getCurrentEcgPacketId() {
        return this.currentEcgPacketId;
    }

    public final void setCurrentEcgPacketId(int n) {
        this.currentEcgPacketId = n;
    }

    private final MonitorEcgSample generateEcgSample() {
        int[] channels = new int[3];
        this.ecgGenerator.generateData(this.ecgPpgDataBuffer, 3, 1);
        int n = channels.length;
        for (int i = 0; i < n; ++i) {
            Ads129xCalculator ads129xCalculator = this.adsCalculator;
            if (ads129xCalculator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adsCalculator");
                ads129xCalculator = null;
            }
            channels[i] = ads129xCalculator.voltageToAdc(this.ecgPpgDataBuffer[i]);
        }
        return new MonitorEcgSample(0, channels[0], channels[1], channels[2]);
    }

    private final MonitorPpgSample.V2 generatePpgSample() {
        this.ppgGenerator.generateData(this.ecgPpgDataBuffer, 2, 1);
        int red = MathKt.roundToInt((float)(this.ecgPpgDataBuffer[0] * (float)1024));
        int ir = MathKt.roundToInt((float)(this.ecgPpgDataBuffer[1] * (float)1024));
        return new MonitorPpgSample.V2(red, ir, red, ir, new PpgState(1, 1, 1, 1, 1, 1, 1, PpgSampleStatus.NORMAL));
    }

    private final void startEcgPpgAcquisition(CoroutineScope eventLoop) {
        this.ecgPpgAcquisitionTask = this.scheduleAtFixedRate(eventLoop, this.generateEcgPpgPacket, 4, 4, DurationUnit.MILLISECONDS);
    }

    private final void stopEcgPpgAcquisition() {
        Job job2 = this.ecgPpgAcquisitionTask;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.ecgPpgAcquisitionTask = null;
    }

    private final void startTempAcquisition(CoroutineScope eventLoop) {
        this.tempDataTask = this.scheduleAtFixedRate(eventLoop, this.generateTempPacket, 1, 1, DurationUnit.SECONDS);
    }

    private final void stopTempAcquisition() {
        Job job2 = this.tempDataTask;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.tempDataTask = null;
    }

    @Override
    public void processMessage(@NotNull Message message2, @NotNull CoroutineScope eventLoop) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)eventLoop, (String)"eventLoop");
        Message message3 = message2;
        if (Intrinsics.areEqual((Object)message3, (Object)Ping.INSTANCE)) {
            this.sendMessage(Pong.INSTANCE);
        } else if (message3 instanceof StartNibp) {
            this.resetNibpAcquisitionState(NibpStatus.INFLATING);
            this.setupNibpAcquisition((StartNibp)message2);
            this.startNibpAcquisition(eventLoop);
        } else if (Intrinsics.areEqual((Object)message3, (Object)StopNibp.INSTANCE)) {
            this.stopNibpAcquisition();
        } else if (Intrinsics.areEqual((Object)message3, (Object)StartNibpCalibration.INSTANCE)) {
            this.resetNibpAcquisitionState(NibpStatus.CALIBRATING);
            this.startNibpAcquisition(eventLoop);
        } else if (!(message3 instanceof SetNibpCalibrationParameters)) {
            if (message3 instanceof SetNibpCalibrationPressure) {
                this.calibrationTargetPressure = ((SetNibpCalibrationPressure)message2).getPressure();
            } else if (Intrinsics.areEqual((Object)message3, (Object)StartEcgPpg.INSTANCE)) {
                this.startEcgPpgAcquisition(eventLoop);
                this.sendMessage(new Ack(MessageType.StartEcgPpg));
            } else if (Intrinsics.areEqual((Object)message3, (Object)StartTemp.INSTANCE)) {
                this.startTempAcquisition(eventLoop);
            } else if (Intrinsics.areEqual((Object)message3, (Object)StopAll.INSTANCE)) {
                this.stopEcgPpgAcquisition();
                this.stopNibpAcquisition();
                this.stopTempAcquisition();
            } else if (Intrinsics.areEqual((Object)message3, (Object)GetInfo.INSTANCE)) {
                this.sendMessage(new MyInfo(3, DeviceType.INMONITOR_BASIC.getDeviceTypeByte(), 6, this.remoteAddress, null, null, null, null, null, 496, null));
            } else if (Intrinsics.areEqual((Object)message3, (Object)Connect.INSTANCE)) {
                this.startBatteryInfoPooling(eventLoop);
                this.sendMessage(new Ack(MessageType.Connect));
            } else if (message3 instanceof SetEcgGain) {
                EcgGain ecgGain = ((SetEcgGain)message2).getEcgGain();
                this.adsCalculator = new Ads129xCalculator(2.4f, ecgGain.getGainValue());
                this.sendMessage(new Ack(message2.getType()));
            } else {
                this.sendMessage(new Nack(message2.getType()));
                return;
            }
        }
        this.sendMessage(new Ack(message2.getType()));
    }

    private final void startBatteryInfoPooling(CoroutineScope eventLoop) {
        if (this.batteryInfoTask == null) {
            this.batteryInfoTask = this.scheduleAtFixedRate(eventLoop, this.generateBatteryInfo, 1, 5, DurationUnit.SECONDS);
        }
    }

    private static final void generateNibpPacket$lambda$1(VirtualInMonitorBasicOperator this$0) {
        int n = 4;
        ArrayList<NibpModuleSample> arrayList = new ArrayList<NibpModuleSample>(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = n2 = i;
            ArrayList<NibpModuleSample> arrayList2 = arrayList;
            boolean bl = false;
            this$0.nibpDataBuffer[0] = 0.0f;
            switch (WhenMappings.$EnumSwitchMapping$0[this$0.status.ordinal()]) {
                case 1: {
                    this$0.status = NibpStatus.INFLATING;
                    break;
                }
                case 2: {
                    this$0.nibpGenerator.generateData(this$0.nibpDataBuffer, 1, 1);
                    this$0.currentPressure += this$0.inflateSlopeStep;
                    if (!(this$0.currentPressure > this$0.maxPressure)) break;
                    this$0.status = NibpStatus.PEAK;
                    break;
                }
                case 3: {
                    this$0.nibpGenerator.generateData(this$0.nibpDataBuffer, 1, 1);
                    ++this$0.peakSamplesRun;
                    if (this$0.peakSamplesRun <= this$0.peakSamples) break;
                    this$0.status = NibpStatus.CONTROLLING;
                    break;
                }
                case 4: {
                    this$0.nibpGenerator.generateData(this$0.nibpDataBuffer, 1, 1);
                    this$0.currentPressure -= this$0.slopeStep;
                    if (!(this$0.currentPressure < this$0.minPressure)) break;
                    this$0.status = NibpStatus.FINISHING;
                    break;
                }
                case 5: {
                    this$0.status = NibpStatus.IDLE;
                    break;
                }
                case 6: {
                    this$0.stopNibpAcquisition();
                    break;
                }
                case 7: {
                    if (this$0.currentPressure < this$0.calibrationTargetPressure) {
                        this$0.currentPressure += this$0.inflateSlopeStep;
                        break;
                    }
                    this$0.currentPressure -= this$0.inflateSlopeStep;
                    break;
                }
                case 8: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 9: {
                    throw new NotImplementedError(null, 1, null);
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            arrayList2.add(new NibpModuleSample(this$0.currentPressure + this$0.nibpDataBuffer[0], this$0.status, null, null, null, 28, null));
        }
        List samples = arrayList;
        ModulePacket<NibpModuleSample> p = new ModulePacket<NibpModuleSample>(this$0.currentNibpSampleId, samples, null);
        this$0.currentNibpSampleId += samples.size();
        this$0.sendMessage(new NibpDataMessage(p));
    }

    private static final void generateEcgPpgPacket$lambda$2(VirtualInMonitorBasicOperator this$0) {
        MonitorEcgSample ecgSample1 = this$0.generateEcgSample();
        MonitorEcgSample ecgSample2 = this$0.generateEcgSample();
        MonitorPpgSample.V2 ppgSample = this$0.generatePpgSample();
        int n = this$0.currentEcgPacketId;
        this$0.currentEcgPacketId = n + 1;
        EcgPpgData msg = new EcgPpgData(n, ecgSample1, ecgSample2, ppgSample);
        this$0.sendMessage(msg);
    }

    private static final void generateBatteryInfo$lambda$3(VirtualInMonitorBasicOperator this$0) {
        BatteryInfoMessage batteryInfo = new BatteryInfoMessage(new BatteryInfo.Normal(120, 100, null, null, 8, null));
        this$0.sendMessage(batteryInfo);
    }

    private static final void generateTempPacket$lambda$4(VirtualInMonitorBasicOperator this$0) {
        TempModuleSample tempData = new TempModuleSample(1024, 1024);
        int n = this$0.currentTempSampleId;
        this$0.currentTempSampleId = n + 1;
        TempDataMessage tempMessage = new TempDataMessage(new ModulePacket<TempModuleSample>(n, CollectionsKt.listOf((Object)tempData), null));
        this$0.sendMessage(tempMessage);
    }

    public VirtualInMonitorBasicOperator() {
        this(null, null, null, null, null, null, 63, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NibpStatus.values().length];
            try {
                nArray[NibpStatus.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.INFLATING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.PEAK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.CONTROLLING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.FINISHING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.IDLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.CALIBRATING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.ADJUSTING_CALIBRATION_OFFSET.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.SETTING_PRESSURE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

