/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.device.module.hardware;

import kotlin.Metadata;
import kotlin.math.MathKt;
import vet.inpulse.libcomm.core.device.module.hardware.AdsCalculator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lvet/inpulse/libcomm/core/device/module/hardware/Ads129xCalculator;", "Lvet/inpulse/libcomm/core/device/module/hardware/AdsCalculator;", "vRef", "", "gain", "", "<init>", "(FI)V", "getGain", "()I", "adsScale", "", "adsScaleInv", "gainInv", "adcToMilliVolts", "adcDigitalValue", "voltageToAdc", "voltageInMilliVolts", "libcomm"})
public final class Ads129xCalculator
implements AdsCalculator {
    private final int gain;
    private final double adsScale;
    private final double adsScaleInv;
    private final double gainInv;

    public Ads129xCalculator(float vRef, int gain) {
        this.gain = gain;
        this.adsScale = (double)vRef / (Math.pow(2.0, 23) - 1.0);
        this.adsScaleInv = 1.0 / this.adsScale;
        this.gainInv = 1.0 / (double)this.gain;
    }

    public final int getGain() {
        return this.gain;
    }

    @Override
    public float adcToMilliVolts(int adcDigitalValue) {
        return (float)((double)adcDigitalValue * this.adsScale * 1000.0 * this.gainInv);
    }

    @Override
    public int voltageToAdc(float voltageInMilliVolts) {
        return MathKt.roundToInt((double)((double)voltageInMilliVolts * this.adsScaleInv * 0.001 * (double)this.gain));
    }
}

