/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.models.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.models.model.NibpResultElement;
import vet.inpulse.core.models.record_data.BloodPressure;
import vet.inpulse.core.models.record_data.BloodPressureResult;
import vet.inpulse.core.models.record_data.BloodPressures;
import vet.inpulse.core.models.record_data.NibpCalculatorOutput;
import vet.inpulse.core.models.record_data.NibpMeasurementSummary;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n*\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\n\u0010\r\u001a\u00020\u0007*\u00020\n\u001a\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u000f*\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"isValid", "", "Lvet/inpulse/core/models/model/NibpResultElement;", "toSummary", "Lvet/inpulse/core/models/record_data/NibpMeasurementSummary;", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput$Success;", "printAsResult", "", "Lvet/inpulse/core/models/record_data/BloodPressures;", "toResultOrNull", "Lvet/inpulse/core/models/record_data/BloodPressureResult;", "", "Lvet/inpulse/core/models/record_data/BloodPressure;", "printStatistics", "variationOrNull", "", "(Ljava/util/List;)Ljava/lang/Float;", "averageOrNull", "core-models"})
@SourceDebugExtension(value={"SMAP\nNibpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NibpUtils.kt\nvet/inpulse/core/models/utils/NibpUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1563#2:58\n1634#2,3:59\n*S KotlinDebug\n*F\n+ 1 NibpUtils.kt\nvet/inpulse/core/models/utils/NibpUtilsKt\n*L\n31#1:58\n31#1:59,3\n*E\n"})
public final class NibpUtilsKt {
    public static final boolean isValid(@NotNull NibpResultElement $this$isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        return $this$isValid.getBloodPressureIndexes().isValid();
    }

    @NotNull
    public static final NibpMeasurementSummary toSummary(@NotNull NibpResultElement $this$toSummary) {
        Intrinsics.checkNotNullParameter((Object)$this$toSummary, (String)"<this>");
        return new NibpMeasurementSummary($this$toSummary.getTimestamp(), $this$toSummary.getBloodPressureValues(), $this$toSummary.getPulsePerMinute-8kGXVMQ(), null);
    }

    @NotNull
    public static final NibpMeasurementSummary toSummary(@NotNull NibpCalculatorOutput.Success $this$toSummary) {
        Intrinsics.checkNotNullParameter((Object)$this$toSummary, (String)"<this>");
        return new NibpMeasurementSummary($this$toSummary.getMeasurementTime(), $this$toSummary.getBloodPressureValues(), $this$toSummary.getPulsePerMinute-8kGXVMQ(), null);
    }

    @NotNull
    public static final String printAsResult(@NotNull BloodPressures $this$printAsResult) {
        Intrinsics.checkNotNullParameter((Object)$this$printAsResult, (String)"<this>");
        return $this$printAsResult.getSystolic-2AKUNdQ() + "/" + $this$printAsResult.getDiastolic-S1WnChQ() + " (" + $this$printAsResult.getMean-c9_QRUg() + ")";
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final BloodPressureResult toResultOrNull(@NotNull List<? extends BloodPressure> $this$toResultOrNull) {
        BloodPressureResult bloodPressureResult;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toResultOrNull, (String)"<this>");
        Iterable $this$map$iv = $this$toResultOrNull;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BloodPressure bloodPressure = (BloodPressure)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(it.getMmHg()));
        }
        List floats = (List)destination$iv$iv;
        Float f = NibpUtilsKt.averageOrNull(floats);
        if (f != null) {
            float average = ((Number)f).floatValue();
            boolean bl = false;
            bloodPressureResult = new BloodPressureResult(average, NibpUtilsKt.variationOrNull(floats));
        } else {
            bloodPressureResult = null;
        }
        return bloodPressureResult;
    }

    @NotNull
    public static final String printStatistics(@NotNull BloodPressureResult $this$printStatistics) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$printStatistics, (String)"<this>");
        StringBuilder $this$printStatistics_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$printStatistics_u24lambda_u243.append(MathKt.roundToInt((float)$this$printStatistics.getMean()));
        Float f = $this$printStatistics.getVariance();
        if (f != null) {
            float variation = ((Number)f).floatValue();
            boolean bl2 = false;
            Object[] objectArray = new Object[]{" \u00b1 ", MathKt.roundToInt((float)variation)};
            StringsKt.append((StringBuilder)$this$printStatistics_u24lambda_u243, (Object[])objectArray);
        }
        $this$printStatistics_u24lambda_u243.append(" mmHg");
        return stringBuilder.toString();
    }

    private static final Float variationOrNull(List<Float> $this$variationOrNull) {
        if ($this$variationOrNull.size() < 2) {
            return null;
        }
        return Float.valueOf((float)Math.ceil(Math.abs(CollectionsKt.maxOrThrow((Iterable)$this$variationOrNull) - CollectionsKt.minOrThrow((Iterable)$this$variationOrNull)) / 2.0f));
    }

    private static final Float averageOrNull(List<Float> $this$averageOrNull) {
        if ($this$averageOrNull.isEmpty()) {
            return null;
        }
        return Float.valueOf((float)CollectionsKt.averageOfFloat((Iterable)$this$averageOrNull));
    }
}

