/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.models.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.Duration;
import kotlinx.datetime.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.models.model.ASA;
import vet.inpulse.core.models.model.BatteryInfoModel;
import vet.inpulse.core.models.model.Breed;
import vet.inpulse.core.models.model.Drug;
import vet.inpulse.core.models.model.DrugItem;
import vet.inpulse.core.models.model.Gender;
import vet.inpulse.core.models.model.Hydration;
import vet.inpulse.core.models.model.KnownSpecies;
import vet.inpulse.core.models.model.MonitorEventType;
import vet.inpulse.core.models.model.Pain;
import vet.inpulse.core.models.model.PatientState;
import vet.inpulse.core.models.model.RecordType;
import vet.inpulse.core.models.model.Species;
import vet.inpulse.core.models.model.Ventilation;
import vet.inpulse.core.models.repository.internationalization.ApplicationErrorType;
import vet.inpulse.core.models.repository.internationalization.CommonStrings;
import vet.inpulse.core.models.repository.internationalization.InternationalizedEnums;
import vet.inpulse.core.models.repository.internationalization.languages.English;
import vet.inpulse.core.models.repository.internationalization.languages.Portuguese;
import vet.inpulse.core.models.repository.internationalization.languages.Spanish;
import vet.inpulse.core.models.utils.AvailableLanguage;
import vet.inpulse.shared.models.Locale;
import vet.inpulse.shared.utils.DateTimeFormatStyle;
import vet.inpulse.shared.utils.DateTimeUtilsKt;
import vet.inpulse.shared.utils.StringExtensionsKt;
import vet.inpulse.shared.utils.YearMonthDay;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\f\u0010\u0010\u001a\u00020\t*\u00020\u0003H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018J)\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u001f\u0010!\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\"J\u0015\u0010!\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$\u00a2\u0006\u0004\b%\u0010&J)\u0010'\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u0010\u0010(\u001a\u00020\u00162\b\u0010)\u001a\u0004\u0018\u00010*J\u0010\u0010+\u001a\u00020\u00162\b\u0010)\u001a\u0004\u0018\u00010*J\u0010\u0010,\u001a\u00020\u00162\b\u0010-\u001a\u0004\u0018\u00010.J$\u0010/\u001a\u00020\u00162\b\u00100\u001a\u0004\u0018\u00010\u00162\b\u00101\u001a\u0004\u0018\u00010\u00162\b\u00102\u001a\u0004\u0018\u00010\u0016J\u0010\u00103\u001a\u00020\u00162\b\u00104\u001a\u0004\u0018\u000105J\u0010\u00106\u001a\u00020\u00162\b\u00104\u001a\u0004\u0018\u000105J\u0010\u00107\u001a\u00020\u00162\b\u00108\u001a\u0004\u0018\u000109J\u0010\u0010:\u001a\u00020\u00162\b\u0010;\u001a\u0004\u0018\u00010<J\u0010\u0010=\u001a\u00020\u00162\b\u0010>\u001a\u0004\u0018\u00010?J\u0010\u0010@\u001a\u00020\u00162\b\u0010A\u001a\u0004\u0018\u00010BJ\u0010\u0010C\u001a\u00020\u00162\b\u0010D\u001a\u0004\u0018\u00010EJ\u000e\u0010F\u001a\u00020\u00162\u0006\u0010G\u001a\u00020HJ\u0010\u0010I\u001a\u00020\u00162\b\u0010J\u001a\u0004\u0018\u00010KJ\u0010\u0010L\u001a\u00020\u00162\b\u0010J\u001a\u0004\u0018\u00010KJ\u0010\u0010I\u001a\u00020\u00162\b\u0010M\u001a\u0004\u0018\u00010NJ\u0010\u0010L\u001a\u00020\u00162\b\u0010M\u001a\u0004\u0018\u00010NJ\u0010\u0010O\u001a\u00020\u00162\b\u0010P\u001a\u0004\u0018\u00010QJ\u000e\u0010R\u001a\u00020\u00162\u0006\u0010S\u001a\u00020TJ\u0015\u0010U\u001a\u00020\u00162\b\u0010V\u001a\u0004\u0018\u00010W\u00a2\u0006\u0002\u0010XJ\f\u0010Y\u001a\u00020\u0016*\u00020ZH\u0002J\u000e\u0010[\u001a\u00020\u00162\u0006\u0010\\\u001a\u00020]J\u000e\u0010R\u001a\u00020\u00162\u0006\u0010^\u001a\u00020_J\u0010\u0010`\u001a\u00020\u00162\b\u0010a\u001a\u0004\u0018\u00010bJ\u000e\u0010c\u001a\u00020\u00162\u0006\u0010d\u001a\u00020eR\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006f"}, d2={"Lvet/inpulse/core/models/repository/StringsRepository;", "", "locale", "Lvet/inpulse/shared/models/Locale;", "<init>", "(Lvet/inpulse/shared/models/Locale;)V", "value", "getLocale", "()Lvet/inpulse/shared/models/Locale;", "Lvet/inpulse/core/models/utils/AvailableLanguage;", "language", "getLanguage", "()Lvet/inpulse/core/models/utils/AvailableLanguage;", "changeLocale", "", "newLocale", "getAvailableLanguage", "enumTranslation", "Lvet/inpulse/core/models/repository/internationalization/InternationalizedEnums;", "getEnumTranslation", "()Lvet/inpulse/core/models/repository/internationalization/InternationalizedEnums;", "getAge", "", "birthdate", "", "refDate", "getDate", "msSinceEpoch", "timeZone", "Lkotlinx/datetime/TimeZone;", "formatStyle", "Lvet/inpulse/shared/utils/DateTimeFormatStyle;", "(Ljava/lang/Long;Lkotlinx/datetime/TimeZone;Lvet/inpulse/shared/utils/DateTimeFormatStyle;)Ljava/lang/String;", "getTime", "(Ljava/lang/Long;Lkotlinx/datetime/TimeZone;)Ljava/lang/String;", "duration", "Lkotlin/time/Duration;", "getTime-LRDsOJo", "(J)Ljava/lang/String;", "getDateAtTime", "getGender", "gender", "Lvet/inpulse/core/models/model/Gender;", "getHumanGender", "getSpecies", "species", "Lvet/inpulse/core/models/model/Species;", "selectLanguage", "pt", "en", "es", "getBreed", "breed", "Lvet/inpulse/core/models/model/Breed;", "getBreedVariations", "getClassificationASA", "asa", "Lvet/inpulse/core/models/model/ASA;", "getHydration", "hydration", "Lvet/inpulse/core/models/model/Hydration;", "getPain", "pain", "Lvet/inpulse/core/models/model/Pain;", "getVentilation", "ventilation", "Lvet/inpulse/core/models/model/Ventilation;", "getPatientState", "state", "Lvet/inpulse/core/models/model/PatientState;", "getRecordType", "recordType", "Lvet/inpulse/core/models/model/RecordType;", "getDrugName", "drug", "Lvet/inpulse/core/models/model/Drug;", "getDrugVariants", "drugItem", "Lvet/inpulse/core/models/model/DrugItem;", "getDrugClassification", "drugClassification", "Lvet/inpulse/core/models/model/Drug$Classification;", "get", "key", "Lvet/inpulse/core/models/repository/internationalization/CommonStrings;", "getWeight", "weight", "", "(Ljava/lang/Float;)Ljava/lang/String;", "getAllDrugNames", "Lvet/inpulse/core/models/model/DrugItem$Combined;", "getKnownSpecies", "knownSpecies", "Lvet/inpulse/core/models/model/KnownSpecies;", "error", "Lvet/inpulse/core/models/repository/internationalization/ApplicationErrorType;", "getBatteryInfoString", "batteryInfo", "Lvet/inpulse/core/models/model/BatteryInfoModel;", "getMonitorEventType", "event", "Lvet/inpulse/core/models/model/MonitorEventType;", "core-models"})
@SourceDebugExtension(value={"SMAP\nStringsRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringsRepository.kt\nvet/inpulse/core/models/repository/StringsRepository\n+ 2 Duration.kt\nkotlin/time/Duration\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,259:1\n517#2:260\n774#3:261\n865#3,2:262\n1#4:264\n*S KotlinDebug\n*F\n+ 1 StringsRepository.kt\nvet/inpulse/core/models/repository/StringsRepository\n*L\n98#1:260\n159#1:261\n159#1:262,2\n*E\n"})
public final class StringsRepository {
    @NotNull
    private Locale locale;
    @NotNull
    private AvailableLanguage language;

    public StringsRepository(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.locale = locale;
        this.language = this.getAvailableLanguage(locale);
    }

    @NotNull
    public final Locale getLocale() {
        return this.locale;
    }

    @NotNull
    public final AvailableLanguage getLanguage() {
        return this.language;
    }

    public final void changeLocale(@NotNull Locale newLocale) {
        Intrinsics.checkNotNullParameter((Object)newLocale, (String)"newLocale");
        this.locale = newLocale;
        this.language = this.getAvailableLanguage(this.locale);
    }

    private final AvailableLanguage getAvailableLanguage(Locale $this$getAvailableLanguage) {
        String string = $this$getAvailableLanguage.getLanguage();
        return Intrinsics.areEqual((Object)string, (Object)new Locale("pt").getLanguage()) ? AvailableLanguage.PT : (Intrinsics.areEqual((Object)string, (Object)new Locale("es").getLanguage()) ? AvailableLanguage.ES : (Intrinsics.areEqual((Object)string, (Object)new Locale("en").getLanguage()) ? AvailableLanguage.EN : AvailableLanguage.PT));
    }

    private final InternationalizedEnums getEnumTranslation() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.language.ordinal()]) {
            case 1 -> Portuguese.INSTANCE;
            case 2 -> English.INSTANCE;
            case 3 -> Spanish.INSTANCE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String getAge(long birthdate, long refDate) {
        StringBuilder stringBuilder;
        YearMonthDay yearMonthDay = DateTimeUtilsKt.getPeriodBetween((long)birthdate, (long)refDate);
        int y = yearMonthDay.component1();
        int m = yearMonthDay.component2();
        StringBuilder $this$getAge_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (y > 0) {
            $this$getAge_u24lambda_u240.append(y);
            $this$getAge_u24lambda_u240.append(" ");
            $this$getAge_u24lambda_u240.append(y == 1 ? this.get(CommonStrings.YEAR) : this.get(CommonStrings.YEARS));
            if (m > 0) {
                $this$getAge_u24lambda_u240.append(" " + this.get(CommonStrings.AND) + " ");
                StringsRepository.getAge$appendMonths($this$getAge_u24lambda_u240, this, m);
            }
        } else if (m > 0) {
            StringsRepository.getAge$appendMonths($this$getAge_u24lambda_u240, this, m);
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String getAge$default(StringsRepository stringsRepository, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = Clock.System.INSTANCE.now().toEpochMilliseconds();
        }
        return stringsRepository.getAge(l, l2);
    }

    @NotNull
    public final String getDate(@Nullable Long msSinceEpoch, @NotNull TimeZone timeZone, @NotNull DateTimeFormatStyle formatStyle) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        Intrinsics.checkNotNullParameter((Object)formatStyle, (String)"formatStyle");
        Object object = msSinceEpoch;
        if (object == null || (object = DateTimeUtilsKt.formatAsDate((long)((Long)object), (Locale)this.locale, (TimeZone)timeZone, (DateTimeFormatStyle)formatStyle)) == null) {
            object = "";
        }
        return object;
    }

    public static /* synthetic */ String getDate$default(StringsRepository stringsRepository, Long l, TimeZone timeZone, DateTimeFormatStyle dateTimeFormatStyle, int n, Object object) {
        if ((n & 2) != 0) {
            timeZone = TimeZone.Companion.currentSystemDefault();
        }
        if ((n & 4) != 0) {
            dateTimeFormatStyle = DateTimeFormatStyle.SHORT;
        }
        return stringsRepository.getDate(l, timeZone, dateTimeFormatStyle);
    }

    @NotNull
    public final String getTime(@Nullable Long msSinceEpoch, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        Object object = msSinceEpoch;
        if (object == null || (object = DateTimeUtilsKt.formatAsTime$default((long)((Long)object), (TimeZone)timeZone, (boolean)false, (int)2, null)) == null) {
            object = "";
        }
        return object;
    }

    public static /* synthetic */ String getTime$default(StringsRepository stringsRepository, Long l, TimeZone timeZone, int n, Object object) {
        if ((n & 2) != 0) {
            timeZone = TimeZone.Companion.currentSystemDefault();
        }
        return stringsRepository.getTime(l, timeZone);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getTime-LRDsOJo(long duration) {
        void seconds;
        void minutes;
        StringBuilder stringBuilder;
        long arg0$iv = duration;
        boolean bl = false;
        long l = Duration.getInWholeHours-impl((long)arg0$iv);
        int n = Duration.getMinutesComponent-impl((long)arg0$iv);
        int n2 = Duration.getSecondsComponent-impl((long)arg0$iv);
        Duration.getNanosecondsComponent-impl((long)arg0$iv);
        int n3 = n2;
        int n4 = n;
        long hours = l;
        boolean bl2 = false;
        StringBuilder $this$getTime_LRDsOJo_u24lambda_u242_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl3 = false;
        if (hours > 0L) {
            $this$getTime_LRDsOJo_u24lambda_u242_u24lambda_u241.append(hours);
            $this$getTime_LRDsOJo_u24lambda_u242_u24lambda_u241.append(":");
        }
        $this$getTime_LRDsOJo_u24lambda_u242_u24lambda_u241.append(StringsRepository.getTime_LRDsOJo$withTwoDigits((int)minutes));
        $this$getTime_LRDsOJo_u24lambda_u242_u24lambda_u241.append(":");
        $this$getTime_LRDsOJo_u24lambda_u242_u24lambda_u241.append(StringsRepository.getTime_LRDsOJo$withTwoDigits((int)seconds));
        return stringBuilder.toString();
    }

    @NotNull
    public final String getDateAtTime(@Nullable Long msSinceEpoch, @NotNull TimeZone timeZone, @NotNull DateTimeFormatStyle formatStyle) {
        Object object;
        block5: {
            block4: {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
                Intrinsics.checkNotNullParameter((Object)formatStyle, (String)"formatStyle");
                object = msSinceEpoch;
                if (object == null) break block4;
                long epoch = ((Number)object).longValue();
                boolean bl = false;
                StringBuilder $this$getDateAtTime_u24lambda_u244_u24lambda_u243 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                $this$getDateAtTime_u24lambda_u244_u24lambda_u243.append(this.getDate(epoch, timeZone, formatStyle));
                $this$getDateAtTime_u24lambda_u244_u24lambda_u243.append(" ");
                if (formatStyle != DateTimeFormatStyle.ULTRA_SHORT) {
                    $this$getDateAtTime_u24lambda_u244_u24lambda_u243.append(this.get(CommonStrings.AT_TIME));
                    $this$getDateAtTime_u24lambda_u244_u24lambda_u243.append(" ");
                }
                $this$getDateAtTime_u24lambda_u244_u24lambda_u243.append(this.getTime(epoch, timeZone));
                String string = stringBuilder.toString();
                object = string;
                if (string != null) break block5;
            }
            object = "";
        }
        return object;
    }

    public static /* synthetic */ String getDateAtTime$default(StringsRepository stringsRepository, Long l, TimeZone timeZone, DateTimeFormatStyle dateTimeFormatStyle, int n, Object object) {
        if ((n & 2) != 0) {
            timeZone = TimeZone.Companion.currentSystemDefault();
        }
        if ((n & 4) != 0) {
            dateTimeFormatStyle = DateTimeFormatStyle.SHORT;
        }
        return stringsRepository.getDateAtTime(l, timeZone, dateTimeFormatStyle);
    }

    @NotNull
    public final String getGender(@Nullable Gender gender) {
        return this.getEnumTranslation().gender(gender);
    }

    @NotNull
    public final String getHumanGender(@Nullable Gender gender) {
        return this.getEnumTranslation().humanGender(gender);
    }

    @NotNull
    public final String getSpecies(@Nullable Species species) {
        Object object;
        block8: {
            block7: {
                object = species;
                if (object == null) break block7;
                Species it = object;
                boolean bl = false;
                String string = switch (WhenMappings.$EnumSwitchMapping$0[this.language.ordinal()]) {
                    case 1 -> it.getPt();
                    case 2 -> it.getEn();
                    case 3 -> it.getEs();
                    default -> throw new NoWhenBranchMatchedException();
                };
                object = string;
                if (string != null) break block8;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public final String selectLanguage(@Nullable String pt, @Nullable String en, @Nullable String es) {
        String string = switch (WhenMappings.$EnumSwitchMapping$0[this.language.ordinal()]) {
            case 1 -> pt;
            case 2 -> en;
            case 3 -> es;
            default -> throw new NoWhenBranchMatchedException();
        };
        String string2 = string;
        if (string == null) {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public final String getBreed(@Nullable Breed breed) {
        Object object;
        block8: {
            block7: {
                object = breed;
                if (object == null) break block7;
                Breed it = object;
                boolean bl = false;
                String string = switch (WhenMappings.$EnumSwitchMapping$0[this.language.ordinal()]) {
                    case 1 -> it.getPt();
                    case 2 -> it.getEn();
                    case 3 -> it.getEs();
                    default -> throw new NoWhenBranchMatchedException();
                };
                object = string;
                if (string != null) break block8;
            }
            object = "";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getBreedVariations(@Nullable Breed breed) {
        Object object;
        block4: {
            block3: {
                void $this$filterTo$iv$iv;
                object = breed;
                if (object == null) break block3;
                Breed it = object;
                boolean bl = false;
                Iterable $this$filter$iv = it.getAllNames();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String name = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)name, (Object)this.getBreed(it)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
                object = string;
                if (string != null) break block4;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getClassificationASA(@Nullable ASA asa) {
        return this.getEnumTranslation().asaClassification(asa);
    }

    @NotNull
    public final String getHydration(@Nullable Hydration hydration) {
        return this.getEnumTranslation().hydration(hydration);
    }

    @NotNull
    public final String getPain(@Nullable Pain pain) {
        return this.getEnumTranslation().pain(pain);
    }

    @NotNull
    public final String getVentilation(@Nullable Ventilation ventilation) {
        return this.getEnumTranslation().ventilation(ventilation);
    }

    @NotNull
    public final String getPatientState(@Nullable PatientState state) {
        return this.getEnumTranslation().patientState(state);
    }

    @NotNull
    public final String getRecordType(@NotNull RecordType recordType) {
        Intrinsics.checkNotNullParameter((Object)((Object)recordType), (String)"recordType");
        return this.getEnumTranslation().recordType(recordType);
    }

    @NotNull
    public final String getDrugName(@Nullable Drug drug) {
        Object object;
        block8: {
            block7: {
                object = drug;
                if (object == null) break block7;
                Drug it = object;
                boolean bl = false;
                String string = switch (WhenMappings.$EnumSwitchMapping$0[this.language.ordinal()]) {
                    case 1 -> it.getNamePT();
                    case 2 -> it.getNameEN();
                    case 3 -> it.getNameES();
                    default -> throw new NoWhenBranchMatchedException();
                };
                object = string;
                if (string != null) break block8;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getDrugVariants(@Nullable Drug drug) {
        Object object;
        block8: {
            block7: {
                object = drug;
                if (object == null) break block7;
                Drug it = object;
                boolean bl = false;
                String string = switch (WhenMappings.$EnumSwitchMapping$0[this.language.ordinal()]) {
                    case 1 -> it.getVariantsPT();
                    case 2 -> it.getVariantsEN();
                    case 3 -> it.getVariantsES();
                    default -> throw new NoWhenBranchMatchedException();
                };
                object = string;
                if (string != null) break block8;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getDrugName(@Nullable DrugItem drugItem) {
        Object object;
        block10: {
            block9: {
                String string;
                object = drugItem;
                if (object == null) break block9;
                DrugItem it = object;
                boolean bl = false;
                DrugItem drugItem2 = it;
                if (drugItem2 instanceof DrugItem.Single) {
                    string = this.getDrugName(((DrugItem.Single)it).getDrug());
                } else if (drugItem2 instanceof DrugItem.Combined) {
                    string = ((DrugItem.Combined)it).getName();
                    if (string == null) {
                        string = this.getAllDrugNames((DrugItem.Combined)it);
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                object = string;
                if (string != null) break block10;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getDrugVariants(@Nullable DrugItem drugItem) {
        Object object;
        block11: {
            block6: {
                String string;
                block8: {
                    block9: {
                        block10: {
                            DrugItem drugItem2;
                            DrugItem it;
                            block7: {
                                object = drugItem;
                                if (object == null) break block6;
                                it = object;
                                boolean bl = false;
                                drugItem2 = it;
                                if (!(drugItem2 instanceof DrugItem.Single)) break block7;
                                string = this.getDrugVariants(((DrugItem.Single)it).getDrug());
                                break block8;
                            }
                            if (!(drugItem2 instanceof DrugItem.Combined)) break block9;
                            string = ((DrugItem.Combined)it).getName();
                            if (string == null) break block10;
                            String $this$getDrugVariants_u24lambda_u2413_u24lambda_u2412 = string;
                            boolean bl = false;
                            String string2 = this.getAllDrugNames((DrugItem.Combined)it);
                            string = string2;
                            if (string2 != null) break block8;
                        }
                        string = "";
                        break block8;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                object = string;
                if (string != null) break block11;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getDrugClassification(@Nullable Drug.Classification drugClassification) {
        Object object;
        block8: {
            block7: {
                object = drugClassification;
                if (object == null) break block7;
                Drug.Classification it = object;
                boolean bl = false;
                String string = switch (WhenMappings.$EnumSwitchMapping$0[this.language.ordinal()]) {
                    case 1 -> it.getPt();
                    case 2 -> it.getEn();
                    case 3 -> it.getEs();
                    default -> throw new NoWhenBranchMatchedException();
                };
                object = string;
                if (string != null) break block8;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public final String get(@NotNull CommonStrings key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return this.getEnumTranslation().get(key);
    }

    @NotNull
    public final String getWeight(@Nullable Float weight) {
        Object object;
        block3: {
            block2: {
                object = weight;
                if (object == null) break block2;
                float it = ((Number)object).floatValue();
                boolean bl = false;
                String string = StringExtensionsKt.toString((float)it, (int)1) + " kg";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String getAllDrugNames(DrugItem.Combined $this$getAllDrugNames) {
        return CollectionsKt.joinToString$default((Iterable)$this$getAllDrugNames.getDrugs(), (CharSequence)" + ", null, null, (int)0, null, arg_0 -> StringsRepository.getAllDrugNames$lambda$16(this, arg_0), (int)30, null);
    }

    @NotNull
    public final String getKnownSpecies(@NotNull KnownSpecies knownSpecies) {
        Intrinsics.checkNotNullParameter((Object)((Object)knownSpecies), (String)"knownSpecies");
        return this.getEnumTranslation().knownSpecies(knownSpecies);
    }

    @NotNull
    public final String get(@NotNull ApplicationErrorType error) {
        Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
        return this.getEnumTranslation().get(error);
    }

    @NotNull
    public final String getBatteryInfoString(@Nullable BatteryInfoModel batteryInfo) {
        StringBuilder stringBuilder;
        if (batteryInfo == null) {
            return this.getEnumTranslation().get(CommonStrings.UNKNOWN);
        }
        StringBuilder $this$getBatteryInfoString_u24lambda_u2417 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getBatteryInfoString_u24lambda_u2417.append(batteryInfo.getCharge());
        $this$getBatteryInfoString_u24lambda_u2417.append("% - ");
        if (batteryInfo.isCharging()) {
            v0 = $this$getBatteryInfoString_u24lambda_u2417.append(this.getEnumTranslation().get(CommonStrings.CHARGING));
        } else {
            int hours = batteryInfo.getDurationInMinutes() / 60;
            int minOfHour = batteryInfo.getDurationInMinutes() % 60;
            $this$getBatteryInfoString_u24lambda_u2417.append(hours);
            $this$getBatteryInfoString_u24lambda_u2417.append("h");
            $this$getBatteryInfoString_u24lambda_u2417.append(minOfHour);
            v0 = $this$getBatteryInfoString_u24lambda_u2417.append("m");
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final String getMonitorEventType(@NotNull MonitorEventType event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        return this.getEnumTranslation().monitorEventType(event);
    }

    private static final void getAge$appendMonths(StringBuilder $this$getAge_u24appendMonths, StringsRepository this$0, int month) {
        $this$getAge_u24appendMonths.append(month);
        $this$getAge_u24appendMonths.append(" ");
        $this$getAge_u24appendMonths.append(month == 1 ? this$0.get(CommonStrings.MONTH) : this$0.get(CommonStrings.MONTHS));
    }

    private static final String getTime_LRDsOJo$withTwoDigits(int $this$getTime_LRDsOJo_u24withTwoDigits) {
        return StringsKt.padStart((String)StringsKt.takeLast((String)String.valueOf($this$getTime_LRDsOJo_u24withTwoDigits), (int)2), (int)2, (char)'0');
    }

    private static final CharSequence getAllDrugNames$lambda$16(StringsRepository this$0, DrugItem.Single it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getDrugName(it.getDrug());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AvailableLanguage.values().length];
            try {
                nArray[AvailableLanguage.PT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AvailableLanguage.EN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AvailableLanguage.ES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

