/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.models.record_data;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.uuid.Uuid;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.FloatSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.models.model.NibpCalculator;
import vet.inpulse.core.models.record_data.BloodPressure;
import vet.inpulse.core.models.record_data.BloodPressureIndexes;
import vet.inpulse.core.models.record_data.BloodPressureIndexes$;
import vet.inpulse.core.models.record_data.BloodPressures;
import vet.inpulse.core.models.record_data.NibpCalculatorOutput$Success$;
import vet.inpulse.core.models.record_data.NibpCuffSize;
import vet.inpulse.core.models.record_data.NibpMeasurementScores;
import vet.inpulse.core.models.record_data.NibpMeasurementScores$;
import vet.inpulse.core.models.record_data.PulsePerMinute;
import vet.inpulse.core.models.record_data.PulsePerMinute$;
import vet.inpulse.shared.models.NibpProcedureRequest;
import vet.inpulse.shared.utils.UuidAsStringSerializer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0006\u0007\bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lvet/inpulse/core/models/record_data/NibpCalculatorOutput;", "", "measurementTime", "", "getMeasurementTime", "()J", "Success", "Failed", "Calculating", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput$Calculating;", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput$Failed;", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput$Success;", "core-models"})
public interface NibpCalculatorOutput {
    public long getMeasurementTime();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lvet/inpulse/core/models/record_data/NibpCalculatorOutput$Calculating;", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput;", "measurementTime", "", "<init>", "(J)V", "getMeasurementTime", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core-models"})
    public static final class Calculating
    implements NibpCalculatorOutput {
        private final long measurementTime;

        public Calculating(long measurementTime) {
            this.measurementTime = measurementTime;
        }

        @Override
        public long getMeasurementTime() {
            return this.measurementTime;
        }

        public final long component1() {
            return this.measurementTime;
        }

        @NotNull
        public final Calculating copy(long measurementTime) {
            return new Calculating(measurementTime);
        }

        public static /* synthetic */ Calculating copy$default(Calculating calculating, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = calculating.measurementTime;
            }
            return calculating.copy(l);
        }

        @NotNull
        public String toString() {
            return "Calculating(measurementTime=" + this.measurementTime + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.measurementTime);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Calculating)) {
                return false;
            }
            Calculating calculating = (Calculating)other;
            return this.measurementTime == calculating.measurementTime;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lvet/inpulse/core/models/record_data/NibpCalculatorOutput$Failed;", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput;", "measurementTime", "", "error", "", "<init>", "(JLjava/lang/Throwable;)V", "getMeasurementTime", "()J", "getError", "()Ljava/lang/Throwable;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core-models"})
    public static final class Failed
    implements NibpCalculatorOutput {
        private final long measurementTime;
        @NotNull
        private final Throwable error;

        public Failed(long measurementTime, @NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.measurementTime = measurementTime;
            this.error = error;
        }

        @Override
        public long getMeasurementTime() {
            return this.measurementTime;
        }

        @NotNull
        public final Throwable getError() {
            return this.error;
        }

        public final long component1() {
            return this.measurementTime;
        }

        @NotNull
        public final Throwable component2() {
            return this.error;
        }

        @NotNull
        public final Failed copy(long measurementTime, @NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new Failed(measurementTime, error);
        }

        public static /* synthetic */ Failed copy$default(Failed failed, long l, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                l = failed.measurementTime;
            }
            if ((n & 2) != 0) {
                throwable = failed.error;
            }
            return failed.copy(l, throwable);
        }

        @NotNull
        public String toString() {
            return "Failed(measurementTime=" + this.measurementTime + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.measurementTime);
            result = result * 31 + this.error.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Failed)) {
                return false;
            }
            Failed failed = (Failed)other;
            if (this.measurementTime != failed.measurementTime) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)failed.error);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 u2\u00020\u0001:\u0002tuB\u00b3\u0001\u0012\u000e\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u000b\u0012\u0006\u0010\u0013\u001a\u00020\u000b\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fB\u00cb\u0001\b\u0010\u0012\u0006\u0010 \u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u000b\u0012\u0006\u0010\u0013\u001a\u00020\u000b\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u0012\b\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0004\b\u001e\u0010#J\f\u0010@\u001a\u00020\u000b*\u00020\u000bH\u0002J\r\u0010A\u001a\u00020B\u00a2\u0006\u0004\bC\u0010-J\r\u0010D\u001a\u00020E\u00a2\u0006\u0004\bF\u0010-J\r\u0010G\u001a\u00020H\u00a2\u0006\u0004\bI\u0010-J\u0006\u0010J\u001a\u00020KJ\r\u0010L\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010MJ\r\u0010N\u001a\u00020O\u00a2\u0006\u0004\bP\u0010)J\r\u0010Q\u001a\u00020O\u00a2\u0006\u0004\bR\u0010)J\u0011\u0010S\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u00c6\u0003J\t\u0010T\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010U\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010V\u001a\u00020\u000bH\u00c6\u0003J\u000f\u0010W\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010X\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010Z\u001a\u00020\u0010H\u00c6\u0003J\t\u0010[\u001a\u00020\u0010H\u00c6\u0003J\t\u0010\\\u001a\u00020\u000bH\u00c6\u0003J\t\u0010]\u001a\u00020\u000bH\u00c6\u0003J\u0010\u0010^\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003\u00a2\u0006\u0002\b_J\u000b\u0010`\u001a\u0004\u0018\u00010\u0017H\u00c6\u0003J\u000b\u0010a\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003J\u000b\u0010b\u001a\u0004\u0018\u00010\u001bH\u00c6\u0003J\u000b\u0010c\u001a\u0004\u0018\u00010\u001dH\u00c6\u0003J\u00d8\u0001\u0010d\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u000b2\b\b\u0002\u0010\u0013\u001a\u00020\u000b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00c6\u0001\u00a2\u0006\u0002\beJ\u0013\u0010f\u001a\u00020g2\b\u0010h\u001a\u0004\u0018\u00010iH\u00d6\u0003J\t\u0010j\u001a\u00020\u000bH\u00d6\u0001J\t\u0010k\u001a\u00020\u001bH\u00d6\u0001J%\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020\u00002\u0006\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020rH\u0001\u00a2\u0006\u0002\bsR$\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010+R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010+R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010+R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00102R\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010-R\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010-R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?\u00a8\u0006v"}, d2={"Lvet/inpulse/core/models/record_data/NibpCalculatorOutput$Success;", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput;", "id", "Lkotlin/uuid/Uuid;", "Lvet/inpulse/shared/models/UUID;", "measurementTime", "", "rawBloodPressure", "", "", "startDeflationIndex", "", "deflation", "oscillometry", "envelope", "calculatedBloodPressureIndexes", "Lvet/inpulse/core/models/record_data/BloodPressureIndexes;", "bloodPressureIndexes", "leftTrimIndex", "rightTrimIndex", "pulsePerMinute", "Lvet/inpulse/core/models/record_data/PulsePerMinute;", "cuffSize", "Lvet/inpulse/core/models/record_data/NibpCuffSize;", "request", "Lvet/inpulse/shared/models/NibpProcedureRequest;", "algorithmVersion", "", "scores", "Lvet/inpulse/core/models/record_data/NibpMeasurementScores;", "<init>", "(Lkotlin/uuid/Uuid;JLjava/util/List;ILjava/util/List;Ljava/util/List;Ljava/util/List;Lvet/inpulse/core/models/record_data/BloodPressureIndexes;Lvet/inpulse/core/models/record_data/BloodPressureIndexes;IILvet/inpulse/core/models/record_data/PulsePerMinute;Lvet/inpulse/core/models/record_data/NibpCuffSize;Lvet/inpulse/shared/models/NibpProcedureRequest;Ljava/lang/String;Lvet/inpulse/core/models/record_data/NibpMeasurementScores;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILkotlin/uuid/Uuid;JLjava/util/List;ILjava/util/List;Ljava/util/List;Ljava/util/List;Lvet/inpulse/core/models/record_data/BloodPressureIndexes;Lvet/inpulse/core/models/record_data/BloodPressureIndexes;IILvet/inpulse/core/models/record_data/PulsePerMinute;Lvet/inpulse/core/models/record_data/NibpCuffSize;Lvet/inpulse/shared/models/NibpProcedureRequest;Ljava/lang/String;Lvet/inpulse/core/models/record_data/NibpMeasurementScores;Lkotlinx/serialization/internal/SerializationConstructorMarker;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getId$annotations", "()V", "getId", "()Lkotlin/uuid/Uuid;", "getMeasurementTime", "()J", "getRawBloodPressure", "()Ljava/util/List;", "getStartDeflationIndex", "()I", "getDeflation", "getOscillometry", "getEnvelope", "getCalculatedBloodPressureIndexes", "()Lvet/inpulse/core/models/record_data/BloodPressureIndexes;", "getBloodPressureIndexes", "getLeftTrimIndex", "getRightTrimIndex", "getPulsePerMinute-8kGXVMQ", "()Lvet/inpulse/core/models/record_data/PulsePerMinute;", "getCuffSize", "()Lvet/inpulse/core/models/record_data/NibpCuffSize;", "getRequest", "()Lvet/inpulse/shared/models/NibpProcedureRequest;", "getAlgorithmVersion", "()Ljava/lang/String;", "getScores", "()Lvet/inpulse/core/models/record_data/NibpMeasurementScores;", "findValueOnDeflation", "getSystolicPressure", "Lvet/inpulse/core/models/record_data/BloodPressure$Systolic;", "getSystolicPressure-2AKUNdQ", "getMeanPressure", "Lvet/inpulse/core/models/record_data/BloodPressure$Mean;", "getMeanPressure-c9_QRUg", "getDiastolicPressure", "Lvet/inpulse/core/models/record_data/BloodPressure$Diastolic;", "getDiastolicPressure-S1WnChQ", "getBloodPressureValues", "Lvet/inpulse/core/models/record_data/BloodPressures;", "getMeanSlope", "()Ljava/lang/Float;", "getProcedureDuration", "Lkotlin/time/Duration;", "getProcedureDuration-UwyO8pc", "getDeflationDuration", "getDeflationDuration-UwyO8pc", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component12-8kGXVMQ", "component13", "component14", "component15", "component16", "copy", "copy-QKKRFQE", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core_models", "$serializer", "Companion", "core-models"})
    public static final class Success
    implements NibpCalculatorOutput {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Uuid id;
        private final long measurementTime;
        @NotNull
        private final List<Float> rawBloodPressure;
        private final int startDeflationIndex;
        @NotNull
        private final List<Float> deflation;
        @NotNull
        private final List<Float> oscillometry;
        @NotNull
        private final List<Float> envelope;
        @NotNull
        private final BloodPressureIndexes calculatedBloodPressureIndexes;
        @NotNull
        private final BloodPressureIndexes bloodPressureIndexes;
        private final int leftTrimIndex;
        private final int rightTrimIndex;
        @Nullable
        private final PulsePerMinute pulsePerMinute;
        @Nullable
        private final NibpCuffSize cuffSize;
        @Nullable
        private final NibpProcedureRequest request;
        @Nullable
        private final String algorithmVersion;
        @Nullable
        private final NibpMeasurementScores scores;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        private Success(Uuid id, long measurementTime, List<Float> rawBloodPressure, int startDeflationIndex, List<Float> deflation, List<Float> oscillometry, List<Float> envelope, BloodPressureIndexes calculatedBloodPressureIndexes, BloodPressureIndexes bloodPressureIndexes, int leftTrimIndex, int rightTrimIndex, PulsePerMinute pulsePerMinute, NibpCuffSize cuffSize, NibpProcedureRequest request, String algorithmVersion, NibpMeasurementScores scores) {
            Intrinsics.checkNotNullParameter(rawBloodPressure, (String)"rawBloodPressure");
            Intrinsics.checkNotNullParameter(deflation, (String)"deflation");
            Intrinsics.checkNotNullParameter(oscillometry, (String)"oscillometry");
            Intrinsics.checkNotNullParameter(envelope, (String)"envelope");
            Intrinsics.checkNotNullParameter((Object)calculatedBloodPressureIndexes, (String)"calculatedBloodPressureIndexes");
            Intrinsics.checkNotNullParameter((Object)bloodPressureIndexes, (String)"bloodPressureIndexes");
            this.id = id;
            this.measurementTime = measurementTime;
            this.rawBloodPressure = rawBloodPressure;
            this.startDeflationIndex = startDeflationIndex;
            this.deflation = deflation;
            this.oscillometry = oscillometry;
            this.envelope = envelope;
            this.calculatedBloodPressureIndexes = calculatedBloodPressureIndexes;
            this.bloodPressureIndexes = bloodPressureIndexes;
            this.leftTrimIndex = leftTrimIndex;
            this.rightTrimIndex = rightTrimIndex;
            this.pulsePerMinute = pulsePerMinute;
            this.cuffSize = cuffSize;
            this.request = request;
            this.algorithmVersion = algorithmVersion;
            this.scores = scores;
        }

        public /* synthetic */ Success(Uuid uuid, long l, List list, int n, List list2, List list3, List list4, BloodPressureIndexes bloodPressureIndexes, BloodPressureIndexes bloodPressureIndexes2, int n2, int n3, PulsePerMinute pulsePerMinute, NibpCuffSize nibpCuffSize, NibpProcedureRequest nibpProcedureRequest, String string, NibpMeasurementScores nibpMeasurementScores, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 0x8000) != 0) {
                nibpMeasurementScores = null;
            }
            this(uuid, l, list, n, list2, list3, list4, bloodPressureIndexes, bloodPressureIndexes2, n2, n3, pulsePerMinute, nibpCuffSize, nibpProcedureRequest, string, nibpMeasurementScores, null);
        }

        @Nullable
        public final Uuid getId() {
            return this.id;
        }

        @Serializable(with=UuidAsStringSerializer.class)
        public static /* synthetic */ void getId$annotations() {
        }

        @Override
        public long getMeasurementTime() {
            return this.measurementTime;
        }

        @NotNull
        public final List<Float> getRawBloodPressure() {
            return this.rawBloodPressure;
        }

        public final int getStartDeflationIndex() {
            return this.startDeflationIndex;
        }

        @NotNull
        public final List<Float> getDeflation() {
            return this.deflation;
        }

        @NotNull
        public final List<Float> getOscillometry() {
            return this.oscillometry;
        }

        @NotNull
        public final List<Float> getEnvelope() {
            return this.envelope;
        }

        @NotNull
        public final BloodPressureIndexes getCalculatedBloodPressureIndexes() {
            return this.calculatedBloodPressureIndexes;
        }

        @NotNull
        public final BloodPressureIndexes getBloodPressureIndexes() {
            return this.bloodPressureIndexes;
        }

        public final int getLeftTrimIndex() {
            return this.leftTrimIndex;
        }

        public final int getRightTrimIndex() {
            return this.rightTrimIndex;
        }

        @Nullable
        public final PulsePerMinute getPulsePerMinute-8kGXVMQ() {
            return this.pulsePerMinute;
        }

        @Nullable
        public final NibpCuffSize getCuffSize() {
            return this.cuffSize;
        }

        @Nullable
        public final NibpProcedureRequest getRequest() {
            return this.request;
        }

        @Nullable
        public final String getAlgorithmVersion() {
            return this.algorithmVersion;
        }

        @Nullable
        public final NibpMeasurementScores getScores() {
            return this.scores;
        }

        private final int findValueOnDeflation(int $this$findValueOnDeflation) {
            return (int)((Number)this.deflation.get(RangesKt.coerceIn((int)$this$findValueOnDeflation, (int)0, (int)CollectionsKt.getLastIndex(this.deflation)))).floatValue();
        }

        public final int getSystolicPressure-2AKUNdQ() {
            return BloodPressure.Systolic.constructor-impl(this.findValueOnDeflation(this.bloodPressureIndexes.getSystolic-gl8i1mk()));
        }

        public final int getMeanPressure-c9_QRUg() {
            return BloodPressure.Mean.constructor-impl(this.findValueOnDeflation(this.bloodPressureIndexes.getMean-8HJK8HE()));
        }

        public final int getDiastolicPressure-S1WnChQ() {
            return BloodPressure.Diastolic.constructor-impl(this.findValueOnDeflation(this.bloodPressureIndexes.getDiastolic-YiW0ZXM()));
        }

        @NotNull
        public final BloodPressures getBloodPressureValues() {
            return new BloodPressures(this.getSystolicPressure-2AKUNdQ(), this.getMeanPressure-c9_QRUg(), this.getDiastolicPressure-S1WnChQ(), null);
        }

        @Nullable
        public final Float getMeanSlope() {
            return NibpCalculator.Companion.calculateMeanSlope(this.deflation, 600.0f);
        }

        public final long getProcedureDuration-UwyO8pc() {
            return NibpCalculator.Companion.calculateDuration-3nIYWDw(this.rawBloodPressure.size(), 600.0);
        }

        public final long getDeflationDuration-UwyO8pc() {
            return NibpCalculator.Companion.calculateDuration-3nIYWDw(this.deflation.size(), 600.0);
        }

        @Nullable
        public final Uuid component1() {
            return this.id;
        }

        public final long component2() {
            return this.measurementTime;
        }

        @NotNull
        public final List<Float> component3() {
            return this.rawBloodPressure;
        }

        public final int component4() {
            return this.startDeflationIndex;
        }

        @NotNull
        public final List<Float> component5() {
            return this.deflation;
        }

        @NotNull
        public final List<Float> component6() {
            return this.oscillometry;
        }

        @NotNull
        public final List<Float> component7() {
            return this.envelope;
        }

        @NotNull
        public final BloodPressureIndexes component8() {
            return this.calculatedBloodPressureIndexes;
        }

        @NotNull
        public final BloodPressureIndexes component9() {
            return this.bloodPressureIndexes;
        }

        public final int component10() {
            return this.leftTrimIndex;
        }

        public final int component11() {
            return this.rightTrimIndex;
        }

        @Nullable
        public final PulsePerMinute component12-8kGXVMQ() {
            return this.pulsePerMinute;
        }

        @Nullable
        public final NibpCuffSize component13() {
            return this.cuffSize;
        }

        @Nullable
        public final NibpProcedureRequest component14() {
            return this.request;
        }

        @Nullable
        public final String component15() {
            return this.algorithmVersion;
        }

        @Nullable
        public final NibpMeasurementScores component16() {
            return this.scores;
        }

        @NotNull
        public final Success copy-QKKRFQE(@Nullable Uuid id, long measurementTime, @NotNull List<Float> rawBloodPressure, int startDeflationIndex, @NotNull List<Float> deflation, @NotNull List<Float> oscillometry, @NotNull List<Float> envelope, @NotNull BloodPressureIndexes calculatedBloodPressureIndexes, @NotNull BloodPressureIndexes bloodPressureIndexes, int leftTrimIndex, int rightTrimIndex, @Nullable PulsePerMinute pulsePerMinute, @Nullable NibpCuffSize cuffSize, @Nullable NibpProcedureRequest request, @Nullable String algorithmVersion, @Nullable NibpMeasurementScores scores) {
            Intrinsics.checkNotNullParameter(rawBloodPressure, (String)"rawBloodPressure");
            Intrinsics.checkNotNullParameter(deflation, (String)"deflation");
            Intrinsics.checkNotNullParameter(oscillometry, (String)"oscillometry");
            Intrinsics.checkNotNullParameter(envelope, (String)"envelope");
            Intrinsics.checkNotNullParameter((Object)calculatedBloodPressureIndexes, (String)"calculatedBloodPressureIndexes");
            Intrinsics.checkNotNullParameter((Object)bloodPressureIndexes, (String)"bloodPressureIndexes");
            return new Success(id, measurementTime, rawBloodPressure, startDeflationIndex, deflation, oscillometry, envelope, calculatedBloodPressureIndexes, bloodPressureIndexes, leftTrimIndex, rightTrimIndex, pulsePerMinute, cuffSize, request, algorithmVersion, scores, null);
        }

        public static /* synthetic */ Success copy-QKKRFQE$default(Success success, Uuid uuid, long l, List list, int n, List list2, List list3, List list4, BloodPressureIndexes bloodPressureIndexes, BloodPressureIndexes bloodPressureIndexes2, int n2, int n3, PulsePerMinute pulsePerMinute, NibpCuffSize nibpCuffSize, NibpProcedureRequest nibpProcedureRequest, String string, NibpMeasurementScores nibpMeasurementScores, int n4, Object object) {
            if ((n4 & 1) != 0) {
                uuid = success.id;
            }
            if ((n4 & 2) != 0) {
                l = success.measurementTime;
            }
            if ((n4 & 4) != 0) {
                list = success.rawBloodPressure;
            }
            if ((n4 & 8) != 0) {
                n = success.startDeflationIndex;
            }
            if ((n4 & 0x10) != 0) {
                list2 = success.deflation;
            }
            if ((n4 & 0x20) != 0) {
                list3 = success.oscillometry;
            }
            if ((n4 & 0x40) != 0) {
                list4 = success.envelope;
            }
            if ((n4 & 0x80) != 0) {
                bloodPressureIndexes = success.calculatedBloodPressureIndexes;
            }
            if ((n4 & 0x100) != 0) {
                bloodPressureIndexes2 = success.bloodPressureIndexes;
            }
            if ((n4 & 0x200) != 0) {
                n2 = success.leftTrimIndex;
            }
            if ((n4 & 0x400) != 0) {
                n3 = success.rightTrimIndex;
            }
            if ((n4 & 0x800) != 0) {
                pulsePerMinute = success.pulsePerMinute;
            }
            if ((n4 & 0x1000) != 0) {
                nibpCuffSize = success.cuffSize;
            }
            if ((n4 & 0x2000) != 0) {
                nibpProcedureRequest = success.request;
            }
            if ((n4 & 0x4000) != 0) {
                string = success.algorithmVersion;
            }
            if ((n4 & 0x8000) != 0) {
                nibpMeasurementScores = success.scores;
            }
            return success.copy-QKKRFQE(uuid, l, list, n, list2, list3, list4, bloodPressureIndexes, bloodPressureIndexes2, n2, n3, pulsePerMinute, nibpCuffSize, nibpProcedureRequest, string, nibpMeasurementScores);
        }

        @NotNull
        public String toString() {
            return "Success(id=" + this.id + ", measurementTime=" + this.measurementTime + ", rawBloodPressure=" + this.rawBloodPressure + ", startDeflationIndex=" + this.startDeflationIndex + ", deflation=" + this.deflation + ", oscillometry=" + this.oscillometry + ", envelope=" + this.envelope + ", calculatedBloodPressureIndexes=" + this.calculatedBloodPressureIndexes + ", bloodPressureIndexes=" + this.bloodPressureIndexes + ", leftTrimIndex=" + this.leftTrimIndex + ", rightTrimIndex=" + this.rightTrimIndex + ", pulsePerMinute=" + this.pulsePerMinute + ", cuffSize=" + this.cuffSize + ", request=" + this.request + ", algorithmVersion=" + this.algorithmVersion + ", scores=" + this.scores + ")";
        }

        public int hashCode() {
            int result = this.id == null ? 0 : this.id.hashCode();
            result = result * 31 + Long.hashCode(this.measurementTime);
            result = result * 31 + ((Object)this.rawBloodPressure).hashCode();
            result = result * 31 + Integer.hashCode(this.startDeflationIndex);
            result = result * 31 + ((Object)this.deflation).hashCode();
            result = result * 31 + ((Object)this.oscillometry).hashCode();
            result = result * 31 + ((Object)this.envelope).hashCode();
            result = result * 31 + this.calculatedBloodPressureIndexes.hashCode();
            result = result * 31 + this.bloodPressureIndexes.hashCode();
            result = result * 31 + Integer.hashCode(this.leftTrimIndex);
            result = result * 31 + Integer.hashCode(this.rightTrimIndex);
            result = result * 31 + (this.pulsePerMinute == null ? 0 : PulsePerMinute.hashCode-impl(this.pulsePerMinute.unbox-impl()));
            result = result * 31 + (this.cuffSize == null ? 0 : this.cuffSize.hashCode());
            result = result * 31 + (this.request == null ? 0 : this.request.hashCode());
            result = result * 31 + (this.algorithmVersion == null ? 0 : this.algorithmVersion.hashCode());
            result = result * 31 + (this.scores == null ? 0 : this.scores.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success = (Success)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)success.id)) {
                return false;
            }
            if (this.measurementTime != success.measurementTime) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rawBloodPressure, success.rawBloodPressure)) {
                return false;
            }
            if (this.startDeflationIndex != success.startDeflationIndex) {
                return false;
            }
            if (!Intrinsics.areEqual(this.deflation, success.deflation)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.oscillometry, success.oscillometry)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.envelope, success.envelope)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.calculatedBloodPressureIndexes, (Object)success.calculatedBloodPressureIndexes)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bloodPressureIndexes, (Object)success.bloodPressureIndexes)) {
                return false;
            }
            if (this.leftTrimIndex != success.leftTrimIndex) {
                return false;
            }
            if (this.rightTrimIndex != success.rightTrimIndex) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pulsePerMinute, (Object)success.pulsePerMinute)) {
                return false;
            }
            if (this.cuffSize != success.cuffSize) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.request, (Object)success.request)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.algorithmVersion, (Object)success.algorithmVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.scores, (Object)success.scores);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$core_models(Success self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)UuidAsStringSerializer.INSTANCE, (Object)self.id);
            output.encodeLongElement(serialDesc, 1, self.getMeasurementTime());
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.rawBloodPressure);
            output.encodeIntElement(serialDesc, 3, self.startDeflationIndex);
            output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)lazyArray[4].getValue(), self.deflation);
            output.encodeSerializableElement(serialDesc, 5, (SerializationStrategy)lazyArray[5].getValue(), self.oscillometry);
            output.encodeSerializableElement(serialDesc, 6, (SerializationStrategy)lazyArray[6].getValue(), self.envelope);
            output.encodeSerializableElement(serialDesc, 7, (SerializationStrategy)BloodPressureIndexes$.serializer.INSTANCE, (Object)self.calculatedBloodPressureIndexes);
            output.encodeSerializableElement(serialDesc, 8, (SerializationStrategy)BloodPressureIndexes$.serializer.INSTANCE, (Object)self.bloodPressureIndexes);
            output.encodeIntElement(serialDesc, 9, self.leftTrimIndex);
            output.encodeIntElement(serialDesc, 10, self.rightTrimIndex);
            output.encodeNullableSerializableElement(serialDesc, 11, (SerializationStrategy)PulsePerMinute$.serializer.INSTANCE, (Object)self.pulsePerMinute);
            output.encodeNullableSerializableElement(serialDesc, 12, (SerializationStrategy)lazyArray[12].getValue(), (Object)self.cuffSize);
            output.encodeNullableSerializableElement(serialDesc, 13, (SerializationStrategy)NibpProcedureRequest.$serializer.INSTANCE, (Object)self.request);
            output.encodeNullableSerializableElement(serialDesc, 14, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.algorithmVersion);
            if (output.shouldEncodeElementDefault(serialDesc, 15) ? true : self.scores != null) {
                output.encodeNullableSerializableElement(serialDesc, 15, (SerializationStrategy)NibpMeasurementScores$.serializer.INSTANCE, (Object)self.scores);
            }
        }

        private /* synthetic */ Success(int seen0, Uuid id, long measurementTime, List rawBloodPressure, int startDeflationIndex, List deflation, List oscillometry, List envelope, BloodPressureIndexes calculatedBloodPressureIndexes, BloodPressureIndexes bloodPressureIndexes, int leftTrimIndex, int rightTrimIndex, PulsePerMinute pulsePerMinute, NibpCuffSize cuffSize, NibpProcedureRequest request, String algorithmVersion, NibpMeasurementScores scores, SerializationConstructorMarker serializationConstructorMarker) {
            if (Short.MAX_VALUE != (Short.MAX_VALUE & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)Short.MAX_VALUE, (SerialDescriptor)Success$$serializer.INSTANCE.getDescriptor());
            }
            this.id = id;
            this.measurementTime = measurementTime;
            this.rawBloodPressure = rawBloodPressure;
            this.startDeflationIndex = startDeflationIndex;
            this.deflation = deflation;
            this.oscillometry = oscillometry;
            this.envelope = envelope;
            this.calculatedBloodPressureIndexes = calculatedBloodPressureIndexes;
            this.bloodPressureIndexes = bloodPressureIndexes;
            this.leftTrimIndex = leftTrimIndex;
            this.rightTrimIndex = rightTrimIndex;
            this.pulsePerMinute = pulsePerMinute;
            this.cuffSize = cuffSize;
            this.request = request;
            this.algorithmVersion = algorithmVersion;
            this.scores = (seen0 & 0x8000) == 0 ? null : scores;
        }

        public /* synthetic */ Success(Uuid id, long measurementTime, List rawBloodPressure, int startDeflationIndex, List deflation, List oscillometry, List envelope, BloodPressureIndexes calculatedBloodPressureIndexes, BloodPressureIndexes bloodPressureIndexes, int leftTrimIndex, int rightTrimIndex, PulsePerMinute pulsePerMinute, NibpCuffSize cuffSize, NibpProcedureRequest request, String algorithmVersion, NibpMeasurementScores scores, DefaultConstructorMarker $constructor_marker) {
            this(id, measurementTime, rawBloodPressure, startDeflationIndex, deflation, oscillometry, envelope, calculatedBloodPressureIndexes, bloodPressureIndexes, leftTrimIndex, rightTrimIndex, pulsePerMinute, cuffSize, request, algorithmVersion, scores);
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        public /* synthetic */ Success(int seen0, Uuid id, long measurementTime, List rawBloodPressure, int startDeflationIndex, List deflation, List oscillometry, List envelope, BloodPressureIndexes calculatedBloodPressureIndexes, BloodPressureIndexes bloodPressureIndexes, int leftTrimIndex, int rightTrimIndex, PulsePerMinute pulsePerMinute, NibpCuffSize cuffSize, NibpProcedureRequest request, String algorithmVersion, NibpMeasurementScores scores, SerializationConstructorMarker serializationConstructorMarker, DefaultConstructorMarker $constructor_marker) {
            this(seen0, id, measurementTime, rawBloodPressure, startDeflationIndex, deflation, oscillometry, envelope, calculatedBloodPressureIndexes, bloodPressureIndexes, leftTrimIndex, rightTrimIndex, pulsePerMinute, cuffSize, request, algorithmVersion, scores, serializationConstructorMarker);
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)FloatSerializer.INSTANCE)), null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)FloatSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)FloatSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)FloatSerializer.INSTANCE)), null, null, null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"vet.inpulse.core.models.record_data.NibpCuffSize", (Enum[])NibpCuffSize.values())), null, null, null};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lvet/inpulse/core/models/record_data/NibpCalculatorOutput$Success$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput$Success;", "core-models"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Success> serializer() {
                return (KSerializer)Success$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

