/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.models.model;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.models.record_data.NibpCalculatorOutput;
import vet.inpulse.core.models.record_data.NibpMeasurementScores;
import vet.inpulse.core.models.record_data.NibpOscillometryData;
import vet.inpulse.core.models.record_data.NibpPulseInfo;
import vet.inpulse.core.models.utils.SignalProcessingAlgorithmVersion;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\bf\u0018\u0000 $2\u00020\u0001:\u0001$J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH&JC\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\fH&\u00a2\u0006\u0002\u0010\u0013J5\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\fH&\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH&J!\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00072\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH&\u00a2\u0006\u0002\u0010 R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010!\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006%\u00c0\u0006\u0003"}, d2={"Lvet/inpulse/core/models/model/NibpCalculator;", "", "version", "Lvet/inpulse/core/models/utils/SignalProcessingAlgorithmVersion;", "getVersion", "()Lvet/inpulse/core/models/utils/SignalProcessingAlgorithmVersion;", "calculateOscillometryData", "Lvet/inpulse/core/models/record_data/NibpOscillometryData;", "rawBloodPressure", "", "", "startDeflationIndex", "", "calculateResult", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput;", "timestamp", "", "customLeftTrim", "customRightTrim", "(Ljava/util/List;IJLjava/lang/Integer;Ljava/lang/Integer;)Lvet/inpulse/core/models/record_data/NibpCalculatorOutput;", "data", "(Lvet/inpulse/core/models/record_data/NibpOscillometryData;JLjava/lang/Integer;Ljava/lang/Integer;)Lvet/inpulse/core/models/record_data/NibpCalculatorOutput;", "calculatePulsePeaks", "Lvet/inpulse/core/models/record_data/NibpPulseInfo;", "oscillometryData", "", "offset", "length", "calculateScores", "Lvet/inpulse/core/models/record_data/NibpMeasurementScores;", "systolicOutOfBounds", "", "(Lvet/inpulse/core/models/record_data/NibpOscillometryData;Ljava/lang/Boolean;)Lvet/inpulse/core/models/record_data/NibpMeasurementScores;", "samplingFrequency", "getSamplingFrequency", "()I", "Companion", "core-models"})
public interface NibpCalculator {
    @NotNull
    public static final Companion Companion = vet.inpulse.core.models.model.NibpCalculator$Companion.$$INSTANCE;

    @NotNull
    public SignalProcessingAlgorithmVersion getVersion();

    @NotNull
    public NibpOscillometryData calculateOscillometryData(@NotNull List<Float> var1, int var2);

    @NotNull
    public NibpCalculatorOutput calculateResult(@NotNull List<Float> var1, int var2, long var3, @Nullable Integer var5, @Nullable Integer var6);

    public static /* synthetic */ NibpCalculatorOutput calculateResult$default(NibpCalculator nibpCalculator, List list, int n, long l, Integer n2, Integer n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: calculateResult");
        }
        if ((n4 & 8) != 0) {
            n2 = null;
        }
        if ((n4 & 0x10) != 0) {
            n3 = null;
        }
        return nibpCalculator.calculateResult(list, n, l, n2, n3);
    }

    @NotNull
    public NibpCalculatorOutput calculateResult(@NotNull NibpOscillometryData var1, long var2, @Nullable Integer var4, @Nullable Integer var5);

    public static /* synthetic */ NibpCalculatorOutput calculateResult$default(NibpCalculator nibpCalculator, NibpOscillometryData nibpOscillometryData, long l, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: calculateResult");
        }
        if ((n3 & 4) != 0) {
            n = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        return nibpCalculator.calculateResult(nibpOscillometryData, l, n, n2);
    }

    @NotNull
    public NibpPulseInfo calculatePulsePeaks(@NotNull float[] var1, int var2, int var3);

    @NotNull
    public NibpMeasurementScores calculateScores(@NotNull NibpOscillometryData var1, @Nullable Boolean var2);

    public static /* synthetic */ NibpMeasurementScores calculateScores$default(NibpCalculator nibpCalculator, NibpOscillometryData nibpOscillometryData, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: calculateScores");
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        return nibpCalculator.calculateScores(nibpOscillometryData, bl);
    }

    public int getSamplingFrequency();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lvet/inpulse/core/models/model/NibpCalculator$Companion;", "", "<init>", "()V", "calculateMeanSlope", "", "deflation", "", "samplingFrequency", "(Ljava/util/List;F)Ljava/lang/Float;", "calculateDuration", "Lkotlin/time/Duration;", "samples", "", "", "calculateDuration-3nIYWDw", "(ID)J", "core-models"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @Nullable
        public final Float calculateMeanSlope(@NotNull List<Float> deflation, float samplingFrequency) {
            Intrinsics.checkNotNullParameter(deflation, (String)"deflation");
            if ((float)deflation.size() <= samplingFrequency) {
                return null;
            }
            int initialIndex = deflation.size() / 3;
            int endIndex = initialIndex * 2 - 1;
            float initialPressure = ((Number)deflation.get(initialIndex)).floatValue();
            float endPressure = ((Number)deflation.get(endIndex)).floatValue();
            float deltaPressure = endPressure - initialPressure;
            float deltaTime = (float)(endIndex - initialIndex) / samplingFrequency;
            float slope = deltaPressure / deltaTime;
            return Float.valueOf(slope);
        }

        public final long calculateDuration-3nIYWDw(int samples, double samplingFrequency) {
            double seconds = (double)samples / samplingFrequency;
            return DurationKt.toDuration((double)seconds, (DurationUnit)DurationUnit.SECONDS);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ NibpCalculatorOutput calculateResult$default(NibpCalculator nibpCalculator, List list, int n, long l, Integer n2, Integer n3, int n4, Object object) {
            return NibpCalculator.calculateResult$default(nibpCalculator, list, n, l, n2, n3, n4, object);
        }

        public static /* synthetic */ NibpCalculatorOutput calculateResult$default(NibpCalculator nibpCalculator, NibpOscillometryData nibpOscillometryData, long l, Integer n, Integer n2, int n3, Object object) {
            return NibpCalculator.calculateResult$default(nibpCalculator, nibpOscillometryData, l, n, n2, n3, object);
        }

        public static /* synthetic */ NibpMeasurementScores calculateScores$default(NibpCalculator nibpCalculator, NibpOscillometryData nibpOscillometryData, Boolean bl, int n, Object object) {
            return NibpCalculator.calculateScores$default(nibpCalculator, nibpOscillometryData, bl, n, object);
        }
    }
}

