/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.models.cloud.auth;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.models.cloud.auth.Authentication;
import vet.inpulse.core.models.cloud.auth.Jwt;
import vet.inpulse.core.models.cloud.auth.OidcToken;
import vet.inpulse.core.models.cloud.auth.OrganizationMetadata;
import vet.inpulse.core.models.cloud.auth.TelemedicineCenterMetadata;
import vet.inpulse.shared.log.CoreLogModuleKt;
import vet.inpulse.shared.log.LoggerInterface;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"logger", "Lvet/inpulse/shared/log/LoggerInterface;", "toAuthentication", "Lvet/inpulse/core/models/cloud/auth/Authentication$Valid;", "Lvet/inpulse/core/models/cloud/auth/OidcToken;", "parseOrganizations", "", "Lvet/inpulse/core/models/cloud/auth/OrganizationMetadata;", "Lvet/inpulse/core/models/cloud/auth/Jwt;", "parseTelemedicineCenters", "Lvet/inpulse/core/models/cloud/auth/TelemedicineCenterMetadata;", "core-models"})
@SourceDebugExtension(value={"SMAP\nAuthUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthUtils.kt\nvet/inpulse/core/models/cloud/auth/AuthUtilsKt\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,57:1\n335#2:58\n335#2:59\n*S KotlinDebug\n*F\n+ 1 AuthUtils.kt\nvet/inpulse/core/models/cloud/auth/AuthUtilsKt\n*L\n34#1:58\n48#1:59\n*E\n"})
public final class AuthUtilsKt {
    @NotNull
    private static final LoggerInterface logger = CoreLogModuleKt.getCoreLogModule().getLogger("Auth");

    @NotNull
    public static final Authentication.Valid toAuthentication(@NotNull OidcToken $this$toAuthentication) {
        Intrinsics.checkNotNullParameter((Object)$this$toAuthentication, (String)"<this>");
        OidcToken token = $this$toAuthentication;
        Object object = Jwt.Companion.parse-IoAF18A(token.getAccess_token());
        ResultKt.throwOnFailure((Object)object);
        Jwt jwt = (Jwt)object;
        String string = jwt.getSub();
        String string2 = jwt.getEmail();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = jwt.getName();
        if (string3 == null) {
            string3 = "";
        }
        List<OrganizationMetadata> list = AuthUtilsKt.parseOrganizations(jwt);
        List<TelemedicineCenterMetadata> list2 = AuthUtilsKt.parseTelemedicineCenters(jwt);
        String string4 = token.getId_token();
        String string5 = token.getAccess_token();
        String string6 = token.getRefresh_token();
        Intrinsics.checkNotNull((Object)string6);
        Authentication.Valid authentication = new Authentication.Valid(string, string2, string3, list, list2, string4, string5, string6, MapsKt.toMap((Map)((Map)jwt.getPayload())), jwt.getPicture());
        return authentication;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<OrganizationMetadata> parseOrganizations(Jwt $this$parseOrganizations) {
        Object object;
        block5: {
            block4: {
                Object object2;
                object = (JsonElement)$this$parseOrganizations.getPayload().get((Object)"organizations");
                if (object == null) break block4;
                JsonElement raw = object;
                boolean bl = false;
                logger.v(() -> AuthUtilsKt.parseOrganizations$lambda$2$lambda$0(raw));
                try {
                    void $this$decodeFromJsonElement$iv;
                    object2 = (Json)Json.Default;
                    JsonElement json$iv = raw;
                    boolean $i$f$decodeFromJsonElement = false;
                    $this$decodeFromJsonElement$iv.getSerializersModule();
                    object2 = (List)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)new ArrayListSerializer(OrganizationMetadata.Companion.serializer()), json$iv);
                }
                catch (Exception ex) {
                    LoggerInterface.w$default((LoggerInterface)logger, null, () -> AuthUtilsKt.parseOrganizations$lambda$2$lambda$1(raw, ex), (int)1, null);
                    object2 = CollectionsKt.emptyList();
                }
                Object object3 = object2;
                object = object3;
                if (object3 != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TelemedicineCenterMetadata> parseTelemedicineCenters(@NotNull Jwt $this$parseTelemedicineCenters) {
        Object object;
        block5: {
            block4: {
                Object object2;
                Intrinsics.checkNotNullParameter((Object)$this$parseTelemedicineCenters, (String)"<this>");
                object = (JsonElement)$this$parseTelemedicineCenters.getPayload().get((Object)"telemedicineCenters");
                if (object == null) break block4;
                JsonElement raw = object;
                boolean bl = false;
                try {
                    void $this$decodeFromJsonElement$iv;
                    object2 = (Json)Json.Default;
                    JsonElement json$iv = raw;
                    boolean $i$f$decodeFromJsonElement = false;
                    $this$decodeFromJsonElement$iv.getSerializersModule();
                    object2 = (List)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)new ArrayListSerializer(TelemedicineCenterMetadata.Companion.serializer()), json$iv);
                }
                catch (Exception ex) {
                    LoggerInterface.w$default((LoggerInterface)logger, null, () -> AuthUtilsKt.parseTelemedicineCenters$lambda$4$lambda$3(raw, ex), (int)1, null);
                    object2 = CollectionsKt.emptyList();
                }
                Object object3 = object2;
                object = object3;
                if (object3 != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final String parseOrganizations$lambda$2$lambda$0(JsonElement $raw) {
        return "Parsing organizations from json: " + $raw;
    }

    private static final String parseOrganizations$lambda$2$lambda$1(JsonElement $raw, Exception $ex) {
        return "Failed to parse organizations from json: " + $raw + " - " + $ex;
    }

    private static final String parseTelemedicineCenters$lambda$4$lambda$3(JsonElement $raw, Exception $ex) {
        return "Failed to parse telemedicine centers from json: " + $raw + " - " + $ex;
    }
}

