/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.text.TextAutoSize;
import androidx.compose.foundation.text.modifiers.TextAutoSizeLayoutScope;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import androidx.compose.ui.unit.TextUnitType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\t\u001a\u00020\u0003*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u0013H\u0002J\f\u0010\u0015\u001a\u00020\u0012*\u00020\u0013H\u0002J\u0013\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u001b"}, d2={"Landroidx/compose/foundation/text/AutoSizeStepBased;", "Landroidx/compose/foundation/text/TextAutoSize;", "minFontSize", "Landroidx/compose/ui/unit/TextUnit;", "maxFontSize", "stepSize", "<init>", "(JJJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "getFontSize", "Landroidx/compose/foundation/text/modifiers/TextAutoSizeLayoutScope;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "text", "Landroidx/compose/ui/text/AnnotatedString;", "getFontSize-Ci0_558", "(Landroidx/compose/foundation/text/modifiers/TextAutoSizeLayoutScope;JLandroidx/compose/ui/text/AnnotatedString;)J", "didOverflow", "", "Landroidx/compose/ui/text/TextLayoutResult;", "didOverflowBounds", "didOverflowByEllipsize", "equals", "other", "", "hashCode", "", "foundation"})
@SourceDebugExtension(value={"SMAP\nTextAutoSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextAutoSize.kt\nandroidx/compose/foundation/text/AutoSizeStepBased\n+ 2 TextUnit.kt\nandroidx/compose/ui/unit/TextUnit\n*L\n1#1,256:1\n187#2,2:257\n187#2,2:259\n*S KotlinDebug\n*F\n+ 1 TextAutoSize.kt\nandroidx/compose/foundation/text/AutoSizeStepBased\n*L\n139#1:257,2\n144#1:259,2\n*E\n"})
final class AutoSizeStepBased
implements TextAutoSize {
    private long minFontSize;
    private final long maxFontSize;
    private final long stepSize;

    private AutoSizeStepBased(long minFontSize, long maxFontSize, long stepSize) {
        long l;
        boolean bl;
        long l2;
        this.minFontSize = minFontSize;
        this.maxFontSize = maxFontSize;
        this.stepSize = stepSize;
        if (TextUnit.equals-impl0((long)this.minFontSize, (long)TextUnit.Companion.getUnspecified-XSAIIZE())) {
            throw new IllegalArgumentException("AutoSize.StepBased: TextUnit.Unspecified is not a valid value for minFontSize. Try using other values e.g. 10.sp");
        }
        if (TextUnit.equals-impl0((long)this.maxFontSize, (long)TextUnit.Companion.getUnspecified-XSAIIZE())) {
            throw new IllegalArgumentException("AutoSize.StepBased: TextUnit.Unspecified is not a valid value for maxFontSize. Try using other values e.g. 100.sp");
        }
        if (TextUnit.equals-impl0((long)this.stepSize, (long)TextUnit.Companion.getUnspecified-XSAIIZE())) {
            throw new IllegalArgumentException("AutoSize.StepBased: TextUnit.Unspecified is not a valid value for stepSize. Try using other values e.g. 0.25.sp");
        }
        if (TextUnitType.equals-impl0((long)TextUnit.getType-UIouoOA((long)this.minFontSize), (long)TextUnit.getType-UIouoOA((long)this.maxFontSize))) {
            long l3 = this.minFontSize;
            l2 = this.maxFontSize;
            bl = false;
            TextUnitKt.checkArithmetic-NB67dxo((long)l, (long)l2);
            if (Float.compare(TextUnit.getValue-impl((long)l), TextUnit.getValue-impl((long)l2)) > 0) {
                this.minFontSize = this.maxFontSize;
            }
        }
        if (TextUnitType.equals-impl0((long)TextUnit.getType-UIouoOA((long)this.stepSize), (long)TextUnitType.Companion.getSp-UIouoOA())) {
            l = this.stepSize;
            l2 = TextUnitKt.getSp((float)1.0E-4f);
            bl = false;
            TextUnitKt.checkArithmetic-NB67dxo((long)l, (long)l2);
            if (Float.compare(TextUnit.getValue-impl((long)l), TextUnit.getValue-impl((long)l2)) < 0) {
                throw new IllegalArgumentException("AutoSize.StepBased: stepSize must be greater than or equal to 0.0001f.sp");
            }
        }
        if (TextUnit.getValue-impl((long)this.minFontSize) < 0.0f) {
            throw new IllegalArgumentException("AutoSize.StepBased: minFontSize must not be negative");
        }
        if (TextUnit.getValue-impl((long)this.maxFontSize) < 0.0f) {
            throw new IllegalArgumentException("AutoSize.StepBased: maxFontSize must not be negative");
        }
    }

    @Override
    public long getFontSize-Ci0_558(@NotNull TextAutoSizeLayoutScope $this$getFontSize_u2dCi0_558, long l, @NotNull AnnotatedString text) {
        TextLayoutResult layoutResult;
        Intrinsics.checkNotNullParameter((Object)$this$getFontSize_u2dCi0_558, (String)"$this$getFontSize");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        float stepSize = $this$getFontSize_u2dCi0_558.toPx--R2X_6o(this.stepSize);
        float smallest = $this$getFontSize_u2dCi0_558.toPx--R2X_6o(this.minFontSize);
        float largest = $this$getFontSize_u2dCi0_558.toPx--R2X_6o(this.maxFontSize);
        float min = smallest;
        float max = largest;
        float current = (min + max) / (float)2;
        while (max - min >= stepSize) {
            layoutResult = $this$getFontSize_u2dCi0_558.performLayout-5ZSfY2I(l, text, $this$getFontSize_u2dCi0_558.toSp-kPz2Gy4(current));
            if (this.didOverflow(layoutResult)) {
                max = current;
            } else {
                min = current;
            }
            current = (min + max) / (float)2;
        }
        current = (float)Math.floor((min - smallest) / stepSize) * stepSize + smallest;
        if (current + stepSize <= largest && !this.didOverflow(layoutResult = $this$getFontSize_u2dCi0_558.performLayout-5ZSfY2I(l, text, $this$getFontSize_u2dCi0_558.toSp-kPz2Gy4(current + stepSize)))) {
            current += stepSize;
        }
        return $this$getFontSize_u2dCi0_558.toSp-kPz2Gy4(current);
    }

    private final boolean didOverflow(TextLayoutResult $this$didOverflow) {
        boolean bl;
        int n = $this$didOverflow.getLayoutInput().getOverflow-gIe3tQ8();
        if (TextOverflow.equals-impl0((int)n, (int)TextOverflow.Companion.getClip-gIe3tQ8()) || TextOverflow.equals-impl0((int)n, (int)TextOverflow.Companion.getVisible-gIe3tQ8())) {
            bl = this.didOverflowBounds($this$didOverflow);
        } else if (TextOverflow.equals-impl0((int)n, (int)TextOverflow.Companion.getStartEllipsis-gIe3tQ8()) || TextOverflow.equals-impl0((int)n, (int)TextOverflow.Companion.getMiddleEllipsis-gIe3tQ8()) || TextOverflow.equals-impl0((int)n, (int)TextOverflow.Companion.getEllipsis-gIe3tQ8())) {
            bl = this.didOverflowByEllipsize($this$didOverflow);
        } else {
            throw new IllegalArgumentException("TextOverflow type " + TextOverflow.toString-impl((int)$this$didOverflow.getLayoutInput().getOverflow-gIe3tQ8()) + " is not supported.");
        }
        return bl;
    }

    private final boolean didOverflowBounds(TextLayoutResult $this$didOverflowBounds) {
        return $this$didOverflowBounds.getDidOverflowWidth() || $this$didOverflowBounds.getDidOverflowHeight();
    }

    private final boolean didOverflowByEllipsize(TextLayoutResult $this$didOverflowByEllipsize) {
        boolean bl;
        switch ($this$didOverflowByEllipsize.getLineCount()) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = $this$didOverflowByEllipsize.isLineEllipsized(0);
                break;
            }
            default: {
                int n = $this$didOverflowByEllipsize.getLayoutInput().getOverflow-gIe3tQ8();
                bl = TextOverflow.equals-impl0((int)n, (int)TextOverflow.Companion.getStartEllipsis-gIe3tQ8()) || TextOverflow.equals-impl0((int)n, (int)TextOverflow.Companion.getMiddleEllipsis-gIe3tQ8()) ? this.didOverflowBounds($this$didOverflowByEllipsize) : (TextOverflow.equals-impl0((int)n, (int)TextOverflow.Companion.getEllipsis-gIe3tQ8()) ? $this$didOverflowByEllipsize.isLineEllipsized($this$didOverflowByEllipsize.getLineCount() - 1) : false);
            }
        }
        return bl;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof AutoSizeStepBased)) {
            return false;
        }
        if (!TextUnit.equals-impl0((long)((AutoSizeStepBased)other).minFontSize, (long)this.minFontSize)) {
            return false;
        }
        if (!TextUnit.equals-impl0((long)((AutoSizeStepBased)other).maxFontSize, (long)this.maxFontSize)) {
            return false;
        }
        return TextUnit.equals-impl0((long)((AutoSizeStepBased)other).stepSize, (long)this.stepSize);
    }

    @Override
    public int hashCode() {
        int result2 = TextUnit.hashCode-impl((long)this.minFontSize);
        result2 = 31 * result2 + TextUnit.hashCode-impl((long)this.maxFontSize);
        result2 = 31 * result2 + TextUnit.hashCode-impl((long)this.stepSize);
        return result2;
    }

    public /* synthetic */ AutoSizeStepBased(long minFontSize, long maxFontSize, long stepSize, DefaultConstructorMarker $constructor_marker) {
        this(minFontSize, maxFontSize, stepSize);
    }
}

