/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.lazy.grid.LazyGridItemProvider;
import androidx.compose.foundation.lazy.grid.LazyGridMeasureResult;
import androidx.compose.foundation.lazy.grid.LazyGridMeasuredItem;
import androidx.compose.foundation.lazy.grid.LazyGridMeasuredLine;
import androidx.compose.foundation.lazy.layout.LazyLayoutItemProviderKt;
import androidx.compose.foundation.lazy.layout.LazyLayoutNearestRangeState;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.SnapshotIntStateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\u0003J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002R+\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00038F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR+\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00038F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000e\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Landroidx/compose/foundation/lazy/grid/LazyGridScrollPosition;", "", "initialIndex", "", "initialScrollOffset", "<init>", "(II)V", "<set-?>", "index", "getIndex", "()I", "setIndex", "(I)V", "index$delegate", "Landroidx/compose/runtime/MutableIntState;", "scrollOffset", "getScrollOffset", "setScrollOffset", "scrollOffset$delegate", "hadFirstNotEmptyLayout", "", "lastKnownFirstItemKey", "nearestRangeState", "Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "getNearestRangeState", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "updateFromMeasureResult", "", "measureResult", "Landroidx/compose/foundation/lazy/grid/LazyGridMeasureResult;", "updateScrollOffset", "requestPositionAndForgetLastKnownKey", "updateScrollPositionIfTheFirstItemWasMoved", "itemProvider", "Landroidx/compose/foundation/lazy/grid/LazyGridItemProvider;", "update", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLazyGridScrollPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridScrollPosition.kt\nandroidx/compose/foundation/lazy/grid/LazyGridScrollPosition\n+ 2 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n*L\n1#1,126:1\n78#2:127\n111#2,2:128\n78#2:130\n111#2,2:131\n51#3,4:133\n51#3,4:137\n97#3,4:141\n*S KotlinDebug\n*F\n+ 1 LazyGridScrollPosition.kt\nandroidx/compose/foundation/lazy/grid/LazyGridScrollPosition\n*L\n33#1:127\n33#1:128,2\n36#1:130\n36#1:131,2\n60#1:133,4\n70#1:137,4\n111#1:141,4\n*E\n"})
public final class LazyGridScrollPosition {
    @NotNull
    private final MutableIntState index$delegate;
    @NotNull
    private final MutableIntState scrollOffset$delegate;
    private boolean hadFirstNotEmptyLayout;
    @Nullable
    private Object lastKnownFirstItemKey;
    @NotNull
    private final LazyLayoutNearestRangeState nearestRangeState;
    public static final int $stable = 8;

    public LazyGridScrollPosition(int initialIndex, int initialScrollOffset) {
        this.index$delegate = SnapshotIntStateKt.mutableIntStateOf((int)initialIndex);
        this.scrollOffset$delegate = SnapshotIntStateKt.mutableIntStateOf((int)initialScrollOffset);
        this.nearestRangeState = new LazyLayoutNearestRangeState(initialIndex, 90, 200);
    }

    public /* synthetic */ LazyGridScrollPosition(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final int getIndex() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.index$delegate;
        LazyGridScrollPosition lazyGridScrollPosition = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setIndex(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.index$delegate;
        LazyGridScrollPosition lazyGridScrollPosition = this;
        Object var4_4 = null;
        int value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(value$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final int getScrollOffset() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.scrollOffset$delegate;
        LazyGridScrollPosition lazyGridScrollPosition = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setScrollOffset(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.scrollOffset$delegate;
        LazyGridScrollPosition lazyGridScrollPosition = this;
        Object var4_4 = null;
        int value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(value$iv);
    }

    @NotNull
    public final LazyLayoutNearestRangeState getNearestRangeState() {
        return this.nearestRangeState;
    }

    public final void updateFromMeasureResult(@NotNull LazyGridMeasureResult measureResult) {
        Intrinsics.checkNotNullParameter((Object)measureResult, (String)"measureResult");
        Object object = measureResult.getFirstVisibleLine();
        Object object2 = object != null && (object = ((LazyGridMeasuredLine)object).getItems()) != null && (object = (LazyGridMeasuredItem)ArraysKt.firstOrNull((Object[])object)) != null ? ((LazyGridMeasuredItem)object).getKey() : (this.lastKnownFirstItemKey = null);
        if (this.hadFirstNotEmptyLayout || measureResult.getTotalItemsCount() > 0) {
            Object object3;
            this.hadFirstNotEmptyLayout = true;
            int scrollOffset = measureResult.getFirstVisibleLineScrollOffset();
            boolean value$iv = (float)scrollOffset >= 0.0f;
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("scrollOffset should be non-negative (" + scrollOffset + ")");
            }
            int firstIndex = (object3 = measureResult.getFirstVisibleLine()) != null && (object3 = ((LazyGridMeasuredLine)object3).getItems()) != null && (object3 = (LazyGridMeasuredItem)ArraysKt.firstOrNull((Object[])object3)) != null ? ((LazyGridMeasuredItem)object3).getIndex() : 0;
            this.update(firstIndex, scrollOffset);
        }
    }

    public final void updateScrollOffset(int scrollOffset) {
        boolean value$iv = (float)scrollOffset >= 0.0f;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("scrollOffset should be non-negative");
        }
        this.setScrollOffset(scrollOffset);
    }

    public final void requestPositionAndForgetLastKnownKey(int index, int scrollOffset) {
        this.update(index, scrollOffset);
        this.lastKnownFirstItemKey = null;
    }

    public final int updateScrollPositionIfTheFirstItemWasMoved(@NotNull LazyGridItemProvider itemProvider, int index) {
        Intrinsics.checkNotNullParameter((Object)itemProvider, (String)"itemProvider");
        int newIndex = LazyLayoutItemProviderKt.findIndexByKey(itemProvider, this.lastKnownFirstItemKey, index);
        if (index != newIndex) {
            this.setIndex(newIndex);
            this.nearestRangeState.update(index);
        }
        return newIndex;
    }

    private final void update(int index, int scrollOffset) {
        boolean value$iv = (float)index >= 0.0f;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Index should be non-negative");
        }
        this.setIndex(index);
        this.nearestRangeState.update(index);
        this.setScrollOffset(scrollOffset);
    }

    public LazyGridScrollPosition() {
        this(0, 0, 3, null);
    }
}

