/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.lazy.grid.LazyGridItemInfo;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0002H\u0000\"\u0018\u0010\u0003\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\t"}, d2={"visibleLinesAverageMainAxisSize", "", "Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;", "singleAxisViewportSize", "getSingleAxisViewportSize", "(Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;)I", "firstVisibleItemLineIndex", "getFirstVisibleItemLineIndex", "calculateContentSize", "foundation"})
@SourceDebugExtension(value={"SMAP\nLazyGridLayoutInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridLayoutInfo.kt\nandroidx/compose/foundation/lazy/grid/LazyGridLayoutInfoKt\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,162:1\n59#2:163\n54#2:165\n59#2:167\n54#2:169\n90#3:164\n85#3:166\n90#3:168\n85#3:170\n*S KotlinDebug\n*F\n+ 1 LazyGridLayoutInfo.kt\nandroidx/compose/foundation/lazy/grid/LazyGridLayoutInfoKt\n*L\n120#1:163\n122#1:165\n138#1:167\n138#1:169\n120#1:164\n122#1:166\n138#1:168\n138#1:170\n*E\n"})
public final class LazyGridLayoutInfoKt {
    public static final int visibleLinesAverageMainAxisSize(@NotNull LazyGridLayoutInfo $this$visibleLinesAverageMainAxisSize) {
        Intrinsics.checkNotNullParameter((Object)$this$visibleLinesAverageMainAxisSize, (String)"<this>");
        boolean isVertical = $this$visibleLinesAverageMainAxisSize.getOrientation() == Orientation.Vertical;
        List<LazyGridItemInfo> visibleItems = $this$visibleLinesAverageMainAxisSize.getVisibleItemsInfo();
        if (visibleItems.isEmpty()) {
            return 0;
        }
        int totalLinesMainAxisSize = 0;
        int linesCount = 0;
        int lineStartIndex = 0;
        while (lineStartIndex < visibleItems.size()) {
            int lineEndIndex;
            int currentLine = LazyGridLayoutInfoKt.visibleLinesAverageMainAxisSize$lineOf(isVertical, $this$visibleLinesAverageMainAxisSize, lineStartIndex);
            if (currentLine == -1) {
                ++lineStartIndex;
                continue;
            }
            int lineMainAxisSize = 0;
            for (lineEndIndex = lineStartIndex; lineEndIndex < visibleItems.size() && LazyGridLayoutInfoKt.visibleLinesAverageMainAxisSize$lineOf(isVertical, $this$visibleLinesAverageMainAxisSize, lineEndIndex) == currentLine; ++lineEndIndex) {
                int n;
                long value$iv$iv;
                if (isVertical) {
                    long l = visibleItems.get(lineEndIndex).getSize-YbymL2g();
                    boolean bl = false;
                    value$iv$iv = l;
                    boolean $i$f$unpackInt2 = false;
                    n = (int)(value$iv$iv & 0xFFFFFFFFL);
                } else {
                    long l = visibleItems.get(lineEndIndex).getSize-YbymL2g();
                    boolean bl = false;
                    value$iv$iv = l;
                    boolean $i$f$unpackInt1 = false;
                    n = (int)(value$iv$iv >> 32);
                }
                int n2 = n;
                lineMainAxisSize = Math.max(lineMainAxisSize, n2);
            }
            totalLinesMainAxisSize += lineMainAxisSize;
            ++linesCount;
            lineStartIndex = lineEndIndex;
        }
        return totalLinesMainAxisSize / linesCount + $this$visibleLinesAverageMainAxisSize.getMainAxisItemSpacing();
    }

    public static final int getSingleAxisViewportSize(@NotNull LazyGridLayoutInfo $this$singleAxisViewportSize) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$singleAxisViewportSize, (String)"<this>");
        if ($this$singleAxisViewportSize.getOrientation() == Orientation.Vertical) {
            long l = $this$singleAxisViewportSize.getViewportSize-YbymL2g();
            boolean bl = false;
            long value$iv$iv = l;
            boolean $i$f$unpackInt2 = false;
            n = (int)(value$iv$iv & 0xFFFFFFFFL);
        } else {
            long l = $this$singleAxisViewportSize.getViewportSize-YbymL2g();
            boolean bl = false;
            long value$iv$iv = l;
            boolean $i$f$unpackInt1 = false;
            n = (int)(value$iv$iv >> 32);
        }
        return n;
    }

    public static final int getFirstVisibleItemLineIndex(@NotNull LazyGridLayoutInfo $this$firstVisibleItemLineIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$firstVisibleItemLineIndex, (String)"<this>");
        List<LazyGridItemInfo> visibleItems = $this$firstVisibleItemLineIndex.getVisibleItemsInfo();
        if (visibleItems.isEmpty()) {
            return 0;
        }
        return $this$firstVisibleItemLineIndex.getOrientation() == Orientation.Vertical ? ((LazyGridItemInfo)CollectionsKt.first(visibleItems)).getRow() : ((LazyGridItemInfo)CollectionsKt.first(visibleItems)).getColumn();
    }

    public static final int calculateContentSize(@NotNull LazyGridLayoutInfo $this$calculateContentSize) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateContentSize, (String)"<this>");
        int contentPadding = $this$calculateContentSize.getBeforeContentPadding() + $this$calculateContentSize.getAfterContentPadding();
        if ($this$calculateContentSize.getTotalItemsCount() == 0) {
            return contentPadding;
        }
        int totalLinesCount = (int)Math.ceil((float)$this$calculateContentSize.getTotalItemsCount() / (float)$this$calculateContentSize.getMaxSpan());
        int contentSizeWithoutSpacing = (LazyGridLayoutInfoKt.visibleLinesAverageMainAxisSize($this$calculateContentSize) - $this$calculateContentSize.getMainAxisItemSpacing()) * totalLinesCount;
        int totalSpacing = (totalLinesCount - 1) * $this$calculateContentSize.getMainAxisItemSpacing();
        return contentSizeWithoutSpacing + totalSpacing + contentPadding;
    }

    private static final int visibleLinesAverageMainAxisSize$lineOf(boolean isVertical, LazyGridLayoutInfo $this_visibleLinesAverageMainAxisSize, int index) {
        return isVertical ? $this_visibleLinesAverageMainAxisSize.getVisibleItemsInfo().get(index).getRow() : $this_visibleLinesAverageMainAxisSize.getVisibleItemsInfo().get(index).getColumn();
    }
}

