/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.ndarray.data;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryView;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B-\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\f\u001a\u00020\rH\u0096\u0002J\u000e\u0010\u000e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArrayIterator;", "T", "", "data", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MemoryView;", "offset", "", "strides", "", "shape", "(Lorg/jetbrains/kotlinx/multik/ndarray/data/MemoryView;I[I[I)V", "index", "hasNext", "", "next", "()Ljava/lang/Object;", "multik-core"})
public final class NDArrayIterator<T>
implements Iterator<T>,
KMappedMarker {
    @NotNull
    private final MemoryView<T> data;
    private final int offset;
    @NotNull
    private final int[] strides;
    @NotNull
    private final int[] shape;
    @NotNull
    private final int[] index;

    public NDArrayIterator(@NotNull MemoryView<T> data2, int offset, @NotNull int[] strides, @NotNull int[] shape) {
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.data = data2;
        this.offset = offset;
        this.strides = strides;
        this.shape = shape;
        this.index = new int[this.shape.length];
    }

    public /* synthetic */ NDArrayIterator(MemoryView memoryView, int n, int[] nArray, int[] nArray2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(memoryView, n, nArray, nArray2);
    }

    @Override
    public boolean hasNext() {
        int n = this.shape.length;
        for (int i = 0; i < n; ++i) {
            if (this.index[i] < this.shape[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        int i;
        int p = this.offset;
        int n = this.shape.length;
        for (i = 0; i < n; ++i) {
            p += this.strides[i] * this.index[i];
        }
        for (i = this.shape.length - 1; -1 < i; --i) {
            int t = this.index[i] + 1;
            if (t < this.shape[i] || i == 0) {
                this.index[i] = t;
                break;
            }
            this.index[i] = 0;
        }
        return this.data.get(p);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

