/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.ndarray.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\t\u0010\u000b\u001a\u00020\u0002H\u0096\u0002J\u0015\u0010\r\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0082\u0002J\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0006H\u0082\u0002J\u0015\u0010\u0012\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0006H\u0082\u0002R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiIndexIterator;", "", "", "first", "last", "step", "", "([I[II)V", "finalElement", "hasNext", "", "next", "startElement", "compareTo", "other", "minusAssign", "", "value", "plusAssign", "multik-core"})
@SourceDebugExtension(value={"SMAP\nMultiIndexProgression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiIndexProgression.kt\norg/jetbrains/kotlinx/multik/ndarray/data/MultiIndexIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class MultiIndexIterator
implements Iterator<int[]>,
KMappedMarker {
    private final int step;
    @NotNull
    private final int[] startElement;
    @NotNull
    private final int[] finalElement;
    private boolean hasNext;
    @NotNull
    private final int[] next;

    /*
     * WARNING - void declaration
     */
    public MultiIndexIterator(@NotNull int[] first, @NotNull int[] last, int step) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)last, (String)"last");
        this.step = step;
        int[] nArray2 = Arrays.copyOf(first, first.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        this.startElement = nArray2;
        int[] nArray3 = Arrays.copyOf(last, last.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"copyOf(...)");
        this.finalElement = nArray3;
        this.hasNext = this.step > 0 ? this.compareTo(first, last) <= 0 : this.compareTo(first, last) >= 0;
        MultiIndexIterator multiIndexIterator = this;
        if (this.hasNext) {
            void $this$next_u24lambda_u240;
            int[] nArray4;
            int[] nArray5 = Arrays.copyOf(first, first.length);
            Intrinsics.checkNotNullExpressionValue((Object)nArray5, (String)"copyOf(...)");
            int[] nArray6 = nArray4 = nArray5;
            MultiIndexIterator multiIndexIterator2 = multiIndexIterator;
            boolean bl = false;
            int n = ArraysKt.getLastIndex((int[])$this$next_u24lambda_u240);
            $this$next_u24lambda_u240[n] = $this$next_u24lambda_u240[n] - this.step;
            multiIndexIterator = multiIndexIterator2;
            nArray = nArray4;
        } else {
            nArray = this.finalElement;
        }
        multiIndexIterator.next = nArray;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    @NotNull
    public int[] next() {
        if (this.step > 0) {
            this.plusAssign(this.next, this.step);
            if (this.compareTo(this.next, this.finalElement) >= 0) {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
            }
        } else {
            this.minusAssign(this.next, -this.step);
            if (this.compareTo(this.next, this.finalElement) <= 0) {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
            }
        }
        return this.next;
    }

    private final void plusAssign(int[] $this$plusAssign, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        for (int i = $this$plusAssign.length - 1; -1 < i; --i) {
            int t = $this$plusAssign[i] + value;
            if (t <= this.finalElement[i] || i == 0) {
                $this$plusAssign[i] = t;
                break;
            }
            $this$plusAssign[i] = this.startElement[i];
        }
    }

    private final void minusAssign(int[] $this$minusAssign, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$minusAssign, (String)"<this>");
        for (int i = $this$minusAssign.length - 1; -1 < i; --i) {
            int t = $this$minusAssign[i] - value;
            if (t >= this.finalElement[i] || i == 0) {
                $this$minusAssign[i] = t;
                break;
            }
            $this$minusAssign[i] = this.startElement[i];
        }
    }

    private final int compareTo(int[] $this$compareTo, int[] other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        if ($this$compareTo == other || $this$compareTo.length == 0 && other.length == 0) {
            n = 0;
        } else if ($this$compareTo.length == 0) {
            n = -1;
        } else if (other.length == 0) {
            n = 1;
        } else {
            int n2 = $this$compareTo.length;
            for (int index = 0; index < n2; ++index) {
                if ($this$compareTo[index] < other[index]) {
                    return -1;
                }
                if ($this$compareTo[index] <= other[index]) continue;
                return 1;
            }
            n = 0;
        }
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

