/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.ndarray.data;

import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryView;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0016J\u0011\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010$\u001a\u00020%2\b\u0010#\u001a\u0004\u0018\u00010&H\u0096\u0002J\u0016\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0013H\u0096\u0002\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u0004H\u0016J\b\u0010+\u001a\u00020\u0013H\u0016J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-H\u0096\u0002J\u0011\u0010.\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010.\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010/\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010/\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0019\u00100\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0002H\u0096\u0002J\u0011\u00102\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0096\u0002J\u0011\u00102\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlinx/multik/ndarray/data/MemoryViewLongArray;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MemoryView;", "", "data", "", "([J)V", "getData", "()[J", "dtype", "Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;", "getDtype", "()Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "setIndices", "(Lkotlin/ranges/IntRange;)V", "lastIndex", "", "getLastIndex", "()I", "setLastIndex", "(I)V", "size", "getSize", "setSize", "copyInto", "destination", "destinationOffset", "startIndex", "endIndex", "copyOf", "divAssign", "", "other", "equals", "", "", "get", "index", "(I)Ljava/lang/Long;", "getLongArray", "hashCode", "iterator", "", "minusAssign", "plusAssign", "set", "value", "timesAssign", "multik-core"})
@SourceDebugExtension(value={"SMAP\nMemoryView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryView.kt\norg/jetbrains/kotlinx/multik/ndarray/data/MemoryViewLongArray\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1057:1\n1789#2,3:1058\n*S KotlinDebug\n*F\n+ 1 MemoryView.kt\norg/jetbrains/kotlinx/multik/ndarray/data/MemoryViewLongArray\n*L\n552#1:1058,3\n*E\n"})
public final class MemoryViewLongArray
extends MemoryView<Long> {
    @NotNull
    private final long[] data;
    @NotNull
    private final DataType dtype;
    private int size;
    @NotNull
    private IntRange indices;
    private int lastIndex;

    public MemoryViewLongArray(@NotNull long[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        super(null);
        this.data = data2;
        this.dtype = DataType.LongDataType;
        this.size = this.getData().length;
        this.indices = ArraysKt.getIndices((long[])this.getData());
        this.lastIndex = ArraysKt.getLastIndex((long[])this.getData());
    }

    @NotNull
    public long[] getData() {
        return this.data;
    }

    @Override
    @NotNull
    public DataType getDtype() {
        return this.dtype;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int n) {
        this.size = n;
    }

    @Override
    @NotNull
    public IntRange getIndices() {
        return this.indices;
    }

    @Override
    public void setIndices(@NotNull IntRange intRange) {
        Intrinsics.checkNotNullParameter((Object)intRange, (String)"<set-?>");
        this.indices = intRange;
    }

    @Override
    public int getLastIndex() {
        return this.lastIndex;
    }

    @Override
    public void setLastIndex(int n) {
        this.lastIndex = n;
    }

    @Override
    @NotNull
    public Long get(int index) {
        return this.getData()[index];
    }

    @Override
    public void set(int index, long value) {
        this.getData()[index] = value;
    }

    @Override
    @NotNull
    public long[] getLongArray() {
        return this.getData();
    }

    @Override
    @NotNull
    public Iterator<Long> iterator() {
        return (Iterator)ArrayIteratorsKt.iterator((long[])this.getData());
    }

    @Override
    @NotNull
    public MemoryView<Long> copyOf() {
        long[] lArray = this.getData();
        long[] lArray2 = Arrays.copyOf(lArray, lArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(...)");
        return new MemoryViewLongArray(lArray2);
    }

    @Override
    @NotNull
    public MemoryView<Long> copyInto(@NotNull MemoryView<Long> destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        ArraysKt.copyInto((long[])this.getData(), (long[])destination.getLongArray(), (int)destinationOffset, (int)startIndex, (int)endIndex);
        return destination;
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (other != null && this.getClass() != other.getClass() ? false : (!(other instanceof MemoryViewLongArray) ? false : (this.getSize() != ((MemoryViewLongArray)other).getSize() ? false : Arrays.equals(this.getData(), ((MemoryViewLongArray)other).getData()))));
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void $this$fold$iv;
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.getSize());
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void r;
            int element$iv;
            int n = element$iv = ((IntIterator)iterator2).nextInt();
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = 31 * acc + Long.hashCode(this.getData()[r]);
        }
        return accumulator$iv;
    }

    @Override
    public final void plusAssign(@NotNull MemoryViewLongArray other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                long[] lArray = this.getData();
                int n2 = ++i;
                lArray[n2] = lArray[n2] + other.getData()[i];
            } while (i != n);
        }
    }

    @Override
    public void plusAssign(long other) {
        int n;
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            do {
                long[] lArray = this.getData();
                int n2 = ++i;
                lArray[n2] = lArray[n2] + other;
            } while (i != n);
        }
    }

    @Override
    public final void minusAssign(@NotNull MemoryViewLongArray other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                long[] lArray = this.getData();
                int n2 = ++i;
                lArray[n2] = lArray[n2] - other.getData()[i];
            } while (i != n);
        }
    }

    @Override
    public void minusAssign(long other) {
        int n;
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            do {
                long[] lArray = this.getData();
                int n2 = ++i;
                lArray[n2] = lArray[n2] - other;
            } while (i != n);
        }
    }

    @Override
    public final void timesAssign(@NotNull MemoryViewLongArray other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                long[] lArray = this.getData();
                int n2 = ++i;
                lArray[n2] = lArray[n2] * other.getData()[i];
            } while (i != n);
        }
    }

    @Override
    public void timesAssign(long other) {
        int n;
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            do {
                long[] lArray = this.getData();
                int n2 = ++i;
                lArray[n2] = lArray[n2] * other;
            } while (i != n);
        }
    }

    @Override
    public final void divAssign(@NotNull MemoryViewLongArray other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                long[] lArray = this.getData();
                int n2 = ++i;
                lArray[n2] = lArray[n2] / other.getData()[i];
            } while (i != n);
        }
    }

    @Override
    public void divAssign(long other) {
        int n;
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            do {
                long[] lArray = this.getData();
                int n2 = ++i;
                lArray[n2] = lArray[n2] / other;
            } while (i != n);
        }
    }
}

