/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.ndarray.data;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDoubleArray;
import org.jetbrains.kotlinx.multik.ndarray.complex._ComplexArraysKt;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryView;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0016J\u0011\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010$\u001a\u00020%2\b\u0010#\u001a\u0004\u0018\u00010&H\u0096\u0002J\u0011\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0013H\u0096\u0002J\b\u0010)\u001a\u00020\u0004H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0013H\u0016J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020.H\u0096\u0002J\u0011\u0010/\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010/\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0011\u00100\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0096\u0002J\u0011\u00100\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0019\u00101\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u0002H\u0096\u0002J\u0011\u00103\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0096\u0002J\u0011\u00103\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlinx/multik/ndarray/data/MemoryViewComplexDoubleArray;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MemoryView;", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDouble;", "data", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDoubleArray;", "(Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDoubleArray;)V", "getData", "()Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDoubleArray;", "dtype", "Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;", "getDtype", "()Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "setIndices", "(Lkotlin/ranges/IntRange;)V", "lastIndex", "", "getLastIndex", "()I", "setLastIndex", "(I)V", "size", "getSize", "setSize", "copyInto", "destination", "destinationOffset", "startIndex", "endIndex", "copyOf", "divAssign", "", "other", "equals", "", "", "get", "index", "getComplexDoubleArray", "getDoubleArray", "", "hashCode", "iterator", "", "minusAssign", "plusAssign", "set", "value", "timesAssign", "multik-core"})
@SourceDebugExtension(value={"SMAP\nMemoryView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryView.kt\norg/jetbrains/kotlinx/multik/ndarray/data/MemoryViewComplexDoubleArray\n+ 2 _ComplexArrays.kt\norg/jetbrains/kotlinx/multik/ndarray/complex/_ComplexArraysKt\n*L\n1#1,1057:1\n1316#2,3:1058\n*S KotlinDebug\n*F\n+ 1 MemoryView.kt\norg/jetbrains/kotlinx/multik/ndarray/data/MemoryViewComplexDoubleArray\n*L\n919#1:1058,3\n*E\n"})
public final class MemoryViewComplexDoubleArray
extends MemoryView<ComplexDouble> {
    @NotNull
    private final ComplexDoubleArray data;
    @NotNull
    private final DataType dtype;
    private int size;
    @NotNull
    private IntRange indices;
    private int lastIndex;

    public MemoryViewComplexDoubleArray(@NotNull ComplexDoubleArray data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        super(null);
        this.data = data2;
        this.dtype = DataType.ComplexDoubleDataType;
        this.size = this.getData().getSize();
        this.indices = _ComplexArraysKt.getIndices(this.getData());
        this.lastIndex = _ComplexArraysKt.getLastIndex(this.getData());
    }

    @Override
    @NotNull
    public ComplexDoubleArray getData() {
        return this.data;
    }

    @Override
    @NotNull
    public DataType getDtype() {
        return this.dtype;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int n) {
        this.size = n;
    }

    @Override
    @NotNull
    public IntRange getIndices() {
        return this.indices;
    }

    @Override
    public void setIndices(@NotNull IntRange intRange) {
        Intrinsics.checkNotNullParameter((Object)intRange, (String)"<set-?>");
        this.indices = intRange;
    }

    @Override
    public int getLastIndex() {
        return this.lastIndex;
    }

    @Override
    public void setLastIndex(int n) {
        this.lastIndex = n;
    }

    @Override
    @NotNull
    public ComplexDouble get(int index) {
        return this.getData().get(index);
    }

    @Override
    public void set(int index, @NotNull ComplexDouble value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getData().set(index, value);
    }

    @Override
    @NotNull
    public double[] getDoubleArray() {
        return this.getData().getFlatArray();
    }

    @Override
    @NotNull
    public ComplexDoubleArray getComplexDoubleArray() {
        return this.getData();
    }

    @Override
    @NotNull
    public Iterator<ComplexDouble> iterator() {
        return this.getData().iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MemoryView<ComplexDouble> copyOf() {
        void var3_3;
        ComplexDoubleArray $this$copyOf$iv = this.getData();
        boolean $i$f$copyOf = false;
        ComplexDoubleArray ret$iv = new ComplexDoubleArray($this$copyOf$iv.getSize());
        ArraysKt.copyInto((double[])$this$copyOf$iv.getFlatArray(), (double[])ret$iv.getFlatArray(), (int)0, (int)0, (int)(ret$iv.getSize() * 2));
        return new MemoryViewComplexDoubleArray((ComplexDoubleArray)var3_3);
    }

    @Override
    @NotNull
    public MemoryView<ComplexDouble> copyInto(@NotNull MemoryView<ComplexDouble> destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        _ComplexArraysKt.copyInto(this.getData(), destination.getComplexDoubleArray(), destinationOffset, startIndex, endIndex);
        return destination;
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (other != null && this.getClass() != other.getClass() ? false : (!(other instanceof MemoryViewComplexDoubleArray) ? false : (this.getSize() != ((MemoryViewComplexDoubleArray)other).getSize() ? false : Intrinsics.areEqual((Object)this.getData(), (Object)((MemoryViewComplexDoubleArray)other).getData()))));
    }

    public int hashCode() {
        int result = this.getData().hashCode();
        result = 31 * result + this.getDtype().hashCode();
        result = 31 * result + this.getSize();
        return result;
    }

    @Override
    public final void plusAssign(@NotNull MemoryViewComplexDoubleArray other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                ComplexDoubleArray complexDoubleArray = this.getData();
                int n2 = ++i;
                complexDoubleArray.set(n2, complexDoubleArray.get(n2).plus(other.getData().get(i)));
            } while (i != n);
        }
    }

    @Override
    public void plusAssign(@NotNull ComplexDouble other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                ComplexDoubleArray complexDoubleArray = this.getData();
                int n2 = ++i;
                complexDoubleArray.set(n2, complexDoubleArray.get(n2).plus(other));
            } while (i != n);
        }
    }

    @Override
    public final void minusAssign(@NotNull MemoryViewComplexDoubleArray other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                ComplexDoubleArray complexDoubleArray = this.getData();
                int n2 = ++i;
                complexDoubleArray.set(n2, complexDoubleArray.get(n2).minus(other.getData().get(i)));
            } while (i != n);
        }
    }

    @Override
    public void minusAssign(@NotNull ComplexDouble other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                ComplexDoubleArray complexDoubleArray = this.getData();
                int n2 = ++i;
                complexDoubleArray.set(n2, complexDoubleArray.get(n2).minus(other));
            } while (i != n);
        }
    }

    @Override
    public final void timesAssign(@NotNull MemoryViewComplexDoubleArray other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                ComplexDoubleArray complexDoubleArray = this.getData();
                int n2 = ++i;
                complexDoubleArray.set(n2, complexDoubleArray.get(n2).times(other.getData().get(i)));
            } while (i != n);
        }
    }

    @Override
    public void timesAssign(@NotNull ComplexDouble other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                ComplexDoubleArray complexDoubleArray = this.getData();
                int n2 = ++i;
                complexDoubleArray.set(n2, complexDoubleArray.get(n2).times(other));
            } while (i != n);
        }
    }

    @Override
    public final void divAssign(@NotNull MemoryViewComplexDoubleArray other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                ComplexDoubleArray complexDoubleArray = this.getData();
                int n2 = ++i;
                complexDoubleArray.set(n2, complexDoubleArray.get(n2).div(other.getData().get(i)));
            } while (i != n);
        }
    }

    @Override
    public void divAssign(@NotNull ComplexDouble other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntRange intRange = this.getIndices();
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            do {
                ComplexDoubleArray complexDoubleArray = this.getData();
                int n2 = ++i;
                complexDoubleArray.set(n2, complexDoubleArray.get(n2).div(other));
            } while (i != n);
        }
    }
}

