/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.ndarray.complex;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDoubleArray;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDoubleIterator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\bH\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/multik/ndarray/complex/ArrayComplexDoubleIterator;", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDoubleIterator;", "array", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDoubleArray;", "(Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDoubleArray;)V", "index", "", "hasNext", "", "nextComplexDouble", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDouble;", "multik-core"})
final class ArrayComplexDoubleIterator
extends ComplexDoubleIterator {
    @NotNull
    private final ComplexDoubleArray array;
    private int index;

    public ArrayComplexDoubleIterator(@NotNull ComplexDoubleArray array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.getSize();
    }

    @Override
    @NotNull
    public ComplexDouble nextComplexDouble() {
        ComplexDouble complexDouble;
        try {
            int n = this.index;
            this.index = n + 1;
            complexDouble = this.array.get(n);
        }
        catch (IndexOutOfBoundsException e) {
            --this.index;
            throw new NoSuchElementException(e.getMessage());
        }
        return complexDouble;
    }
}

