/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.api.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.NoSuchFileException;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.api.Multik;
import org.jetbrains.kotlinx.multik.api.io.CsvKt;
import org.jetbrains.kotlinx.multik.api.io.FileFormats;
import org.jetbrains.kotlinx.multik.api.io.NpyKt;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble32;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble64;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat;
import org.jetbrains.kotlinx.multik.ndarray.data.D1;
import org.jetbrains.kotlinx.multik.ndarray.data.D2;
import org.jetbrains.kotlinx.multik.ndarray.data.D3;
import org.jetbrains.kotlinx.multik.ndarray.data.D4;
import org.jetbrains.kotlinx.multik.ndarray.data.DN;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.Dim2;
import org.jetbrains.kotlinx.multik.ndarray.data.DimN;
import org.jetbrains.kotlinx.multik.ndarray.data.Dimension;
import org.jetbrains.kotlinx.multik.ndarray.data.NDArray;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a9\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0004\"\n\b\u0001\u0010\u0003\u0018\u0001*\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\b\u001a9\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0004\"\n\b\u0001\u0010\u0003\u0018\u0001*\u00020\u0005*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0086\b\u001aG\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0004\"\b\b\u0001\u0010\u0003*\u00020\u0005*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\u000e\u001a9\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0004\"\n\b\u0001\u0010\u0003\u0018\u0001*\u00020\u0005*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\b\u001a\"\u0010\u0011\u001a\u00020\u0012*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0001\u001a\"\u0010\u0011\u001a\u00020\u0012*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0001\u001a\"\u0010\u0011\u001a\u00020\u0012*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0001\u00a8\u0006\u0014"}, d2={"read", "Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArray;", "T", "D", "", "Lorg/jetbrains/kotlinx/multik/ndarray/data/Dimension;", "Lorg/jetbrains/kotlinx/multik/api/Multik;", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "dtype", "Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;", "dim", "(Lorg/jetbrains/kotlinx/multik/api/Multik;Ljava/nio/file/Path;Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;Lorg/jetbrains/kotlinx/multik/ndarray/data/Dimension;)Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArray;", "fileName", "", "write", "", "ndarray", "multik-core"})
@SourceDebugExtension(value={"SMAP\nio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 io.kt\norg/jetbrains/kotlinx/multik/api/io/IoKt\n+ 2 DataType.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType$Companion\n+ 3 DataType.jvm.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType_jvmKt\n+ 4 Dimensions.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DimensionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n24#1:66\n19#1,6:86\n79#2:67\n79#2:92\n79#2:111\n13#3,11:68\n13#3,11:93\n13#3,11:112\n36#4,7:79\n36#4,7:104\n36#4,7:123\n1#5:130\n*S KotlinDebug\n*F\n+ 1 io.kt\norg/jetbrains/kotlinx/multik/api/io/IoKt\n*L\n19#1:66\n21#1:86,6\n19#1:67\n21#1:92\n24#1:111\n19#1:68,11\n21#1:93,11\n24#1:112,11\n19#1:79,7\n21#1:104,7\n24#1:123,7\n*E\n"})
public final class IoKt {
    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T, D extends Dimension> NDArray<T, D> read(Multik $this$read, String fileName) {
        void path$iv;
        void $this$read$iv;
        DataType dataType;
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        boolean $i$f$read = false;
        Multik multik = $this$read;
        Path path = Paths.get(fileName, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = path;
        boolean $i$f$read2 = false;
        DataType.Companion companion = DataType.Companion;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(Object.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        int dim$iv$iv = -1;
        boolean $i$f$dimensionClassOf = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"D");
        KClass kClass2 = Reflection.getOrCreateKotlinClass(Dimension.class);
        DimN dimN = Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D1.class)) ? (DimN)D1.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D2.class)) ? (DimN)D2.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D3.class)) ? (DimN)D3.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D4.class)) ? (DimN)D4.Companion : (DimN)new DN(dim$iv$iv))));
        Intrinsics.reifiedOperationMarker((int)1, (String)"D");
        return IoKt.read((Multik)$this$read$iv, (Path)path$iv, dataType, (Dimension)dimN);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T, D extends Dimension> NDArray<T, D> read(Multik $this$read, File file) {
        void path$iv$iv;
        void $this$read$iv$iv;
        DataType dataType;
        void $this$read$iv;
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean $i$f$read = false;
        Multik multik = $this$read;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String fileName$iv = string;
        boolean $i$f$read2 = false;
        void var6_6 = $this$read$iv;
        Path path = Paths.get(fileName$iv, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = path;
        boolean $i$f$read3 = false;
        DataType.Companion companion = DataType.Companion;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass type$iv$iv$iv = Reflection.getOrCreateKotlinClass(Object.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv$iv.getSimpleName());
        }
        int dim$iv$iv$iv = -1;
        boolean $i$f$dimensionClassOf = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"D");
        KClass kClass2 = Reflection.getOrCreateKotlinClass(Dimension.class);
        DimN dimN = Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D1.class)) ? (DimN)D1.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D2.class)) ? (DimN)D2.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D3.class)) ? (DimN)D3.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D4.class)) ? (DimN)D4.Companion : (DimN)new DN(dim$iv$iv$iv))));
        Intrinsics.reifiedOperationMarker((int)1, (String)"D");
        return IoKt.read((Multik)$this$read$iv$iv, (Path)path$iv$iv, dataType, (Dimension)dimN);
    }

    public static final /* synthetic */ <T, D extends Dimension> NDArray<T, D> read(Multik $this$read, Path path) {
        DataType dataType;
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean $i$f$read = false;
        DataType.Companion companion = DataType.Companion;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass type$iv = Reflection.getOrCreateKotlinClass(Object.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv.getSimpleName());
        }
        int dim$iv = -1;
        boolean $i$f$dimensionClassOf = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"D");
        KClass kClass2 = Reflection.getOrCreateKotlinClass(Dimension.class);
        DimN dimN = Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D1.class)) ? (DimN)D1.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D2.class)) ? (DimN)D2.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D3.class)) ? (DimN)D3.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D4.class)) ? (DimN)D4.Companion : (DimN)new DN(dim$iv))));
        Intrinsics.reifiedOperationMarker((int)1, (String)"D");
        return IoKt.read($this$read, path, dataType, (Dimension)dimN);
    }

    @NotNull
    public static final <T, D extends Dimension> NDArray<T, D> read(@NotNull Multik $this$read, @NotNull Path path, @NotNull DataType dtype, @NotNull D dim) {
        NDArray nDArray;
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)dtype), (String)"dtype");
        Intrinsics.checkNotNullParameter(dim, (String)"dim");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            File file = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            throw new NoSuchFileException(file, null, null, 6, null);
        }
        String string = PathsKt.getExtension((Path)path);
        if (Intrinsics.areEqual((Object)string, (Object)FileFormats.NPY.getExtension())) {
            if (dtype.isComplex()) {
                throw new Exception("NPY format only supports Number types");
            }
            nDArray = NpyKt.readNPY($this$read, path, dtype, dim);
        } else if (Intrinsics.areEqual((Object)string, (Object)FileFormats.CSV.getExtension())) {
            if (dim.getD() > 2) {
                throw new Exception("CSV format only supports 1 and 2 dimensions");
            }
            File file = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            NDArray nDArray2 = CsvKt.readRaw$default($this$read, file, dtype, (Dim2)dim, '\u0000', null, 24, null);
            nDArray = nDArray2;
            Intrinsics.checkNotNull((Object)nDArray2, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.api.io.IoKt.read, D of org.jetbrains.kotlinx.multik.api.io.IoKt.read>");
        } else {
            throw new Exception("Format " + PathsKt.getExtension((Path)path) + " does not support reading ndarrays. If it is `npz` format, try `mk.readNPZ`");
        }
        return nDArray;
    }

    public static final void write(@NotNull Multik $this$write, @NotNull String fileName, @NotNull NDArray<?, ?> ndarray) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(ndarray, (String)"ndarray");
        Path path = Paths.get(fileName, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        IoKt.write($this$write, path, ndarray);
    }

    public static final void write(@NotNull Multik $this$write, @NotNull File file, @NotNull NDArray<?, ?> ndarray) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(ndarray, (String)"ndarray");
        Path path = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        IoKt.write($this$write, path, ndarray);
    }

    public static final void write(@NotNull Multik $this$write, @NotNull Path path, @NotNull NDArray<?, ?> ndarray) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(ndarray, (String)"ndarray");
        String string = PathsKt.getExtension((Path)path);
        if (Intrinsics.areEqual((Object)string, (Object)FileFormats.NPY.getExtension())) {
            if (!(ndarray.getDtype() != DataType.ComplexFloatDataType || ndarray.getDtype() != DataType.ComplexFloatDataType)) {
                boolean $i$a$-require-IoKt$write$32 = false;
                String $i$a$-require-IoKt$write$32 = "NPY format does not support complex numbers.";
                throw new IllegalArgumentException($i$a$-require-IoKt$write$32.toString());
            }
            NpyKt.writeNPY($this$write, path, ndarray);
        } else if (Intrinsics.areEqual((Object)string, (Object)FileFormats.CSV.getExtension())) {
            if (!(ndarray.getDim().getD() < 2)) {
                boolean bl = false;
                String string2 = "Expected array of dimension less than 2, but got array of dimension " + ndarray.getDim().getD() + '.';
                throw new IllegalArgumentException(string2.toString());
            }
            File file = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            CsvKt.writeCSV$default($this$write, file, ndarray, '\u0000', 4, null);
        } else {
            throw new Exception("Unknown format `" + PathsKt.getExtension((Path)path) + "`. Please use one of the supported formats: `npy`, `csv`.");
        }
    }
}

