/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.api.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.multik.api.Multik;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble32;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble64;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble_jvmKt;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat;
import org.jetbrains.kotlinx.multik.ndarray.data.D1;
import org.jetbrains.kotlinx.multik.ndarray.data.D2;
import org.jetbrains.kotlinx.multik.ndarray.data.D3;
import org.jetbrains.kotlinx.multik.ndarray.data.D4;
import org.jetbrains.kotlinx.multik.ndarray.data.DN;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.Dim2;
import org.jetbrains.kotlinx.multik.ndarray.data.DimN;
import org.jetbrains.kotlinx.multik.ndarray.data.Dimension;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryView;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewKt;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.NDArray;
import org.jetbrains.kotlinx.multik.ndarray.data.ScalarsGettersAndSettersKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002\u001aM\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\n\b\u0000\u0010\u000b\u0018\u0001*\u00020\r\"\n\b\u0001\u0010\f\u0018\u0001*\u00020\u000e*\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0086\b\u001aR\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\f*\u00020\u000e*\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u001aM\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\n\b\u0000\u0010\u000b\u0018\u0001*\u00020\r\"\n\b\u0001\u0010\f\u0018\u0001*\u00020\u000e*\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0086\b\u001aR\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\f*\u00020\u000e*\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u001a^\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\f*\u00020\u000e*\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u001aL\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\f*\u00020\u000e*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e\u001aH\u0010\u001e\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u001f0\n*\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u001aH\u0010\u001e\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u001f0\n*\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u001a\f\u0010 \u001a\u00020!*\u00020\bH\u0002\u001a\u0011\u0010\"\u001a\u00020#*\u00020\bH\u0002\u00a2\u0006\u0002\u0010$\u001a\u001f\u0010%\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b*\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010&\u001a@\u0010'\u001a\u00020(\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\f*\u00020\u000e*\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u001a@\u0010'\u001a\u00020(\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\f*\u00020\u000e*\u00020\u000f2\u0006\u0010*\u001a\u00020\b2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u001aD\u0010'\u001a\u00020(\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\f*\u00020\u000e*\u00020\u000f2\n\u0010+\u001a\u00060,j\u0002`-2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n2\b\b\u0002\u0010\u001c\u001a\u00020\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"regexComplexDouble", "Lkotlin/text/Regex;", "isCompressed", "", "file", "Ljava/io/File;", "parseDtype", "Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;", "", "readCSV", "Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArray;", "T", "D", "", "Lorg/jetbrains/kotlinx/multik/ndarray/data/Dim2;", "Lorg/jetbrains/kotlinx/multik/api/Multik;", "delimiter", "", "charset", "Ljava/nio/charset/Charset;", "dtype", "dim", "fileName", "readDelim", "inStream", "Ljava/io/InputStream;", "reader", "Ljava/io/Reader;", "format", "Lorg/apache/commons/csv/CSVFormat;", "readRaw", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2;", "toComplexDouble", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDouble;", "toComplexFloat", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexFloat;", "(Ljava/lang/String;)J", "toType", "(Ljava/lang/String;Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;)Ljava/lang/Object;", "writeCSV", "", "ndarray", "path", "writer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "multik-core"})
@SourceDebugExtension(value={"SMAP\ncsv.kt\nKotlin\n*S Kotlin\n*F\n+ 1 csv.kt\norg/jetbrains/kotlinx/multik/api/io/CsvKt\n+ 2 DataType.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType$Companion\n+ 3 DataType.jvm.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType_jvmKt\n+ 4 Dimensions.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DimensionsKt\n+ 5 IteratingNDArray.kt\norg/jetbrains/kotlinx/multik/ndarray/operations/IteratingNDArrayKt\n*L\n1#1,251:1\n79#2:252\n79#2:271\n13#3,11:253\n13#3,11:272\n36#4,7:264\n36#4,7:283\n535#5,2:290\n*S KotlinDebug\n*F\n+ 1 csv.kt\norg/jetbrains/kotlinx/multik/api/io/CsvKt\n*L\n27#1:252\n74#1:271\n27#1:253,11\n74#1:272,11\n27#1:264,7\n74#1:283,7\n240#1:290,2\n*E\n"})
public final class CsvKt {
    @NotNull
    private static final Regex regexComplexDouble = new Regex("-?[0-9]+\\.?[0-9e\\-\\d]*");

    public static final /* synthetic */ <T, D extends Dim2> NDArray<T, D> readCSV(Multik $this$readCSV, String fileName, char delimiter, Charset charset) {
        DataType dataType;
        Intrinsics.checkNotNullParameter((Object)$this$readCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        boolean $i$f$readCSV = false;
        DataType.Companion companion = DataType.Companion;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass type$iv = Reflection.getOrCreateKotlinClass(Object.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv.getSimpleName());
        }
        int dim$iv = -1;
        boolean $i$f$dimensionClassOf = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"D");
        KClass kClass2 = Reflection.getOrCreateKotlinClass(Dimension.class);
        DimN dimN = Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D1.class)) ? (DimN)D1.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D2.class)) ? (DimN)D2.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D3.class)) ? (DimN)D3.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D4.class)) ? (DimN)D4.Companion : (DimN)new DN(dim$iv))));
        Intrinsics.reifiedOperationMarker((int)1, (String)"D");
        return CsvKt.readCSV($this$readCSV, fileName, dataType, (Dim2)dimN, delimiter, charset);
    }

    public static /* synthetic */ NDArray readCSV$default(Multik $this$readCSV_u24default, String fileName, char delimiter, Charset charset, int n, Object object) {
        DataType dataType;
        if ((n & 2) != 0) {
            delimiter = (char)44;
        }
        if ((n & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter((Object)$this$readCSV_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        boolean $i$f$readCSV = false;
        object = DataType.Companion;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass type$iv = Reflection.getOrCreateKotlinClass(Object.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv.getSimpleName());
        }
        int dim$iv = -1;
        boolean $i$f$dimensionClassOf = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"D");
        KClass kClass2 = Reflection.getOrCreateKotlinClass(Dimension.class);
        DimN dimN = Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D1.class)) ? (DimN)D1.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D2.class)) ? (DimN)D2.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D3.class)) ? (DimN)D3.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D4.class)) ? (DimN)D4.Companion : (DimN)new DN(dim$iv))));
        Intrinsics.reifiedOperationMarker((int)1, (String)"D");
        return CsvKt.readCSV($this$readCSV_u24default, fileName, dataType, (Dim2)dimN, delimiter, charset);
    }

    @NotNull
    public static final <T, D extends Dim2> NDArray<T, D> readCSV(@NotNull Multik $this$readCSV, @NotNull String fileName, @NotNull DataType dtype, @NotNull Dim2 dim, char delimiter, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)((Object)dtype), (String)"dtype");
        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        File file = new File(fileName);
        if (!file.exists()) {
            throw new NoSuchFileException(file, null, null, 6, null);
        }
        return CsvKt.readCSV($this$readCSV, file, dtype, dim, delimiter, charset);
    }

    public static /* synthetic */ NDArray readCSV$default(Multik multik, String string, DataType dataType, Dim2 dim2, char c, Charset charset, int n, Object object) {
        if ((n & 8) != 0) {
            c = (char)44;
        }
        if ((n & 0x10) != 0) {
            charset = Charsets.UTF_8;
        }
        return CsvKt.readCSV(multik, string, dataType, dim2, c, charset);
    }

    @NotNull
    public static final NDArray<?, D2> readRaw(@NotNull Multik $this$readRaw, @NotNull String fileName, @Nullable DataType dtype, @Nullable Dim2 dim, char delimiter, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readRaw, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        File file = new File(fileName);
        if (!file.exists()) {
            throw new NoSuchFileException(file, null, null, 6, null);
        }
        return CsvKt.readRaw($this$readRaw, file, dtype, dim, delimiter, charset);
    }

    public static /* synthetic */ NDArray readRaw$default(Multik multik, String string, DataType dataType, Dim2 dim2, char c, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            dataType = null;
        }
        if ((n & 4) != 0) {
            dim2 = null;
        }
        if ((n & 8) != 0) {
            c = (char)44;
        }
        if ((n & 0x10) != 0) {
            charset = Charsets.UTF_8;
        }
        return CsvKt.readRaw(multik, string, dataType, dim2, c, charset);
    }

    public static final /* synthetic */ <T, D extends Dim2> NDArray<T, D> readCSV(Multik $this$readCSV, File file, char delimiter, Charset charset) {
        DataType dataType;
        Intrinsics.checkNotNullParameter((Object)$this$readCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        boolean $i$f$readCSV = false;
        DataType.Companion companion = DataType.Companion;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass type$iv = Reflection.getOrCreateKotlinClass(Object.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv.getSimpleName());
        }
        int dim$iv = -1;
        boolean $i$f$dimensionClassOf = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"D");
        KClass kClass2 = Reflection.getOrCreateKotlinClass(Dimension.class);
        DimN dimN = Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D1.class)) ? (DimN)D1.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D2.class)) ? (DimN)D2.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D3.class)) ? (DimN)D3.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D4.class)) ? (DimN)D4.Companion : (DimN)new DN(dim$iv))));
        Intrinsics.reifiedOperationMarker((int)1, (String)"D");
        return CsvKt.readCSV($this$readCSV, file, dataType, (Dim2)dimN, delimiter, charset);
    }

    public static /* synthetic */ NDArray readCSV$default(Multik $this$readCSV_u24default, File file, char delimiter, Charset charset, int n, Object object) {
        DataType dataType;
        if ((n & 2) != 0) {
            delimiter = (char)44;
        }
        if ((n & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter((Object)$this$readCSV_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        boolean $i$f$readCSV = false;
        object = DataType.Companion;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass type$iv = Reflection.getOrCreateKotlinClass(Object.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv.getSimpleName());
        }
        int dim$iv = -1;
        boolean $i$f$dimensionClassOf = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"D");
        KClass kClass2 = Reflection.getOrCreateKotlinClass(Dimension.class);
        DimN dimN = Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D1.class)) ? (DimN)D1.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D2.class)) ? (DimN)D2.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D3.class)) ? (DimN)D3.Companion : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(D4.class)) ? (DimN)D4.Companion : (DimN)new DN(dim$iv))));
        Intrinsics.reifiedOperationMarker((int)1, (String)"D");
        return CsvKt.readCSV($this$readCSV_u24default, file, dataType, (Dim2)dimN, delimiter, charset);
    }

    @NotNull
    public static final <T, D extends Dim2> NDArray<T, D> readCSV(@NotNull Multik $this$readCSV, @NotNull File file, @NotNull DataType dtype, @NotNull Dim2 dim, char delimiter, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)dtype), (String)"dtype");
        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return CsvKt.readDelim($this$readCSV, new FileInputStream(file), dtype, dim, delimiter, charset, CsvKt.isCompressed(file));
    }

    public static /* synthetic */ NDArray readCSV$default(Multik multik, File file, DataType dataType, Dim2 dim2, char c, Charset charset, int n, Object object) {
        if ((n & 8) != 0) {
            c = (char)44;
        }
        if ((n & 0x10) != 0) {
            charset = Charsets.UTF_8;
        }
        return CsvKt.readCSV(multik, file, dataType, dim2, c, charset);
    }

    @NotNull
    public static final NDArray<?, D2> readRaw(@NotNull Multik $this$readRaw, @NotNull File file, @Nullable DataType dtype, @Nullable Dim2 dim, char delimiter, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readRaw, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return CsvKt.readDelim($this$readRaw, new FileInputStream(file), dtype, dim, delimiter, charset, CsvKt.isCompressed(file));
    }

    public static /* synthetic */ NDArray readRaw$default(Multik multik, File file, DataType dataType, Dim2 dim2, char c, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            dataType = null;
        }
        if ((n & 4) != 0) {
            dim2 = null;
        }
        if ((n & 8) != 0) {
            c = (char)44;
        }
        if ((n & 0x10) != 0) {
            charset = Charsets.UTF_8;
        }
        return CsvKt.readRaw(multik, file, dataType, dim2, c, charset);
    }

    @NotNull
    public static final <T, D extends Dim2> NDArray<T, D> readDelim(@NotNull Multik $this$readDelim, @NotNull InputStream inStream, @Nullable DataType dtype, @Nullable Dim2 dim, char delimiter, @NotNull Charset charset, boolean isCompressed) {
        Intrinsics.checkNotNullParameter((Object)$this$readDelim, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inStream, (String)"inStream");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Reader $this$readDelim_u24lambda_u240 = isCompressed ? (Reader)new InputStreamReader((InputStream)new GZIPInputStream(inStream), charset) : (Reader)new BufferedReader(new InputStreamReader(inStream, charset));
        boolean bl = false;
        CSVFormat cSVFormat = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setDelimiter(delimiter).build();
        Intrinsics.checkNotNullExpressionValue((Object)cSVFormat, (String)"build(...)");
        return CsvKt.readDelim($this$readDelim, $this$readDelim_u24lambda_u240, cSVFormat, dtype, dim);
    }

    public static /* synthetic */ NDArray readDelim$default(Multik multik, InputStream inputStream, DataType dataType, Dim2 dim2, char c, Charset charset, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            c = (char)44;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return CsvKt.readDelim(multik, inputStream, dataType, dim2, c, charset, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final <T, D extends Dim2> NDArray<T, D> readDelim(@NotNull Multik $this$readDelim, @NotNull Reader reader, @NotNull CSVFormat format, @Nullable DataType dtype, @Nullable Dim2 dim) {
        NDArray nDArray;
        int[] shape;
        Dim2 d2;
        Intrinsics.checkNotNullParameter((Object)$this$readDelim, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        int iSize = 0;
        int jSize = 0;
        MemoryView<T> data2 = null;
        Closeable closeable = (Closeable)format.parse(reader);
        Throwable throwable = null;
        try {
            CSVParser csvParser = (CSVParser)closeable;
            boolean bl = false;
            List records = csvParser.getRecords();
            iSize = records.size();
            Intrinsics.checkNotNull((Object)records);
            jSize = ((CSVRecord)CollectionsKt.first((List)records)).size();
            DataType dataType = dtype;
            if (dataType == null) {
                String string = ((CSVRecord)records.get(0)).get(0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                dataType = CsvKt.parseDtype(string);
            }
            DataType type = dataType;
            data2 = MemoryViewKt.initMemoryView(iSize * jSize, type);
            int index = 0;
            for (CSVRecord record : records) {
                for (String el : record) {
                    int n = index++;
                    Intrinsics.checkNotNull((Object)el);
                    data2.set(n, CsvKt.toType(el, type));
                }
            }
            csvParser = Unit.INSTANCE;
        }
        catch (Throwable csvParser) {
            throwable = csvParser;
            throw csvParser;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Dim2 dim2 = dim;
        if (dim2 == null) {
            dim2 = D2.Companion;
        }
        if (Intrinsics.areEqual((Object)(d2 = dim2), (Object)D1.Companion)) {
            int[] nArray = new int[]{jSize * iSize};
            shape = nArray;
            nDArray = new NDArray(data2, 0, shape, null, D1.Companion, null, 40, null);
        } else {
            int[] nArray = new int[]{iSize, jSize};
            shape = nArray;
            nDArray = new NDArray(data2, 0, shape, null, D2.Companion, null, 40, null);
        }
        return nDArray;
    }

    public static /* synthetic */ NDArray readDelim$default(Multik multik, Reader reader, CSVFormat cSVFormat, DataType dataType, Dim2 dim2, int n, Object object) {
        if ((n & 2) != 0) {
            CSVFormat cSVFormat2 = CSVFormat.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)cSVFormat2, (String)"DEFAULT");
            cSVFormat = cSVFormat2;
        }
        return CsvKt.readDelim(multik, reader, cSVFormat, dataType, dim2);
    }

    private static final DataType parseDtype(String $this$parseDtype) {
        DataType dataType;
        List matches = SequencesKt.toList((Sequence)Regex.findAll$default((Regex)regexComplexDouble, (CharSequence)$this$parseDtype, (int)0, (int)2, null));
        switch (matches.size()) {
            case 1: {
                dataType = DataType.DoubleDataType;
                break;
            }
            case 2: {
                dataType = DataType.ComplexDoubleDataType;
                break;
            }
            default: {
                throw new TypeCastException("Unknown type " + $this$parseDtype + " element");
            }
        }
        return dataType;
    }

    private static final <T> T toType(String $this$toType, DataType dtype) {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[dtype.ordinal()]) {
            case 1: {
                object = Double.parseDouble($this$toType);
                break;
            }
            case 2: {
                object = Float.valueOf(Float.parseFloat($this$toType));
                break;
            }
            case 3: {
                object = Integer.parseInt($this$toType);
                break;
            }
            case 4: {
                object = Long.parseLong($this$toType);
                break;
            }
            case 5: {
                object = CsvKt.toComplexDouble($this$toType);
                break;
            }
            case 6: {
                object = ComplexFloat.box-impl(CsvKt.toComplexFloat($this$toType));
                break;
            }
            case 7: {
                object = Short.parseShort($this$toType);
                break;
            }
            case 8: {
                object = Byte.parseByte($this$toType);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (T)object;
    }

    private static final ComplexDouble toComplexDouble(String $this$toComplexDouble) {
        List list = SequencesKt.toList((Sequence)Regex.findAll$default((Regex)regexComplexDouble, (CharSequence)$this$toComplexDouble, (int)0, (int)2, null));
        MatchResult re = (MatchResult)list.get(0);
        MatchResult im = (MatchResult)list.get(1);
        return ComplexDouble_jvmKt.ComplexDouble(Double.parseDouble(re.getValue()), Double.parseDouble(im.getValue()));
    }

    private static final long toComplexFloat(String $this$toComplexFloat) {
        List list = SequencesKt.toList((Sequence)Regex.findAll$default((Regex)regexComplexDouble, (CharSequence)$this$toComplexFloat, (int)0, (int)2, null));
        MatchResult re = (MatchResult)list.get(0);
        MatchResult im = (MatchResult)list.get(1);
        return ComplexFloat.constructor-impl(Float.parseFloat(re.getValue()), Float.parseFloat(im.getValue()));
    }

    private static final boolean isCompressed(File file) {
        Object[] objectArray = new String[]{"gz", "zip"};
        return CollectionsKt.listOf((Object[])objectArray).contains(FilesKt.getExtension((File)file));
    }

    public static final <T, D extends Dim2> void writeCSV(@NotNull Multik $this$writeCSV, @NotNull File file, @NotNull NDArray<T, D> ndarray, char delimiter) {
        Intrinsics.checkNotNullParameter((Object)$this$writeCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(ndarray, (String)"ndarray");
        Appendable appendable = new FileWriter(file);
        CSVFormat cSVFormat = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setDelimiter(delimiter).build();
        Intrinsics.checkNotNullExpressionValue((Object)cSVFormat, (String)"build(...)");
        CsvKt.writeCSV($this$writeCSV, appendable, ndarray, cSVFormat);
    }

    public static /* synthetic */ void writeCSV$default(Multik multik, File file, NDArray nDArray, char c, int n, Object object) {
        if ((n & 4) != 0) {
            c = (char)44;
        }
        CsvKt.writeCSV(multik, file, nDArray, c);
    }

    public static final <T, D extends Dim2> void writeCSV(@NotNull Multik $this$writeCSV, @NotNull String path, @NotNull NDArray<T, D> ndarray, char delimiter) {
        Intrinsics.checkNotNullParameter((Object)$this$writeCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(ndarray, (String)"ndarray");
        Appendable appendable = new FileWriter(path);
        CSVFormat cSVFormat = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setDelimiter(delimiter).build();
        Intrinsics.checkNotNullExpressionValue((Object)cSVFormat, (String)"build(...)");
        CsvKt.writeCSV($this$writeCSV, appendable, ndarray, cSVFormat);
    }

    public static /* synthetic */ void writeCSV$default(Multik multik, String string, NDArray nDArray, char c, int n, Object object) {
        if ((n & 4) != 0) {
            c = (char)44;
        }
        CsvKt.writeCSV(multik, string, nDArray, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T, D extends Dim2> void writeCSV(@NotNull Multik $this$writeCSV, @NotNull Appendable writer, @NotNull NDArray<T, D> ndarray, @NotNull CSVFormat format) {
        Intrinsics.checkNotNullParameter((Object)$this$writeCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(ndarray, (String)"ndarray");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Closeable closeable = (Closeable)format.print(writer);
        Throwable throwable = null;
        try {
            CSVPrinter printer = (CSVPrinter)closeable;
            boolean bl = false;
            if (((Dim2)ndarray.getDim()).getD() == 1) {
                MultiArray $this$forEach$iv = ndarray;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Object[] objectArray = new Object[]{it};
                    printer.printRecord(objectArray);
                }
            } else {
                int n = ndarray.getShape()[0];
                for (int i = 0; i < n; ++i) {
                    int n2 = ndarray.getShape()[1];
                    for (int j = 0; j < n2; ++j) {
                        printer.print(ScalarsGettersAndSettersKt.genGet2((MultiArray)ndarray, i, j));
                    }
                    printer.println();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeCSV$default(Multik multik, Appendable appendable, NDArray nDArray, CSVFormat cSVFormat, int n, Object object) {
        if ((n & 4) != 0) {
            CSVFormat cSVFormat2 = CSVFormat.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)cSVFormat2, (String)"DEFAULT");
            cSVFormat = cSVFormat2;
        }
        CsvKt.writeCSV(multik, appendable, nDArray, cSVFormat);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.DoubleDataType.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.FloatDataType.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.IntDataType.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.LongDataType.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.ComplexDoubleDataType.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.ComplexFloatDataType.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.ShortDataType.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.ByteDataType.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

