/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.api;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.multik.api.DefaultEngineType;
import org.jetbrains.kotlinx.multik.api.EngineKt;
import org.jetbrains.kotlinx.multik.api.EngineMultikException;
import org.jetbrains.kotlinx.multik.api.EngineType;
import org.jetbrains.kotlinx.multik.api.linalg.LinAlg;
import org.jetbrains.kotlinx.multik.api.math.Math;
import org.jetbrains.kotlinx.multik.api.stat.Statistics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u0010H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/multik/api/Engine;", "", "()V", "name", "", "getName", "()Ljava/lang/String;", "type", "Lorg/jetbrains/kotlinx/multik/api/EngineType;", "getType", "()Lorg/jetbrains/kotlinx/multik/api/EngineType;", "getLinAlg", "Lorg/jetbrains/kotlinx/multik/api/linalg/LinAlg;", "getMath", "Lorg/jetbrains/kotlinx/multik/api/math/Math;", "getStatistics", "Lorg/jetbrains/kotlinx/multik/api/stat/Statistics;", "Companion", "multik-core"})
public abstract class Engine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<EngineType, Engine> enginesProvider = EngineKt.enginesProvider();
    @Nullable
    private static EngineType defaultEngine;

    @NotNull
    protected abstract String getName();

    @NotNull
    public abstract EngineType getType();

    @NotNull
    public abstract Math getMath();

    @NotNull
    public abstract LinAlg getLinAlg();

    @NotNull
    public abstract Statistics getStatistics();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019J\u0015\u0010\u0007\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001aR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/multik/api/Engine$Companion;", "Lorg/jetbrains/kotlinx/multik/api/Engine;", "()V", "defaultEngine", "Lorg/jetbrains/kotlinx/multik/api/EngineType;", "getDefaultEngine", "()Lorg/jetbrains/kotlinx/multik/api/EngineType;", "setDefaultEngine", "(Lorg/jetbrains/kotlinx/multik/api/EngineType;)V", "enginesProvider", "", "name", "", "getName", "()Ljava/lang/String;", "type", "getType", "getDefaultEngine$multik_core", "getLinAlg", "Lorg/jetbrains/kotlinx/multik/api/linalg/LinAlg;", "getMath", "Lorg/jetbrains/kotlinx/multik/api/math/Math;", "getStatistics", "Lorg/jetbrains/kotlinx/multik/api/stat/Statistics;", "loadEngine", "", "setDefaultEngine$multik_core", "multik-core"})
    @SourceDebugExtension(value={"SMAP\nEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Engine.kt\norg/jetbrains/kotlinx/multik/api/Engine$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
    public static final class Companion
    extends Engine {
        private Companion() {
        }

        @Nullable
        public final EngineType getDefaultEngine() {
            return defaultEngine;
        }

        public final void setDefaultEngine(@Nullable EngineType engineType) {
            defaultEngine = engineType;
        }

        public final void loadEngine() {
            this.setDefaultEngine(enginesProvider.containsKey(DefaultEngineType.INSTANCE) ? (EngineType)DefaultEngineType.INSTANCE : (!enginesProvider.isEmpty() ? (EngineType)enginesProvider.entrySet().iterator().next().getKey() : null));
        }

        @Override
        @NotNull
        protected String getName() {
            throw new EngineMultikException("For a companion object, the name is undefined.");
        }

        @Override
        @NotNull
        public EngineType getType() {
            throw new EngineMultikException("For a companion object, the type is undefined.");
        }

        @Nullable
        public final String getDefaultEngine$multik_core() {
            Object object = this.getDefaultEngine();
            if (object == null || (object = ((EngineType)object).getName()) == null) {
                this.loadEngine();
                Unit it = Unit.INSTANCE;
                boolean bl = false;
                EngineType engineType = Companion.getDefaultEngine();
                object = engineType != null ? engineType.getName() : null;
            }
            return object;
        }

        public final void setDefaultEngine$multik_core(@NotNull EngineType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            if (!enginesProvider.containsKey(type)) {
                throw new EngineMultikException("This type of engine is not available.");
            }
            this.setDefaultEngine(type);
        }

        @Override
        @NotNull
        public Math getMath() {
            Object object;
            if (enginesProvider.isEmpty()) {
                throw new EngineMultikException("The map of engines is empty. Can not provide Math implementation.");
            }
            if (this.getDefaultEngine() == null) {
                this.loadEngine();
            }
            if ((object = (Engine)enginesProvider.get(this.getDefaultEngine())) == null || (object = ((Engine)object).getMath()) == null) {
                throw new EngineMultikException("The used engine type is not defined.");
            }
            return object;
        }

        @Override
        @NotNull
        public LinAlg getLinAlg() {
            Object object;
            if (enginesProvider.isEmpty()) {
                throw new EngineMultikException("The map of engines is empty. Can not provide LinAlg implementation.");
            }
            if (this.getDefaultEngine() == null) {
                this.loadEngine();
            }
            if ((object = (Engine)enginesProvider.get(this.getDefaultEngine())) == null || (object = ((Engine)object).getLinAlg()) == null) {
                throw new EngineMultikException("The used engine type is not defined.");
            }
            return object;
        }

        @Override
        @NotNull
        public Statistics getStatistics() {
            Object object;
            if (enginesProvider.isEmpty()) {
                throw new EngineMultikException("The map of engines is empty. Can not provide Statistics implementation.");
            }
            if (this.getDefaultEngine() == null) {
                this.loadEngine();
            }
            if ((object = (Engine)enginesProvider.get(this.getDefaultEngine())) == null || (object = ((Engine)object).getStatistics()) == null) {
                throw new EngineMultikException("The used engine type is not defined.");
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

